/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.sim.split.dto.BillDealResultDto;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.dto.SmsRequestDto;
import kd.imc.sim.split.dto.SmsResultDto;
import kd.imc.sim.split.enums.EnumType;
import kd.imc.sim.split.methods.BillCheckMethods;
import kd.imc.sim.split.service.BillsCheckService;
import kd.imc.sim.split.service.GoodsDiscountService;
import kd.imc.sim.split.service.InvoiceCoreService;
import org.apache.commons.lang3.StringUtils;

public class SMSERN {
    private static Log logger = LogFactory.getLog(SMSERN.class);
    private static BillCheckMethods billCheckMethods = new BillCheckMethods();

    public SmsResultDto doSMSER(SmsRequestDto requestDto) {
        SmsResultDto resultDto = new SmsResultDto();
        try {
            if (requestDto.getBillSubject() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u9700\u5904\u7406\u5355\u636e", (String)"SMSERN_0", (String)"imc-sim-split", (Object[])new Object[0]));
            }
            this.buildSmr(requestDto);
            billCheckMethods.checkBill(requestDto, resultDto);
            int failNums = this.ruleBillSubjects(requestDto, resultDto);
            resultDto.setTotals(1);
            resultDto.setDoSucc(1 - failNums);
            resultDto.setDoFail(failNums);
            return resultDto;
        }
        catch (Exception e) {
            logger.error("\u5355\u636e\u62c6\u5206\u5904\u7406\u5f02\u5e38", (Throwable)e);
            resultDto.setSuccess(false);
            resultDto.setErrorMsg(e.getMessage());
            return resultDto;
        }
    }

    private void buildSmr(SmsRequestDto requestDto) {
        if (requestDto.getSmr() == null) {
            requestDto.setSmr(new SmruleConfigDto());
        }
        SmruleConfigDto smr = requestDto.getSmr();
        if (requestDto.getSmr().getSplitGoodsWithNumber() == 1) {
            smr.setSplitGoodsWithNumber(EnumType.SplitGoodsTypeEnum.TWO.getValue());
        }
    }

    private int ruleBillSubjects(SmsRequestDto requestDto, SmsResultDto resultDto) {
        BillSubjectDto bill = requestDto.getBillSubject();
        if (!bill.getCheckPassed().booleanValue()) {
            return 1;
        }
        try {
            SmruleConfigDto smruleConfigDto = requestDto.getSmr();
            smruleConfigDto.setFinalLimitAmt(this.getInvLimitAmt(bill.getInvKind(), requestDto));
            bill.setIsOil(requestDto.getIsOil());
            bill.setAllEReducedTax(requestDto.isAllEReducedTax());
            this.tranferRule(bill, smruleConfigDto, resultDto);
            return 0;
        }
        catch (Exception e) {
            logger.error("\u62c6\u5408\u5f02\u5e38", (Throwable)e);
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(bill.getBillNO(), false, e.getMessage());
            resultDto.getBdrList().add(dealResultDto);
            return 1;
        }
    }

    private void tranferRule(BillSubjectDto subjectDto, SmruleConfigDto smruleConfigDto, SmsResultDto resultDto) throws KDBizException {
        BillsCheckService.billItemsCheck(subjectDto, smruleConfigDto);
        this.getMaxLine(subjectDto, smruleConfigDto);
        List<BillDetailDto> billDetailDtos = GoodsDiscountService.doDisLine(subjectDto.getBillDList());
        subjectDto.setBillDList(billDetailDtos);
        this.invoiceAverageLimit(subjectDto);
        InvoiceCoreService.openInvoice(subjectDto, smruleConfigDto, resultDto);
        InvoiceCoreService.taxAmtCheck(resultDto);
    }

    private BigDecimal getInvLimitAmt(int preInvKind, SmsRequestDto requestDto) {
        BigDecimal invLimitAmt = BigDecimal.ZERO;
        if (EnumType.InvKindEnum.SPECIAL.getValue() == preInvKind) {
            invLimitAmt = requestDto.getSiAmt();
        } else if (EnumType.InvKindEnum.NORMAL.getValue() == preInvKind) {
            invLimitAmt = requestDto.getCiAmt();
        } else if (EnumType.InvKindEnum.ROLL.getValue() == preInvKind) {
            invLimitAmt = requestDto.getVlAmt();
        } else if (EnumType.InvKindEnum.ESINV.getValue() == preInvKind) {
            invLimitAmt = requestDto.getEsiAmt();
        } else if (EnumType.InvKindEnum.EINV.getValue() == preInvKind) {
            invLimitAmt = requestDto.getEiAmt();
        } else if (EnumType.InvKindEnum.ALLEINV.getValue() == preInvKind) {
            invLimitAmt = requestDto.getAllecAmt();
        } else if (EnumType.InvKindEnum.ALLESINV.getValue() == preInvKind) {
            invLimitAmt = requestDto.getAllesAmt();
        }
        return invLimitAmt;
    }

    private void getMaxLine(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        int invkind = billSubjectDto.getInvKind();
        int maxLine = 100;
        if (EnumType.InvKindEnum.SPECIAL.getValue() == invkind) {
            maxLine = configDto.getMaxSLine();
        } else if (EnumType.InvKindEnum.NORMAL.getValue() == invkind) {
            maxLine = configDto.getMaxCLine();
        } else if (EnumType.InvKindEnum.ESINV.getValue() == invkind) {
            maxLine = configDto.getMaxEsiLine();
        } else if (EnumType.InvKindEnum.EINV.getValue() == invkind) {
            maxLine = configDto.getMaxELine();
        } else if (EnumType.InvKindEnum.ROLL.getValue() == invkind) {
            String mode = billSubjectDto.getRollInvSpec();
            maxLine = StringUtils.isNotEmpty((CharSequence)mode) && mode.equals("01") ? 13 : 6;
        } else if (EnumType.InvKindEnum.ALLEINV.getValue() == invkind) {
            maxLine = configDto.getMaxAllELine();
        } else if (EnumType.InvKindEnum.ALLESINV.getValue() == invkind) {
            maxLine = configDto.getMaxAllEsiLine();
        }
        String isOil = billSubjectDto.getIsOil();
        if (StringUtils.isNotEmpty((CharSequence)isOil) && isOil.equals(EnumType.NumberTypeEnum.ONE.getValue().toString())) {
            maxLine = 8;
        } else if (EnumType.NumberTypeEnum.TWO.getValue().intValue() == configDto.getListType()) {
            if ((EnumType.InvKindEnum.SPECIAL.getValue() == invkind || EnumType.InvKindEnum.NORMAL.getValue() == invkind) && maxLine > 8) {
                maxLine = 8;
            } else if ((EnumType.InvKindEnum.ESINV.getValue() == invkind || EnumType.InvKindEnum.EINV.getValue() == invkind) && maxLine > 100) {
                maxLine = 100;
            }
        }
        billSubjectDto.setLimitLine(maxLine);
    }

    private void invoiceAverageLimit(BillSubjectDto subjectDto) {
        List<BillDetailDto> billDList = subjectDto.getBillDList();
        BigDecimal sumAmtJe = BigDecimal.ZERO;
        BigDecimal sumAmtSe = BigDecimal.ZERO;
        for (BillDetailDto billDetailDto : billDList) {
            sumAmtJe = sumAmtJe.add(billDetailDto.getAmounts());
            sumAmtSe = sumAmtSe.add(billDetailDto.getTaxAmt());
        }
        subjectDto.setSumAmtJE(sumAmtJe);
        subjectDto.setSumAmtSE(sumAmtSe);
    }
}

