/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.InvoiceDetailDto;
import kd.imc.sim.split.enums.EnumType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ComUtil {
    private static Log LOG = LogFactory.getLog(ComUtil.class);

    public static boolean isDisLine(BillDetailDto detailDto) {
        return EnumType.LinePropertyEnum.FOUR.getValue().compareTo(detailDto.getLineProperty()) == 0 && detailDto.getAmounts().compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isInvoiceDisLine(InvoiceDetailDto detail) {
        return EnumType.LinePropertyEnum.FOUR.getValue().compareTo(detail.getLineProperty()) == 0 && detail.getAmounts().compareTo(BigDecimal.ZERO) < 0;
    }

    public static Object cloneObj(Object obj) {
        ByteArrayOutputStream bos = null;
        ObjectInputStream ois = null;
        try {
            bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            LOG.error("\u5546\u54c1\u62c6\u5206\u65f6\uff0c\u5907\u4efd\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u62c6\u5206\u65f6\uff0c\u5907\u4efd\u6570\u636e\u5f02\u5e38", (String)"ComUtil_0", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int findObjIndexInList(List<BillDetailDto> billDList, BillDetailDto detailDto) {
        String billNoP = detailDto.getBillNO();
        String billDetailNoP = detailDto.getBillDetailNO();
        if (StringUtils.isEmpty((CharSequence)billDetailNoP)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s] \u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ComUtil_1", (String)"imc-sim-split", (Object[])new Object[0]), billNoP));
        }
        if (CollectionUtils.isEmpty(billDList)) {
            return -1;
        }
        int i = 0;
        for (BillDetailDto dto : billDList) {
            String billNo = dto.getBillNO();
            String billDetailNo = dto.getBillDetailNO();
            if (billNo.equals(billNoP) && billDetailNo.equals(billDetailNoP)) break;
            ++i;
        }
        return i;
    }
}

