/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.constant;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Objects;
import kd.imc.bdm.common.constant.MultiLangEnumBridge;

public enum RedConfirmStatusEnum {
    NO_CONFIRM(new MultiLangEnumBridge("\u65e0\u9700\u786e\u8ba4", "RedConfirmStatusEnum_0", "imc-sim-common"), "01"),
    BUYER_CONFIRM(new MultiLangEnumBridge("\u9500\u65b9\u5f55\u5165\u5f85\u8d2d\u65b9\u786e\u8ba4", "RedConfirmStatusEnum_1", "imc-sim-common"), "02"),
    SELLER_CONFIRM(new MultiLangEnumBridge("\u8d2d\u65b9\u5f55\u5165\u5f85\u9500\u65b9\u786e\u8ba4", "RedConfirmStatusEnum_2", "imc-sim-common"), "03"),
    ALL_CONFIRM(new MultiLangEnumBridge("\u8d2d\u9500\u53cc\u65b9\u5df2\u786e\u8ba4", "RedConfirmStatusEnum_3", "imc-sim-common"), "04"),
    SALES_DISCOUNTS(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u9500\u65b9\u5f55\u5165\u8d2d\u65b9\u5426\u8ba4\uff09", "RedConfirmStatusEnum_4", "imc-sim-common"), "05"),
    SELLER_CANCEL(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u8d2d\u65b9\u5f55\u5165\u9500\u65b9\u5426\u8ba4\uff09", "RedConfirmStatusEnum_5", "imc-sim-common"), "06"),
    TIME_CANCEL(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u8d8572\u5c0f\u65f6\u672a\u786e\u8ba4\uff09", "RedConfirmStatusEnum_6", "imc-sim-common"), "07"),
    CREATOR_REVOKE(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u53d1\u8d77\u65b9\u5df2\u64a4\u9500\uff09", "RedConfirmStatusEnum_7", "imc-sim-common"), "08"),
    CONFIRM_REVOKE(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u786e\u8ba4\u540e\u64a4\u9500\uff09", "RedConfirmStatusEnum_8", "imc-sim-common"), "09"),
    EXCEPTION_CONFIRM(new MultiLangEnumBridge("\u4f5c\u5e9f\uff08\u5f02\u5e38\u51ed\u8bc1\uff09", "RedConfirmStatusEnum_9", "imc-sim-common"), "10");

    private MultiLangEnumBridge bridge;
    private String billCode;
    public static final ImmutableSet<String> validConfirmStatus;

    private RedConfirmStatusEnum(MultiLangEnumBridge bridge, String billCode) {
        this.bridge = bridge;
        this.billCode = billCode;
    }

    public String getDesc() {
        return this.bridge.loadKDString();
    }

    public String getBillCode() {
        return this.billCode;
    }

    public static String getBillCodeByDesc(String billCode) {
        return ((RedConfirmStatusEnum)Objects.requireNonNull(Arrays.stream(RedConfirmStatusEnum.values()).filter(e -> e.getBillCode().equals(billCode)).findFirst().orElse(null))).getDesc();
    }

    public static boolean isRevokeRed(String confirmStatus) {
        return ImmutableSet.of((Object)RedConfirmStatusEnum.NO_CONFIRM.billCode, (Object)RedConfirmStatusEnum.BUYER_CONFIRM.billCode, (Object)RedConfirmStatusEnum.SELLER_CONFIRM.billCode, (Object)RedConfirmStatusEnum.ALL_CONFIRM.billCode).contains((Object)confirmStatus);
    }

    public static boolean isQuickRedByNumber(String confirmStatus) {
        return ImmutableSet.of((Object)RedConfirmStatusEnum.NO_CONFIRM.billCode, (Object)RedConfirmStatusEnum.BUYER_CONFIRM.billCode, (Object)RedConfirmStatusEnum.SELLER_CONFIRM.billCode, (Object)RedConfirmStatusEnum.ALL_CONFIRM.billCode).contains((Object)confirmStatus);
    }

    static {
        validConfirmStatus = new ImmutableSet.Builder().add((Object[])new String[]{SALES_DISCOUNTS.getBillCode(), SELLER_CANCEL.getBillCode(), TIME_CANCEL.getBillCode(), CREATOR_REVOKE.getBillCode(), CONFIRM_REVOKE.getBillCode(), EXCEPTION_CONFIRM.getBillCode()}).build();
    }
}

