/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.dto.bgd.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.common.dto.bgd.request.BgdListRequestDTO;

public class BgdCollectDTO
extends BgdListRequestDTO {
    private Date start;
    private Date end;
    private DynamicObject org;
    private String bgdSource;
    private String ddateks;
    private String ddatejs;
    private String completeStatusCode;

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public DynamicObject getOrg() {
        return this.org;
    }

    public void setOrg(DynamicObject org) {
        this.org = org;
    }

    public String getStartYear() {
        return DateUtils.format((Date)this.start, (String)"yyyy");
    }

    public String getEndYear() {
        return DateUtils.format((Date)this.end, (String)"yyyy");
    }

    public String getStartMonth() {
        return DateUtils.format((Date)this.start, (String)"MM");
    }

    public String getEndMonth() {
        return DateUtils.format((Date)this.end, (String)"MM");
    }

    public String getBgdSource() {
        return this.bgdSource;
    }

    public void setBgdSource(String bgdSource) {
        this.bgdSource = bgdSource;
    }

    @Override
    public String getDdateks() {
        return this.ddateks;
    }

    @Override
    public void setDdateks(String ddateks) {
        this.ddateks = ddateks;
    }

    @Override
    public String getDdatejs() {
        return this.ddatejs;
    }

    @Override
    public void setDdatejs(String ddatejs) {
        this.ddatejs = ddatejs;
    }

    public String getCompleteStatusCode() {
        return this.completeStatusCode;
    }

    public void setCompleteStatusCode(String completeStatusCode) {
        this.completeStatusCode = completeStatusCode;
    }

    public BgdListRequestDTO generateListDto() {
        BgdListRequestDTO listDto = new BgdListRequestDTO();
        listDto.setDdateks(this.getDdateks());
        listDto.setDdatejs(this.getDdatejs());
        listDto.setEntryid(this.getEntryid());
        return listDto;
    }

    public List<BgdListRequestDTO> generateListDtos() {
        ArrayList<BgdListRequestDTO> result = new ArrayList<BgdListRequestDTO>();
        Calendar canlendarStart = Calendar.getInstance();
        canlendarStart.setTime(this.start);
        return this.splitTime(result, canlendarStart);
    }

    public List<BgdListRequestDTO> splitTime(ArrayList<BgdListRequestDTO> result, Calendar canlendarStart) {
        Date tempStartTime = canlendarStart.getTime();
        BgdListRequestDTO listDto = new BgdListRequestDTO();
        listDto.setDdateks(DateUtils.format((Date)tempStartTime, (String)"yyyy-MM-dd"));
        canlendarStart.add(5, 6);
        Date mediumTime = canlendarStart.getTime();
        Date tempEndTime = DateUtils.compare((Date)this.end, (Date)mediumTime) > 0 ? mediumTime : this.end;
        listDto.setDdatejs(DateUtils.format((Date)tempEndTime, (String)"yyyy-MM-dd"));
        listDto.setEntryid(this.getEntryid());
        result.add(listDto);
        if (DateUtils.compare((Date)this.end, (Date)mediumTime) > 0) {
            canlendarStart.add(5, 1);
            return this.splitTime(result, canlendarStart);
        }
        return result;
    }
}

