/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HTXXUtil;
import org.apache.commons.lang.StringUtils;

public class BwServerInvoiceHelper {
    private static final Log logger = LogFactory.getLog(BwServerInvoiceHelper.class);

    public static MsgResponse invoiceAbolish(DynamicObject invoiceDynamicObject, MsgResponse msgResponse) {
        String res;
        try {
            JSONObject invoiceJson = new JSONObject();
            DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)invoiceDynamicObject, (JSONObject)invoiceJson);
            res = UnitTestHelper.isUnitTest() ? ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u4f5c\u5e9f\u53d1\u7968\u6210\u529f", (String)"BwServerInvoiceHelper_0", (String)"imc-sim-common", (Object[])new Object[0]) : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"BwServerOpenInvoice", (String)"invoice_abolish");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u53d1\u7968\u53f7\u7801\uff1a%s,\u5df2\u5f00\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), invoiceJson.getString("invoiceno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static void handleAbolishResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u53d1\u7968\u4f5c\u5e9f\u5931\u8d25", (String)"BwServerInvoiceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static MsgResponse redInfoUpload(DynamicObject redInfo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = DynamicObjectUtil.dynamicObject2Json((DynamicObject)redInfo);
            if (StringUtils.isEmpty((String)redInfo.getString("submitter"))) {
                redInfo.set("submitter", (Object)RequestContext.get().getOrgId());
                invoiceJson.put("submitter", (Object)RequestContext.get().getUserName());
            } else {
                invoiceJson.put("submitter", (Object)redInfo.getString("submitter.name"));
            }
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"BwServerOpenInvoice", (String)"redinfo_upload");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleRedInfoSubmitResponse(res, msgResponse);
        return msgResponse;
    }

    public static void handleRedInfoSubmitResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u5931\u8d25", (String)"BwServerInvoiceHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static void handleRedInfoDownloadResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u6570\u636e", (String)"BwServerInvoiceHelper_3", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static MsgResponse blankInvoiceAbolish(String taxNo, String invoiceCode, String invoiceType, String invoiceNo, String equipmentNo, String terminalNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("salertaxno", (Object)taxNo);
            invoiceJson.put("jqbh", (Object)equipmentNo);
            invoiceJson.put("invoicecode", (Object)invoiceCode);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("terminalno", (Object)terminalNo);
            invoiceJson.put("invoiceno", (Object)invoiceNo);
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"BwServerOpenInvoice", (String)"blank_invoice_abolish");
            logger.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a%s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%s,\u7ec8\u7aef\u53f7\uff1a%s,\u7a7a\u767d\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", invoiceCode, invoiceNo, terminalNo, res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7a7a\u767d\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleBlankAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static void handleBlankAbolishResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u7a7a\u767d\u53d1\u7968\u4f5c\u5e9f\u5931\u8d25", (String)"BwServerInvoiceHelper_4", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static int getStockIntValue(String equipmentNo, String terminalNo, String invoiceType, String devNo, String taxNo) {
        MsgResponse response = BwServerInvoiceHelper.getInvoiceStock(equipmentNo, terminalNo, invoiceType, devNo, taxNo);
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            String res = response.getRespData();
            JSONObject retJson = JSONObject.parseObject((String)res);
            String remainder = retJson.getString("remainder");
            return Integer.parseInt(remainder);
        }
        logger.info(String.format("invoicetype:%s", invoiceType));
        throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BwServerInvoiceHelper_5", (String)"imc-sim-common", (Object[])new Object[0]));
    }

    public static MsgResponse getInvoiceStock(String equipmentNo, String terminalNo, String invoiceType, String devNo, String taxNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("terminalno", (Object)terminalNo);
            invoiceJson.put("jqbh", (Object)equipmentNo);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("salertaxno", (Object)taxNo);
            res = UnitTestHelper.isUnitTest() ? "{\"remainder\" : \"99999\", \"invoice_code\" : \"1111111111\", \"invoice_num\" : \"11111111\"}" : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"BwServerOpenInvoice", (String)"stock");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7ec8\u7aef\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u8bf7\u6c42\u53d1\u7968\u9886\u8d2d\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c:%s", devNo, terminalNo, taxNo, res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleInvoiceStockResponse(res, msgResponse);
        return msgResponse;
    }

    public static void handleInvoiceStockResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u4f59\u7968\u5931\u8d25", (String)"BwServerInvoiceHelper_6", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static MsgResponse getInvoice(JSONObject invoiceJson) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"BwServerOpenInvoice", (String)"query_invoice");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7ec8\u7aef\u53f7\uff1a%s,\u8bf7\u6c42\u53d1\u7968\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("terminalno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleGetInvoiceResponse(res, msgResponse);
        return msgResponse;
    }

    public static void handleGetInvoiceResponse(String res, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
            msgResponse.setRespData(res);
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u672a\u5f00\u7968\u53f7\u5931\u8d25", (String)"BwServerInvoiceHelper_7", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }
}

