/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HTXXUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.RedInfoHelper;

public class HostModeInvoiceHelper {
    private static final Log logger = LogFactory.getLog(HostModeInvoiceHelper.class);

    public static MsgResponse invoiceAbolish(DynamicObject invoiceDynamicObject, MsgResponse msgResponse) {
        String res;
        try {
            JSONObject invoiceJson = new JSONObject();
            DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)invoiceDynamicObject, (JSONObject)invoiceJson);
            res = UnitTestHelper.isUnitTest() ? ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u4f5c\u5e9f\u53d1\u7968\u6210\u529f", (String)"HostModeInvoiceHelper_0", (String)"imc-sim-common", (Object[])new Object[0]) : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"invoice_abolish");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u53d1\u7968\u53f7\u7801\uff1a%s,\u5df2\u5f00\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), invoiceJson.getString("invoiceno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse redInfoUpload(JSONObject invoiceJson) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"redinfo_upload");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0a\u4f20\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleRedInfoSubmitResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse redInfoDownload(JSONObject invoiceJson) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"redinfo_download");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u8fd4\u56de\u7ed3\u679c:%s", invoiceJson.getString("jqbh"), invoiceJson.getString("salertaxno"), res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7ea2\u5b57\u4fe1\u606f\u8868\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleRedInfoDownloadResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse blankInvoiceAbolish(String taxNo, String invoiceType, String devNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("salertaxno", (Object)taxNo);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("jqbh", (Object)devNo);
            invoiceJson.put("orderno", (Object)UUID.next());
            res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"blank_invoice_abolish");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u7a7a\u767d\u4f5c\u5e9f\u8fd4\u56de\u7ed3\u679c:%s", devNo, taxNo, res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7a7a\u767d\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            msgResponse.setErrorCode(ErrorType.FAIL.getCode());
            msgResponse.setErrorMsg(e.getMessage());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleBlankAbolishResponse(res, msgResponse);
        return msgResponse;
    }

    public static MsgResponse getInvoiceStock(String taxNo, String invoiceType, String devNo) {
        String res;
        MsgResponse msgResponse = new MsgResponse();
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("salertaxno", (Object)taxNo);
            invoiceJson.put("invoicetype", (Object)invoiceType);
            invoiceJson.put("jqbh", (Object)devNo);
            invoiceJson.put("orderno", (Object)UUID.next());
            res = UnitTestHelper.isUnitTest() ? "{\"remainder\" : \"99999\", \"invoice_code\" : \"1111111111\", \"invoice_num\" : \"11111111\"}" : HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"stock");
            logger.info(String.format("\u8bbe\u5907\u7f16\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u8bf7\u6c42\u4f59\u7968\u8fd4\u56de\u7ed3\u679c:%s", devNo, taxNo, res));
        }
        catch (MsgException e) {
            msgResponse.setErrorCode(e.getErrorCode());
            msgResponse.setErrorMsg(e.getErrorMsg());
            return msgResponse;
        }
        BwServerInvoiceHelper.handleInvoiceStockResponse(res, msgResponse);
        return msgResponse;
    }

    public static int getStockIntValue(String taxNo, String invoiceType, String devNo) {
        MsgResponse response = HostModeInvoiceHelper.getInvoiceStock(taxNo, invoiceType, devNo);
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            String res = response.getRespData();
            JSONObject retJson = JSONObject.parseObject((String)res);
            String remainder = retJson.getString("remainder");
            return Integer.parseInt(StringUtils.isNotEmpty((CharSequence)remainder) ? remainder : "0");
        }
        logger.info(String.format("invoicetype:%s", invoiceType));
        throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5e93\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HostModeInvoiceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
    }

    public static void revokeRedInfo(List<DynamicObject> successObjs, DynamicObject redInfo, OperationResult operationResult) {
        try {
            JSONObject invoiceJson = new JSONObject();
            invoiceJson.put("infocode", (Object)redInfo.getString("infocode"));
            invoiceJson.put("jqbh", (Object)redInfo.getString("jqbh"));
            invoiceJson.put("salertaxno", (Object)redInfo.getString("salertaxno"));
            invoiceJson.put("applytaxno", (Object)redInfo.getString("applytaxno"));
            invoiceJson.put("invoicetype", (Object)redInfo.getString("invoicetype"));
            invoiceJson.put("orderno", (Object)UUID.next());
            String res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJson, (String)"HostModeOpenInvoice", (String)"redinfo_revoke");
            logger.info(String.format("\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\uff1a%s,\u64a4\u9500\u8fd4\u56de\u7ed3\u679c:%s", redInfo.getString("infocode"), res));
            RedInfoHelper.revokeRedInfo(redInfo);
            successObjs.add(redInfo);
        }
        catch (MsgException e) {
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u7a0e\u5c40\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"HostModeInvoiceHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), e.getErrorMsg())));
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7a7a\u767d\u4f5c\u5e9f\u5f02\u5e38\uff1a", (Throwable)e);
            operationResult.addErrorInfo((OperateErrorInfo)RedInfoHelper.buildValidationErrorInfo(redInfo, String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u7a0e\u5c40\u64a4\u9500\u5931\u8d25\uff0c%2$s", (String)"HostModeInvoiceHelper_2", (String)"imc-sim-common", (Object[])new Object[0]), redInfo.getString("infoserialno"), e.getMessage())));
        }
    }
}

