/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.util.MqPublishUtils;

public class ReOpenInvoiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ReOpenInvoiceHelper.class);

    public static void issueReOpenInvoice(DynamicObject originalBill, DynamicObject invoice, HashMap<String, DynamicObject> invalidBillMap) {
        try {
            DynamicObject[] invoices;
            DynamicObject[] reOpenBills;
            String invoiceStatus = invoice.getString("invoicestatus");
            if ("3".equals(invoiceStatus)) {
                return;
            }
            if ("6".equals(invoiceStatus)) {
                if (invalidBillMap.containsKey("INVALID_BILL")) {
                    DynamicObject bill = invalidBillMap.get("INVALID_BILL");
                    if (null == bill) {
                        return;
                    }
                    originalBill = bill;
                } else {
                    String invoiceCode = invoice.getString("invoicecode");
                    String invoiceNo = invoice.getString("invoiceno");
                    QFilter filters = new QFilter("invoicecode", "=", (Object)invoiceCode).and(new QFilter("invoiceno", "=", (Object)invoiceNo)).and("billsourcetype", "=", (Object)"C");
                    DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "billstatus", "billsourcetype", "billproperties"), (QFilter[])filters.toArray());
                    if (originalBills.length == 0) {
                        invalidBillMap.put("INVALID_BILL", null);
                        return;
                    }
                    originalBill = originalBills[0];
                    invalidBillMap.put("INVALID_BILL", originalBill);
                }
            }
            String billState = originalBill.getString("billstatus");
            if (!BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billState)) {
                return;
            }
            String billSourceType = originalBill.getString("billsourcetype");
            if (("B".equals(billSourceType) || "C".equals(billSourceType)) && (reOpenBills = RelationHelper.queryReopenBills((DynamicObject)originalBill)).length > 0 && (invoices = RelationHelper.queryRelateWaitInvoice((DynamicObject)reOpenBills[0])).length > 0) {
                for (DynamicObject dynamicObject : invoices) {
                    dynamicObject.set("issuebillstatus", (Object)"D");
                }
                SaveServiceHelper.update((DynamicObject[])invoices);
                ReOpenInvoiceHelper.submitInvoice2MQ(invoices);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("issueReOpenInvoiceError,invoiceCode:%s,invoiceNo:%s", invoice.getString("invoicecode"), invoice.getString("invoiceno")), (Throwable)e);
        }
    }

    private static void submitInvoice2MQ(DynamicObject[] vatInvoiceList) {
        Map<String, List<DynamicObject>> batchDynamicObjectMap = Stream.of(vatInvoiceList).collect(Collectors.groupingBy(k -> ReOpenInvoiceHelper.getIssueInvoiceLockKey(k.getString("salertaxno"), k.getString("jqbh"))));
        LOGGER.info("submitInvoice2MQ_length" + vatInvoiceList.length);
        batchDynamicObjectMap.forEach((lockKey, list) -> MqPublishUtils.publish((String)"imc", (String)"imc.sim.sim_queue", list.stream().map(obj -> obj.getString("orderno")).collect(Collectors.toList())));
    }

    private static String getIssueInvoiceLockKey(String saleTaxNo, String devno) {
        return saleTaxNo + "_" + devno;
    }
}

