/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.allele;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ZipUtils;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecificTaxationMethodEnum;
import kd.imc.bdm.file.fpy.enums.TaxpayerTypeEnum;
import kd.imc.bdm.file.fpy.model.pdf.fedi.CargoTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoiceItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.PassengerTransportItem;
import kd.imc.bdm.file.fpy.model.xml.ConstructionServicesItem;
import kd.imc.bdm.file.fpy.model.xml.FullDigitalEInvoiceXml;
import kd.imc.bdm.file.fpy.model.xml.RealEstateLeaseItem;
import kd.imc.bdm.file.fpy.model.xml.RealEstateSalesItem;
import kd.imc.bdm.file.fpy.service.OutputFileService;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.enums.TransportTypeEnum;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.file.InvoiceFileUploadService;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AllEleInvoiceFileHelper {
    private static final Log log = LogFactory.getLog(AllEleInvoiceFileHelper.class);
    private static final String[] fileTypes = new String[]{FileType.XML.getFileExtension(), FileType.OFD.getFileExtension(), FileType.PDF.getFileExtension(), FileType.JPG.getFileExtension()};
    public static final String personStr = "\uff08\u4e2a\u4eba\uff09";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileRecord(DynamicObject invoice, String issueChannel) {
        DLock dLock = null;
        try {
            if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("\u53d1\u7968\u53f7\u7801:[%s]\u65b0\u589e\u6587\u4ef6\u8bb0\u5f55", invoice.getString("invoiceno")));
            }
            String invoiceNo = invoice.getString("invoiceno");
            Date issueTime = invoice.getDate("issuetime");
            dLock = DLock.create((String)(AllEleInvoiceFileHelper.class + invoice.getString("invoiceno")));
            dLock.lock();
            QFilter qFilter = new QFilter("issuetime", ">=", (Object)DateUtils.addDay((Date)issueTime, (int)-1)).and("issuetime", "<=", (Object)DateUtils.addDay((Date)issueTime, (int)1)).and("filetype", "in", (Object)fileTypes).and("invoiceno", "=", (Object)invoiceNo);
            DynamicObject[] files = BusinessDataServiceHelper.load((String)"sim_vatinvoice_file", (String)String.join((CharSequence)",", "callbacktype", "localfilestatus", "remotefilestatus"), (QFilter[])qFilter.toArray());
            if (files.length != 0) {
                return;
            }
            ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(4);
            Pair<String, String> snapshotUrlPair = null;
            for (String fileType : fileTypes) {
                DynamicObject invoiceFile = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_file");
                invoiceFile.set("salertaxno", (Object)invoice.getString("salertaxno"));
                invoiceFile.set("orderno", (Object)invoice.getString("orderno"));
                invoiceFile.set("invoiceno", (Object)invoice.getString("invoiceno"));
                invoiceFile.set("invoiceid", invoice.getPkValue());
                invoiceFile.set("issuetime", invoice.get("issuetime"));
                invoiceFile.set("issuechannel", (Object)issueChannel);
                invoiceFile.set("filetype", (Object)fileType);
                String notUploadS3 = ImcConfigUtil.getValue((String)"invoicefile_config", (String)"not_upload_s3");
                if ("notUploadS3".equals(notUploadS3)) {
                    invoiceFile.set("callbacktype", (Object)"local");
                } else {
                    invoiceFile.set("callbacktype", (Object)"remote");
                }
                switch (fileType) {
                    case "pdf": {
                        snapshotUrlPair = AllEleInvoiceFileHelper.createPdf(invoice, invoiceFile);
                        break;
                    }
                    case "xml": {
                        AllEleInvoiceFileHelper.createXml(invoice, invoiceFile);
                        break;
                    }
                    case "ofd": {
                        AllEleInvoiceFileHelper.createOfd(invoice, invoiceFile);
                        break;
                    }
                    case "jpg": {
                        AllEleInvoiceFileHelper.createJpg(invoice, invoiceFile, snapshotUrlPair);
                    }
                }
                records.add(invoiceFile);
            }
            ImcSaveServiceHelper.save(records);
            if (log.isInfoEnabled()) {
                log.info(String.format("\u53d1\u7968\u53f7\u7801:[%s]\u65b0\u589e\u6587\u4ef6\u8bb0\u5f55\u7ed3\u675f", invoice.getString("invoiceno")));
            }
        }
        finally {
            if (dLock != null) {
                dLock.unlock();
            }
        }
    }

    public static void createJpg(DynamicObject invoice, DynamicObject invoiceFile, Pair<String, String> snapshotUrlPair) {
        if (snapshotUrlPair != null) {
            String localFile = (String)snapshotUrlPair.getKey();
            String remoteFile = (String)snapshotUrlPair.getValue();
            invoiceFile.set("localfileurl", (Object)localFile);
            invoiceFile.set("localfilestatus", (Object)(StringUtils.isNotBlank((CharSequence)localFile) ? "1" : "-1"));
            invoiceFile.set("remotefileurl", (Object)remoteFile);
            invoiceFile.set("remotefilestatus", (Object)(StringUtils.isNotBlank((CharSequence)remoteFile) ? "1" : "-1"));
            if ("rpa".equals(invoiceFile.getString("issuechannel"))) {
                invoiceFile.set("remotefilestatus", (Object)"-1");
                if ("local".equals(invoiceFile.getString("callbacktype"))) {
                    invoice.set("snapshoturl", (Object)"");
                }
            }
        }
    }

    public static void createOfd(DynamicObject invoice, DynamicObject invoiceFile) {
        if ("rpa".equals(invoiceFile.getString("issuechannel"))) {
            invoiceFile.set("remotefileurl", (Object)invoice.getString("fileurl"));
            invoiceFile.set("remotefilestatus", (Object)"-1");
            if ("local".equals(invoiceFile.getString("callbacktype"))) {
                invoice.set("fileurl", (Object)"");
            }
            return;
        }
        AllEleInvoiceFileHelper.createLqOrVirtualOfd(invoice, invoiceFile);
    }

    private static void createLqOrVirtualOfd(DynamicObject invoice, DynamicObject invoiceFile) {
        try {
            OutputFileService outputFileService;
            byte[] ofd;
            DynamicObject epInfo = TaxUtils.getEpInfoByOrg((Long)invoice.getDynamicObject("orgid").getLong("id"));
            DynamicObject epBaseInfo = epInfo.getDynamicObject("epinfo");
            String orgTaxNo = epBaseInfo.getString("number");
            String dir = FileUploadUtils.getInvoiceDir((String)"simeinv");
            String ofdFileName = invoice.getString("invoiceno") + ".ofd";
            boolean testFlag = false;
            if ("virtual".equals(invoiceFile.getString("issuechannel"))) {
                testFlag = true;
            } else if ("lqpt".equals(invoiceFile.getString("issuechannel")) && "1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sxcsbz"))) {
                ofdFileName = invoice.getString("orderno") + ".ofd";
                testFlag = true;
            }
            DynamicObject dataInvoice = AllEleInvoiceFileHelper.getAcquisitionData(invoice, orgTaxNo);
            FullDigitalEInvoice eInvoice = AllEleInvoiceFileHelper.createFullDigitalEInvoice(dataInvoice);
            String zgswskfjdm = epInfo.getString("zgswskfjdm");
            if (StringUtils.isNotEmpty((CharSequence)zgswskfjdm)) {
                eInvoice.setTaxBureauCode(zgswskfjdm);
            }
            if ((ofd = (outputFileService = new OutputFileService()).createOfd(eInvoice)) == null) {
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFile.set("remotefilestatus", (Object)"-1");
                invoice.set("ofdstatus", (Object)"0");
                invoice.set("fileurl", (Object)"");
                return;
            }
            String fileFullName = dir + ofdFileName;
            FileUploadUtils.delete((String)fileFullName);
            String ofdUrl = FileUploadUtils.uploadBytes((String)fileFullName, (String)ofdFileName, (byte[])ofd);
            invoiceFile.set("localfileurl", (Object)ofdUrl);
            invoiceFile.set("localfilestatus", (Object)"1");
            if ("remote".equals(invoiceFile.getString("callbacktype"))) {
                Pair<String, String> urlPair = AllEleInvoiceFileHelper.uploadS3(ofd, ofdUrl, orgTaxNo, "s3_ofd_upload", invoice.getString("orderno") + ".ofd", testFlag, invoiceFile.getString("remotefileurl"));
                invoiceFile.set("remotefileurl", urlPair.getKey());
                invoiceFile.set("remotefilestatus", (Object)(StringUtils.isNotBlank((CharSequence)((CharSequence)urlPair.getKey())) ? "1" : "-1"));
                invoice.set("fileurl", urlPair.getKey());
            } else {
                invoiceFile.set("remotefilestatus", (Object)"-1");
                invoice.set("fileurl", (Object)ofdUrl);
            }
            invoice.set("ofdstatus", (Object)(StringUtils.isNotBlank((CharSequence)invoice.getString("fileurl")) ? "1" : "0"));
        }
        catch (KDBizException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (ErrorType.USER_ERROR_A0420.errcode.equals(errorCode.getCode())) {
                log.error(String.format("\u751f\u6210ofd\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
                invoiceFile.set("localfilestatus", (Object)"1");
                invoiceFile.set("remotefilestatus", (Object)"1");
            } else {
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFile.set("remotefilestatus", (Object)"-1");
            }
        }
        catch (Exception e) {
            log.error(String.format("\u751f\u6210ofd\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
            invoiceFile.set("localfilestatus", (Object)"-1");
            invoiceFile.set("remotefilestatus", (Object)"-1");
        }
    }

    public static Pair<String, String> createPdf(DynamicObject invoice, DynamicObject invoiceFile) {
        if ("rpa".equals(invoiceFile.getString("issuechannel"))) {
            invoiceFile.set("remotefileurl", (Object)invoice.getString("pdffileurl"));
            invoiceFile.set("remotefilestatus", (Object)"-1");
            if ("local".equals(invoiceFile.getString("callbacktype"))) {
                invoice.set("pdffileurl", (Object)"");
            }
            return Pair.of((Object)"", (Object)invoice.getString("snapshoturl"));
        }
        return AllEleInvoiceFileHelper.createLqOrVirtualPdf(invoice, invoiceFile);
    }

    public static void createXml(DynamicObject invoice, DynamicObject invoiceFile) {
        if ("rpa".equals(invoiceFile.getString("issuechannel"))) {
            invoiceFile.set("remotefileurl", (Object)invoice.getString("xmlfileurl"));
            invoiceFile.set("remotefilestatus", (Object)"-1");
            if ("local".equals(invoiceFile.getString("callbacktype"))) {
                invoice.set("xmlfileurl", (Object)"");
            }
            return;
        }
        AllEleInvoiceFileHelper.createLqOrVirtualXml(invoice, invoiceFile);
    }

    private static void createLqOrVirtualXml(DynamicObject invoice, DynamicObject invoiceFile) {
        try {
            byte[] xml;
            DynamicObject epInfo = TaxUtils.getEpInfoByOrg((Long)invoice.getDynamicObject("orgid").getLong("id"));
            DynamicObject epBaseInfo = epInfo.getDynamicObject("epinfo");
            String orgTaxNo = epBaseInfo.getString("number");
            String fileNamePre = invoice.getString("invoiceno");
            boolean testFlag = false;
            if ("virtual".equals(invoiceFile.getString("issuechannel"))) {
                testFlag = true;
            } else if ("lqpt".equals(invoiceFile.getString("issuechannel")) && "1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sxcsbz"))) {
                fileNamePre = invoice.getString("orderno");
                testFlag = true;
            }
            DynamicObject dataInvoice = AllEleInvoiceFileHelper.getAcquisitionData(invoice, orgTaxNo);
            FullDigitalEInvoiceXml eInvoiceXml = AllEleInvoiceFileHelper.createFullDigitalEInvoiceXml(dataInvoice, epInfo, orgTaxNo);
            String zgswskfjdm = epInfo.getString("zgswskfjdm");
            if (StringUtils.isNotEmpty((CharSequence)zgswskfjdm)) {
                eInvoiceXml.setTaxBureauCode(zgswskfjdm);
            }
            if ((xml = new OutputFileService().createXml(eInvoiceXml)) == null) {
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFile.set("remotefilestatus", (Object)"-1");
                return;
            }
            String xmlFileName = fileNamePre + ".xml";
            String fileFullName = FileUploadUtils.getInvoiceDir((String)"simeinv") + xmlFileName;
            FileUploadUtils.delete((String)fileFullName);
            String fileUrl = FileUploadUtils.uploadBytes((String)fileFullName, (String)xmlFileName, (byte[])xml);
            invoiceFile.set("localfileurl", (Object)fileUrl);
            invoiceFile.set("localfilestatus", (Object)"1");
            if ("remote".equals(invoiceFile.getString("callbacktype"))) {
                byte[] zip = ZipUtils.compressFileDataToZIP((byte[])xml, (String)(fileNamePre + ".xml"));
                if (zip != null) {
                    Pair<String, String> urlPair = AllEleInvoiceFileHelper.uploadS3(zip, fileUrl, orgTaxNo, "s3_file_upload", invoice.getString("orderno") + ".zip", testFlag, invoiceFile.getString("remotefileurl"));
                    invoiceFile.set("remotefileurl", urlPair.getKey());
                    invoiceFile.set("remotefilestatus", (Object)(StringUtils.isNotBlank((CharSequence)((CharSequence)urlPair.getKey())) ? "1" : "-1"));
                    invoice.set("xmlfileurl", urlPair.getKey());
                } else {
                    invoiceFile.set("remotefilestatus", (Object)"-1");
                    invoice.set("xmlfileurl", (Object)"");
                }
            } else {
                invoiceFile.set("remotefilestatus", (Object)"-1");
                invoice.set("xmlfileurl", (Object)fileUrl);
            }
        }
        catch (KDBizException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (ErrorType.USER_ERROR_A0420.errcode.equals(errorCode.getCode())) {
                log.error(String.format("\u751f\u6210xml\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
                invoiceFile.set("localfilestatus", (Object)"1");
                invoiceFile.set("remotefilestatus", (Object)"1");
            } else {
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFile.set("remotefilestatus", (Object)"-1");
            }
        }
        catch (Exception e) {
            log.error(String.format("\u751f\u6210xml\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
            invoiceFile.set("localfilestatus", (Object)"-1");
            invoiceFile.set("remotefilestatus", (Object)"-1");
        }
    }

    private static Pair<String, String> createLqOrVirtualPdf(DynamicObject invoice, DynamicObject invoiceFile) {
        try {
            OutputFileService outputFileService;
            byte[] pdf;
            DynamicObject epInfo = TaxUtils.getEpInfoByOrg((Long)invoice.getDynamicObject("orgid").getLong("id"));
            DynamicObject epBaseInfo = epInfo.getDynamicObject("epinfo");
            String orgTaxNo = epBaseInfo.getString("number");
            String fileName = invoice.getString("invoiceno") + ".pdf";
            boolean testFlag = false;
            if ("virtual".equals(invoiceFile.getString("issuechannel"))) {
                testFlag = true;
            } else if ("lqpt".equals(invoiceFile.getString("issuechannel")) && "1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"sxcsbz"))) {
                fileName = invoice.getString("orderno") + ".pdf";
                testFlag = true;
            }
            DynamicObject dataInvoice = AllEleInvoiceFileHelper.getAcquisitionData(invoice, orgTaxNo);
            FullDigitalEInvoice eInvoice = AllEleInvoiceFileHelper.createFullDigitalEInvoice(dataInvoice);
            String zgswskfjdm = epInfo.getString("zgswskfjdm");
            if (StringUtils.isNotEmpty((CharSequence)zgswskfjdm)) {
                eInvoice.setTaxBureauCode(zgswskfjdm);
            }
            if ((pdf = (outputFileService = new OutputFileService()).createPdf(eInvoice)) == null) {
                return Pair.of((Object)"", (Object)"");
            }
            String dir = FileUploadUtils.getInvoiceDir((String)"simeinv");
            String fullUrlName = dir + fileName;
            FileUploadUtils.delete((String)fullUrlName);
            String pdfUrl = FileUploadUtils.uploadBytes((String)fullUrlName, (String)fileName, (byte[])pdf);
            invoiceFile.set("localfileurl", (Object)pdfUrl);
            invoiceFile.set("localfilestatus", (Object)"1");
            String imageUrl = outputFileService.pdf2image(pdf, dir, eInvoice.getInvoiceNo() + ".jpg");
            invoice.set("snapshoturl", (Object)imageUrl);
            if ("remote".equals(invoiceFile.getString("callbacktype"))) {
                Pair<String, String> urlPair = AllEleInvoiceFileHelper.uploadS3(pdf, pdfUrl, orgTaxNo, "s3_pdf_upload", invoice.getString("orderno") + ".pdf", testFlag, invoiceFile.getString("remotefileurl"));
                invoice.set("pdffileurl", urlPair.getKey());
                invoice.set("snapshoturl", urlPair.getValue());
                invoiceFile.set("remotefileurl", urlPair.getKey());
                invoiceFile.set("remotefilestatus", (Object)(StringUtils.isNotBlank((CharSequence)((CharSequence)urlPair.getKey())) ? "1" : "-1"));
                return Pair.of((Object)imageUrl, (Object)urlPair.getValue());
            }
            invoice.set("pdffileurl", (Object)pdfUrl);
            invoiceFile.set("remotefilestatus", (Object)"-1");
            return Pair.of((Object)imageUrl, (Object)"");
        }
        catch (KDBizException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (ErrorType.USER_ERROR_A0420.errcode.equals(errorCode.getCode())) {
                log.error(String.format("\u751f\u6210pdf\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
                invoiceFile.set("localfilestatus", (Object)"1");
                invoiceFile.set("remotefilestatus", (Object)"1");
            } else {
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFile.set("remotefilestatus", (Object)"-1");
            }
            return Pair.of((Object)"", (Object)"");
        }
        catch (Exception e) {
            log.error(String.format("\u751f\u6210pdf\u5931\u8d25\uff0c\u53d1\u7968\u6570\u636e[%s]", SerializationUtils.toJsonString((Object)invoice)), (Throwable)e);
            return Pair.of((Object)"", (Object)"");
        }
    }

    private static Pair<String, String> uploadS3(byte[] fileBytes, String localUrl, String orgTaxNo, String type, String fileName, boolean testFlag, String remoteUrl) {
        return InvoiceFileUploadService.newInstance().upload(fileBytes, localUrl, orgTaxNo, type, fileName, testFlag, remoteUrl);
    }

    public static FullDigitalEInvoice createFullDigitalEInvoice(DynamicObject invoice) {
        FullDigitalEInvoice eInvoice = (FullDigitalEInvoice)DynamicObjectUtil.dynamicObject2Bean(FullDigitalEInvoice.class, (DynamicObject)invoice);
        eInvoice.setInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)eInvoice.getInvoiceType()));
        List itemList = eInvoice.getItemList();
        for (FullDigitalEInvoiceItem item : itemList) {
            if (MathUtils.isNullOrZero(item.getUnitPrice()) || MathUtils.isNullOrZero(item.getNum())) {
                item.setUnitPrice(null);
                item.setNum(null);
            }
            if (!"1".equals(item.getRowType())) continue;
            item.setSpecModel("");
            item.setUnit("");
        }
        AllEleInvoiceFileHelper.setRemark(eInvoice, invoice);
        AllEleInvoiceFileHelper.writeEstateSaleInfo(invoice, eInvoice);
        return eInvoice;
    }

    private static FullDigitalEInvoice writeEstateSaleInfo(DynamicObject invoice, FullDigitalEInvoice eInvoice) {
        if ("E05".equals(invoice.getString("specialtype"))) {
            List itemList = eInvoice.getItemList();
            DynamicObjectCollection estatesales = invoice.getDynamicObjectCollection("estatesales");
            for (int i = 0; i < estatesales.size(); ++i) {
                ((FullDigitalEInvoiceItem)itemList.get(i)).setUnit(((DynamicObject)estatesales.get(i)).getString("saleunit"));
                ((FullDigitalEInvoiceItem)itemList.get(i)).setSpecModel(((DynamicObject)estatesales.get(i)).getString("saleestateid"));
            }
        }
        return eInvoice;
    }

    private static DynamicObject getAcquisitionData(DynamicObject invoice, String orgTaxNo) {
        DynamicObject dataInvoice = (DynamicObject)OrmUtils.clone((IDataEntityBase)invoice, (boolean)false, (boolean)false);
        String specialTypeStr = dataInvoice.getString("specialtype");
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)specialTypeStr);
        if (SpecialTypeEnum.OTHER == specialType || SpecialTypeEnum.NOT_SPECIAL == specialType) {
            AllEleInvoiceFileHelper.setBuyerNameByInvoice(dataInvoice);
        } else if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
            String salerTaxNo = dataInvoice.getString("salertaxno");
            String buyerTaxNo = dataInvoice.getString("buyertaxno");
            if (StringUtils.isNotEmpty((CharSequence)orgTaxNo) && orgTaxNo.equals(salerTaxNo) && !orgTaxNo.equals(buyerTaxNo)) {
                IssueInvoiceService.reverseBuyerSellerByPurchase(dataInvoice);
            }
        }
        return dataInvoice;
    }

    private static void setBuyerNameByInvoice(DynamicObject invoice) {
        String buyerName = invoice.getString("buyername");
        String buyerProperty = invoice.getString("buyerproperty");
        if ("1".equals(buyerProperty) && StringUtils.isNotEmpty((CharSequence)buyerName) && !buyerName.endsWith(personStr)) {
            buyerName = buyerName + personStr;
        }
        invoice.set("buyername", (Object)buyerName);
    }

    private static FullDigitalEInvoiceXml createFullDigitalEInvoiceXml(DynamicObject invoice, DynamicObject epInfo, String orgTaxNo) {
        FullDigitalEInvoiceXml fullDigitalEInvoiceXml = (FullDigitalEInvoiceXml)DynamicObjectUtil.dynamicObject2Bean(FullDigitalEInvoiceXml.class, (DynamicObject)invoice);
        fullDigitalEInvoiceXml.setInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)fullDigitalEInvoiceXml.getInvoiceType()));
        if (epInfo != null) {
            String epType = epInfo.getString("eptype");
            TaxpayerTypeEnum taxpayerTypeEnum = TaxpayerTypeEnum.getTaxpayerTypeEnumByCode((String)epType);
            if (taxpayerTypeEnum != null) {
                fullDigitalEInvoiceXml.setTaxpayerType(taxpayerTypeEnum.getValue());
            }
            fullDigitalEInvoiceXml.setBusinessSectorType(epInfo.getString("qyhyxzdm"));
            fullDigitalEInvoiceXml.setConsumptionTaxpayerType(epInfo.getString("nsrlx"));
            fullDigitalEInvoiceXml.setExportEnterpriseClassification(epInfo.getString("ckqyfldm"));
            fullDigitalEInvoiceXml.setSpecificTaxationMethod(AllEleInvoiceFileHelper.getSpecificTaxationMethod(invoice));
            DynamicObject epBaseInfo = epInfo.getDynamicObject("epinfo");
            if (epBaseInfo != null && (epBaseInfo = BusinessDataServiceHelper.loadSingle((Object)epBaseInfo.getPkValue(), (String)"bdm_enterprise_baseinfo")) != null) {
                fullDigitalEInvoiceXml.setTaxpayerCreditGrade(epBaseInfo.getString("nsrxydj"));
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("salertelno"))) {
                String sellerAdder = invoice.getString("saleraddr");
                Pair<String, String> sellerAddressAndTelPair = AllEleInvoiceFileHelper.getAddressAndTelPair(sellerAdder);
                fullDigitalEInvoiceXml.setSalerAddr((String)sellerAddressAndTelPair.getKey());
                fullDigitalEInvoiceXml.setSalerTelNum((String)sellerAddressAndTelPair.getValue());
            } else {
                fullDigitalEInvoiceXml.setSalerAddr(invoice.getString("saleraddr"));
                fullDigitalEInvoiceXml.setSalerTelNum(invoice.getString("salertelno"));
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("salerbankacc"))) {
                String sellerBank = invoice.getString("salerbank");
                Pair<String, String> sellerBankPair = AllEleInvoiceFileHelper.getBankInfoPair(sellerBank);
                fullDigitalEInvoiceXml.setSalerBankName((String)sellerBankPair.getKey());
                fullDigitalEInvoiceXml.setSalerBankAccNum((String)sellerBankPair.getValue());
            } else {
                fullDigitalEInvoiceXml.setSalerBankName(invoice.getString("salerbank"));
                fullDigitalEInvoiceXml.setSalerBankAccNum(invoice.getString("salerbankacc"));
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("buyerbankacc"))) {
                String buyerBank = invoice.getString("buyerbank");
                Pair<String, String> buyerBankPair = AllEleInvoiceFileHelper.getBankInfoPair(buyerBank);
                fullDigitalEInvoiceXml.setBuyerBankName((String)buyerBankPair.getKey());
                fullDigitalEInvoiceXml.setBuyerBankAccNum((String)buyerBankPair.getValue());
            } else {
                fullDigitalEInvoiceXml.setBuyerBankName(invoice.getString("buyerbank"));
                fullDigitalEInvoiceXml.setBuyerBankAccNum(invoice.getString("buyerbankacc"));
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("buyertelno"))) {
                String buyerAdder = invoice.getString("buyeraddr");
                Pair<String, String> buyerAddressAndTelPair = AllEleInvoiceFileHelper.getAddressAndTelPair(buyerAdder);
                fullDigitalEInvoiceXml.setBuyerAddr((String)buyerAddressAndTelPair.getKey());
                fullDigitalEInvoiceXml.setBuyerTelNum((String)buyerAddressAndTelPair.getValue());
            } else {
                fullDigitalEInvoiceXml.setBuyerAddr(invoice.getString("buyeraddr"));
                fullDigitalEInvoiceXml.setBuyerTelNum(invoice.getString("buyertelno"));
            }
            DynamicObject agent = invoice.getDynamicObject("operator");
            if (agent != null) {
                fullDigitalEInvoiceXml.setBuyerHandlingName(agent.getString("name"));
            }
            AllEleInvoiceFileHelper.setSpecialInfo(null, null, fullDigitalEInvoiceXml, invoice);
            String differenceTaxType = fullDigitalEInvoiceXml.getDifferenceTaxType();
            if (StringUtils.isNotEmpty((CharSequence)differenceTaxType)) {
                String deduction = EInvoicePdfUtils.getPriceWithScale((BigDecimal)invoice.getBigDecimal("deduction"));
                fullDigitalEInvoiceXml.setDeduction(deduction);
                fullDigitalEInvoiceXml.setSalesIncludingTax(invoice.getString("totalamount"));
            }
            fullDigitalEInvoiceXml.setOriginalInvoiceCode(invoice.getString("originalEtaxInvoiceNo"));
            fullDigitalEInvoiceXml.setCreditNoteNumber(invoice.getString("infocode"));
            LqptService service = new LqptService();
            LqEpConfig lqEpConfig = service.getLqEpConfig(orgTaxNo);
            fullDigitalEInvoiceXml.setPtbh(lqEpConfig.getSydwptbh());
        }
        return fullDigitalEInvoiceXml;
    }

    private static String getSpecificTaxationMethod(DynamicObject invoice) {
        DynamicObjectCollection items2;
        ArrayList<String> list = new ArrayList<String>(8);
        String taxedType = invoice.getString("taxedtype");
        if (TaxedTypeEnum.deduction(taxedType)) {
            list.add(SpecificTaxationMethodEnum.INCREMENTAL_INVOICE.getValue());
        }
        if (TaxedTypeEnum.subtract.getValue().equals(taxedType)) {
            list.add(SpecificTaxationMethodEnum.REDUCTION.getValue());
        }
        if ((items2 = invoice.getDynamicObjectCollection("items")) != null) {
            for (DynamicObject item : items2) {
                BigDecimal taxRate;
                String zzstsgl = item.getString("zzstsgl");
                if (StringUtils.isEmpty((CharSequence)zzstsgl)) continue;
                String itemSpecificTaxationMethod = null;
                if (SpecificTaxationMethodEnum.NO_TAX.getMsg().equals(zzstsgl)) {
                    itemSpecificTaxationMethod = SpecificTaxationMethodEnum.NO_TAX.getValue();
                } else if (SpecificTaxationMethodEnum.EXEMPT.getMsg().equals(zzstsgl)) {
                    itemSpecificTaxationMethod = SpecificTaxationMethodEnum.EXEMPT.getValue();
                } else if (zzstsgl.contains("\u7b80\u6613\u5f81\u6536") && !zzstsgl.contains("\u51cf\u6309")) {
                    itemSpecificTaxationMethod = SpecificTaxationMethodEnum.SIMPLIFIED_TAXATION.getValue();
                }
                if (itemSpecificTaxationMethod == null && BigDecimal.ZERO.compareTo(taxRate = item.getBigDecimal("taxrate")) == 0) {
                    itemSpecificTaxationMethod = SpecificTaxationMethodEnum.ZERO_TAX_RATE.getValue();
                }
                if (itemSpecificTaxationMethod == null || list.contains(itemSpecificTaxationMethod)) continue;
                list.add(itemSpecificTaxationMethod);
            }
        }
        String specificTaxationMethod = null;
        if (!list.isEmpty()) {
            specificTaxationMethod = list.stream().sorted().collect(Collectors.joining(","));
        }
        return specificTaxationMethod;
    }

    private static void setRemark(FullDigitalEInvoice fullDigitalEInvoice, DynamicObject invoice) {
        String reviewer;
        String payee;
        String remark;
        StringBuffer remarkBuffer = new StringBuffer();
        if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            remarkBuffer.append((CharSequence)AllEleInvoiceFileHelper.getRedInvoiceRemark(invoice));
        }
        AllEleInvoiceFileHelper.setSpecialInfo(remarkBuffer, fullDigitalEInvoice, null, invoice);
        if (remarkBuffer.length() > 0) {
            remarkBuffer.append(System.lineSeparator());
        }
        if (StringUtils.equals((CharSequence)invoice.getString("showsalerbank"), (CharSequence)"Y")) {
            AllEleInvoiceFileHelper.setBankInfoToRemark(remarkBuffer, invoice.getString("salerbank"), invoice.getString("salerbankacc"), "\u9500\u65b9");
        }
        if (StringUtils.equals((CharSequence)invoice.getString("showbuyerbank"), (CharSequence)"Y")) {
            AllEleInvoiceFileHelper.setBankInfoToRemark(remarkBuffer, invoice.getString("buyerbank"), invoice.getString("buyerbankacc"), "\u8d2d\u65b9");
        }
        if (Handle.isNotEmpty((Object)(remark = fullDigitalEInvoice.getRemark()))) {
            remarkBuffer.append(remark).append(';').append(System.lineSeparator());
        }
        if (Handle.isNotEmpty((Object)(payee = invoice.getString("payee")))) {
            remarkBuffer.append("\u6536\u6b3e\u4eba:").append(payee).append(';').append("    ");
        }
        if (Handle.isNotEmpty((Object)(reviewer = invoice.getString("reviewer")))) {
            remarkBuffer.append("\u590d\u6838\u4eba:").append(reviewer).append(';');
        }
        fullDigitalEInvoice.setRemark(remarkBuffer.toString());
        if (log.isInfoEnabled()) {
            log.info(String.format("\u53d1\u7968\u7684\u5907\u6ce8\u5185\u5bb9:{%s}", remarkBuffer.toString()));
        }
    }

    private static StringBuilder getRedInvoiceRemark(DynamicObject invoice) {
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        String originalInvoiceCode = invoice.getString("originalinvoicecode");
        String infoCode = invoice.getString("infocode");
        StringBuilder redRemarkBuffer = new StringBuilder();
        if (Handle.isNotEmpty((Object)originalInvoiceNo)) {
            redRemarkBuffer.append("\u88ab\u7ea2\u51b2\u84dd\u5b57\u53d1\u7968\u53f7\u7801:").append(originalInvoiceNo).append(' ');
        }
        if (Handle.isNotEmpty((Object)originalInvoiceCode)) {
            redRemarkBuffer.append("\u88ab\u7ea2\u51b2\u84dd\u5b57\u53d1\u7968\u4ee3\u7801:").append(originalInvoiceCode).append(' ');
        }
        if (Handle.isNotEmpty((Object)infoCode)) {
            redRemarkBuffer.append("\u7ea2\u5b57\u53d1\u7968\u4fe1\u606f\u786e\u8ba4\u5355\u7f16\u53f7:").append(infoCode);
        }
        redRemarkBuffer.append(';').append(' ');
        return redRemarkBuffer;
    }

    public static void setBankInfoToRemark(StringBuffer remarkBuffer, String bankInfo, String bankAccount, String headStr) {
        String bankName = bankInfo;
        String bankNo = bankAccount;
        if (StringUtils.isBlank((CharSequence)bankAccount)) {
            Pair<String, String> bankInfoPair = AllEleInvoiceFileHelper.getBankInfoPair(bankInfo);
            bankName = (String)bankInfoPair.getKey();
            bankNo = (String)bankInfoPair.getValue();
        }
        if (Handle.isEmpty((Object)bankName)) {
            bankName = "-";
        }
        if (Handle.isEmpty((Object)bankNo)) {
            bankNo = "-";
        }
        remarkBuffer.append(headStr).append("\u5f00\u6237\u94f6\u884c:").append(bankName).append(';').append("    ");
        remarkBuffer.append("\u94f6\u884c\u8d26\u53f7:").append(bankNo).append(';').append(System.lineSeparator());
    }

    private static Pair<String, String> getBankInfoPair(String bankInfo) {
        Pair bankPair = Handle.isNotEmpty((Object)bankInfo) ? AddressSplitHelper.splitBankAndName((String)bankInfo) : Pair.of((Object)"", (Object)"");
        return bankPair;
    }

    private static Pair<String, String> getAddressAndTelPair(String addressAndTel) {
        Pair addressAndTelPair = Handle.isNotEmpty((Object)addressAndTel) ? AddressSplitHelper.splitAddressAndTel((String)addressAndTel) : Pair.of((Object)"", (Object)"");
        return addressAndTelPair;
    }

    private static void setSpecialInfo(StringBuffer remarkBuffer, FullDigitalEInvoice fullDigitalEInvoice, FullDigitalEInvoiceXml fullDigitalEInvoiceXml, DynamicObject invoice) {
        String specialType;
        String string = specialType = fullDigitalEInvoice != null ? fullDigitalEInvoice.getSpecialType() : fullDigitalEInvoiceXml.getSpecialType();
        if (Handle.isNotEmpty((Object)specialType) && !SpecialTypeEnum.NOT_SPECIAL.getValue().equals(specialType)) {
            if (SpecialTypeEnum.CONSTRUCTION_SERVICE.getValue().equals(specialType)) {
                AllEleInvoiceFileHelper.assembleBuildInfoItem(remarkBuffer, fullDigitalEInvoice, fullDigitalEInvoiceXml, invoice);
            } else if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE.getValue().equals(specialType)) {
                List<CargoTransportItem> transportItems = AllEleInvoiceFileHelper.assembleCargoTransportItem(invoice);
                if (fullDigitalEInvoice != null) {
                    fullDigitalEInvoice.setCargoTransportList(transportItems);
                }
                if (fullDigitalEInvoiceXml != null) {
                    fullDigitalEInvoiceXml.setCargoTransportList(transportItems);
                }
            } else if (SpecialTypeEnum.SALE_OF_REAL_ESTATE.getValue().equals(specialType)) {
                AllEleInvoiceFileHelper.assembleStateSaleInfoItem(remarkBuffer, fullDigitalEInvoice, fullDigitalEInvoiceXml, invoice);
            } else if (SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE.getValue().equals(specialType)) {
                AllEleInvoiceFileHelper.assembleEstateLeaseInfoItem(remarkBuffer, fullDigitalEInvoice, fullDigitalEInvoiceXml, invoice);
            } else if (SpecialTypeEnum.PASSENGER_TRANSPORT.getValue().equals(specialType)) {
                List<PassengerTransportItem> passengerTransportItems = AllEleInvoiceFileHelper.assemblePassengerTransportInfoItem(invoice);
                if (fullDigitalEInvoice != null) {
                    fullDigitalEInvoice.setTravelerList(passengerTransportItems);
                }
                if (fullDigitalEInvoiceXml != null) {
                    fullDigitalEInvoiceXml.setTravelerList(passengerTransportItems);
                }
            } else if (SpecialTypeEnum.TRACTORS_AND_COMBINE_HARVESTERS.getValue().equals(specialType)) {
                AllEleInvoiceFileHelper.assembleTractorInfo(fullDigitalEInvoice, invoice);
            } else if (SpecialTypeEnum.VESSUESHIP.getValue().equals(specialType)) {
                AllEleInvoiceFileHelper.assembleVessueShipInfo(remarkBuffer, invoice);
            } else {
                log.info("\u4e0d\u652f\u6301\u751f\u6210\u5e95\u8d26\u6570\u636e\u7684\u7279\u6b8a\u884c\u4e1a\u7c7b\u578b:{}", (Object)specialType);
            }
        }
    }

    private static void assembleVessueShipInfo(StringBuffer remarkBuffer, DynamicObject invoice) {
        DynamicObjectCollection vessueShipCollection = invoice.getDynamicObjectCollection("vehichevesselships");
        for (DynamicObject vessueShipObject : vessueShipCollection) {
            remarkBuffer.append("\u4fdd\u9669\u5355\u53f7:").append(vessueShipObject.getString("policyno")).append(";");
            remarkBuffer.append("\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7:").append(vessueShipObject.getString("shipsno")).append(";");
            remarkBuffer.append("\u7a0e\u6b3e\u6240\u5c5e\u671f:").append(vessueShipObject.getString("perioddate")).append(";");
            remarkBuffer.append("\u8f66\u67b6\u53f7:").append(vessueShipObject.getString("vehiclecode")).append(";");
            BigDecimal vehiclevesselamount = vessueShipObject.getBigDecimal("vehiclevesselamount").setScale(2, RoundingMode.HALF_UP);
            remarkBuffer.append("\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d:").append(vehiclevesselamount).append(";");
            BigDecimal vehiclelateamount = vessueShipObject.getBigDecimal("vehiclelateamount").setScale(2, RoundingMode.HALF_UP);
            remarkBuffer.append("\u6ede\u7eb3\u91d1\u91d1\u989d:").append(vehiclelateamount).append(";");
            BigDecimal vehicletotalamount = vessueShipObject.getBigDecimal("vehicletotalamount").setScale(2, RoundingMode.HALF_UP);
            remarkBuffer.append("\u91d1\u989d\u5408\u8ba1:").append(vehicletotalamount).append("\n");
        }
        log.info("\u62fc\u63a5\u7684\u5907\u6ce8\u5185\u5bb9:{}", (Object)remarkBuffer.toString());
    }

    private static void assembleBuildInfoItem(StringBuffer remarkBuffer, FullDigitalEInvoice fullDigitalEInvoice, FullDigitalEInvoiceXml fullDigitalEInvoiceXml, DynamicObject invoice) {
        String buildingName = invoice.getString("buildingname");
        String landTaxNo = invoice.getString("landtaxno");
        String crossCitySign = "0".equals(invoice.getString("crosscitysign")) ? "\u5426" : "\u662f";
        String realAddress = AllEleInvoiceFileHelper.getRealAddress(invoice);
        List itemList = null;
        if (fullDigitalEInvoice != null) {
            itemList = fullDigitalEInvoice.getItemList();
            StringBuilder remarkSb = new StringBuilder();
            remarkSb.append("\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7:");
            remarkSb.append(landTaxNo).append("; ").append("    ");
            remarkSb.append("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7:");
            remarkSb.append(crossCitySign).append(';').append(System.lineSeparator());
            remarkBuffer.append((CharSequence)remarkSb);
        }
        if (fullDigitalEInvoiceXml != null) {
            itemList = fullDigitalEInvoiceXml.getItemList();
            ConstructionServicesItem constructionServicesItem = new ConstructionServicesItem();
            constructionServicesItem.setOccurredSite(realAddress);
            constructionServicesItem.setItemName(buildingName);
            constructionServicesItem.setLandValueAddedTaxProjectNumber(invoice.getString("landtaxno"));
            constructionServicesItem.setCrossRegionIdentifier(crossCitySign);
            fullDigitalEInvoiceXml.setConstructionServicesItem(constructionServicesItem);
        }
        if (itemList != null && !itemList.isEmpty()) {
            FullDigitalEInvoiceItem buildInfoItem = (FullDigitalEInvoiceItem)itemList.get(0);
            buildInfoItem.setUnit(buildingName);
            buildInfoItem.setSpecModel(realAddress);
        }
    }

    private static List<CargoTransportItem> assembleCargoTransportItem(DynamicObject invoice) {
        DynamicObjectCollection freightList = invoice.getDynamicObjectCollection("freights");
        ArrayList<CargoTransportItem> cargoTransportItems = new ArrayList<CargoTransportItem>();
        freightList.forEach(itemDto -> {
            CargoTransportItem eInvoiceItem = new CargoTransportItem();
            eInvoiceItem.setStartPlace(itemDto.getString("startplace"));
            eInvoiceItem.setEndPlace(itemDto.getString("endplace"));
            eInvoiceItem.setTransportGoods(itemDto.getString("transportgoods"));
            eInvoiceItem.setTransportType(itemDto.getString("transporttype"));
            eInvoiceItem.setLicensePlate(itemDto.getString("licenseplate"));
            cargoTransportItems.add(eInvoiceItem);
        });
        return cargoTransportItems;
    }

    private static void assembleEstateLeaseInfoItem(StringBuffer remarkBuffer, FullDigitalEInvoice fullDigitalEInvoice, FullDigitalEInvoiceXml fullDigitalEInvoiceXml, DynamicObject invoice) {
        String crossCitySign;
        String areaUnit = invoice.getString("areaunit");
        String estateId = invoice.getString("estateid");
        String realAddress = AllEleInvoiceFileHelper.getRealAddress(invoice);
        String startLeaseDate = DateUtils.format((Date)invoice.getDate("startleasedate"));
        String endLeaseDate = DateUtils.format((Date)invoice.getDate("endleasedate"));
        String startAndEndDate = startLeaseDate + ' ' + endLeaseDate;
        String string = crossCitySign = "0".equals(invoice.getString("crosscitysign")) ? "\u5426" : "\u662f";
        if (fullDigitalEInvoice != null) {
            FullDigitalEInvoiceItem estateLeaseInfoItem = (FullDigitalEInvoiceItem)fullDigitalEInvoice.getItemList().get(0);
            estateLeaseInfoItem.setUnit(areaUnit);
            estateLeaseInfoItem.setSpecModel(estateId);
            StringBuilder remarkSb = new StringBuilder();
            remarkSb.append("\u4e0d\u52a8\u4ea7\u5730\u5740:");
            remarkSb.append(realAddress).append(';').append("    ");
            remarkSb.append("\u79df\u8d41\u671f\u8d77\u6b62:");
            remarkSb.append(startAndEndDate).append(';').append("    ");
            remarkSb.append("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7:");
            remarkSb.append(crossCitySign).append(';').append(System.lineSeparator());
            remarkBuffer.append((CharSequence)remarkSb);
        }
        if (fullDigitalEInvoiceXml != null) {
            RealEstateLeaseItem realEstateLeaseItem = new RealEstateLeaseItem();
            realEstateLeaseItem.setHouseTitleCertificateNumber(estateId);
            realEstateLeaseItem.setRealEstateAddress(realAddress);
            realEstateLeaseItem.setTheLeaseTermBeginsAndEnds(startAndEndDate);
            realEstateLeaseItem.setCrossRegionIdentifier(crossCitySign);
        }
    }

    private static void assembleStateSaleInfoItem(StringBuffer remarkBuffer, FullDigitalEInvoice fullDigitalEInvoice, FullDigitalEInvoiceXml fullDigitalEInvoiceXml, DynamicObject invoice) {
        DynamicObjectCollection estateSalesEntry = invoice.getDynamicObjectCollection("estatesales");
        DynamicObjectCollection cobuyerEntry = invoice.getDynamicObjectCollection("cobuyers");
        ArrayList realEstateSalesItems = Lists.newArrayListWithCapacity((int)0);
        ArrayList coBuyerItems = Lists.newArrayListWithCapacity((int)0);
        List itemList = null;
        if (estateSalesEntry.size() > 0) {
            int i;
            for (i = 0; i < estateSalesEntry.size(); ++i) {
                RealEstateSalesItem realEstateSalesItem = new RealEstateSalesItem();
                String estateCode = ((DynamicObject)estateSalesEntry.get(i)).getString("saleestatecode");
                String onlineContracteNo = ((DynamicObject)estateSalesEntry.get(i)).getString("onlinecontracteno");
                String crossCitySign = "0".equals(((DynamicObject)estateSalesEntry.get(i)).getString("salecrosscitysign")) ? "\u5426" : "\u662f";
                BigDecimal approvedPrice = ((DynamicObject)estateSalesEntry.get(i)).getBigDecimal("assessmenttaxamount");
                BigDecimal actualTurnover = ((DynamicObject)estateSalesEntry.get(i)).getBigDecimal("actualtotalamount");
                String approvedPriceStr = MathUtils.isNullOrZero(approvedPrice) ? "-" : approvedPrice.setScale(2, 4).toPlainString();
                String actualTurnoverStr = MathUtils.isNullOrZero(actualTurnover) ? "-" : actualTurnover.setScale(2, 4).toPlainString();
                String landTaxNo = ((DynamicObject)estateSalesEntry.get(i)).getString("salelandtaxno");
                String realAddress = ((DynamicObject)estateSalesEntry.get(i)).getString("saleprincename") + ((DynamicObject)estateSalesEntry.get(i)).getString("salecityname") + ((DynamicObject)estateSalesEntry.get(i)).getString("saledetailaddress");
                String estateId = ((DynamicObject)estateSalesEntry.get(i)).getString("saleestateid");
                String areaUnit = ((DynamicObject)estateSalesEntry.get(i)).getString("saleunit");
                if (remarkBuffer != null) {
                    if (StringUtils.isEmpty((CharSequence)estateCode)) {
                        estateCode = "-";
                    }
                    if (StringUtils.isEmpty((CharSequence)landTaxNo)) {
                        landTaxNo = "-";
                    }
                    if (StringUtils.isEmpty((CharSequence)onlineContracteNo)) {
                        onlineContracteNo = "-";
                    }
                    StringBuilder remarkSb = new StringBuilder();
                    remarkSb.append("\u4e0d\u52a8\u4ea7\u4fe1\u606f").append(i + 1).append("\uff1a").append(System.lineSeparator());
                    remarkSb.append("\u4e0d\u52a8\u4ea7\u5355\u5143\u4ee3\u7801:");
                    remarkSb.append(estateCode).append(';').append("    ");
                    remarkSb.append("\u7f51\u7b7e\u5408\u540c\u5907\u6848\u7f16\u53f7:");
                    remarkSb.append(onlineContracteNo).append(';').append(System.lineSeparator());
                    remarkSb.append("\u4e0d\u52a8\u4ea7\u5730\u5740:");
                    remarkSb.append(realAddress).append(';').append("    ");
                    remarkSb.append("\u8de8\u5730\uff08\u5e02\uff09\u6807\u5fd7:");
                    remarkSb.append(crossCitySign).append(';').append(System.lineSeparator());
                    remarkSb.append("\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u7f16\u53f7:");
                    remarkSb.append(landTaxNo).append(';').append("    ");
                    remarkSb.append("\u6838\u5b9a\u8ba1\u7a0e\u4ef7\u683c:");
                    remarkSb.append(approvedPriceStr).append(';').append("    ");
                    remarkSb.append("\u5b9e\u9645\u6210\u4ea4\u542b\u7a0e\u91d1\u989d:");
                    remarkSb.append(actualTurnoverStr).append(';').append(System.lineSeparator());
                    remarkBuffer.append((CharSequence)remarkSb);
                }
                if (fullDigitalEInvoiceXml == null) continue;
                itemList = fullDigitalEInvoiceXml.getItemList();
                realEstateSalesItem.setHouseTitleCertificateNumber(estateId);
                realEstateSalesItem.setRealEstateAddress(realAddress);
                realEstateSalesItem.setRealEstateUnitNumber(estateCode);
                realEstateSalesItem.setActualTransactionAmountIncludingTax(actualTurnoverStr);
                realEstateSalesItem.setLandValueAddedTaxProjectNumber(landTaxNo);
                realEstateSalesItem.setCrossRegionIdentifier(crossCitySign);
                realEstateSalesItem.setApprovedTaxPrice(approvedPriceStr);
                realEstateSalesItems.add(realEstateSalesItem);
                ((FullDigitalEInvoiceItem)itemList.get(i)).setUnit(areaUnit);
                ((FullDigitalEInvoiceItem)itemList.get(i)).setSpecModel(estateId);
            }
            for (i = 0; i < cobuyerEntry.size(); ++i) {
                if (remarkBuffer != null) {
                    StringBuilder remarkSb = new StringBuilder();
                    remarkSb.append("\u5171\u540c\u8d2d\u4e70\u65b9:");
                    remarkSb.append(((DynamicObject)cobuyerEntry.get(i)).getString("cobuyer")).append(';').append("    ");
                    remarkSb.append("\u8bc1\u4ef6\u7c7b\u578b:");
                    remarkSb.append(BillCoBuyerItemVo.CoBuyerTypeEnum.formatNameByCode((String)((DynamicObject)cobuyerEntry.get(i)).getString("cobuyercardtype"))).append(';').append("    ");
                    remarkSb.append("\u8bc1\u4ef6\u53f7\u7801:");
                    remarkSb.append(((DynamicObject)cobuyerEntry.get(i)).getString("cobuyercardno")).append(';').append(System.lineSeparator());
                    remarkBuffer.append((CharSequence)remarkSb);
                }
                if (fullDigitalEInvoiceXml == null) continue;
                BillCoBuyerItemVo coBuyerItem = new BillCoBuyerItemVo();
                coBuyerItem.setCardNo(((DynamicObject)cobuyerEntry.get(i)).getString("cobuyercardno"));
                coBuyerItem.setCoBuyer(((DynamicObject)cobuyerEntry.get(i)).getString("cobuyer"));
                coBuyerItem.setCardType(BillCoBuyerItemVo.CoBuyerTypeEnum.formatNameByCode((String)((DynamicObject)cobuyerEntry.get(i)).getString("cobuyercardtype")));
                coBuyerItems.add(coBuyerItem);
            }
            if (fullDigitalEInvoiceXml != null) {
                fullDigitalEInvoiceXml.setRealEstateSalesItems((List)realEstateSalesItems);
                fullDigitalEInvoiceXml.setCoBuyerItems((List)coBuyerItems);
                fullDigitalEInvoiceXml.setItemList(itemList);
            }
        }
    }

    private static String getRealAddress(DynamicObject invoice) {
        DynamicObject simpleNameDO = invoice.getDynamicObject("simpleaddress");
        String simpleName = "";
        if (simpleNameDO != null) {
            simpleName = simpleNameDO.getString("name");
        }
        return simpleName + StringUtils.stripToEmpty((String)invoice.getString("detailaddress"));
    }

    private static List<PassengerTransportItem> assemblePassengerTransportInfoItem(DynamicObject invoice) {
        DynamicObjectCollection travelerList = invoice.getDynamicObjectCollection("travelers");
        ArrayList<PassengerTransportItem> travelerItems = new ArrayList<PassengerTransportItem>();
        travelerList.forEach(itemDto -> {
            PassengerTransportItem passengerTransportItem = new PassengerTransportItem();
            passengerTransportItem.setCardType(TransportTypeEnum.getDescByCode(itemDto.getString("travelercardtype")));
            passengerTransportItem.setTransportType(TransportTypeEnum.getDescByCode(itemDto.getString("travelertransporttype")));
            Date travel_date = itemDto.getDate("traveldate");
            passengerTransportItem.setTravelDate(DateUtils.format((Date)travel_date));
            passengerTransportItem.setTraveler(itemDto.getString("traveler"));
            passengerTransportItem.setSeatClass(itemDto.getString("travelerseatclass"));
            passengerTransportItem.setCardNo(AllEleInvoiceFileHelper.desensitizeIdNumber(itemDto.getString("travelercardno")));
            passengerTransportItem.setStartPlace(itemDto.getString("travelerstartplace"));
            passengerTransportItem.setEndPlace(itemDto.getString("travelerendplace"));
            travelerItems.add(passengerTransportItem);
        });
        return travelerItems;
    }

    public static String desensitizeIdNumber(String idNumber) {
        if (idNumber == null || idNumber.length() < 3) {
            return null;
        }
        HashMap<Integer, int[]> desensitizeRules = new HashMap<Integer, int[]>();
        desensitizeRules.put(18, new int[]{6, 14, 8});
        desensitizeRules.put(15, new int[]{4, 12, 8});
        int length = idNumber.length();
        int[] rules = desensitizeRules.getOrDefault(length, new int[]{length / 3, 2 * (length / 3), 8});
        return AllEleInvoiceFileHelper.applyDesensitization(idNumber, rules);
    }

    private static String applyDesensitization(String idNumber, int[] rules) {
        int start = rules[0];
        int end = rules[1];
        int maskLength = Math.min(rules[2], end - start);
        StringBuilder sb = new StringBuilder();
        sb.append(idNumber, 0, start);
        for (int i = 0; i < maskLength; ++i) {
            sb.append('*');
        }
        sb.append(idNumber.substring(end));
        return sb.toString();
    }

    private static void assembleTractorInfo(FullDigitalEInvoice fullDigitalEInvoice, DynamicObject invoice) {
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

