/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.allele;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleLonType;
import kd.imc.bdm.common.dto.allele.AllEleLoginResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import org.apache.commons.lang3.StringUtils;

public class ApiAllEHelper {
    private static final Log log = LogFactory.getLog(ApiAllEHelper.class);

    public static ApiResult alleLoginCheck(String taxNo, String account) {
        AllEleResponseDTO<AllEleLoginResponseDTO> loginInfo = ApiAllEHelper.alleLogin(taxNo, account);
        if (!loginInfo.getSuccess().booleanValue()) {
            String description = loginInfo.getDescription();
            return ResponseVo.fail(ApiErrCodeEnum.ERROR.getCode(), StringUtils.isBlank((CharSequence)description) ? ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u767b\u5f55\u5931\u8d25", (String)"ApiAllEHelper_0", (String)"imc-sim-common", (Object[])new Object[0]) : description);
        }
        if (!AllEleLonType.AUTO_LOGIN.equals(((AllEleLoginResponseDTO)loginInfo.getData()).getLoginType()) && ((AllEleLoginResponseDTO)loginInfo.getData()).getEtaxAccountType() == -1) {
            return ApiAllEHelper.needLogin(taxNo, loginInfo, false);
        }
        if (((AllEleLoginResponseDTO)loginInfo.getData()).getNeedAuth().booleanValue()) {
            return ApiAllEHelper.needAuth(taxNo, loginInfo, false);
        }
        return null;
    }

    private static AllEleResponseDTO<AllEleLoginResponseDTO> alleLogin(String taxNo, String account) {
        if (EnterpriseHelper.isLqptChannel((String)taxNo)) {
            AllEleLoginResponseDTO loginResponse = new AllEleLoginResponseDTO();
            loginResponse.setEtaxAccountType(Integer.valueOf(1));
            loginResponse.setLoginType(Integer.valueOf(1));
            loginResponse.setNeedAuth(Boolean.FALSE);
            AllEleResponseDTO response = new AllEleResponseDTO();
            response.setErrcode(ErrorType.SUCCESS.getCode());
            response.setDescription("");
            response.setData((Object)loginResponse);
            return response;
        }
        log.info("\u6570\u7535api\u5f00\u7968\u63a5\u53e3\u68c0\u6d4b\u767b\u5f55\uff0c" + taxNo);
        return AllEleServiceHelper.eleLogin((String)taxNo, (AllEleInterfaceTypeEnum)AllEleInterfaceTypeEnum.LOGIN_CHECK, (String)account);
    }

    private static ApiResult needLogin(String taxNo, AllEleResponseDTO<AllEleLoginResponseDTO> loginInfo, boolean isIssueInvoice) {
        log.info("\u6570\u7535api\u5f00\u7968\u63a5\u53e3\u9700\u8981\u767b\u5f55\uff0c" + taxNo);
        String msg = String.format(ApiErrCodeEnum.ALLE_NOT_LOGIN.getMsg(), taxNo);
        if (isIssueInvoice) {
            msg = String.format(ResManager.loadKDString((String)"\u5f00\u7968\u8bf7\u6c42\u5df2\u63a8\u9001\uff0c%s", (String)"ApiAllEHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), msg);
        }
        ApiResult apiResult = ResponseVo.fail(ApiErrCodeEnum.ALLE_NOT_LOGIN.getCode(), msg);
        apiResult.setData((Object)((AllEleLoginResponseDTO)loginInfo.getData()).getLoginWebUrl());
        return apiResult;
    }

    private static ApiResult needAuth(String taxNo, AllEleResponseDTO<AllEleLoginResponseDTO> loginInfo, boolean isIssueInvoice) {
        log.info("\u6570\u7535api\u5f00\u7968\u63a5\u53e3\u9700\u8981\u8ba4\u8bc1\uff0c" + taxNo);
        String msg = String.format(ApiErrCodeEnum.ALLE_NOT_AUTH.getMsg(), taxNo);
        if (isIssueInvoice) {
            msg = String.format(ResManager.loadKDString((String)"\u5f00\u7968\u8bf7\u6c42\u5df2\u63a8\u9001\uff0c%s", (String)"ApiAllEHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), msg);
        }
        ApiResult apiResult = ResponseVo.fail(ApiErrCodeEnum.ALLE_NOT_AUTH.getCode(), msg);
        apiResult.setData((Object)((AllEleLoginResponseDTO)loginInfo.getData()).getLoginWebUrl());
        return apiResult;
    }

    public static boolean checkIssueInvoicePermission(DynamicObject epInfo) {
        if (epInfo == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u5b58\u5728", (String)"ApiAllEHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("epinfo", "=", epInfo.getPkValue()).and("authstate", "=", (Object)"1").and("servergroup", "=", (Object)PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo());
        return QueryServiceHelper.exists((String)"bdm_invoice_permission", (QFilter[])qFilter.toArray());
    }
}

