/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.invoice.RemarkTemplateHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.utils.MathUtils;

public class BuildInvoiceHelper {
    private static final Log LOG = LogFactory.getLog(BuildInvoiceHelper.class);

    public static String buildComponentData(DynamicObject invoiceDynamicObject, String orderNo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("czlx", (Object)ComponentInterfaceTypeEnum.OPENVOICE.getCzlx());
        String terminalNo = invoiceDynamicObject.getString("terminalno");
        jsonObject.put("hxbzdh", (Object)(StringUtils.isEmpty((String)terminalNo) ? "" : terminalNo));
        JSONObject dataJsonObject = new JSONObject();
        String invoiceType = invoiceDynamicObject.getString("invoicetype");
        dataJsonObject.put("kpzl", (Object)InvoiceType.getTypeCodeHx((String)invoiceType));
        if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceType)) {
            invoiceDynamicObject.set("uploadismcstatus", (Object)"2");
        }
        String remark = BuildInvoiceHelper.buildRemark(invoiceDynamicObject);
        LOG.info("log_component before remark " + remark);
        if ("1".equals(invoiceDynamicObject.get("issuesource")) || "0".equals(invoiceDynamicObject.get("issuesource"))) {
            if (InvoiceUtils.isRed((String)invoiceDynamicObject.getString("issuetype"))) {
                remark = remark.replace(RemarkTemplateHelper.getRedRemarkTemplate((String)invoiceDynamicObject.getString("issuetype"), (int)invoiceDynamicObject.getInt("taxedtype"), (BigDecimal)invoiceDynamicObject.getBigDecimal("totalamount"), (BigDecimal)invoiceDynamicObject.getBigDecimal("deduction"), (String)invoiceDynamicObject.getString("originalinvoicecode"), (String)invoiceDynamicObject.getString("originalinvoiceno")).toString(), StringUtils.getEmpty());
            } else if ("2".equals(invoiceDynamicObject.getString("taxedtype"))) {
                remark = BuildInvoiceHelper.replaceRemarkTemplate(invoiceDynamicObject, remark);
            }
        }
        LOG.info("log_component after remark " + remark);
        dataJsonObject.put("bz", (Object)remark);
        dataJsonObject.put("ddh", (Object)invoiceDynamicObject.getString("billno"));
        dataJsonObject.put("fhr", (Object)invoiceDynamicObject.getString("reviewer"));
        dataJsonObject.put("kpy", (Object)invoiceDynamicObject.getString("drawer"));
        dataJsonObject.put("sky", (Object)invoiceDynamicObject.getString("payee"));
        dataJsonObject.put("fpqqlsh", (Object)orderNo);
        dataJsonObject.put("ghf_dzdh", (Object)invoiceDynamicObject.getString("buyeraddr"));
        dataJsonObject.put("ghf_mc", (Object)invoiceDynamicObject.getString("buyername"));
        dataJsonObject.put("ghf_nsrsbh", (Object)invoiceDynamicObject.getString("buyertaxno"));
        dataJsonObject.put("ghf_yhzh", (Object)invoiceDynamicObject.getString("buyerbank"));
        dataJsonObject.put("jshjje", (Object)invoiceDynamicObject.getBigDecimal("totalamount").setScale(2, 4).toString());
        dataJsonObject.put("kphjse", (Object)invoiceDynamicObject.getBigDecimal("totaltax").setScale(2, 4).toString());
        dataJsonObject.put("hjbhsje", (Object)invoiceDynamicObject.getBigDecimal("invoiceamount").setScale(2, 4).toString());
        dataJsonObject.put("kplx", (Object)invoiceDynamicObject.getString("issuetype"));
        dataJsonObject.put("zsfs", (Object)invoiceDynamicObject.getString("taxedtype"));
        dataJsonObject.put("xhf_dzdh", (Object)invoiceDynamicObject.getString("saleraddr"));
        dataJsonObject.put("xhf_mc", (Object)invoiceDynamicObject.getString("salername"));
        dataJsonObject.put("xhf_nsrsbh", (Object)invoiceDynamicObject.getString("salertaxno"));
        dataJsonObject.put("xhf_yhzh", (Object)invoiceDynamicObject.getString("salerbank"));
        dataJsonObject.put("yfpdm", (Object)invoiceDynamicObject.getString("originalinvoicecode"));
        dataJsonObject.put("yfphm", (Object)invoiceDynamicObject.getString("originalinvoiceno"));
        dataJsonObject.put("ylbz", (Object)"0");
        dataJsonObject.put("hcyy", (Object)invoiceDynamicObject.getString("redreason"));
        dataJsonObject.put("dylppz", (Object)InvoiceType.getTypeCodeHx((String)invoiceDynamicObject.getString("originalinvoicetype")));
        dataJsonObject.put("dylpkprq", (Object)DateUtils.format((Date)invoiceDynamicObject.getDate("originalissuetime"), (String)"yyyyMMdd"));
        String specialType = invoiceDynamicObject.getString("specialtype");
        if ("11".equals(specialType)) {
            dataJsonObject.put("sgfp", (Object)"11");
        } else if ("02".equals(specialType)) {
            dataJsonObject.put("sgfp", (Object)"2");
        } else if ("08".equals(specialType)) {
            dataJsonObject.put("sgfp", (Object)"8");
        }
        DynamicObjectCollection items2 = invoiceDynamicObject.getDynamicObjectCollection("items");
        dataJsonObject.put("hsbz", (Object)invoiceDynamicObject.getString("hsbz"));
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject item : items2) {
            BigDecimal xmdj;
            String xmje;
            JSONObject itemJsonObject = new JSONObject();
            itemJsonObject.put("byzd1", (Object)"");
            itemJsonObject.put("byzd2", (Object)"");
            itemJsonObject.put("byzd3", (Object)"");
            itemJsonObject.put("ggxh", item.get("specification"));
            itemJsonObject.put("se", (Object)String.valueOf(item.getBigDecimal("tax").setScale(2, 4)));
            itemJsonObject.put("sl", item.get("taxrate"));
            itemJsonObject.put("xmdw", item.get("unit"));
            itemJsonObject.put("xmlx", item.get("rowtype"));
            String goodsName = item.getString("goodsname");
            itemJsonObject.put("xmmc", (Object)goodsName.replaceAll("^\\*[A-Za-z0-9\\u4E00-\\u9FA5]+\\*", ""));
            if ("1".equals(invoiceDynamicObject.getString("hsbz"))) {
                xmje = String.valueOf(item.getBigDecimal("taxamount").setScale(2, 4));
                xmdj = item.getBigDecimal("taxunitprice");
            } else {
                xmje = String.valueOf(item.getBigDecimal("amount").setScale(2, 4));
                xmdj = item.getBigDecimal("unitprice");
            }
            itemJsonObject.put("xmje", (Object)xmje);
            if (BigDecimal.ZERO.compareTo(xmdj) == 0) {
                itemJsonObject.put("xmdj", (Object)"");
            } else {
                itemJsonObject.put("xmdj", (Object)xmdj.stripTrailingZeros().toPlainString());
            }
            BigDecimal xmsl = item.getBigDecimal("num");
            if (BigDecimal.ZERO.compareTo(xmsl) == 0) {
                itemJsonObject.put("xmsl", (Object)"");
            } else {
                itemJsonObject.put("xmsl", (Object)xmsl.stripTrailingZeros().toPlainString());
            }
            BuildInvoiceHelper.buildComponentTaxCodeObj(invoiceDynamicObject, dataJsonObject, item, itemJsonObject);
            jsonArray.add((Object)itemJsonObject);
        }
        String inventoryMark = invoiceDynamicObject.getString("inventorymark");
        if (!"1".equals(inventoryMark)) {
            if (items2.size() > 8) {
                dataJsonObject.put("qdbz", (Object)"1");
            } else {
                dataJsonObject.put("qdbz", (Object)"0");
            }
        } else {
            dataJsonObject.put("qdbz", (Object)"1");
        }
        dataJsonObject.put("items", (Object)jsonArray);
        jsonObject.put("sjd", (Object)dataJsonObject);
        return JSON.toJSONString((Object)jsonObject);
    }

    private static String replaceRemarkTemplate(DynamicObject invoiceDynamicObject, String remark) {
        String template = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", invoiceDynamicObject.getBigDecimal("deduction").setScale(2, RoundingMode.HALF_UP));
        remark = remark.replace(template, StringUtils.getEmpty());
        return remark;
    }

    private static void buildComponentTaxCodeObj(DynamicObject invoiceDynamicObject, JSONObject dataJsonObject, DynamicObject item, JSONObject itemJsonObject) {
        JSONObject taxCodeObj = new JSONObject();
        taxCodeObj.put("ssflbm", (Object)item.getString("goodscode"));
        taxCodeObj.put("lslbs", (Object)item.getString("zerotaxmark"));
        if (StringUtils.isEmpty((String)item.getString("taxpremark"))) {
            taxCodeObj.put("ssyhzc", (Object)"0");
        } else {
            taxCodeObj.put("ssyhzc", (Object)item.getString("taxpremark"));
        }
        taxCodeObj.put("ssyhzcnr", (Object)item.getString("zzstsgl"));
        BigDecimal deduction = invoiceDynamicObject.getBigDecimal("deduction");
        if (MathUtils.isNullOrZero(deduction)) {
            taxCodeObj.put("kce", (Object)"");
        } else {
            String issueSource;
            if ("1".equals(invoiceDynamicObject.getString("issuetype")) && deduction.compareTo(BigDecimal.ZERO) > 0) {
                deduction = deduction.negate();
            }
            taxCodeObj.put("kce", (Object)deduction.setScale(2, RoundingMode.HALF_UP).toString());
            if ("1".equals(itemJsonObject.get((Object)"xmlx"))) {
                taxCodeObj.put("kce", (Object)"");
            }
            if ("0".equals(issueSource = invoiceDynamicObject.getString("issuesource")) || "1".equals(issueSource)) {
                dataJsonObject.put("hsbz", (Object)"1");
                BigDecimal xmdjhs = item.getBigDecimal("taxunitprice");
                if (BigDecimal.ZERO.compareTo(xmdjhs) != 0) {
                    itemJsonObject.put("xmdj", (Object)xmdjhs.toString());
                }
                itemJsonObject.put("xmje", (Object)String.valueOf(item.getBigDecimal("taxamount").setScale(2, 4)));
            }
        }
        itemJsonObject.put("taxcode", (Object)taxCodeObj);
    }

    public static String buildRemark(DynamicObject invoiceDynamicObject) {
        String remark = invoiceDynamicObject.getString("remark");
        String template = "";
        if ("1".equals(invoiceDynamicObject.getString("issuetype"))) {
            if ("2".equals(invoiceDynamicObject.getString("taxedtype"))) {
                template = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%1$s\u3002\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%2$s\u53f7\u7801:%3$s ", invoiceDynamicObject.getBigDecimal("deduction"), invoiceDynamicObject.getString("originalinvoicecode"), invoiceDynamicObject.getString("originalinvoiceno"));
            } else if (StringUtils.isBlank((String)remark) || !remark.contains("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801")) {
                String originalInvoiceCode = invoiceDynamicObject.getString("originalinvoicecode");
                String originalInvoiceNo = invoiceDynamicObject.getString("originalinvoiceno");
                if (StringUtils.isNotEmpty((String)originalInvoiceCode) && StringUtils.isNotEmpty((String)originalInvoiceNo)) {
                    template = String.format("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:%1$s\u53f7\u7801:%2$s ", originalInvoiceCode, originalInvoiceNo);
                }
            }
        } else if ("2".equals(invoiceDynamicObject.getString("taxedtype"))) {
            template = String.format("\u5dee\u989d\u5f81\u7a0e\uff1a%s\u3002", invoiceDynamicObject.getBigDecimal("deduction").setScale(2, RoundingMode.HALF_UP));
        }
        if (StringUtils.isEmpty((String)remark) || !remark.contains(template)) {
            remark = String.format("%s%s", template, remark);
        }
        invoiceDynamicObject.set("remark", (Object)remark);
        LOG.info(String.format("[%s]\u5907\u6ce8\u4e3a[%s]", invoiceDynamicObject.getString("invoicecode"), remark));
        return remark;
    }
}

