/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.sim.common.utils.MathUtils;

public class UnitPriceHelper {
    public static int MONEY_ACCURACY = 2;

    public static BigDecimal calcNum(BigDecimal divisor, BigDecimal dividend) {
        if (MathUtils.isNullOrZero(dividend)) {
            return BigDecimal.ZERO;
        }
        return divisor.divide(dividend, UnitPriceHelper.getMaxPointLength(divisor, dividend), 4).stripTrailingZeros();
    }

    public static int getMaxPointLength(BigDecimal divisor, BigDecimal dividend) {
        int intLength = divisor.divide(dividend, 0, 1).abs().toPlainString().length();
        if (intLength > 13) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5f97\u51fa\u7684\u5355\u4ef7/\u6570\u91cf\u6574\u6570\u4f4d\u8d85\u957f\uff0c \u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"UnitPriceHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        int pointLength = 15 - intLength;
        if (pointLength > 13) {
            pointLength = 13;
        }
        return pointLength;
    }

    public static BigDecimal getNumValue(BigDecimal inputValue, String name) {
        if (null == inputValue) {
            return BigDecimal.ZERO;
        }
        String inputValueStr = inputValue.toPlainString();
        String replacedStr = inputValueStr.replace("-", "");
        if (!inputValueStr.contains(".") && replacedStr.length() > 13) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"UnitPriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, inputValue));
        }
        String[] array = replacedStr.split("\\.");
        if (array[0].length() > 13) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6574\u6570\u4f4d\u8d85\u957f,\u6574\u6570\u4f4d\u6700\u591a13\u4f4d", (String)"UnitPriceHelper_1", (String)"imc-sim-common", (Object[])new Object[0]), name, inputValue));
        }
        if (array.length > 1) {
            int firstLength = array[0].length();
            return inputValue.setScale(15 - firstLength, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        return inputValue.stripTrailingZeros();
    }

    public static String getNumStrValue(String inputValue, String name) {
        if (StringUtils.isBlank((CharSequence)inputValue)) {
            return inputValue;
        }
        if (!BigDecimalUtil.isNumber((String)inputValue)) {
            return "";
        }
        return UnitPriceHelper.getNumValue(new BigDecimal(inputValue), name).toPlainString();
    }

    public static BigDecimal getNumValue(BigDecimal inputValue) {
        return UnitPriceHelper.getNumValue(inputValue, "");
    }
}

