/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.helper.ReOpenInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.AbstractIssueInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;
import org.apache.commons.lang3.StringUtils;

public class InvalidInvoiceWriteBackHelper
extends AbstractIssueInvoiceWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(InvalidInvoiceWriteBackHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeBack2OriginBillByInvalid(DynamicObject invoice) {
        String lockKey = invoice.getString("invoicecode") + "_" + invoice.getString("invoiceno") + "invalid";
        try (DLock lock = DLock.create((String)lockKey);){
            DynamicObject dbInvoice;
            if (!lock.tryLock(1L)) {
                if (!LOG.isInfoEnabled()) return;
                LOG.info(String.format("%s\u672a\u83b7\u53d6\u5230\u9501\uff0c\u5f53\u524d\u6b63\u5728\u4f5c\u5e9f\u56de\u5199", lockKey));
                return;
            }
            String abolishWritebackStatus = invoice.getString("abolishwritebackstatus");
            if ("1".equals(abolishWritebackStatus)) {
                if (!LOG.isInfoEnabled()) return;
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u4f5c\u5e9f\u56de\u5199\u5df2\u6210\u529f\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                return;
            }
            if ((StringUtils.isBlank((CharSequence)abolishWritebackStatus) || "0".equals(abolishWritebackStatus)) && "6".equals((dbInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicestatus", (QFilter[])new QFilter("id", "=", invoice.getPkValue()).toArray())).getString("invoicestatus"))) {
                if (!LOG.isInfoEnabled()) return;
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                return;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u8fdb\u884c\u4f5c\u5e9f\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            TXHandle tx = TX.required();
            DLock billLock = InvalidInvoiceWriteBackHelper.lockOriginalBillWriteBack(invoice);
            try {
                if (InvalidInvoiceWriteBackHelper.isNegativeSpecialInvoice(invoice)) {
                    InvalidInvoiceWriteBackHelper.redInfoValidWriteBack(invoice);
                    invoice.set("abolishwritebackstatus", (Object)"1");
                    return;
                }
                String billNo = invoice.getString("billno");
                if (StringUtils.isBlank((CharSequence)billNo)) {
                    if (!LOG.isInfoEnabled()) return;
                    LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                    return;
                }
                IssuedInvoiceWriteBackHelper.writeBack(invoice, invoice, true);
                invoice.set("abolishwritebackstatus", (Object)"1");
                return;
            }
            catch (Exception e) {
                tx.markRollback();
                LOG.error("\u4f5c\u5e9f\u56de\u5199\u5931\u8d25", (Throwable)e);
                return;
            }
            finally {
                tx.close();
                billLock.unlock();
            }
        }
    }

    private static void redInfoValidWriteBack(DynamicObject invoice) {
        boolean noWriteBack;
        DynamicObject redInfo;
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u6b63\u5728\u5f00\u59cb\u7ea2\u5b57\u4e13\u7968\u4f5c\u5e9f\u56de\u5199\uff0c\u53d1\u7968\u4ee3\u7801%s\uff0c\u53d1\u7968\u53f7\u7801%s", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        if ((redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "status", "invoicecode", "invoiceno", "jqbh", "orderno", "infosource", "systemsource", "billno", "batchbelong", "infocode"), (QFilter[])new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno")).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"))).toArray())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u6839\u636e\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\uff0c \u4e0d\u56de\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            return;
        }
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid", "isdelete"), (QFilter[])new QFilter("tbillid", "=", redInfo.getPkValue()).and("isdelete", "!=", (Object)"Y").toArray());
        DynamicObject invalidBill = InvalidInvoiceWriteBackHelper.getInvalidBill(invoice);
        if (invalidBill != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u8fdb\u884c\u4f5c\u5e9f\u5355\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            InvalidInvoiceWriteBackHelper.invalidBillWriteBack(invalidBill, redInfo, invoice, relations);
            return;
        }
        if (relations.length != 0) {
            InvalidInvoiceWriteBackHelper.writeInvoiceCodeAndNo2OriginalBill(invoice, true, false);
        }
        if ((noWriteBack = InvalidInvoiceWriteBackHelper.isNoWriteBack(true, false, invoice)) || relations.length == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u6839\u636e\u914d\u7f6e\u4e0d\u56de\u5199\u5f00\u7968\u7533\u8bf7\u5355\u6216\u5173\u7cfb\u8868\u4e3a\u7a7a", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            if (relations.length != 0) {
                InvalidInvoiceWriteBackHelper.deleteRelate(relations);
            }
            if (noWriteBack) {
                DynamicObject[] originalBills;
                InvalidInvoiceWriteBackHelper.modifyRedInfo(redInfo, true);
                ArrayList<Long> pkList = new ArrayList<Long>(relations.length);
                Arrays.stream(relations).map(relation -> pkList.add(relation.getLong("sbillid")));
                for (DynamicObject originalBill : originalBills = InvalidInvoiceWriteBackHelper.loadOriginalBill(pkList, null)) {
                    BillHelper.clearRedInvoiceData(originalBill);
                }
                ImcSaveServiceHelper.update((DynamicObject[])originalBills);
            } else {
                InvalidInvoiceWriteBackHelper.modifyRedInfo(redInfo, false);
            }
            ImcSaveServiceHelper.save((DynamicObject)redInfo);
            return;
        }
        DynamicObject[] waitInvoiceIdRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", (Object)Stream.of(relations).map(relation -> relation.getLong("sbillid")).toArray()).and("isdelete", "!=", (Object)"Y").toArray());
        Object[] tBillIds = Stream.of(waitInvoiceIdRelations).map(relation -> relation.get("tbillid")).distinct().toArray();
        if (tBillIds.length == 1) {
            if ("6".equals(redInfo.getString("infosource"))) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"), (Object[])new Object[]{redInfo.getPkValue()});
            } else {
                InvalidInvoiceWriteBackHelper.modifyRedInfo(redInfo, true);
                ImcSaveServiceHelper.save((DynamicObject)redInfo);
            }
            InvalidInvoiceWriteBackHelper.deleteRelateAndWritebackBill(relations);
            return;
        }
        DynamicObject[] redInfos = InvalidInvoiceWriteBackHelper.isRedInfoAllInvalid(redInfo, tBillIds);
        if (redInfos.length != 0) {
            for (DynamicObject info : redInfos) {
                if (info.getPkValue().equals(redInfo.getPkValue())) {
                    InvalidInvoiceWriteBackHelper.modifyRedInfo(info, true);
                    continue;
                }
                InvalidInvoiceWriteBackHelper.clearSystemSource(info);
            }
            ImcSaveServiceHelper.save((DynamicObject[])redInfos);
            InvalidInvoiceWriteBackHelper.deleteRelateAndWritebackBill(relations);
        } else {
            InvalidInvoiceWriteBackHelper.modifyRedInfo(redInfo, false);
            ImcSaveServiceHelper.save((DynamicObject)redInfo);
        }
    }

    private static void invalidBillWriteBack(DynamicObject invalidBill, DynamicObject redInfo, DynamicObject invoice, DynamicObject[] relations) {
        InvalidInvoiceWriteBackHelper.modifyRedInfo(redInfo, false);
        ImcSaveServiceHelper.save((DynamicObject)redInfo);
        QFilter qFilter = new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("issuestatus", "!=", (Object)IssueStatusEnum.ok.getCode());
        DynamicObject waitInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"orderno", (QFilter[])qFilter.toArray());
        if (waitInvoice != null) {
            waitInvoice.set("orderno", (Object)redInfo.getString("orderno"));
            ImcSaveServiceHelper.update((DynamicObject)waitInvoice);
        }
        InvalidInvoiceWriteBackHelper.writeInvoiceCodeAndNo2OriginalBill(invoice, true, false);
        invalidBill.set("validstate", (Object)"2");
        invalidBill.set("confirmstate", (Object)"2");
        ImcSaveServiceHelper.update((DynamicObject)invalidBill);
        qFilter = new QFilter("sbillid", "=", invalidBill.getPkValue()).and("relationtype", "=", (Object)"1");
        DynamicObject reOpenBill = BusinessDataServiceHelper.loadSingle((String)"sim_bill_relation", (String)"tbillid", (QFilter[])qFilter.toArray());
        long reOpenBillId = reOpenBill == null ? 0L : reOpenBill.getLong("tbillid");
        for (DynamicObject relation : relations) {
            if (relation.getLong("sbillid") == reOpenBillId) continue;
            relation.set("isdelete", (Object)"Y");
        }
        ImcSaveServiceHelper.update((DynamicObject[])relations);
        HashMap<String, DynamicObject> invalidBillMap = new HashMap<String, DynamicObject>();
        ReOpenInvoiceHelper.issueReOpenInvoice(invalidBill, invoice, invalidBillMap);
    }

    private static void deleteRelateAndWritebackBill(DynamicObject[] relations) {
        InvalidInvoiceWriteBackHelper.deleteRelate(relations);
        List<DynamicObject> originalBills = new BillRollbackHelper().originalBillAllRollBack(Stream.of(relations).collect(Collectors.toList()));
        if (BotpHelper.isFromAr((Object)originalBills.get(0).getString("systemsource"))) {
            ImcSaveServiceHelper.save(originalBills);
            return;
        }
        try {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"writebacksave", (String)"sim_original_bill", (DynamicObject[])originalBills.toArray(new DynamicObject[0]), null);
            if (!operationResult.isSuccess()) {
                ImcSaveServiceHelper.save(originalBills);
            }
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528\u82cd\u7a79\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            ImcSaveServiceHelper.save(originalBills);
        }
    }

    private static void deleteRelate(DynamicObject[] relations) {
        for (DynamicObject relation : relations) {
            relation.set("isdelete", (Object)"Y");
        }
        ImcSaveServiceHelper.update((DynamicObject[])relations);
    }

    private static DynamicObject[] isRedInfoAllInvalid(DynamicObject redInfo, Object[] tbillId) {
        DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "infosource", "systemsource", "infocode", "status", "invoicecode", "invoiceno", "orderno", "billno", "batchbelong", "jqbh"), (QFilter[])new QFilter("id", "in", (Object)tbillId).toArray());
        boolean isAllInvalid = true;
        for (DynamicObject info : redInfos) {
            DynamicObject[] invoices;
            if (info.getPkValue().equals(redInfo.getPkValue()) || !Stream.of(invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoicestatus", (QFilter[])new QFilter("infocode", "=", (Object)info.getString("infocode")).toArray())).anyMatch(invoice -> !"6".equals(invoice.getString("invoicestatus")))) continue;
            isAllInvalid = false;
            break;
        }
        return isAllInvalid ? redInfos : new DynamicObject[]{};
    }

    private static void modifyRedInfo(DynamicObject redInfo, boolean isClearSystemSource) {
        redInfo.set("status", (Object)"3");
        redInfo.set("invoicecode", (Object)"");
        redInfo.set("invoiceno", (Object)"");
        redInfo.set("orderno", (Object)UUID.next());
        if (isClearSystemSource) {
            InvalidInvoiceWriteBackHelper.clearSystemSource(redInfo);
        }
    }

    private static void clearSystemSource(DynamicObject redInfo) {
        redInfo.set("infosource", (Object)"2");
        redInfo.set("systemsource", (Object)"");
        redInfo.set("billno", (Object)"");
        redInfo.set("batchbelong", (Object)"");
    }
}

