/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.ReOpenInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.AbstractIssueInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.MatchBillWriteBackHelper;

public class RedInfoAndConfirmBillWriteBackHelper
extends AbstractIssueInvoiceWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(RedInfoAndConfirmBillWriteBackHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBack2OriginBillByRedSpecial(DynamicObject invoice) {
        try (TXHandle tx = TX.required();){
            if (StringUtils.isBlank((Object)invoice.get("infocode"))) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\uff0c\u65e0\u6cd5\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                }
                return;
            }
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"));
            isAllEle = isAllEle || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"));
            DynamicObject red = isAllEle ? RedInfoAndConfirmBillWriteBackHelper.getRedConfirmBillByInfoCode(invoice) : RedInfoAndConfirmBillWriteBackHelper.getRedInfoByInfoCodeAndWriteBackRedInfo(invoice);
            if (red == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\u6216\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u65e0\u6cd5\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                }
                return;
            }
            if (isAllEle && "10".equals(red.getString("source")) || !isAllEle && "10".equals(red.getString("infosource"))) {
                MatchBillWriteBackHelper.issueWriteback(invoice, red);
                return;
            }
            DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", red.getPkValue()).and("isdelete", "!=", (Object)"Y").toArray());
            if (relations.length == 0) {
                relations = RedInfoAndConfirmBillWriteBackHelper.getRedInfoRelation(red);
            }
            if (relations.length == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u672a\u627e\u5230\u5173\u7cfb\u8868\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                }
                return;
            }
            if (!isAllEle && StringUtils.isBlank((CharSequence)invoice.getString("infocode"))) {
                invoice.set("infocode", (Object)red.getString("infocode"));
            }
            if (Stream.of(relations).noneMatch(o -> "-1".equals(o.getString("pushtype")))) {
                IssuedInvoiceWriteBackHelper.writeBack(red, invoice, false);
                return;
            }
            if (isAllEle) {
                RedInfoAndConfirmBillWriteBackHelper.writeback2OriginBillByAllEle(Stream.of(relations).map(relation -> relation.getLong("sbillid")).toArray(), invoice);
            } else {
                RedInfoAndConfirmBillWriteBackHelper.writeBackRelate(red, invoice, relations);
            }
        }
    }

    private static DynamicObject getRedConfirmBillByInfoCode(DynamicObject invoice) {
        QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)invoice.get("orgid"));
        if (StringUtils.isNotBlank((CharSequence)invoice.getString("govuuid"))) {
            baseDataFilter.and("govuuid", "=", (Object)invoice.getString("govuuid"));
        } else {
            baseDataFilter.and("number", "=", (Object)invoice.getString("infocode"));
        }
        return BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "invoiceno", "issuestatus", "originalinvoicecode", "originalinvoiceno", "invoiceamount", "totaltax", "systemsource", "source", "amount", "tax", "num"), (QFilter[])baseDataFilter.toArray());
    }

    private static DynamicObject getRedInfoByInfoCodeAndWriteBackRedInfo(DynamicObject invoice) {
        QFilter qFilter = new QFilter("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"))).and("infocode", "=", invoice.get("infocode"));
        return BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true), (QFilter[])qFilter.toArray());
    }

    static void writeback2OriginBillByAllEle(Object[] billIds, DynamicObject invoice) {
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(billIds.length);
        DynamicObject[] bills = RedInfoAndConfirmBillWriteBackHelper.loadOriginalBill(billIds, writeback_fields);
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>();
        for (DynamicObject bill : bills) {
            RedInfoAndConfirmBillWriteBackHelper.setOriginalBillAllIssue(bill, arIssuedRelationMap);
            DynamicObject writeBackLog = RedInfoAndConfirmBillWriteBackHelper.createWriteBackLog(bill, invoice);
            writeBackLog.set("param", (Object)"{\"desc\": \"\u7ea2\u5b57\u786e\u8ba4\u5355\u5168\u989d\u56de\u5199\"}");
            writeBackLogList.add(writeBackLog);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            ImcSaveServiceHelper.save(writeBackLogList);
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        IssuedInvoiceWriteBackHelper.updateBillState(bills, invoice, false, false, arIssuedRelationMap);
    }

    private static void setOriginalBillAllIssue(DynamicObject bill, Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap) {
        bill.set("mainissuedamount", (Object)bill.getBigDecimal("invoiceamount"));
        bill.set("mainissuedtax", (Object)bill.getBigDecimal("totaltax"));
        bill.set("surplusamount", (Object)BigDecimal.ZERO);
        bill.set("surplustax", (Object)BigDecimal.ZERO);
        DynamicObjectCollection items2 = bill.getDynamicObjectCollection("sim_original_bill_item");
        String systemSource = bill.getString("systemsource");
        boolean isFromAr = BotpHelper.isFromAr((Object)systemSource);
        for (DynamicObject item : items2) {
            long billItemPk = item.getLong("id");
            item.set("issuedamount", (Object)item.getBigDecimal("amount"));
            item.set("issuedtax", (Object)item.getBigDecimal("tax"));
            item.set("issuedtotaltaxamount", (Object)item.getBigDecimal("taxamount"));
            item.set("issuednum", (Object)item.getBigDecimal("num"));
            if (!isFromAr) continue;
            RedInfoAndConfirmBillWriteBackHelper.addArIssuedRelationRedConfirm(bill, arIssuedRelationMap, item, billItemPk);
        }
    }

    private static void addArIssuedRelationRedConfirm(DynamicObject bill, Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap, DynamicObject item, long billItemPk) {
        ArBillRelationExtensionDTO relationDto = arIssuedRelationMap.get(billItemPk);
        long sDetailPk = item.getLong("id");
        if (null == relationDto) {
            relationDto = new ArBillRelationExtensionDTO();
            arIssuedRelationMap.put(sDetailPk, relationDto);
        }
        relationDto.setAmount(item.getBigDecimal("amount"));
        relationDto.setTax(item.getBigDecimal("tax"));
        relationDto.setsBillId(Long.valueOf(bill.getLong("id")));
        relationDto.setsDetailId(Long.valueOf(sDetailPk));
        relationDto.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))));
        boolean isClosed = "1".equals(bill.getString("closestatus"));
        relationDto.setClosed(Boolean.valueOf(isClosed));
        BigDecimal beforeRateNum = BotpHelper.getNumBeforeNumRate((BigDecimal)item.getBigDecimal("num"), (DynamicObject)item);
        relationDto.setNum(beforeRateNum);
    }

    private static void writeBackRelate(DynamicObject redInfo, DynamicObject invoice, DynamicObject[] relations) {
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u7ea2\u5b57\u4fe1\u606f\u8868\u5173\u8054\u4e0b\u63a8\u5f00\u59cb\u8fdb\u884c\u53cd\u5199", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
        }
        Object[] sBillIds = Stream.of(relations).map(relation -> relation.getLong("sbillid")).toArray();
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>();
        DynamicObject[] bills = RedInfoAndConfirmBillWriteBackHelper.loadOriginalBill(sBillIds, writeback_fields);
        BigDecimal invoiceAmount = redInfo.getBigDecimal("invoiceamount");
        BigDecimal totalTax = redInfo.getBigDecimal("totaltax");
        HashMap<String, DynamicObject> invalidBillMap = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(4);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            billItems.sort(Comparator.comparing(o -> o.getBigDecimal("amount")));
            ReOpenInvoiceHelper.issueReOpenInvoice(bill, invoice, invalidBillMap);
            boolean isClosed = "1".equals(bill.getString("closestatus"));
            for (DynamicObject billItem : billItems) {
                BigDecimal tax;
                BigDecimal amount;
                if (invoiceAmount.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal issuedamount = billItem.getBigDecimal("issuedamount");
                BigDecimal issuedtax = billItem.getBigDecimal("issuedtax");
                BigDecimal remainIssuedAmount = billItem.getBigDecimal("amount").subtract(issuedamount);
                BigDecimal remainIssuedTax = billItem.getBigDecimal("tax").subtract(issuedtax);
                if (remainIssuedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject writeBackLog = RedInfoAndConfirmBillWriteBackHelper.createWriteBackLog(bill, invoice);
                JSONObject writeJson = new JSONObject();
                writeJson.put("sDetailId", (Object)billItem.getLong("id"));
                writeJson.put("desc", (Object)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5173\u8054\u56de\u5199");
                RedInfoAndConfirmBillWriteBackHelper.updateBefore(writeJson, billItem);
                BigDecimal defaultNum = billItem.getBigDecimal("num");
                if (invoiceAmount.abs().compareTo(remainIssuedAmount.abs()) >= 0) {
                    amount = remainIssuedAmount;
                    tax = remainIssuedTax;
                    invoiceAmount = invoiceAmount.subtract(remainIssuedAmount);
                    totalTax = totalTax.subtract(remainIssuedTax);
                } else {
                    amount = invoiceAmount;
                    tax = totalTax;
                    invoiceAmount = BigDecimal.ZERO;
                }
                if (BotpHelper.isFromAr((Object)bill.getString("systemsource"))) {
                    RedInfoAndConfirmBillWriteBackHelper.addArIssuedRelationRedInfo(arIssuedRelationMap, bill, isClosed, billItem, amount, tax, defaultNum);
                }
                billItem.set("issuedamount", (Object)issuedamount.add(amount));
                billItem.set("issuedtax", (Object)issuedtax.add(tax));
                billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
                RedInfoAndConfirmBillWriteBackHelper.updateAfter(writeJson, billItem);
                writeBackLog.set("param", (Object)writeJson.toJSONString());
                writeBackLogList.add(writeBackLog);
                RedInfoAndConfirmBillWriteBackHelper.writeBillIssued(bill, amount, tax);
            }
            if (invoiceAmount.compareTo(BigDecimal.ZERO) == 0) break;
        }
        try {
            ImcSaveServiceHelper.save(writeBackLogList);
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        RedInfoAndConfirmBillWriteBackHelper.updateBillState(bills, invoice, false, false, arIssuedRelationMap);
    }

    private static void addArIssuedRelationRedInfo(Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap, DynamicObject bill, boolean isClosed, DynamicObject billItem, BigDecimal amount, BigDecimal tax, BigDecimal defaultNum) {
        long billPk = billItem.getLong("id");
        ArBillRelationExtensionDTO relationDto = arIssuedRelationMap.get(billPk);
        long sDetailPk = billItem.getLong("id");
        if (null == relationDto) {
            relationDto = new ArBillRelationExtensionDTO();
            arIssuedRelationMap.put(sDetailPk, relationDto);
        }
        relationDto.setAmount(relationDto.getAmount().add(amount));
        relationDto.setTax(relationDto.getTax().add(tax));
        relationDto.setsBillId(Long.valueOf(bill.getLong("id")));
        relationDto.setsDetailId(Long.valueOf(sDetailPk));
        relationDto.setDeducatedRow(Boolean.valueOf(false));
        relationDto.setClosed(Boolean.valueOf(isClosed));
        BigDecimal beforeRateNum = BotpHelper.getNumBeforeNumRate((BigDecimal)defaultNum, (DynamicObject)billItem);
        relationDto.setNum(beforeRateNum);
        relationDto.setMergeLabel("1");
        relationDto.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))));
    }
}

