/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.model.invoice;

import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;

public class InvoiceHomeRate {
    public static final int SET_NOW = 0;
    public static final int SET_LAST = 1;
    public static final int SET_LAST_YEAR = 2;
    private BigDecimal nowCount;
    private BigDecimal nowAmount;
    private BigDecimal nowTax;
    private BigDecimal lastCount;
    private BigDecimal lastAmount;
    private BigDecimal lastTax;
    private BigDecimal lastYearCount;
    private BigDecimal lastYearAmount;
    private BigDecimal lastYearTax;

    public InvoiceHomeRate() {
    }

    public InvoiceHomeRate(DynamicObjectCollection now, DynamicObjectCollection last, DynamicObjectCollection lastYear) {
        this.setData(now, 0);
        this.setData(last, 1);
        this.setData(lastYear, 2);
    }

    private void setData(DynamicObjectCollection invoices, int type) {
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return;
        }
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        for (DynamicObject invoice : invoices) {
            amount = amount.add(invoice.getBigDecimal("invoiceamount"));
            tax = tax.add(invoice.getBigDecimal("totaltax"));
        }
        switch (type) {
            case 1: {
                this.lastCount = new BigDecimal(invoices.size());
                this.lastAmount = amount;
                this.lastTax = tax;
                break;
            }
            case 2: {
                this.lastYearCount = new BigDecimal(invoices.size());
                this.lastYearAmount = amount;
                this.lastYearTax = tax;
                break;
            }
            default: {
                this.nowCount = new BigDecimal(invoices.size());
                this.nowAmount = amount;
                this.nowTax = tax;
            }
        }
    }

    public BigDecimal getNowCount() {
        return this.nowCount;
    }

    public BigDecimal getNowAmount() {
        return this.nowAmount;
    }

    public BigDecimal getNowTax() {
        return this.nowTax;
    }

    public BigDecimal getLastCount() {
        return this.lastCount;
    }

    public BigDecimal getLastAmount() {
        return this.lastAmount;
    }

    public BigDecimal getLastTax() {
        return this.lastTax;
    }

    public BigDecimal getLastYearCount() {
        return this.lastYearCount;
    }

    public BigDecimal getLastYearAmount() {
        return this.lastYearAmount;
    }

    public BigDecimal getLastYearTax() {
        return this.lastYearTax;
    }
}

