/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.model.invoice;

import java.util.Arrays;
import kd.bos.dataentity.utils.StringUtils;

public class InvoiceSpecialType {
    public static final String NORMAL = "00";
    public static final String PURCHASE = "02";
    public static final String DKTXF = "06";
    public static final String BDKTXF = "07";
    public static final String OIL = "08";
    public static final String TOBACCO = "11";
    public static final String VEHICLE = "18";
    public static final String ESTATE_LEASE = "E06";
    public static final String BUILD = "E03";
    public static final String ESTATE_SALE = "E05";
    public static final String FREIGHT = "E04";
    public static final String ALL_ELE_OIL = "E01";
    public static final String ALL_ELE_TOBACCO = "E18";
    public static final String ALL_ELE_PURCHASE = "E16";
    public static final String ALL_ELE_FARM_PRODUCE_SALE = "E12";
    public static final String TRAVELER = "E09";
    public static final String ALL_ELE_VEHICLE = "E14";
    public static final String ALL_ELE_VESSEL_VEHICHE = "E07";

    public static boolean allEleSpecialOneRow(String specialType) {
        if (specialType == null) {
            return false;
        }
        return BUILD.equals(specialType) || ESTATE_LEASE.equals(specialType);
    }

    public static boolean allEleSpecialType(String specialType) {
        if (specialType == null) {
            return false;
        }
        return Arrays.stream(InvoiceSpecialTypeEnum.values()).anyMatch(enums -> enums.getCode().equals(specialType));
    }

    public static boolean allEleSpecialMerge(String specialType) {
        if (specialType == null) {
            return true;
        }
        return FREIGHT.equals(specialType) || ALL_ELE_VEHICLE.equals(specialType);
    }

    public static boolean allEleSpecialSplit(String specialType) {
        if (specialType == null) {
            return true;
        }
        return BUILD.equals(specialType) || FREIGHT.equals(specialType) || ALL_ELE_VEHICLE.equals(specialType);
    }

    public static enum InvoiceSpecialTypeEnum {
        BUILD("E03", "\u5efa\u7b51\u670d\u52a1", "\u5efa\u7b51\u670d\u52a1\uff08\u6570\u7535\u7968\uff09", "03"),
        ESTATE_LEASE("E06", "\u4e0d\u52a8\u4ea7\u79df\u8d41", "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\uff08\u6570\u7535\u7968\uff09", "06"),
        ESTATE_SALE("E05", "\u4e0d\u52a8\u4ea7\u9500\u552e", "\u4e0d\u52a8\u4ea7\u9500\u552e\uff08\u6570\u7535\u7968\uff09", "05"),
        FREIGHT("E04", "\u8d27\u7269\u8fd0\u8f93", "\u8d27\u7269\u8fd0\u8f93\uff08\u6570\u7535\u7968\uff09", "04"),
        ALL_ELE_OIL("E01", "\u6210\u54c1\u6cb9", "\u6210\u54c1\u6cb9\uff08\u6570\u7535\u7968\uff09", "01"),
        PURCHASE("02", "\u519c\u4ea7\u54c1\u6536\u8d2d", "\u519c\u4ea7\u54c1\u6536\u8d2d\uff08\u6570\u7535\u7968\uff09", "16"),
        FARM_PRODUCE_SALE("E12", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\uff08\u6570\u7535\u7968\uff09", "12"),
        ALL_ELE_TOBACCO("E18", "\u5377\u70df", "\u5377\u70df\uff08\u6570\u7535\u7968\uff09", "18"),
        TRAVELER("E09", "\u65c5\u5ba2\u8fd0\u8f93", "\u65c5\u5ba2\u8fd0\u8f93\uff08\u6570\u7535\u7968\uff09", "09"),
        ALL_ELE_VEHICLE("E14", "\u673a\u52a8\u8f66", "\u673a\u52a8\u8f66\uff08\u6570\u7535\u7968\uff09", "14"),
        VESSEL_VEHICHE("E07", "\u4ee3\u6536\u8f66\u8239\u7a0e", "\u4ee3\u6536\u8f66\u8239\u7a0e\uff08\u6570\u7535\u7968\uff09", "07");

        private String code;
        private String description;
        private String excelDesctiption;
        private String lqCode;

        private InvoiceSpecialTypeEnum(String code, String description, String excelDesctiption, String lqCode) {
            this.code = code;
            this.description = description;
            this.excelDesctiption = excelDesctiption;
            this.lqCode = lqCode;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExcelDesctiption() {
            return this.excelDesctiption;
        }

        public String getLqCode() {
            return this.lqCode;
        }

        public static String getDescriptionByCode(String code) {
            for (InvoiceSpecialTypeEnum c : InvoiceSpecialTypeEnum.values()) {
                if (!c.getCode().equals(code)) continue;
                return c.description;
            }
            return null;
        }

        public static String getCodeByExcelDescription(String excelDesctiption) {
            for (InvoiceSpecialTypeEnum c : InvoiceSpecialTypeEnum.values()) {
                if (!c.getExcelDesctiption().equals(excelDesctiption)) continue;
                return c.code;
            }
            return InvoiceSpecialType.NORMAL;
        }

        public static String getCodeBySpecialType(String specilaType) {
            if (StringUtils.isBlank((CharSequence)specilaType)) {
                return InvoiceSpecialType.NORMAL;
            }
            for (InvoiceSpecialTypeEnum c : InvoiceSpecialTypeEnum.values()) {
                if (!c.getCode().equals(specilaType)) continue;
                return c.code;
            }
            return InvoiceSpecialType.NORMAL;
        }

        public static String getLqCodeBySpecialType(String specilaType) {
            if (StringUtils.isBlank((CharSequence)specilaType) || InvoiceSpecialType.NORMAL.equals(specilaType)) {
                return "";
            }
            for (InvoiceSpecialTypeEnum c : InvoiceSpecialTypeEnum.values()) {
                if (!c.getCode().equals(specilaType)) continue;
                return c.getLqCode();
            }
            return "";
        }

        public static String getCodeByLqCode(String lqCode) {
            for (InvoiceSpecialTypeEnum c : InvoiceSpecialTypeEnum.values()) {
                if (!StringUtils.equals((CharSequence)c.getLqCode(), (CharSequence)lqCode)) continue;
                return c.code;
            }
            return InvoiceSpecialType.NORMAL;
        }
    }
}

