/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.sim.common.service.InvoiceAddServiceImpl;

public class AwsSyncInvoiceService {
    private static final Log logger = LogFactory.getLog(AwsSyncInvoiceService.class);

    public static void awsBatchSyncInvoice(Object[] pkValue) {
        DynamicObject[] syncLogs;
        for (DynamicObject syncLog : syncLogs = BusinessDataServiceHelper.load((Object[])pkValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_his_sync_log"))) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("queryTotalCount", 0);
            map.put("queryPageCount", 1);
            map.put("pageSize", 500);
            map.put("startTime", DateUtils.format((Date)syncLog.getDate("data_date_start")));
            map.put("endTime", DateUtils.format((Date)syncLog.getDate("data_date_end")));
            map.put("updateCount", 0);
            map.put("status", 1);
            if (logger.isInfoEnabled()) {
                logger.info(MessageFormat.format("\u5f00\u59cb\u540c\u6b65aws\u9500\u9879\u6570\u636e,\u7a0e\u53f7{0}", syncLog.getString("tax_no")));
            }
            boolean continueSync = true;
            while (continueSync) {
                try {
                    continueSync = AwsSyncInvoiceService.sinleQueryAwsInvoice(syncLog, map);
                }
                catch (Exception e) {
                    map.put("status", 0);
                    syncLog.set("msg", (Object)GBKUtils.cutGBKString((String)e.getMessage(), (int)500));
                    logger.error("syncaws invoice exception ", (Throwable)e);
                    continueSync = false;
                }
            }
            try {
                AwsSyncInvoiceService.saveResult(syncLog, map);
            }
            catch (Exception e) {
                logger.error("syncaws save invoice record exception", (Throwable)e);
            }
        }
    }

    public static void saveResult(DynamicObject syncLog, Map<String, Object> map) {
        int status = (Integer)map.get("status");
        if (status == 1) {
            syncLog.set("msg", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"AwsSyncInvoiceService_0", (String)"imc-sim-common", (Object[])new Object[0]));
            syncLog.set("status", (Object)"1");
        } else {
            syncLog.set("status", (Object)"0");
        }
        syncLog.set("deal_times", (Object)(syncLog.getInt("deal_times") + 1));
        syncLog.set("success", map.get("updateCount"));
        syncLog.set("end_time", (Object)new Date());
        ImcSaveServiceHelper.save((DynamicObject)syncLog);
    }

    public static boolean sinleQueryAwsInvoice(DynamicObject syncLog, Map<String, Object> map) {
        String retCode;
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)syncLog.get("org"));
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("pageNo", map.get("queryPageCount"));
        param.put("pageSize", map.get("pageSize"));
        param.put("startTime", map.get("startTime"));
        param.put("endTime", map.get("endTime"));
        param.put("taxNo", syncLog.getString("tax_no"));
        JSONObject retJson = AwsFpyService.newInstance().postAppJson("query_invoice", Long.valueOf(orgId), param, syncLog.getString("clientid"));
        if (retJson == null || retJson.isEmpty()) {
            map.put("status", 0);
            syncLog.set("msg", (Object)ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u4fe1\u606f", (String)"AwsSyncInvoiceService_1", (String)"imc-sim-common", (Object[])new Object[0]));
            return false;
        }
        if (logger.isInfoEnabled()) {
            logger.info("syncaws invoice result:" + retJson.toJSONString());
        }
        if (!"0000".equals(retCode = retJson.getString("errcode"))) {
            map.put("status", 0);
            syncLog.set("msg", (Object)retJson.getString("description"));
            return false;
        }
        int totalElement = retJson.getInteger("totalElement");
        int totalPage = retJson.getInteger("totalPage");
        int currentPage = retJson.getInteger("currentPage");
        map.put("queryTotalCount", totalElement);
        JSONArray invoiceArr = retJson.getJSONArray("data");
        InvoiceAddServiceImpl invoiceAddService = new InvoiceAddServiceImpl();
        for (int i = 0; i < invoiceArr.size(); ++i) {
            JSONObject invoiceJson = invoiceArr.getJSONObject(i);
            invoiceJson.put("orgid", (Object)orgId);
            boolean saveSuccess = invoiceAddService.saveAwsInvoice(invoiceJson);
            if (!saveSuccess) continue;
            int hasUpdateCount = (Integer)map.get("updateCount");
            map.put("updateCount", hasUpdateCount + 1);
        }
        if (totalElement < 500 || currentPage == totalPage) {
            return false;
        }
        map.put("queryPageCount", currentPage + 1);
        return true;
    }
}

