/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckBillService {
    private static final String billNoReg = "^[0-9a-zA-Z_\\-]+$";
    private BillVo bill;

    public CheckBillService(BillVo bill) {
        this.bill = bill;
    }

    public CheckBillService checkBillNO() {
        if (StringUtils.isBlank((CharSequence)this.bill.getBillNo())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILLNO_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u672a\u4f20\u5165", (String)"CheckBillService_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!this.bill.getBillNo().matches(billNoReg)) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILLNO_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf", (String)"CheckBillService_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (this.bill.getBillNo().length() > 50) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_BILLNO_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u8d85\u8fc7\u6700\u5927\u957f\u5ea6[50]", (String)"CheckBillService_2", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return this;
    }

    public CheckBillService checkInvoiceType(BillCheckProcessDto process) {
        if (BillHelper.isBillFromQrScan(this.bill.getBillSource())) {
            return this;
        }
        if (process.getInvoiceTypeNeed().booleanValue() && StringUtils.isBlank((CharSequence)this.bill.getInvoiceType())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_INVOICETYPE_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u672a\u4f20\u5165", (String)"CheckBillService_3", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (process.getInvoiceTypeNeed().booleanValue() && (InvoiceType.getTypeCodeHx((String)this.bill.getInvoiceType()) == null || InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(this.bill.getInvoiceType()))) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_INVOICETYPE_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u79cd\u7c7b[%s]", (String)"CheckBillService_4", (String)"imc-sim-common", (Object[])new Object[0]), this.bill.getInvoiceType()));
        }
        return this;
    }

    public CheckBillService checkTotalAmount() {
        if (MathUtils.isNullOrZero(this.bill.getTotalAmount()) && this.bill.getBillDetail().size() == 0) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u91d1\u989d\u4e3a0\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckBillService_5", (String)"imc-sim-common", (Object[])new Object[0]), this.bill.getBillNo()));
        }
        if (this.bill.getTotalAmount() == null) {
            this.bill.setTotalAmount(BigDecimal.ZERO);
        }
        return this;
    }

    public CheckBillService checkBuyerProperty() {
        if (this.bill.getBuyerProperty() == Integer.parseInt("1") && InvoiceUtils.isSpecialInvoice((String)this.bill.getInvoiceType())) {
            throw new MsgException(ApiErrCodeEnum.BILL_PUSH_ITEM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u4f01\u4e1a\u7c7b\u578b\u4e3a'\u4e2a\u4eba', \u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"CheckBillService_6", (String)"imc-sim-common", (Object[])new Object[0]), this.bill.getBillNo()));
        }
        return this;
    }
}

