/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.InvoiceAddService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.VehicleInvoiceAddService;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections4.CollectionUtils;

public class InvoiceAddServiceImpl
implements InvoiceAddService {
    private static final String SYSTEM_SOURCE_INCOME_DOWNLOAD = "INCOME_DOWNLOAD";
    private static final Log LOGGER = LogFactory.getLog(InvoiceAddServiceImpl.class);
    private static final String TXF = "15";
    private static final String JDC = "12";

    @Override
    public String addInvoice(JSONObject inputJson) {
        long start = System.currentTimeMillis();
        MsgResponse response = new MsgResponse();
        LOGGER.info("InvoiceAddServiceImpladdInvoiceJSON:" + inputJson);
        String inputInvoiceType = inputJson.getString("invoiceType");
        if (JDC.equals(inputInvoiceType)) {
            MsgResponse msgResponse = VehicleInvoiceAddService.VehicleInvoiceAddService(inputJson);
            return JSONObject.toJSONString((Object)msgResponse);
        }
        try {
            DynamicObject saveInvoice;
            BaseInvoice baseInvoice = this.jsonToBaseInvoice(inputJson, "9");
            if (baseInvoice == null) {
                return JSONObject.toJSONString((Object)MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u8f6c\u6362\u4e3a\u7a7a", (String)"InvoiceAddServiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0])));
            }
            if (!(!CollectionUtils.isEmpty((Collection)baseInvoice.getInvoiceItemList()) || baseInvoice.getInvoiceamount().compareTo(BigDecimal.ZERO) == 0 && "6".equals(baseInvoice.getInvoicestatus()) && InvoiceUtils.isPaperInvoice((String)baseInvoice.getInvoicetype()))) {
                return JSONObject.toJSONString((Object)MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801[%1$s],\u53f7\u7801[%2$s]\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a", (String)"InvoiceAddServiceImpl_1", (String)"imc-sim-common", (Object[])new Object[0]), baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno())));
            }
            String invoiceCode = baseInvoice.getInvoicecode();
            String invoiceNo = baseInvoice.getInvoiceno();
            String invoiceStatus = baseInvoice.getInvoicestatus();
            DynamicObject[] queryInvoiceList = this.queryInvoice(invoiceCode, invoiceNo, baseInvoice.getInvoicetype());
            if (queryInvoiceList.length == 0) {
                saveInvoice = this.fillInfoAndSave(baseInvoice, inputInvoiceType);
                this.saveBlueInvoiceStatus(saveInvoice);
            } else if (!String.valueOf(queryInvoiceList[0].getString("invoicestatus")).equals(invoiceStatus)) {
                saveInvoice = this.updateLocalInvoiceStatus(baseInvoice);
            } else {
                saveInvoice = queryInvoiceList[0];
                IssueInvoiceService.updateTaxOrg(saveInvoice);
                SaveServiceHelper.update((DynamicObject)saveInvoice);
            }
            response.setErrorCode(ErrorType.SUCCESS.getCode());
            response.setErrorMsg(ErrorType.SUCCESS.getName());
            response.setMsgId(saveInvoice.getString("orderno"));
            ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest(saveInvoice, false);
        }
        catch (MsgException e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getErrorMsg(), (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.valueOf(e.getErrorMsg()));
        }
        catch (Exception e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getMessage(), (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.valueOf(e.getMessage()));
        }
        catch (Throwable t) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + t.getMessage(), t);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(t.getMessage());
            throw t;
        }
        long end = System.currentTimeMillis();
        LOGGER.info("InvoiceAddServiceImplTime:" + (end - start));
        return JSONObject.toJSONString((Object)response);
    }

    @Override
    public boolean saveAwsInvoice(JSONObject inputJson) {
        boolean saveSuccess = false;
        try {
            BaseInvoice baseInvoice = this.jsonToBaseInvoice(inputJson, "10");
            if (baseInvoice == null) {
                return false;
            }
            DynamicObject[] dbData = this.queryInvoice(baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno(), baseInvoice.getInvoicetype());
            if (dbData.length == 0) {
                DynamicObject saveInvoice = this.fillInfoAndSave(baseInvoice, null);
                saveInvoice.set("buyertype", (Object)"10");
                saveInvoice.set("systemsource", (Object)"AWS_SYNC");
                ImcSaveServiceHelper.update((DynamicObject)saveInvoice);
                saveSuccess = true;
            } else if (!String.valueOf(dbData[0].getString("invoicestatus")).equals(baseInvoice.getInvoicestatus())) {
                this.updateLocalInvoiceStatus(baseInvoice);
                saveSuccess = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getMessage(), (Throwable)e);
        }
        return saveSuccess;
    }

    private BaseInvoice jsonToBaseInvoice(JSONObject invoiceJson, String buyerType) {
        String invoiceType = invoiceJson.getString("invoiceType");
        BaseInvoice baseInvoice = new BaseInvoice();
        baseInvoice.setInvoicecode(invoiceJson.getString("invoiceCode"));
        baseInvoice.setInvoiceno(invoiceJson.getString("invoiceNo"));
        baseInvoice.setSalername(invoiceJson.getString("salerName"));
        BigDecimal invoiceAmount = invoiceJson.getBigDecimal("invoiceAmount");
        baseInvoice.setInvoiceamount(invoiceAmount);
        baseInvoice.setRemark(GBKUtils.cutGBKString((String)invoiceJson.getString("remark"), (int)230));
        baseInvoice.setInvoicetype(InvoiceAddServiceImpl.convertRIMInvoiceType(invoiceJson.getString("invoiceType")));
        baseInvoice.setJqbh(invoiceJson.getString("machineNo"));
        baseInvoice.setPayee(invoiceJson.getString("payee"));
        baseInvoice.setSalertaxno(invoiceJson.getString("salerTaxNo"));
        baseInvoice.setTaxedtype("0");
        baseInvoice.setBuyeraddr(invoiceJson.getString("buyerAddressPhone"));
        baseInvoice.setSalerbank(invoiceJson.getString("salerAccount"));
        baseInvoice.setBuyertaxno(invoiceJson.getString("buyerTaxNo"));
        baseInvoice.setDrawer(invoiceJson.getString("drawer"));
        baseInvoice.setReviewer(invoiceJson.getString("reviewer"));
        baseInvoice.setBuyername(invoiceJson.getString("buyerName"));
        baseInvoice.setCheckcode(invoiceJson.getString("checkCode"));
        baseInvoice.setOrgid(invoiceJson.getString("orgid"));
        baseInvoice.setHsbz("0");
        baseInvoice.setTotalamount(invoiceJson.getBigDecimal("totalAmount"));
        baseInvoice.setSaleraddr(invoiceJson.getString("salerAddressPhone"));
        baseInvoice.setBuyerbank(invoiceJson.getString("buyerAccount"));
        baseInvoice.setInvoicestatus(InvoiceAddServiceImpl.matchStatus(invoiceJson.getString("invoiceStatus")));
        baseInvoice.setTotaltax(invoiceJson.getBigDecimal("totalTaxAmount"));
        baseInvoice.setIssuetime(invoiceJson.getDate("invoiceDate"));
        baseInvoice.setSkm(invoiceJson.getString("cipherArea"));
        baseInvoice.setIssuetype(invoiceJson.getString("type"));
        baseInvoice.setAlletaxinvoiceno(invoiceJson.getString("etaxInvoiceNo"));
        if ("10".equals(buyerType)) {
            String fileUrl = invoiceJson.getString("kdorgpdfurl");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                fileUrl = invoiceJson.getString("pdfurl");
            }
            baseInvoice.setFileurl(fileUrl);
            baseInvoice.setSnapshoturl(invoiceJson.getString("snapshotUrl"));
            baseInvoice.setBuyeremail(invoiceJson.getString("buyerEmail"));
            baseInvoice.setBuyerphone(invoiceJson.getString("buyerMobilePhone"));
        }
        if (InvoiceUtils.isAllEInvoice((Object)baseInvoice.getInvoicetype())) {
            // empty if block
        }
        baseInvoice.setSpecialtype("00");
        if (TXF.equals(invoiceType)) {
            baseInvoice.setSpecialtype("06");
        }
        boolean isHsbz = false;
        boolean isChae = false;
        BigDecimal duction = BigDecimal.ZERO;
        String specialType = "00";
        String listItemStr = "\u9500\u8d27\u6e05\u5355";
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("items"))) {
            List items2 = JSONArray.parseArray((String)invoiceJson.getString("items"), Map.class);
            ArrayList<BaseInvoiceItem> baseInvoiceItems = new ArrayList<BaseInvoiceItem>(items2.size());
            int seq = 0;
            int itemSize = items2.size();
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)baseInvoice.getInvoicetype()) || AllEleAuthHelper.elePaperSetValue((Object)baseInvoice.getSalertaxno(), (Object)baseInvoice.getInvoicetype());
            for (Map item : items2) {
                String goodsName = String.valueOf(item.get("goodsName"));
                if (goodsName.contains(listItemStr) && itemSize != 1) continue;
                BaseInvoiceItem baseInvoiceItem = new BaseInvoiceItem();
                if ("10".equals(buyerType)) {
                    baseInvoiceItem.setTaxrate(InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxRate")).stripTrailingZeros());
                    if (new BigDecimal("0.1").compareTo(baseInvoiceItem.getTaxrate()) == 0) {
                        baseInvoiceItem.setTaxrate(new BigDecimal("0.10"));
                    }
                    BigDecimal unitPrice = InvoiceAddServiceImpl.getBigDecimalVal(item.get("unitPrice"));
                    baseInvoiceItem.setUnitprice(unitPrice);
                    BigDecimal num = InvoiceAddServiceImpl.getBigDecimalVal(item.get("num"));
                    baseInvoiceItem.setNum(num);
                    BigDecimal detailAmount = InvoiceAddServiceImpl.getBigDecimalVal(item.get("detailAmount"));
                    baseInvoiceItem.setAmount(detailAmount);
                    BigDecimal tax = InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxAmount"));
                    baseInvoiceItem.setTax(tax);
                    BigDecimal itemDuction = InvoiceAddServiceImpl.getBigDecimalVal(item.get("deduction"));
                    if (BigDecimalUtil.greaterZero((BigDecimal)itemDuction)) {
                        duction = itemDuction;
                        isChae = true;
                    }
                    int itemTaxFlag = (Integer)item.get("taxFlag");
                    baseInvoiceItem.setTaxflag(String.valueOf(item.get("taxFlag")));
                    if (1 == itemTaxFlag) {
                        baseInvoiceItem.setTaxflag(String.valueOf(item.get("taxFlag")));
                        baseInvoiceItem.setTaxAmount(detailAmount);
                        baseInvoiceItem.setAmount(detailAmount.subtract(tax));
                        baseInvoiceItem.setTaxunitprice(unitPrice);
                        if (!MathUtils.isNullOrZero(num)) {
                            baseInvoiceItem.setUnitprice(PriceHelper.calcPriceOrNum(baseInvoiceItem.getAmount(), num, isAllEle));
                        }
                        isHsbz = true;
                    } else {
                        baseInvoiceItem.setTaxAmount(detailAmount.add(tax));
                        if (!MathUtils.isNullOrZero(num)) {
                            baseInvoiceItem.setTaxunitprice(PriceHelper.calcPriceOrNum(baseInvoiceItem.getTaxAmount(), num, isAllEle));
                        }
                    }
                } else if ("9".equals(buyerType)) {
                    baseInvoiceItem.setUnitprice(InvoiceAddServiceImpl.getBigDecimalVal(item.get("unitPrice")));
                    baseInvoiceItem.setTaxrate(new BigDecimal(StringUtils.isNotEmpty((CharSequence)((String)item.get("taxRate"))) ? (String)item.get("taxRate") : "0").stripTrailingZeros());
                    if (new BigDecimal("0.1").compareTo(baseInvoiceItem.getTaxrate()) == 0) {
                        baseInvoiceItem.setTaxrate(new BigDecimal("0.10"));
                    }
                    baseInvoiceItem.setNum(new BigDecimal(StringUtils.isNotEmpty((CharSequence)((String)item.get("num"))) ? (String)item.get("num") : "0"));
                    baseInvoiceItem.setAmount(InvoiceAddServiceImpl.getBigDecimalVal(item.get("detailAmount")));
                    baseInvoiceItem.setTax(InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxAmount")));
                    baseInvoiceItem.setTaxAmount(baseInvoiceItem.getAmount().add(baseInvoiceItem.getTax()));
                    baseInvoiceItem.setTaxflag("0");
                }
                baseInvoiceItem.setUnit((String)item.get("unit"));
                baseInvoiceItem.setGoodscode((String)item.get("goodsCode"));
                baseInvoiceItem.setSpecification((String)item.get("specModel"));
                baseInvoiceItem.setGoodsname((String)item.get("goodsName"));
                baseInvoiceItem.setVehplate((String)item.get("vehPlate"));
                baseInvoiceItem.setStartdate(InvoiceAddServiceImpl.getDate((String)item.get("startDate")));
                baseInvoiceItem.setEnddate(InvoiceAddServiceImpl.getDate((String)item.get("endDate")));
                baseInvoiceItem.setSeq(String.valueOf(seq++));
                Object discountType = item.get("discountType");
                String discountTypeStr = null == discountType ? "0" : String.valueOf(discountType);
                baseInvoiceItem.setRowtype(discountTypeStr);
                baseInvoiceItems.add(baseInvoiceItem);
            }
            baseInvoice.setInvoiceItemList(baseInvoiceItems);
        }
        if ("10".equals(buyerType)) {
            if (isHsbz) {
                baseInvoice.setHsbz("1");
            }
            if (isChae) {
                baseInvoice.setTaxedtype("2");
                baseInvoice.setDeduction(duction);
            }
            String qsbz = invoiceJson.getString("qsbz");
            String sgfp = invoiceJson.getString("sgfp");
            if (StringUtils.isNotBlank((CharSequence)qsbz) && "4".equals(qsbz)) {
                specialType = "08";
            }
            if (StringUtils.isNotBlank((CharSequence)sgfp) && "2".equals(sgfp)) {
                specialType = "02";
            }
            if (StringUtils.isNotBlank((CharSequence)sgfp) && "18".equals(sgfp)) {
                return null;
            }
            baseInvoice.setSpecialtype(specialType);
        }
        return baseInvoice;
    }

    private static BigDecimal getBigDecimalVal(Object val) {
        if (val == null) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof String && StringUtils.isBlank((Object)val)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(String.valueOf(val));
        }
        catch (Exception e) {
            LOGGER.error("\u8f6cBigDecimal\u62a5\u9519", (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    private static Date getDate(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        return DateUtils.stringToDate((String)dateStr, (String)"yyyyMMdd");
    }

    private static String matchStatus(String invoiceStatus) {
        if ("0".equals(invoiceStatus)) {
            return invoiceStatus;
        }
        if ("2".equals(invoiceStatus)) {
            return "6";
        }
        if ("7".equals(invoiceStatus)) {
            return "2";
        }
        return "3";
    }

    private static String convertRIMInvoiceType(String type) {
        String inputType = null;
        switch (type) {
            case "1": {
                inputType = "026";
                break;
            }
            case "2": {
                inputType = "028";
                break;
            }
            case "3": {
                inputType = "007";
                break;
            }
            case "4": {
                inputType = "004";
                break;
            }
            case "5": {
                inputType = "025";
                break;
            }
            case "12": {
                inputType = "006";
                break;
            }
            case "15": {
                inputType = "026";
                break;
            }
            case "26": {
                inputType = InvoiceType.ALL_E_NORMAL.getTypeCode();
                break;
            }
            case "27": {
                inputType = InvoiceType.ALL_E_SPECIAL.getTypeCode();
            }
        }
        return inputType;
    }

    private DynamicObject[] queryInvoice(String invoiceCode, String invoiceNo, String invoiceType) {
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])this.getFilter(invoiceCode, invoiceNo, invoiceType).toArray());
    }

    @Override
    public DynamicObject fillInfoAndSave(BaseInvoice baseInvoice, String inputInvoiceType) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObject invoice = DynamicObjectUtil.bean2DynamicObject((Object)baseInvoice, (DynamicObject)object);
        invoice.set("buyertype", (Object)"9");
        invoice.set("systemsource", (Object)SYSTEM_SOURCE_INCOME_DOWNLOAD);
        invoice.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("downloadflag", (Object)"0");
        invoice.set("printflag", (Object)"0");
        invoice.set("createtime", (Object)new Date());
        invoice.set("orderno", (Object)UUID.next());
        invoice.set("billdate", (Object)new Date());
        invoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("ofdstatus", (Object)"0");
        invoice.set("issuestatus", (Object)"0");
        invoice.set("pushstatus", (Object)"4");
        invoice.set("uploadismcstatus", (Object)"2");
        IssueInvoiceService.setBlueInvoiceRemainRedAmount(invoice);
        IssueInvoiceService.updateDiscountInfo(invoice);
        this.setOriBlueInvoiceData(baseInvoice, invoice);
        LOGGER.info("inputInvoiceType:" + inputInvoiceType);
        if (TXF.equals(inputInvoiceType)) {
            LOGGER.info("\u901a\u884c\u8d39\u5904\u7406");
            this.updateBaseInvoiceInvoiceType(inputInvoiceType, invoice);
        } else {
            LOGGER.info("\u975e\u901a\u884c\u8d39\u5904\u7406");
            IssueInvoiceService.updateBaseInvoiceType(invoice);
        }
        return (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice})[0];
    }

    public void updateBaseInvoiceInvoiceType(String baseCode, DynamicObject invoice) {
        try {
            String id = CacheHelper.get((String)("imc_base_invoice_type_id_" + baseCode));
            if (id == null || StringUtils.isEmpty((CharSequence)id)) {
                QFilter qFilter = new QFilter("number", "=", (Object)baseCode);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])qFilter.toArray());
                id = String.valueOf(dynamicObject.getPkValue());
                CacheHelper.put((String)("imc_base_invoice_type_id_" + baseCode), (String)id);
            }
            invoice.set("baseinvoicetype", (Object)Long.parseLong(id));
            LOGGER.info("updateBaseInvoiceInvoiceTypeNew\u901a\u884c\u8d39\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IssueInvoiceService.updateTaxOrg(invoice);
    }

    private void setOriBlueInvoiceData(BaseInvoice baseInvoice, DynamicObject invoice) {
        if ("1".equals(baseInvoice.getIssuetype()) && StringUtils.isBlank((CharSequence)baseInvoice.getOriginalinvoiceno())) {
            String remark = baseInvoice.getRemark();
            int i = remark.indexOf("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:");
            if (-1 == i) {
                return;
            }
            int codeIndex = remark.indexOf("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801");
            int startIndex = codeIndex + 9;
            String invoiceCode = InvoiceAddServiceImpl.getNumStr(remark, startIndex);
            String invoiceNo = InvoiceAddServiceImpl.getNumStr(remark, startIndex + invoiceCode.length());
            invoice.set("originalinvoicecode", (Object)invoiceCode);
            invoice.set("originalinvoiceno", (Object)invoiceNo);
        }
    }

    private static String getNumStr(String source, int startIndex) {
        StringBuilder resultBuilder = new StringBuilder();
        boolean isStart = false;
        for (int i = 0; i < 100 && source.length() > startIndex; ++i) {
            char value;
            if ('0' <= (value = source.charAt(startIndex++)) && value <= '9') {
                isStart = true;
                resultBuilder.append(value);
                continue;
            }
            if (isStart) break;
        }
        return resultBuilder.toString();
    }

    @Override
    public DynamicObject updateLocalInvoiceStatus(BaseInvoice baseInvoice) {
        QFilter filter = this.getFilter(baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno(), baseInvoice.getInvoicetype());
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
        Date issueTime = invoice.getDate("issuetime");
        Date issueTimeNew = baseInvoice.getIssuetime();
        if (DateUtils.isNullOrStartOfDay((Date)issueTime) && !DateUtils.isNullOrStartOfDay((Date)issueTimeNew)) {
            invoice.set("issuetime", (Object)issueTimeNew);
        }
        if ("6".equals(baseInvoice.getInvoicestatus())) {
            invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
            IssueInvoiceService.updateTaxOrg(invoice);
            SaveServiceHelper.update((DynamicObject)invoice);
        } else if ("3".equals(baseInvoice.getInvoicestatus())) {
            invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
            IssueInvoiceService.updateTaxOrg(invoice);
            SaveServiceHelper.update((DynamicObject)invoice);
            if ("0".equals(baseInvoice.getInvoicestatus()) && StringUtils.isNotBlank((CharSequence)baseInvoice.getOriginalinvoiceno())) {
                QFilter redfilter = new QFilter("salertaxno", "=", (Object)baseInvoice.getSalertaxno()).and("originalinvoicecode", "=", (Object)baseInvoice.getOriginalinvoicecode()).and("originalinvoiceno", "=", (Object)baseInvoice.getOriginalinvoiceno());
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicestatus", (QFilter[])redfilter.toArray());
                if (blueInvoice != null) {
                    blueInvoice.set("invoicestatus", (Object)"3");
                    SaveServiceHelper.update((DynamicObject)blueInvoice);
                }
                invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
                IssueInvoiceService.updateTaxOrg(invoice);
                SaveServiceHelper.update((DynamicObject)invoice);
            }
        }
        return invoice;
    }

    @Override
    public void saveBlueInvoiceStatus(DynamicObject invoice) {
        if (InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus")) && IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            QFilter allFilter = this.getFilter(invoice.getString("originalinvoicecode"), invoice.getString("originalinvoiceno"), invoice.getString("invoicetype"));
            DynamicObject oriInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicestatus", (QFilter[])allFilter.toArray());
            if (oriInvoice == null) {
                return;
            }
            BigDecimal redTotalAmount = invoice.getBigDecimal("totalamount");
            BigDecimal blueTotalAmount = oriInvoice.getBigDecimal("totalamount");
            if (redTotalAmount.abs().compareTo(blueTotalAmount) == 0) {
                oriInvoice.set("invoicestatus", (Object)"3");
            }
            SaveServiceHelper.update((DynamicObject)oriInvoice);
        }
    }

    private QFilter getFilter(String invoiceCode, String invoiceNo, String invoiceType) {
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            return new QFilter("invoiceno", "=", (Object)invoiceNo);
        }
        return new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo);
    }
}

