/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillDeductionItemVo;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BeanUtil;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.file.util.Handle;
import kd.imc.sim.common.constant.BillConstant;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.CACheckHelper;
import kd.imc.sim.common.helper.FiArFinArBillHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.InvoiceAllESpecialCheckService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCheckService {
    public static final String GBK_LEN_ERR_MSG_TEMPLATE = InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE();
    public static final String LEN_ERR_MSG_TEMPLATE = InvoiceCheckService.LEN_ERR_MSG_TEMPLATE();
    public static final Set<String> areaUnitSet = new ImmutableSet.Builder().add((Object[])new String[]{"\u5e73\u65b9\u7c73", "\u4ea9", "\u33a1", "\u5e73\u65b9\u5343\u7c73", "\u516c\u9877", "h\u33a1", "k\u33a1"}).build();

    public static String GBK_LEN_ERR_MSG_TEMPLATE() {
        return ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b572\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"InvoiceCheckService_0", (String)"imc-sim-common", (Object[])new Object[0]);
    }

    public static String LEN_ERR_MSG_TEMPLATE() {
        return ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\u4e2a\u5b57\u7b26", (String)"InvoiceCheckService_1", (String)"imc-sim-common", (Object[])new Object[0]);
    }

    public static String BILL_ERROR_TEMPLATE() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\uff0c%2$s", (String)"InvoiceCheckService_2", (String)"imc-sim-common", (Object[])new Object[0]);
    }

    public static String BILL_ITEM_ERROR_TEMPLATE() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%1$s]\u7b2c[%2$s]\u884c\uff0c%3$s", (String)"InvoiceCheckService_3", (String)"imc-sim-common", (Object[])new Object[0]);
    }

    public static void checkNull(String fieldValue, String msg) {
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            throw new MsgException(msg);
        }
    }

    public static void checklength(String value, String name, int length) {
        if (GBKUtils.getGBKLength((String)value) > length) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u957f\u5ea6\u9650\u5236\u4e3a%2$s\u5b57\u7b26", (String)"InvoiceCheckService_4", (String)"imc-sim-common", (Object[])new Object[0]), name, length));
        }
    }

    public static void checkAmountNull(BigDecimal amount, String msg) {
        if (amount == null) {
            throw new MsgException(msg);
        }
    }

    public static void checkStrLength(String value, String name, int length) {
        int strLength;
        int n = strLength = StringUtils.isEmpty((CharSequence)value) ? 0 : value.length();
        if (strLength > length) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u957f\u5ea6\u9650\u5236\u4e3a%2$s\u5b57\u7b26", (String)"InvoiceCheckService_100", (String)"imc-sim-common", (Object[])new Object[0]), name, length));
        }
    }

    private static void checkGbkLen(String fieldValue, Integer maxLen, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)fieldValue) && GBKUtils.getGBKLength((String)fieldValue) > maxLen) {
            throw new MsgException(msg);
        }
    }

    public static void checkLen(String fieldValue, Integer maxLen, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)fieldValue) && fieldValue.length() > maxLen) {
            throw new MsgException(msg);
        }
    }

    public static void checkComparedDate(String fieldValue, String msg) {
        String[] array = fieldValue.split("\\s");
        String fieldValue0 = array[0];
        String fieldValue1 = array[1];
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
            Date date0 = dateFormat.parse(fieldValue0);
            Date date1 = dateFormat.parse(fieldValue1);
            if (date0.compareTo(date1) > 0) {
                throw new MsgException(msg);
            }
        }
        catch (ParseException exception) {
            throw new MsgException(msg);
        }
    }

    public static void checkFormat(String fieldValue, String msg) {
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            throw new MsgException(msg);
        }
        String[] array = fieldValue.split("\\s");
        if (array == null || array.length != 2) {
            throw new MsgException(msg);
        }
        String fieldValue0 = array[0];
        String fieldValue1 = array[1];
        if (StringUtils.isEmpty((CharSequence)fieldValue0) || StringUtils.isEmpty((CharSequence)fieldValue1)) {
            throw new MsgException(msg);
        }
        boolean flag0 = InvoiceCheckService.isValidDateFormat(fieldValue0);
        boolean flag1 = InvoiceCheckService.isValidDateFormat(fieldValue1);
        if (flag0 && flag1) {
            return;
        }
        throw new MsgException(msg);
    }

    public static boolean isValidDateFormat(String dateStr) {
        if (dateStr == null || dateStr.length() != 7) {
            return false;
        }
        try {
            int year = Integer.parseInt(dateStr.substring(0, 4));
            if (year == 0) {
                return false;
            }
            int month = Integer.parseInt(dateStr.substring(5, 7));
            return month >= 1 && month <= 12;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void checkBuyerEmail(String email) {
        if (StringUtils.isEmpty((CharSequence)email)) {
            return;
        }
        InvoiceCheckService.checkGbkLen(email, 100, String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u8d2d\u4e70\u65b9\u90ae\u7bb1", 100));
        String[] emailList = email.split(";");
        if (emailList.length > 3) {
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u4e0d\u80fd\u8d85\u8fc73\u4e2a", (String)"InvoiceCheckService_5", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        for (String subEmail : emailList) {
            if (RegexUtil.isEmail((String)subEmail)) continue;
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceCheckService_6", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static void checkMobile(String mobile) {
        InvoiceValidHelper.checkMultiMobile((String)mobile);
    }

    private static void checkTaxNo(String taxNo, String name) {
        if (!RegexUtil.isNsrsbh((String)taxNo, (boolean)true)) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceCheckService_7", (String)"imc-sim-common", (Object[])new Object[0]), name));
        }
    }

    private static void checkBillNoUnique(String billNo) {
        String partten = "[0-9a-zA-Z_-]{1,50}";
        if (StringUtils.isNotEmpty((CharSequence)billNo) && !Pattern.matches(partten, billNo)) {
            throw new MsgException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e(\u8bf7\u8f93\u5165\u957f\u5ea6\u4e3a\u4e0d\u8d85\u8fc750\u4f4d\u7684\u6570\u5b57\u6216\u5b57\u6bcd)", (String)"InvoiceCheckService_8", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static void checkInvoice(BaseInvoice invoice) {
        DynamicObject equipment;
        Object immutableSet;
        String taxedType = invoice.getTaxedtype();
        String invoiceType = invoice.getInvoicetype();
        String blankInvalidCache = CacheHelper.get((String)String.format("imc_invalid_dev_cache%s", invoice.getJqbh()));
        if (!StringUtils.isEmpty((CharSequence)blankInvalidCache)) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u5907\u6b63\u5728\u8fdb\u884c\u7a7a\u767d\u4f5c\u5e9f\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u5f00\u7968", (String)"InvoiceCheckService_9", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        boolean isTobaccoEnterprise = TaxUtils.isTobaccoEnterprise((String)invoice.getSalertaxno());
        if (StringUtils.isBlank((CharSequence)invoice.getApplicant()) || StringUtils.isNotBlank((CharSequence)invoice.getApplicant()) && RedInfoConstant.ApplicantEnum.SALER.getCode().equals(invoice.getApplicant())) {
            if (!isTobaccoEnterprise && !InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && ("11".equals(invoice.getSpecialtype()) || "E18".equals(invoice.getSpecialtype()))) {
                throw new MsgException(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e0d\u662f\u5377\u70df\u4f01\u4e1a\uff0c\u4e0d\u80fd\u5f00\u5177\u5377\u70df\u7c7b\u660e\u7ec6\u53d1\u7968", (String)"InvoiceCheckService_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!TaxUtils.isOilEnterpriseByTaxNo((String)invoice.getSalertaxno()) && !InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && "08".equals(invoice.getSpecialtype())) {
                throw new MsgException(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e0d\u662f\u6210\u54c1\u6cb9\u4f01\u4e1a\uff0c\u4e0d\u80fd\u5f00\u5177\u6210\u54c1\u6cb9\u7c7b\u660e\u7ec6\u53d1\u7968", (String)"InvoiceCheckService_11", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if ("11".equals(invoice.getSpecialtype()) || "E18".equals(invoice.getSpecialtype())) {
            if (invoice.getInvoiceItemList().size() > 8) {
                throw new MsgException(ResManager.loadKDString((String)"\u5377\u70df\u7c7b\u660e\u7ec6\u53d1\u7968\u4e0d\u5141\u8bb8\u5f00\u5177\u6e05\u5355\u53d1\u7968,\u660e\u7ec6\u4e0d\u80fd\u8d85\u8fc78\u6761", (String)"InvoiceCheckService_12", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (TaxedTypeEnum.deduction.getValue().equals(invoice.getTaxedtype())) {
                throw new MsgException(ResManager.loadKDString((String)"\u5377\u70df\u7c7b\u660e\u7ec6\u53d1\u7968\u4e0d\u5141\u8bb8\u5f00\u5177\u5dee\u989d\u5f81\u7a0e\u53d1\u7968", (String)"InvoiceCheckService_13", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if ("08".equals(invoice.getSpecialtype())) {
            if (invoice.getInvoiceItemList().size() > 8) {
                throw new MsgException(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9\u7c7b\u660e\u7ec6\u53d1\u7968\u4e0d\u5141\u8bb8\u5f00\u5177\u6e05\u5355\u53d1\u7968,\u660e\u7ec6\u4e0d\u80fd\u8d85\u8fc78\u6761", (String)"InvoiceCheckService_14", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (!TaxedTypeEnum.normal.getValue().equals(invoice.getTaxedtype())) {
                throw new MsgException(ResManager.loadKDString((String)"\u6210\u54c1\u6cb9\u7c7b\u660e\u7ec6\u53d1\u7968\u53ea\u5141\u8bb8\u5f00\u5177\u666e\u901a\u5f81\u7a0e\u53d1\u7968", (String)"InvoiceCheckService_15", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if ("02".equals(invoice.getSpecialtype()) && !(immutableSet = ImmutableSet.of((Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), (Object)InvoiceType.ALL_E_NORMAL.getTypeCode(), (Object)InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode())).contains((Object)invoice.getInvoicetype())) {
            throw new MsgException(ResManager.loadKDString((String)"\u6536\u8d2d\u7c7b\u53d1\u7968\uff0c\u53d1\u7968\u7c7b\u578b\u9700\u4e3a\u666e\u7968", (String)"InvoiceCheckService_16", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        InvoiceCheckService.checkRedLimit(invoice);
        if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(invoice.getTaxedtype())) {
            for (BaseInvoiceItem baseInvoiceItem : invoice.getInvoiceItemList()) {
                if (new BigDecimal("0.015").compareTo(baseInvoiceItem.getTaxrate()) == 0) continue;
                throw new MsgException("\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u5f81\u7a0e\u65f6\uff0c\u7a0e\u7387\u5fc5\u987b\u662f1.5%");
            }
        }
        if (TaxedTypeEnum.subtract.getValue().equals(invoice.getTaxedtype()) && invoice.getDeduction().compareTo(BigDecimal.ZERO) != 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u4eab\u6709\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81\uff0c\u4e0d\u80fd\u6709\u6263\u9664\u989d", (String)"InvoiceCheckService_17", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if ("0".equals(invoice.getIssuetype()) && TaxedTypeEnum.deduction.getValue().equals(taxedType) && (invoice.getDeduction() == null || invoice.getDeduction().compareTo(BigDecimal.ZERO) == 0)) {
            throw new MsgException(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_18", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        int goodLines = 0;
        int discountLines = 0;
        List invoiceItems = invoice.getInvoiceItemList();
        if (invoiceItems == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728", (String)"InvoiceCheckService_19", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        int onePointFiveTaxRateCount = 0;
        String equipmentType = "";
        if (StringUtils.isNotBlank((CharSequence)invoice.getJqbh()) && (equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)invoice.getJqbh(), (String)invoice.getSalertaxno())) != null) {
            equipmentType = equipment.getString("equipmenttype");
        }
        BigDecimal invoiceAmountSum = BigDecimal.ZERO;
        BigDecimal taxSum = BigDecimal.ZERO;
        BigDecimal totalAmountSum = BigDecimal.ZERO;
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype());
        for (int i = 0; i < invoiceItems.size(); ++i) {
            boolean isDiscount;
            BigDecimal calcTax;
            int seq = i + 1;
            BaseInvoiceItem item = (BaseInvoiceItem)invoiceItems.get(i);
            BigDecimal bhsAmount = item.getAmount();
            BigDecimal taxRate = item.getTaxrate();
            InvoiceCheckService.checkNull(item.getGoodsname(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_20", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            if (isAllEle) {
                InvoiceCheckService.checkLen(item.getSpecification(), 40, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.LEN_ERR_MSG_TEMPLATE(), "\u89c4\u683c\u578b\u53f7", 40)));
                InvoiceCheckService.checkLen(item.getUnit(), 22, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.LEN_ERR_MSG_TEMPLATE(), "\u5355\u4f4d", 22)));
                InvoiceCheckService.checkLen(item.getGoodsname(), 117, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), "\u5546\u54c1\u540d\u79f0", 117)));
            } else {
                InvoiceCheckService.checkGbkLen(item.getSpecification(), 40, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), "\u89c4\u683c\u578b\u53f7", 40)));
                InvoiceCheckService.checkGbkLen(item.getUnit(), 22, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), "\u5355\u4f4d", 22)));
                InvoiceCheckService.checkGbkLen(item.getGoodsname(), 92, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c,%2$s", (String)"InvoiceCheckService_114", (String)"imc-sim-common", (Object[])new Object[0]), seq, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), "\u5546\u54c1\u540d\u79f0", 92)));
            }
            if (MathUtils.isNullOrZero(bhsAmount)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"InvoiceCheckService_21", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            if ("1".equals(item.getRowtype())) {
                if (i == 0) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u7b2c\u4e00\u884c\u5fc5\u987b\u4e3a\u5546\u54c1\u884c", (String)"InvoiceCheckService_22", (String)"imc-sim-common", (Object[])new Object[0]), seq));
                }
                if (bhsAmount.compareTo(BigDecimal.ZERO) > 0) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u6298\u6263\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0", (String)"InvoiceCheckService_23", (String)"imc-sim-common", (Object[])new Object[0]), seq));
                }
                ++discountLines;
            } else {
                if ("08".equals(invoice.getSpecialtype()) || "E01".equals(invoice.getSpecialtype())) {
                    String xmdw = item.getUnit();
                    BigDecimal xmsl = item.getNum();
                    if (StringUtils.isEmpty((CharSequence)xmdw) || !Arrays.asList(GoodsInfoConstant.getOilUnit()).contains(xmdw)) {
                        throw new MsgException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5355\u4f4d\"\u3002\u6210\u54c1\u6cb9\u53ea\u80fd\u4f7f\u7528\u201c\u5428\u201d\u6216\u201c\u5347\u201d\u4e3a\u5355\u4f4d\uff01", (String)"InvoiceCheckService_24", (String)"imc-sim-common", (Object[])new Object[0]));
                    }
                    if (null == xmsl || 0 == BigDecimal.valueOf(0L).compareTo(xmsl)) {
                        throw new MsgException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u6570\u91cf\"\u3002\u6210\u54c1\u6cb9\u660e\u7ec6\u7684\"\u6570\u91cf\"\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\"0\"", (String)"InvoiceCheckService_25", (String)"imc-sim-common", (Object[])new Object[0]));
                    }
                }
                ++goodLines;
            }
            if (!MathUtils.isNullOrZero(item.getUnitprice()) && item.getUnitprice().compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"InvoiceCheckService_26", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            if ("02".equals(invoice.getSpecialtype()) && !ResManager.loadKDString((String)"\u514d\u7a0e", (String)"InvoiceCheckService_27", (String)"imc-sim-common", (Object[])new Object[0]).equals(item.getZzstsgl())) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u6536\u8d2d\u7c7b\u53d1\u7968\uff0c\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u660e\u7ec6\u987b\u4e3a\u514d\u7a0e", (String)"InvoiceCheckService_28", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            ImmutableSet etcInvoiceSet = ImmutableSet.of((Object)InvoiceType.getCodeByDesc((String)"\u7eb8\u8d28\u4e13\u7528\u53d1\u7968"), (Object)InvoiceType.getCodeByDesc((String)"\u7535\u5b50\u4e13\u7528\u53d1\u7968"));
            if (taxRate != null && etcInvoiceSet.contains((Object)invoiceType) && BigDecimal.ZERO.compareTo(taxRate) == 0) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,0\u7a0e\u7387\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"InvoiceCheckService_29", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            if (taxRate != null && "0".equals(invoice.getIssuetype()) && InvoiceConstant.TAX_015.compareTo(taxRate) == 0 && TaxedTypeEnum.deduction.getValue().equals(taxedType)) {
                throw new MsgException(MessageFormat.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c{0}\u884c,\u5dee\u989d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u80fd\u4e3a1.5%", (String)"InvoiceCheckService_30", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            if (StringUtils.isEmpty((CharSequence)item.getGoodscode()) && !BillConstant.TIP_ITEM_DETAIL.equals(item.getGoodsname())) {
                if (!InvoiceUtils.isRedInfo((BigDecimal)invoice.getTotalamount(), (String)invoice.getInvoicetype())) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u672a\u9009\u62e9\u5546\u54c1\u5206\u7c7b\u7f16\u7801", (String)"InvoiceCheckService_31", (String)"imc-sim-common", (Object[])new Object[0]), seq));
                }
            } else {
                if (!InvoiceUtils.isAllEInvoice((Object)invoiceType) && ("11".equals(invoice.getSpecialtype()) || "E18".equals(invoice.getSpecialtype())) && !item.getGoodscode().startsWith("1030402")) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u9009\u62e9\u975e\u5377\u70df\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"InvoiceCheckService_32", (String)"imc-sim-common", (Object[])new Object[0]), seq));
                }
                if (!InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && !isTobaccoEnterprise && item.getGoodscode().startsWith("1030402")) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u975e\u5377\u70df\u4f01\u4e1a\u4e0d\u80fd\u9009\u62e9\u5377\u70df\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"InvoiceCheckService_33", (String)"imc-sim-common", (Object[])new Object[0]), seq));
                }
            }
            if (taxRate != null && ("11".equals(invoice.getSpecialtype()) || "E18".equals(invoice.getSpecialtype())) && TaxRate.ONE_POINT_FIVE_PERCENT.getNumValue().compareTo(taxRate) == 0) {
                throw new MsgException(MessageFormat.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c{0}\u884c,\u5377\u70df\u53d1\u7968\u4e0d\u80fd\u5f001.5%\u7a0e\u7387\u7684\u53d1\u7968", (String)"InvoiceCheckService_34", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            InvoiceCheckService.checkVehicleItem(invoice, item, i);
            if (taxRate != null && InvoiceConstant.TAX_015.compareTo(taxRate) == 0) {
                ++onePointFiveTaxRateCount;
            }
            if (taxRate != null && taxRate.compareTo(BigDecimal.ZERO) != 0 && item.getTax().compareTo(BigDecimal.ZERO) == 0 && (calcTax = bhsAmount.subtract((isDiscount = "1".equals(item.getRowtype())) ? BigDecimal.ZERO : invoice.getDeduction()).multiply(taxRate).setScale(2, 4)).compareTo(BigDecimal.ZERO) != 0 && "2".equals(equipmentType)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c,\u4e0d\u542b\u7a0e\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u4e0d\u7b49\u4e8e0\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5f00\u7968", (String)"InvoiceCheckService_35", (String)"imc-sim-common", (Object[])new Object[0]), seq));
            }
            invoiceAmountSum = invoiceAmountSum.add(item.getAmount().setScale(2, 4));
            taxSum = taxSum.add(item.getTax().setScale(2, 4));
            totalAmountSum = totalAmountSum.add(item.getTaxAmount().setScale(2, 4));
        }
        if (!MathUtils.isNullOrZero(invoice.getInvoiceamount()) && invoiceAmountSum.compareTo(invoice.getInvoiceamount().setScale(2, 4)) != 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u7d2f\u8ba1\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceCheckService_36", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!MathUtils.isNullOrZero(invoice.getTotaltax()) && taxSum.compareTo(invoice.getTotaltax().setScale(2, 4)) != 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u989d\u7d2f\u8ba1\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"InvoiceCheckService_37", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (!MathUtils.isNullOrZero(invoice.getTotalamount()) && !MathUtils.isNullOrZero(totalAmountSum) && totalAmountSum.compareTo(invoice.getTotalamount().setScale(2, 4)) != 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u660e\u7ec6\u4ef7\u7a0e\u5408\u8ba1\u7d2f\u8ba1\u4e0e\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u4e00\u81f4", (String)"InvoiceCheckService_38", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (onePointFiveTaxRateCount > 0 && onePointFiveTaxRateCount != invoiceItems.size()) {
            throw new MsgException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a\u51cf\u63091.5%\u7684\u53d1\u7968\u4e0a\u4e0d\u5141\u8bb8\u518d\u6709\u5176\u4ed6\u7a0e\u7387", (String)"InvoiceCheckService_39", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if ("0".equals(invoice.getIssuetype()) && TaxedTypeEnum.deduction.getValue().equals(taxedType) && (goodLines > 1 || discountLines > 1)) {
            throw new MsgException(ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u6700\u591a\u53ea\u80fd1\u884c\u5546\u54c1\u884c\u30011\u884c\u6298\u6263\u884c", (String)"InvoiceCheckService_40", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (MathUtils.isZero(invoice.getTotalamount())) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"InvoiceCheckService_41", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    public static void checkEleSpecialType(BaseInvoice invoice) {
        String specialType = invoice.getSpecialtype();
        InvoiceAllESpecialCheckService invoiceAllESpecialCheckService = new InvoiceAllESpecialCheckService();
        if ("E03".equals(specialType)) {
            invoiceAllESpecialCheckService.allEBuildCheck(invoice);
        } else if ("E06".equals(specialType)) {
            invoiceAllESpecialCheckService.allEEstateCheck(invoice);
        } else if ("E05".equals(specialType)) {
            invoiceAllESpecialCheckService.allEEstateListCheck(invoice);
        } else if ("E04".equals(specialType)) {
            invoiceAllESpecialCheckService.allEFreightCheck(invoice);
        } else if ("E01".equals(specialType)) {
            invoiceAllESpecialCheckService.allEOilCheck(invoice);
        } else if ("E18".equals(specialType)) {
            invoiceAllESpecialCheckService.allETobaccoCheck(invoice);
        } else if (!"12".equals(specialType)) {
            if ("E09".equals(specialType)) {
                invoiceAllESpecialCheckService.allETravlerCheck(invoice);
            } else if ("E14".equals(specialType)) {
                invoiceAllESpecialCheckService.allEVehicleCheck(invoice);
            } else if ("E07".equals(specialType)) {
                invoiceAllESpecialCheckService.allEVesselVehicheCheck(invoice);
            }
        }
        if ("3".equals(invoice.getTaxedtype()) && StringUtils.isNotEmpty((CharSequence)invoice.getSpecialtype()) && !InvoiceSpecialType.InvoiceSpecialTypeEnum.ESTATE_LEASE.getCode().equals(invoice.getSpecialtype())) {
            throw new MsgException(ResManager.loadKDString((String)"\u7279\u6b8a\u7968\u79cd\u53ea\u6709\u6570\u7535\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1\u652f\u6301\u51cf\u6309\u5f81\u7a0e", (String)"InvoiceCheckService_102", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        List invoiceItemList = invoice.getInvoiceItemList();
        if (InvoiceSpecialType.allEleSpecialOneRow(invoice.getSpecialtype()) && invoiceItemList.stream().filter(item -> "0".equals(item.getRowtype()) || "2".equals(item.getRowtype())).count() > 1L) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), invoice.getBillno(), String.format(ResManager.loadKDString((String)"%s\u53ea\u5141\u8bb8\u6709\u4e00\u884c\u5546\u54c1\u884c", (String)"InvoiceCheckService_42", (String)"imc-sim-common", (Object[])new Object[0]), InvoiceSpecialType.InvoiceSpecialTypeEnum.getDescriptionByCode(specialType))));
        }
    }

    private static void checkIssueType(BaseInvoice invoice) {
        BigDecimal invoiceAmount = invoice.getInvoiceamount();
        BigDecimal totalTax = invoice.getTotaltax();
        if (invoiceAmount.compareTo(BigDecimal.ZERO) < 0) {
            invoice.setIssuetype(IssueType.RED_INVOICE.getTypeCode());
        }
        if (IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getIssuetype())) {
            if (invoiceAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(ResManager.loadKDString((String)"\u84dd\u7968\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceCheckService_43", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (totalTax.compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(ResManager.loadKDString((String)"\u84dd\u7968\u5408\u8ba1\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"InvoiceCheckService_44", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        } else if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getIssuetype())) {
            if (invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
                throw new MsgException(ResManager.loadKDString((String)"\u7ea2\u7968\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"InvoiceCheckService_45", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if (totalTax.compareTo(BigDecimal.ZERO) > 0) {
                throw new MsgException(ResManager.loadKDString((String)"\u7ea2\u7968\u5408\u8ba1\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e0", (String)"InvoiceCheckService_46", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    public static void checkRedLimit(BaseInvoice invoice) {
        String issueType = invoice.getIssuetype();
        if ("1".equals(issueType)) {
            if (StringUtils.isBlank((CharSequence)invoice.getOriginalinvoicecode()) || StringUtils.isBlank((CharSequence)invoice.getOriginalinvoiceno())) {
                return;
            }
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoice.getOriginalinvoicecode());
            qFilter.and("invoiceno", "=", (Object)invoice.getOriginalinvoiceno());
            DynamicObject blueInvoiceDynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "remainredamount", "canredtaxamount", "totaltax", "systemsource", "buyertype", "invoicecode", "invoiceno", "invoiceamount"), (QFilter[])qFilter.toArray());
            if (blueInvoiceDynamicObject != null) {
                String buyerType = blueInvoiceDynamicObject.getString("buyertype");
                if ("9".equals(buyerType) || "10".equals(buyerType)) {
                    return;
                }
                String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew(blueInvoiceDynamicObject, invoice.getOrderno());
                if (StringUtils.isNotBlank((CharSequence)errmsg)) {
                    throw new MsgException(errmsg);
                }
                if (BotpHelper.isFromAr((Object)blueInvoiceDynamicObject.getString("systemsource")) && !BotpHelper.isExistBillByInvoiceOrderNo((BaseInvoice)invoice) && invoice.getInvoiceamount().abs().compareTo(blueInvoiceDynamicObject.getBigDecimal("invoiceamount")) < 0) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u5e94\u6536\u4e0b\u63a8\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u7ea2\u51b2\u3002", (String)"InvoiceCheckService_48", (String)"imc-sim-common", (Object[])new Object[0]), invoice.getOriginalinvoicecode(), invoice.getOriginalinvoiceno()));
                }
                BigDecimal limitRed = blueInvoiceDynamicObject.getBigDecimal("remainredamount");
                if (limitRed.compareTo(invoice.getInvoiceamount().abs()) < 0) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7ea2\u51b2\u9650\u989d\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\u4e3a:%s", (String)"InvoiceCheckService_98", (String)"imc-sim-common", (Object[])new Object[0]), limitRed.setScale(2, 4).toPlainString()));
                }
                BigDecimal canRedTaxAmount = blueInvoiceDynamicObject.getBigDecimal("canredtaxamount");
                if (canRedTaxAmount.abs().compareTo(invoice.getTotaltax().abs()) < 0) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7ea2\u51b2\u9650\u989d\uff0c\u5269\u4f59\u53ef\u7ea2\u51b2\u7a0e\u989d\u4e3a: %s", (String)"InvoiceCheckService_99", (String)"imc-sim-common", (Object[])new Object[0]), canRedTaxAmount.setScale(2, 4).toPlainString()));
                }
            }
        }
    }

    public static void baseInvoiceCheck(BaseInvoice invoice, boolean isCheckDevice, boolean isRedInfoAdd) {
        InvoiceCheckService.checkBillNoUnique(invoice.getBillno());
        String saleTaxNo = invoice.getSalertaxno();
        if (isRedInfoAdd && StringUtils.isNotEmpty((CharSequence)invoice.getApplicant()) && !RedInfoConstant.ApplicantEnum.SALER.getCode().equals(invoice.getApplicant())) {
            saleTaxNo = invoice.getBuyertaxno();
        }
        boolean isElePaper = AllEleAuthHelper.isElePaper((Object)invoice.getIselepaper());
        if (isCheckDevice && !InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && !isElePaper) {
            InvoiceCheckService.checkNull(invoice.getJqbh(), ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8bbe\u5907", (String)"InvoiceCheckService_51", (String)"imc-sim-common", (Object[])new Object[0]));
            EquipmentUtil.checkEquipment((BaseInvoice)invoice, (String)saleTaxNo);
            CACheckHelper.checkCaIsAvailable(invoice, saleTaxNo);
        }
        if ("02".equals(invoice.getSpecialtype())) {
            if (!InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && !TaxUtils.isPurchaseEnterpriseByTaxNo((String)saleTaxNo)) {
                throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u4f01\u4e1a\u4e0d\u662f\u6536\u8d2d\u7c7b\u4f01\u4e1a\uff0c\u65e0\u6cd5\u5f00\u5177\u6536\u8d2d\u7c7b\u53d1\u7968\u3002\u8bf7\u524d\u5f80'\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406'\u4fee\u6539\u4f01\u4e1a\u8d44\u8d28 ", (String)"InvoiceCheckService_52", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if ((InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) || isElePaper) && StringUtils.isEmpty((CharSequence)invoice.getCardType())) {
                throw new MsgException(ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968\u6536\u8d2d\u7c7b\uff0c\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u586b", (String)"InvoiceCheckService_53", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            if ((InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) || isElePaper) && StringUtils.isEmpty((CharSequence)invoice.getBuyertaxno())) {
                throw new MsgException(ResManager.loadKDString((String)"\u6570\u7535\u53d1\u7968\u6536\u8d2d\u7c7b\uff0c\u9500\u65b9\u8bc6\u522b\u53f7\u5fc5\u586b", (String)"InvoiceCheckService_54", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if (TaxedTypeEnum.all_e_reduced_tax.getValue().equals(invoice.getTaxedtype()) && !EnterpriseHelper.isLqptChannel((String)saleTaxNo) && StringUtils.isEmpty((CharSequence)invoice.getReductionTaxType())) {
            throw new MsgException("\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u51cf\u6309\u5f81\u7a0e\u65f6\uff0c\u51cf\u6309\u5f81\u7a0e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceCheckService.buyerCheck(invoice, isRedInfoAdd);
        InvoiceCheckService.saleCheck(invoice, isRedInfoAdd);
        ImmutableSet electInvoiceTypeSet = ImmutableSet.of((Object)InvoiceType.getCodeByDesc((String)"\u7535\u5b50\u666e\u901a\u53d1\u7968"), (Object)InvoiceType.getCodeByDesc((String)"\u7535\u5b50\u4e13\u7528\u53d1\u7968"), (Object)InvoiceType.getCodeByDesc((String)"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09"), (Object)InvoiceType.getCodeByDesc((String)"\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09"));
        if (electInvoiceTypeSet.contains((Object)invoice.getInvoicetype()) && "0".equals(invoice.getIssuetype())) {
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getOrgid()));
            if (StringUtils.isNotBlank((CharSequence)invoice.getWxid()) || "12".equals(invoice.getBuyertype())) {
                boolean isNewDySmkpSetting;
                DynamicObject qrKeyDO = BusinessDataServiceHelper.loadSingle((String)"bdm_scaninvoice_setting", (QFilter[])new QFilter("eqinfotaxno", "=", (Object)invoice.getSalertaxno()).toArray());
                boolean bl = isNewDySmkpSetting = null != qrKeyDO && qrKeyDO.getBoolean("extendflag");
                if (isNewDySmkpSetting) {
                    checkPhone = CheckPhoneEnum.CLOSE.getCode();
                }
            }
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone)) {
                if (StringUtils.isEmpty((CharSequence)invoice.getBuyerphone()) && StringUtils.isEmpty((CharSequence)invoice.getBuyeremail())) {
                    throw new MsgException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d2d\u4e70\u65b9\u90ae\u7bb1\u6216\u624b\u673a\u53f7", (String)"InvoiceCheckService_55", (String)"imc-sim-common", (Object[])new Object[0]));
                }
                InvoiceCheckService.checkMobile(invoice.getBuyerphone());
            }
            InvoiceCheckService.checkBuyerEmailMethod(invoice.getBuyeremail());
        }
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && StringUtils.isBlank((CharSequence)invoice.getApplicant())) {
            InvoiceCheckService.checkNull(invoice.getDrawer(), ResManager.loadKDString((String)"\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_56", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype())) {
            InvoiceCheckService.checkLen(invoice.getRemark(), 200, String.format(LEN_ERR_MSG_TEMPLATE, "\u5907\u6ce8", 200));
            InvoiceCheckService.checkLen(invoice.getPayee(), 16, String.format(LEN_ERR_MSG_TEMPLATE, "\u6536\u6b3e\u4eba", 16));
            InvoiceCheckService.checkLen(invoice.getReviewer(), 16, String.format(LEN_ERR_MSG_TEMPLATE, "\u590d\u6838\u4eba", 16));
        } else {
            InvoiceCheckService.checkGbkLen(invoice.getRemark(), 230, String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u5907\u6ce8", 230));
            InvoiceCheckService.checkGbkLen(invoice.getPayee(), 16, String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u6536\u6b3e\u4eba", 16));
            InvoiceCheckService.checkGbkLen(invoice.getReviewer(), 16, String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u590d\u6838\u4eba", 16));
        }
        InvoiceCheckService.checkIssueType(invoice);
        if (!EnterpriseHelper.isLqptChannel((String)invoice.getSalertaxno()) && "E03".equals(invoice.getSpecialtype()) && IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getIssuetype()) && Handle.isNotEmpty((Object)invoice.getCrosscitysign()) && "1".equals(invoice.getCrosscitysign()) && Handle.isEmpty((Object)invoice.getCrossCityTaxVerifyNo())) {
            throw new MsgException(ResManager.loadKDString((String)"\u7535\u5b50\u7a0e\u5c40\u5efa\u7b51\u670d\u52a1\u5f00\u7968\u65f6\u8de8\u5730(\u5e02)\u6807\u5fd7\u4e3a\u662f\u5219\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u9a8c\u7ba1\u7406\u7f16\u53f7\u5fc5\u586b", (String)"InvoiceCheckService_103", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    private static void checkBuyerEmailMethod(String buyerEmail) {
        if (StringUtils.isEmpty((CharSequence)buyerEmail)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)buyerEmail) && GBKUtils.getGBKLength((String)buyerEmail) > 100) {
            String GBK_LEN_ERR_MSG_TEMPLATE = ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b572\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"InvoiceCheckService_0", (String)"imc-sim-common", (Object[])new Object[0]);
            throw new MsgException(String.format(GBK_LEN_ERR_MSG_TEMPLATE, "\u8d2d\u4e70\u65b9\u90ae\u7bb1", 100));
        }
        String[] emailList = buyerEmail.split(";");
        if (emailList.length > 3) {
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u4e0d\u80fd\u8d85\u8fc73\u4e2a", (String)"InvoiceCheckService_5", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String emailRegex = "/^([a-zA-Z0-9._%+-]+)@([a-zA-Z0-9-]+\\.[a-zA-Z]{2,})(\\.[a-zA-Z]{2,})?$/";
        for (String subEmail : emailList) {
            if (!Pattern.matches(emailRegex, subEmail)) continue;
            throw new MsgException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceCheckService_6", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }

    private static void saleCheck(BaseInvoice invoice, boolean isRedInfoAdd) {
        String name = ResManager.loadKDString((String)"\u9500\u552e\u65b9", (String)"InvoiceCheckService_57", (String)"imc-sim-common", (Object[])new Object[0]);
        if ("02".equals(invoice.getSpecialtype())) {
            name = ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9", (String)"InvoiceCheckService_58", (String)"imc-sim-common", (Object[])new Object[0]);
        }
        InvoiceCheckService.checkNull(invoice.getSalername(), String.format(ResManager.loadKDString((String)"%s\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_59", (String)"imc-sim-common", (Object[])new Object[0]), name));
        InvoiceCheckService.checkGbkLen(invoice.getSalername(), 100, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), String.format(ResManager.loadKDString((String)"%s\u540d\u79f0", (String)"InvoiceCheckService_60", (String)"imc-sim-common", (Object[])new Object[0]), name), 100));
        InvoiceCheckService.checkNull(invoice.getSalertaxno(), String.format(ResManager.loadKDString((String)"%s\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_61", (String)"imc-sim-common", (Object[])new Object[0]), name));
        if (!(isRedInfoAdd || InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype()) && EnterpriseHelper.isLqptChannel((String)invoice.getSalertaxno()))) {
            InvoiceCheckService.checkNull(invoice.getSaleraddr(), String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u3001\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_62", (String)"imc-sim-common", (Object[])new Object[0]), name));
            InvoiceCheckService.checkNull(invoice.getSalerbank(), String.format(ResManager.loadKDString((String)"%s\u540d\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_63", (String)"imc-sim-common", (Object[])new Object[0]), name));
        }
        InvoiceCheckService.checkGbkLen(invoice.getSaleraddr(), 100, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u3001\u7535\u8bdd", (String)"InvoiceCheckService_64", (String)"imc-sim-common", (Object[])new Object[0]), name), 100));
        InvoiceCheckService.checkGbkLen(invoice.getSalerbank(), 100, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), String.format(ResManager.loadKDString((String)"%s\u540d\u5f00\u6237\u884c\u53ca\u8d26\u53f7", (String)"InvoiceCheckService_65", (String)"imc-sim-common", (Object[])new Object[0]), name), 100));
    }

    private static void buyerCheck(BaseInvoice invoice, boolean isRedInfoAdd) {
        String name = ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9", (String)"InvoiceCheckService_58", (String)"imc-sim-common", (Object[])new Object[0]);
        if ("02".equals(invoice.getSpecialtype())) {
            name = ResManager.loadKDString((String)"\u9500\u552e\u65b9", (String)"InvoiceCheckService_57", (String)"imc-sim-common", (Object[])new Object[0]);
        }
        InvoiceCheckService.checkNull(invoice.getBuyername(), String.format(ResManager.loadKDString((String)"%s\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_59", (String)"imc-sim-common", (Object[])new Object[0]), name));
        InvoiceCheckService.checkGbkLen(invoice.getBuyername(), 100, String.format(InvoiceCheckService.GBK_LEN_ERR_MSG_TEMPLATE(), "\u8d2d\u4e70\u65b9\u540d\u79f0", 100));
        if (StringUtils.isNotEmpty((CharSequence)invoice.getBuyertaxno()) && invoice.getInvoiceamount().compareTo(BigDecimal.ZERO) > 0 && !"02".equals(invoice.getSpecialtype())) {
            InvoiceCheckService.checkTaxNo(invoice.getBuyertaxno(), String.format(ResManager.loadKDString((String)"%s\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceCheckService_66", (String)"imc-sim-common", (Object[])new Object[0]), name));
        }
        if (InvoiceUtils.isSpecialInvoice((String)invoice.getInvoicetype())) {
            InvoiceCheckService.checkNull(invoice.getBuyertaxno(), String.format(ResManager.loadKDString((String)"%s\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_61", (String)"imc-sim-common", (Object[])new Object[0]), name));
            if (!isRedInfoAdd) {
                InvoiceCheckService.checkNull(invoice.getBuyeraddr(), String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u3001\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_62", (String)"imc-sim-common", (Object[])new Object[0]), name));
                InvoiceCheckService.checkNull(invoice.getBuyerbank(), String.format(ResManager.loadKDString((String)"%s\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_69", (String)"imc-sim-common", (Object[])new Object[0]), name));
            }
        }
        if (InvoiceUtils.isAllESpecialInvoice((String)invoice.getInvoicetype())) {
            InvoiceCheckService.checkNull(invoice.getBuyertaxno(), String.format(ResManager.loadKDString((String)"%s\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_61", (String)"imc-sim-common", (Object[])new Object[0]), name));
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoice.getInvoicetype())) {
            InvoiceCheckService.checkLen(invoice.getBuyeraddr(), 120, String.format(LEN_ERR_MSG_TEMPLATE, name + "\u5730\u5740\u3001\u7535\u8bdd", 120));
            InvoiceCheckService.checkLen(invoice.getBuyerbank(), 150, String.format(LEN_ERR_MSG_TEMPLATE, name + "\u5f00\u6237\u884c\u53ca\u8d26\u53f7", 150));
        } else {
            InvoiceCheckService.checkGbkLen(invoice.getBuyeraddr(), 100, String.format(GBK_LEN_ERR_MSG_TEMPLATE, name + "\u5730\u5740\u3001\u7535\u8bdd", 100));
            InvoiceCheckService.checkGbkLen(invoice.getBuyerbank(), 100, String.format(GBK_LEN_ERR_MSG_TEMPLATE, name + "\u5f00\u6237\u884c\u53ca\u8d26\u53f7", 100));
        }
    }

    public static String checkRedInfo(DynamicObject dynamicObject) {
        String errMsg = "";
        try {
            BaseInvoice baseInvoice = (BaseInvoice)DynamicObjectUtil.dynamicObject2Bean(BaseInvoice.class, (DynamicObject)dynamicObject);
            InvoiceCheckService.baseInvoiceCheck(baseInvoice, true, true);
        }
        catch (MsgException e) {
            errMsg = e.getErrorMsg();
        }
        return errMsg;
    }

    public static String checkBaseParams(DynamicObject dynamicObject, boolean isCheckDevice) {
        String errMsg = "";
        try {
            BaseInvoice baseInvoice = (BaseInvoice)DynamicObjectUtil.dynamicObject2Bean(BaseInvoice.class, (DynamicObject)dynamicObject);
            InvoiceCheckService.baseInvoiceCheck(baseInvoice, isCheckDevice, false);
        }
        catch (MsgException e) {
            errMsg = e.getErrorMsg();
            CallbackHelperUtil.sendErrorCallbackMessage((String)errMsg, (DynamicObject)dynamicObject, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        }
        return errMsg;
    }

    public static String checkParams(DynamicObject dynamicObject, boolean isCheckDevice) {
        return InvoiceCheckService.checkParams(dynamicObject, isCheckDevice, true);
    }

    public static String checkParams(DynamicObject dynamicObject, boolean isCheckDevice, boolean sendCallBack) {
        String errMsg;
        block2: {
            errMsg = "";
            try {
                BaseInvoice baseInvoice = InvoiceCheckService.invoiceDynamicObject2Invoice(dynamicObject);
                InvoiceCheckService.baseInvoiceCheck(baseInvoice, isCheckDevice, false);
                InvoiceCheckService.checkInvoice(baseInvoice);
            }
            catch (MsgException e) {
                errMsg = e.getErrorMsg();
                if (!sendCallBack) break block2;
                CallbackHelperUtil.sendErrorCallbackMessage((String)errMsg, (DynamicObject)dynamicObject, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
            }
        }
        return errMsg;
    }

    public static BaseInvoice invoiceDynamicObject2Invoice(DynamicObject invoiceObj) {
        BaseInvoice baseInvoice = (BaseInvoice)DynamicObjectUtil.dynamicObject2Bean(BaseInvoice.class, (DynamicObject)invoiceObj);
        String billName = invoiceObj.getDataEntityType().getName();
        if ("sim_vatinvoice".equals(billName)) {
            baseInvoice.setOrgid(String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceObj.get("orgid"))));
        } else if ("sim_red_info".equals(billName)) {
            baseInvoice.setOrgid(String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceObj.get("org"))));
        } else if ("sim_red_confirm_bill".equals(billName)) {
            baseInvoice.setOrgid(String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceObj.get("org"))));
        }
        DynamicObjectCollection items2 = invoiceObj.getDynamicObjectCollection("items");
        if (!items2.isEmpty()) {
            ArrayList itemList = new ArrayList(items2.size());
            items2.forEach(item -> itemList.add(BeanUtil.dynamicObject2SimpleBean((DynamicObject)item, BaseInvoiceItem.class)));
            baseInvoice.setInvoiceItemList(itemList);
        }
        return baseInvoice;
    }

    public static Boolean checkInvoiceExists(String invoiceCode, String invoiceNo) {
        return QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo(invoiceCode, invoiceNo).toArray());
    }

    public static void checkVehicleItem(String specialType, String invoiceType, String property, int i, String num, String price, String unit) throws Exception {
        if (StringUtils.isEmpty((CharSequence)specialType) || StringUtils.isEmpty((CharSequence)invoiceType) || StringUtils.isEmpty((CharSequence)property)) {
            return;
        }
        if ("1".equals(property)) {
            return;
        }
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType) && "18".equals(specialType)) {
            if (StringUtils.isEmpty((CharSequence)unit) || !ResManager.loadKDString((String)"\u8f86", (String)"InvoiceCheckService_70", (String)"imc-sim-common", (Object[])new Object[0]).equals(unit)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\uff0c\u7b2c%1$s\u884c\u660e\u7ec6\u5355\u4f4d\u4e3a%2$s\u8f86%3$s", (String)"InvoiceCheckService_71", (String)"imc-sim-common", (Object[])new Object[0]), i + 1, "\"", "\""));
            }
            if (StringUtils.isEmpty((CharSequence)num)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\uff0c\u7b2c%d\u884c\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_72", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
            if (!Pattern.matches("^-?\\d+$", num) && !Pattern.matches("^-?\\d+(\\.[0]+)?$", num)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\uff0c\u7b2c%d\u884c\u660e\u7ec6\u6570\u91cf\u5fc5\u987b\u662f\u6574\u6570", (String)"InvoiceCheckService_73", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((CharSequence)price) || "0E-8".equals(price)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\uff0c\u7b2c%d\u884c\u660e\u7ec6\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_74", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
            }
        }
    }

    public static void checkVehicleItem(BaseInvoice invoice, BaseInvoiceItem item, int index) {
        String invoiceType = invoice.getInvoicetype();
        String specialtype = invoice.getSpecialtype();
        String property = item.getRowtype();
        String num = String.valueOf(item.getNum());
        String price = String.valueOf(item.getUnitprice());
        String unit = item.getUnit();
        try {
            InvoiceCheckService.checkVehicleItem(specialtype, invoiceType, property, index, num, price, unit);
        }
        catch (Exception e) {
            throw new MsgException(e.getMessage());
        }
    }

    public static void checkEleDeduction(BaseInvoice baseInvoice, boolean issueInvoiceCheck) {
        if (!TaxedTypeEnum.alleTaxedTypeDeduction(baseInvoice.getTaxedtype())) {
            return;
        }
        List items2 = baseInvoice.getInvoiceItemList();
        if (!baseInvoice.getArIssue().booleanValue() && items2.stream().filter(item -> "0".equals(item.getRowtype()) || "2".equals(item.getRowtype())).count() > 1L) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u5dee\u989d\u5f81\u7a0e\u53ea\u80fd\u6709\u4e00\u884c\u5546\u54c1\u884c\u6216\u4e00\u884c\u5546\u54c1\u884c+\u4e00\u884c\u6298\u6263\u884c", (String)"InvoiceCheckService_75", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(baseInvoice.getTaxedtype())) {
            return;
        }
        if (baseInvoice.getInvoiceamount().compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        List deductionItems = baseInvoice.getDeductionItems();
        if (issueInvoiceCheck && CollectionUtils.isEmpty((Collection)deductionItems)) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u5f81\u7a0e\u65b9\u5f0f\u4e3a\u5dee\u989d\u5f81\u7a0e-\u5dee\u989d\u5f00\u7968\uff0c\u5dee\u989d\u660e\u7ec6\u5fc5\u586b", (String)"InvoiceCheckService_76", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        if (CollectionUtils.isEmpty((Collection)deductionItems)) {
            return;
        }
        BigDecimal sumDeduction = BigDecimal.ZERO;
        HashMap<String, JSONObject> deducInvoiceMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < deductionItems.size(); ++i) {
            String tip;
            JSONObject json;
            String key;
            BillDeductionItemVo deductionItem = (BillDeductionItemVo)deductionItems.get(i);
            int seq = i + 1;
            if (issueInvoiceCheck && MathUtils.isNullOrZero(deductionItem.getEvidenceAmount())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51ed\u8bc1\u5408\u8ba1\u91d1\u989d\u5fc5\u586b", (String)"InvoiceCheckService_77", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            if (issueInvoiceCheck && MathUtils.isNullOrZero(deductionItem.getDeduction())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u672c\u6b21\u6263\u9664\u91d1\u989d\u5fc5\u586b", (String)"InvoiceCheckService_78", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            if (issueInvoiceCheck && deductionItem.getDeduction().compareTo(deductionItem.getEvidenceAmount()) > 0) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u672c\u6b21\u6263\u9664\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u51ed\u8bc1\u5408\u8ba1\u91d1\u989d", (String)"InvoiceCheckService_79", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            String evidenceType = deductionItem.getEvidenceType();
            if (issueInvoiceCheck) {
                InvoiceCheckService.checkNull(evidenceType, String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51ed\u8bc1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_80", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            if (StringUtils.isNotBlank((CharSequence)evidenceType)) {
                if (evidenceType.length() != 2 || !evidenceType.startsWith("0")) {
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51ed\u8bc1\u7c7b\u578b\u9519\u8bef", (String)"InvoiceCheckService_81", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
                String subEvidenceType = evidenceType.replace("0", "");
                if (subEvidenceType.length() != 1 || !BigDecimalUtil.isNumber((String)subEvidenceType)) {
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51ed\u8bc1\u7c7b\u578b\u9519\u8bef", (String)"InvoiceCheckService_81", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
            }
            InvoiceCheckService.checkStrLength(deductionItem.getEvidenceNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u7801", (String)"InvoiceCheckService_101", (String)"imc-sim-common", (Object[])new Object[0])), 20);
            InvoiceCheckService.checkStrLength(deductionItem.getEtaxInvoiceNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801", (String)"InvoiceCheckService_82", (String)"imc-sim-common", (Object[])new Object[0])), 20);
            InvoiceCheckService.checkStrLength(deductionItem.getInvoiceCode(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCheckService_83", (String)"imc-sim-common", (Object[])new Object[0])), 20);
            InvoiceCheckService.checkStrLength(deductionItem.getInvoiceNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCheckService_84", (String)"imc-sim-common", (Object[])new Object[0])), 10);
            if (StringUtils.isNotBlank((CharSequence)deductionItem.getEtaxInvoiceNo()) && StringUtils.isNotBlank((CharSequence)deductionItem.getInvoiceCode()) && StringUtils.isNotBlank((CharSequence)deductionItem.getInvoiceNo())) {
                throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6570\u7535\u53f7\u7801\u3001\u53d1\u7968\u4ee3\u7801\u3001\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u540c\u65f6\u6709\u503c", (String)"InvoiceCheckService_85", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            InvoiceCheckService.checkStrLength(deductionItem.getInvoiceDate(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCheckService_86", (String)"imc-sim-common", (Object[])new Object[0])), 10);
            InvoiceCheckService.checkStrLength(deductionItem.getRemark(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"InvoiceCheckService_87", (String)"imc-sim-common", (Object[])new Object[0])), 100);
            if ("01".equals(evidenceType)) {
                if (issueInvoiceCheck) {
                    InvoiceCheckService.checkNull(deductionItem.getEtaxInvoiceNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6570\u7535\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_88", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
                if (GBKUtils.getGBKLength((String)deductionItem.getEtaxInvoiceNo()) > 20) {
                    throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6570\u7535\u7968\u53f7\u7801\u7684\u957f\u5ea6\u9650\u5236\u4e3a20\u5b57\u7b26", (String)"InvoiceCheckService_89", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
                if (issueInvoiceCheck) {
                    InvoiceCheckService.checkNull(deductionItem.getInvoiceDate(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_90", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
                key = deductionItem.getEtaxInvoiceNo();
                json = InvoiceCheckService.getJsonObject(deducInvoiceMap, deductionItem, key);
                tip = String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s,\u6263\u9664\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u91d1\u989d", (String)"InvoiceCheckService_91", (String)"imc-sim-common", (Object[])new Object[0]), deductionItem.getEtaxInvoiceNo()));
                InvoiceCheckService.throwTips(deductionItem, json, tip);
            } else if ("02".equals(evidenceType) || "03".equals(evidenceType) || "04".equals(evidenceType)) {
                if (issueInvoiceCheck) {
                    InvoiceCheckService.checkNull(deductionItem.getInvoiceCode(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_92", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                    InvoiceCheckService.checkNull(deductionItem.getInvoiceNo(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_93", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                    InvoiceCheckService.checkNull(deductionItem.getInvoiceDate(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_90", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
                }
                key = deductionItem.getInvoiceCode() + deductionItem.getInvoiceNo();
                json = InvoiceCheckService.getJsonObject(deducInvoiceMap, deductionItem, key);
                tip = String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\u3001\u53d1\u7968\u53f7\u7801%2$s,\u6263\u9664\u91d1\u989d\u8d85\u8fc7\u53d1\u7968\u91d1\u989d", (String)"InvoiceCheckService_94", (String)"imc-sim-common", (Object[])new Object[0]), deductionItem.getInvoiceCode(), deductionItem.getInvoiceNo()));
                InvoiceCheckService.throwTips(deductionItem, json, tip);
            } else if (("08".equals(evidenceType) || "09".equals(evidenceType)) && issueInvoiceCheck) {
                InvoiceCheckService.checkNull(deductionItem.getRemark(), String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), String.format(ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceCheckService_95", (String)"imc-sim-common", (Object[])new Object[0]), seq)));
            }
            sumDeduction = sumDeduction.add(deductionItem.getDeduction());
        }
        if (issueInvoiceCheck && sumDeduction.compareTo(baseInvoice.getDeduction()) != 0) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u5dee\u989d\u660e\u7ec6\u5408\u8ba1\u6263\u9664\u989d\u4e0e\u603b\u8ba1\u6263\u9664\u989d\u4e0d\u76f8\u7b49", (String)"InvoiceCheckService_96", (String)"imc-sim-common", (Object[])new Object[0])));
        }
        if (baseInvoice.getDeduction().compareTo(baseInvoice.getInvoiceamount()) > 0) {
            throw new MsgException(String.format(InvoiceCheckService.BILL_ERROR_TEMPLATE(), baseInvoice.getBillno(), ResManager.loadKDString((String)"\u603b\u8ba1\u6263\u9664\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceCheckService_97", (String)"imc-sim-common", (Object[])new Object[0])));
        }
    }

    private static void throwTips(BillDeductionItemVo deductionItem, JSONObject json, String tip) {
        if (null != json && !BigDecimalUtil.compareZero((BigDecimal)deductionItem.getOriEvidenceAmount())) {
            BigDecimal deductionAmount = json.getBigDecimal("deductionamount");
            BigDecimal oriInvoiceAmount = json.getBigDecimal("orievidenceamount");
            if (deductionAmount.abs().compareTo(oriInvoiceAmount.abs()) > 0) {
                throw new MsgException(tip);
            }
        }
    }

    private static JSONObject getJsonObject(HashMap<String, JSONObject> deducInvoiceMap, BillDeductionItemVo deductionItem, String key) {
        JSONObject json = deducInvoiceMap.get(key);
        if (null == json && !BigDecimalUtil.compareZero((BigDecimal)deductionItem.getOriEvidenceAmount())) {
            json = new JSONObject();
            json.put("orievidenceamount", (Object)deductionItem.getOriEvidenceAmount());
            json.put("deductionamount", (Object)deductionItem.getDeduction());
            deducInvoiceMap.put(key, json);
        } else if (null != json && !BigDecimalUtil.compareZero((BigDecimal)deductionItem.getOriEvidenceAmount())) {
            json = deducInvoiceMap.get(key);
            json.put("deductionamount", (Object)json.getBigDecimal("deductionamount").add(deductionItem.getDeduction()));
        }
        return json;
    }
}

