/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.constant.systemsetting.CallBackTypeEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ConfigCacheHelper;
import kd.imc.bdm.common.helper.DeviceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.service.InvoiceFileService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.SendMsgEmailService;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;

public class InvoiceIsmcSyncToImcService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceIsmcSyncToImcService.class);
    public static final String FAIL_PREFIX = "OFD_FAIL";
    public static final String REPEAT_QUERY = "REAPEAT_SYNC";
    public static final Integer CACHE_TIME = 7200;

    public static DynamicObject[] getNeedSyncPDFStatusInvoice() {
        int value;
        QFilter qFilter1 = InvoiceQFilterUtil.getInvoiceStatusQFilter();
        qFilter1.and("buyertype", "not in", (Object)new String[]{"2", "8", "9"});
        String syncStatus = ImcConfigUtil.getValue((String)"needSyncNotNeed", (String)"needSyncNotNeed");
        QFilter qFilter2 = new QFilter("ofdstatus", "=", (Object)"0");
        if (StringUtils.isNotBlank((CharSequence)syncStatus)) {
            qFilter2 = new QFilter("ofdstatus", "in", (Object)new String[]{"0", "3"});
        }
        value = (value = ConfigCacheHelper.getIntegerValueByParamConfig((String)"sim_query_no_pdf_invoice_recent")) == 0 ? -120 : -value;
        QFilter qFilter3 = new QFilter("createtime", ">=", (Object)DateUtils.addHour((Date)new Date(), (int)value));
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2, qFilter3};
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"orderno,skm,checkcode,invoicetype,invoiceno,invoicecode,jqbh,issuesource,terminalno", (QFilter[])qFilters, (String)"id desc", (int)0, (int)1000);
    }

    public static boolean executeSyncIsmcInvoice(Object dynamicObject, String syncOrderNo) {
        MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"SimSyncInvoiceStatus", (Object)dynamicObject);
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            InvoiceIsmcSyncToImcService.handleResponseSuccess(msgResponse, syncOrderNo);
            return true;
        }
        return false;
    }

    public static void handleResponseSuccess(MsgResponse msgResponse, String syncOrderNo) {
        String respData = msgResponse.getRespData();
        JSONObject dataMap = JSONObject.parseObject((String)respData);
        JSONArray ofdStatusFailList = dataMap.getJSONArray("ofdStatusFailList");
        JSONArray ofdStatusSuccessList = dataMap.getJSONArray("ofdStatusSuccessList");
        if (StringUtils.isNotBlank((CharSequence)syncOrderNo) && ofdStatusSuccessList.size() == 0) {
            CacheHelper.put((String)(REPEAT_QUERY + syncOrderNo), (String)REPEAT_QUERY, (int)60);
        }
        if (ofdStatusFailList.size() > 0) {
            LOGGER.info("ofdStatusFailList size: " + ofdStatusFailList.size());
            InvoiceIsmcSyncToImcService.updateUploadOrOFDStatusList(ofdStatusFailList, "ofdstatus", "0");
        }
        if (ofdStatusSuccessList.size() > 0) {
            DynamicObject[] dynamicObjects;
            LOGGER.info("ofdStatusSuccessList size: " + ofdStatusSuccessList.size());
            try (TXHandle tx = TX.required();){
                try {
                    dynamicObjects = InvoiceIsmcSyncToImcService.updateUploadOrOFDStatusList(ofdStatusSuccessList, "ofdstatus", "1");
                }
                catch (Exception t) {
                    LOGGER.error("InvoiceIsmcSyncToImcServiceFail:" + t.getMessage(), (Throwable)t);
                    tx.markRollback();
                    throw t;
                }
            }
            try {
                String systemSourceCallbackType = ConfigCacheHelper.getCacheValue((String)"sim_system_source_callback_type");
                LOGGER.info("ofdStatusSuccessList systemSourceCallbackType: " + systemSourceCallbackType);
                boolean volumnCreatePdf = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF));
                boolean isAfterPdf = CallBackTypeEnum.AFTER_PDF.getCode().equals(systemSourceCallbackType);
                if (CallBackTypeEnum.AFTER_PDF.getCode().equals(systemSourceCallbackType) || "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF))) {
                    InvoiceIsmcSyncToImcService.electricalInvoiceAsyncSendOpenInvoiceCallBack(dynamicObjects, isAfterPdf, volumnCreatePdf);
                }
            }
            catch (Exception e) {
                LOGGER.error("InvoiceIsmcSyncToImcServiceSendCallBackFail:" + e.getMessage(), (Throwable)e);
            }
            if (dynamicObjects.length > 0) {
                Set<DynamicObject> needSendSet = Arrays.stream(dynamicObjects).filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("fileurl")) && String.valueOf(o.getString("fileurl")).startsWith("http")).collect(Collectors.toSet());
                InvoiceIsmcSyncToImcService.dealWithEmailOrSms(needSendSet.toArray(new DynamicObject[0]));
                InvoiceIsmcSyncToImcService.deleteRepairData(dynamicObjects);
                RequestContext context = RequestContext.get();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ThreadPoolsHelper.invokeRimSaveInvoiceThreadPool.execute(() -> {
                        RequestContext.copyAndSet((RequestContext)context);
                        IssueInvoiceService.invokeRimSaveInvoice(dynamicObject);
                    });
                }
            }
        }
    }

    private static void deleteRepairData(DynamicObject[] dynamicObjects) {
        ArrayList<Object> billPks = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            billPks.add(dynamicObject.getPkValue());
        }
        QFilter deleteFilter = new QFilter("invoicepk", "in", (Object)billPks.toArray(new Object[0]));
        DeleteServiceHelper.delete((String)"sim_repair_invoice", (QFilter[])deleteFilter.toArray());
    }

    public static DynamicObject[] updateUploadOrOFDStatusList(JSONArray statusList, String updateEntry, String status) {
        DynamicObject[] dynamicObjects;
        HashMap<String, JSONObject> statusMap = new HashMap<String, JSONObject>();
        for (Object o : statusList) {
            JSONObject json = (JSONObject)o;
            String orderNo = json.getString("orderno");
            statusMap.put(orderNo, json);
            String cacheKey = FAIL_PREFIX + orderNo;
            String cacheValue = CacheHelper.get((String)cacheKey);
            if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                try {
                    CacheHelper.put((String)cacheKey, (String)String.valueOf(Integer.parseInt(cacheValue) + 1), (int)CACHE_TIME);
                }
                catch (Exception e) {
                    LOGGER.error("updateUploadOrOFDStatusList" + e.getMessage(), (Throwable)e);
                }
                continue;
            }
            CacheHelper.put((String)cacheKey, (String)"0", (int)CACHE_TIME);
        }
        for (DynamicObject dynamicObject : dynamicObjects = InvoiceIsmcSyncToImcService.getDynamicObjects(statusList)) {
            dynamicObject.set(updateEntry, (Object)status);
            if (!"1".equals(status)) continue;
            InvoiceIsmcSyncToImcService.setInvoiceFileUrl(statusMap, dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        return dynamicObjects;
    }

    private static void electricalInvoiceAsyncSendOpenInvoiceCallBack(DynamicObject[] dynamicObjects, boolean isAfterPdf, boolean volumnCreatePdf) {
        for (DynamicObject invoiceDynamicObject : dynamicObjects) {
            boolean isVolumnCreatePdf;
            if (!isAfterPdf && volumnCreatePdf && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype"))) {
                return;
            }
            boolean bl = isVolumnCreatePdf = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF)) && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype"));
            if (!InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype")) && !InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype")) && !isVolumnCreatePdf) continue;
            LOGGER.info("\u751f\u6210\u5b8cPDF\u53d1\u7968\u56de\u8c03 " + invoiceDynamicObject.getString("invoiceno"));
            CallbackHelperUtil.sendCallbackMessage((DynamicObject)invoiceDynamicObject, (String)invoiceDynamicObject.getString("systemsource"), (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        }
    }

    private static void setInvoiceFileUrl(HashMap<String, JSONObject> statusMap, DynamicObject invoice) {
        boolean isVolumnCreatePdf;
        JSONObject jsonObject = statusMap.get(invoice.getString("orderno"));
        String fileUrl = jsonObject.getString("fileurl");
        String snapShortUrl = jsonObject.getString("snapshoturl");
        String invoiceType = invoice.getString("invoicetype");
        if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            LOGGER.info(String.format("InvoiceIsmcSyncToImcService %s \u5bf9\u5e94\u6587\u4ef6\u7684\u4e0b\u8f7d\u5730\u5740\uff1a%s,\u5feb\u7167\u4e0b\u8f7d\u5730\u5740\uff1a%s", invoice.getString("orderno"), fileUrl, snapShortUrl));
        }
        invoice.set("fileurl", (Object)fileUrl);
        invoice.set("snapshoturl", (Object)snapShortUrl);
        InvoiceIsmcSyncToImcService.fillPdfUrl(invoice, fileUrl);
        boolean bl = isVolumnCreatePdf = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF)) && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoice.getString("invoicetype"));
        if (isVolumnCreatePdf) {
            return;
        }
        boolean isPaperInvoice = InvoiceUtils.isPaperInvoice((String)invoice.getString("invoicetype"));
        boolean isVirtualUkey = "3".equals(invoice.getString("issuesource"));
        if (isPaperInvoice || isVirtualUkey) {
            String taxNo = invoice.getString("salertaxno");
            if ("02".equals(invoice.getString("specialtype"))) {
                taxNo = invoice.getString("buyertaxno");
            }
            String orderNo = invoice.getString("orderno");
            String prefix = "/dim/invoice/" + taxNo + File.separator;
            String suffix = File.separator + orderNo.substring(0, 2) + File.separator + orderNo;
            invoice.set("fileurl", (Object)(prefix + "pdf" + suffix + ".pdf"));
            invoice.set("snapshoturl", (Object)(prefix + "jpg" + suffix + ".jpg"));
        }
    }

    public static void fillPdfUrl(DynamicObject invoice, String fileUrl) {
        if (DeviceHelper.isOfdDevice((String)invoice.getString("issuesource"))) {
            if (fileUrl.contains("chinatax") && fileUrl.contains("type=3")) {
                invoice.set("pdffileurl", (Object)InvoiceIsmcSyncToImcService.getPdfUrl(fileUrl));
            }
        } else {
            invoice.set("pdffileurl", (Object)fileUrl);
        }
    }

    public static String getPdfUrl(String fileUrl) {
        if ((fileUrl = fileUrl.replace("type=3", "type=12")).contains("type=3")) {
            return InvoiceIsmcSyncToImcService.getPdfUrl(fileUrl);
        }
        return fileUrl;
    }

    public static DynamicObject[] getDynamicObjects(JSONArray list) {
        ArrayList<String> orderNoList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            JSONObject jsonObject = list.getJSONObject(i);
            String orderNo = jsonObject.getString("orderno");
            orderNoList.add(orderNo);
        }
        QFilter orderNoFilter = new QFilter("orderno", "in", orderNoList);
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice"), (QFilter[])orderNoFilter.toArray());
    }

    private static void dealWithEmailOrSms(DynamicObject[] ofdSuccessDynamicObjects) {
        for (DynamicObject invoiceObj : ofdSuccessDynamicObjects) {
            LOGGER.info(String.format("\u5f00\u7968\u53d1\u9001\u90ae\u4ef6\u77ed\u4fe1 \u53d1\u7968\u4ee3\u7801\uff1a%s \u53d1\u7968\u53f7\u7801\uff1a%s", invoiceObj.getString("invoicecode"), invoiceObj.getString("invoiceno")));
            String redisKey = String.format("email_send_times%s%s", invoiceObj.getString("invoicecode"), invoiceObj.getString("invoiceno"));
            String sendTimes = CacheHelper.get((String)redisKey);
            LOGGER.info("\u5f00\u7968\u53d1\u9001\u90ae\u4ef6\u77ed\u4fe1 sendTimes " + sendTimes + ", pushStatus: " + invoiceObj.getString("pushstatus"));
            ImmutableSet etcInvoiceSet = ImmutableSet.of((Object)InvoiceType.getCodeByDesc((String)"\u7535\u5b50\u666e\u901a\u53d1\u7968"), (Object)InvoiceType.getCodeByDesc((String)"\u7535\u5b50\u4e13\u7528\u53d1\u7968"));
            if ((!StringUtils.isBlank((CharSequence)sendTimes) || !etcInvoiceSet.contains((Object)String.valueOf(invoiceObj.get("invoicetype")))) && !InvoiceUtils.isVolumeInvCreatePdf((DynamicObject)invoiceObj) || !IssueType.BLUE_INVOICE.getTypeCode().equals(invoiceObj.get("issuetype")) && (!IssueType.RED_INVOICE.getTypeCode().equals(invoiceObj.get("issuetype")) || !"4".equals(invoiceObj.getString("buyertype")))) continue;
            SendMsgEmailService.sendMultiMsgJson((DynamicObject)invoiceObj, (String)invoiceObj.getString("buyerphone"), (String)invoiceObj.getString("buyeremail"));
            CacheHelper.put((String)redisKey, (String)"1", (int)120);
        }
    }

    private static void uploadInvoiceFile(JSONObject fileJson) {
        ArrayList<String> orderNos = new ArrayList<String>();
        for (Map.Entry entry : fileJson.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank(value)) continue;
            String[] split = key.split(",");
            String taxNo = split[0];
            String orderNo = split[1];
            orderNos.add(orderNo);
            String fileExtension = split[2];
            String fileNameWithExtension = orderNo + "." + fileExtension;
            String base64OfdStr = (String)value;
            byte[] decodeOfdBytes = Base64.getDecoder().decode(base64OfdStr);
            ByteArrayInputStream in = new ByteArrayInputStream(decodeOfdBytes);
            String fileSavePath = InvoiceFileService.getFileSavePath((String)taxNo, (String)orderNo, (FileType)FileType.getFileType((String)fileExtension), null, null);
            String uploadResult = FileUploadUtils.upload((String)fileSavePath, (String)fileNameWithExtension, (InputStream)in);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info(String.format("InvoiceIsmcSyncToImcService %s\uff0c\u4e0a\u4f20\u53d1\u7968\u6587\u4ef6, \u4e0a\u4f20\u7ed3\u679c\uff1a%s", fileNameWithExtension, uploadResult));
        }
        int delete = DeleteServiceHelper.delete((String)"sim_repair_invoice", (QFilter[])new QFilter("orderno", "in", (Object)orderNos.toArray(new Object[0])).toArray());
        LOGGER.info("InvoiceIsmcSyncToImcService \u5220\u9664\u4fee\u590d\u6570\u636e\u8868\u6570\u636e\uff1a" + delete);
        if (!QueryServiceHelper.exists((String)"sim_repair_invoice", (QFilter[])new QFilter("businesstype", "in", (Object)new String[]{"0", "1"}).toArray())) {
            CacheHelper.remove((String)"sim_repair_invoice");
        }
    }
}

