/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.enums.AllEPrivilegeTypeEnum;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.dto.allele.issue.AllEleEstateLeaseInfoRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleEstateSaleCoBuyerInfoReqeustDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleEstateSaleInfoReqeustDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueBuildInfoRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueDeductionRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueFreightRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueItemRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueResponseDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleIssueTravelerRequestDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleVehicleReqeustDTO;
import kd.imc.sim.common.dto.allele.issue.AllEleVehicleVesselTaxRequestDTO;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.issueinvoice.impl.AbstractTGIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleLqIssueInvoiceImpl;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AllEleIssueInvoiceImpl
extends AbstractTGIssueInvoiceImpl {
    @Override
    public boolean support(DynamicObject invoice) {
        return InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper")) || InvoiceUtils.isAllEVehicleInv((String)invoice.getString("invoicetype"));
    }

    @Override
    public MsgResponse issue(DynamicObject invoice) {
        if (EnterpriseHelper.isLqptChannel((String)invoice.getString("salertaxno")) && !"E14".equals(invoice.getString("specialtype"))) {
            return new AllEleLqIssueInvoiceImpl().issue(invoice);
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getString("invoiceno")) && "13".equals(invoice.getString("issuesource"))) {
            return MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5f00\u53d1\u7968\u5df2\u4f7f\u7528\u4e50\u4f01\u901a\u9053\u8fdb\u884c\u53d1\u7968\u9884\u8d4b\u7801\uff0c\u4e0d\u80fd\u5207\u6362\u4f7f\u7528\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0\u8fdb\u884c\u5f00\u5177\u3002", (String)"AllEleIssueInvoiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        invoice.set("issuesource", (Object)"12");
        AllEleIssueRequestDTO eleIssue = InvoiceUtils.isAllEVehicleInv((String)invoice.getString("invoicetype")) ? this.buildVehicleIssueRequestDto(invoice) : AllEleIssueInvoiceImpl.buildIssueInvoide(invoice);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u6570\u7535\u7968\u6d41\u6c34\u53f7[%s]\u5f00\u7968\u8bf7\u6c42\u6570\u636e[%s]", invoice.getString("orderno"), JSONObject.toJSONString((Object)((Object)eleIssue))));
        }
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)invoice.getString("salertaxno"), (AllEleRequestDTO)eleIssue, AllEleIssueResponseDTO.class);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u6570\u7535\u7968\u6d41\u6c34\u53f7[%s]\u5f00\u7968\u8fd4\u56de\u6570\u636e[%s]", invoice.getString("orderno"), JSONObject.toJSONString((Object)response)));
        }
        this.warpAllEPrivilegeType(invoice);
        if (response.getSuccess().booleanValue()) {
            MsgResponse msgResponse = new MsgResponse();
            msgResponse.setErrorCode(ErrorType.SUBMITED.getCode());
            invoice.set("govorderno", (Object)((AllEleIssueResponseDTO)response.getData()).getSerialNo());
            this.warpResponseData(invoice, msgResponse, "rpa");
            return msgResponse;
        }
        return MsgResponse.valueOfError((String)response.getErrcode(), (String)response.getDescription());
    }

    private AllEleIssueRequestDTO buildVehicleIssueRequestDto(DynamicObject invoice) {
        AllEleIssueRequestDTO issueInvoice = (AllEleIssueRequestDTO)((Object)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueRequestDTO.class, (DynamicObject)invoice));
        AllEleVehicleReqeustDTO vehicleInfo = (AllEleVehicleReqeustDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleVehicleReqeustDTO.class, (DynamicObject)invoice);
        issueInvoice.setAccount(invoice.getString("account"));
        issueInvoice.setTaxFlag(0);
        issueInvoice.setRequest_path(AllEleInterfaceTypeEnum.OPEN_INVOICE.getRequestPath());
        issueInvoice.setPaperInvoiceType(2);
        issueInvoice.setInvoiceType("12");
        issueInvoice.setBusinessType("14");
        issueInvoice.setType(0);
        issueInvoice.setSalerCardName(invoice.getString("salerbankname"));
        issueInvoice.setSalerCardNumber(invoice.getString("saleraccount"));
        issueInvoice.setSalerAddress(invoice.getString("saleraddress"));
        issueInvoice.setSalerPhone(invoice.getString("salerphone"));
        issueInvoice.setMotorVehicle(vehicleInfo);
        ArrayList<AllEleIssueItemRequestDTO> items2 = new ArrayList<AllEleIssueItemRequestDTO>();
        issueInvoice.setItems(items2);
        AllEleIssueItemRequestDTO item = new AllEleIssueItemRequestDTO();
        items2.add(item);
        String goodsCode = invoice.getString("goodscode");
        DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode);
        if (null == taxClassCode) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230:%s\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"AllEleIssueInvoiceImpl_15", (String)"imc-sim-common", (Object[])new Object[0]), goodsCode));
        }
        String simpleName = taxClassCode.getString("simplename");
        String goodsName = "*" + simpleName + "*" + invoice.getString("vehicletype");
        item.setGoodsName(goodsName);
        item.setDiscountType("0");
        item.setGoodsCode(invoice.getString("goodscode"));
        item.setDetailAmount(invoice.getBigDecimal("invoiceamount"));
        item.setTaxAmount(invoice.getBigDecimal("totalamount"));
        item.setTaxAmount(invoice.getBigDecimal("totaltax"));
        item.setTaxRate(new BigDecimal(invoice.getString("taxrate")));
        String preferentialPolicy = StringUtils.isBlank((CharSequence)invoice.getString("taxpremark")) ? "0" : invoice.getString("taxpremark");
        item.setPreferentialPolicy(preferentialPolicy);
        item.setVatException(invoice.getString("zzstsgl"));
        item.setSpecModel(invoice.getString("vehicleidcode"));
        return issueInvoice;
    }

    private void warpAllEPrivilegeType(DynamicObject invoice) {
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoice.getString("invoicetype"))) {
            String name;
            String zzstsgl = invoice.getString("zzstsgl");
            if (StringUtils.isNotEmpty((CharSequence)zzstsgl) && StringUtils.isNotEmpty((CharSequence)(name = AllEPrivilegeTypeEnum.getName((String)zzstsgl)))) {
                invoice.set("zzstsgl", (Object)name);
            }
            return;
        }
        for (DynamicObject item : invoice.getDynamicObjectCollection("items")) {
            String name;
            if (!StringUtils.isNotEmpty((CharSequence)item.getString("zzstsgl")) || !StringUtils.isNotEmpty((CharSequence)(name = AllEPrivilegeTypeEnum.getName((String)item.getString("zzstsgl"))))) continue;
            item.set("zzstsgl", (Object)name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AllEleIssueRequestDTO buildIssueInvoide(DynamicObject invoice) {
        boolean isInvoice = "sim_vatinvoice".equals(invoice.getDataEntityType().getName());
        AllEleIssueRequestDTO issueInvoice = (AllEleIssueRequestDTO)((Object)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueRequestDTO.class, (DynamicObject)invoice));
        issueInvoice.setAccount(invoice.getString("account"));
        String optionAccountList = CacheHelper.get((String)("accountList_" + invoice.getString("orderno")));
        if (!StringUtils.isBlank((CharSequence)optionAccountList)) {
            issueInvoice.setOptionAccountList(optionAccountList);
            issueInvoice.setMultAccountRuleId("003");
        }
        issueInvoice.setTaxFlag(0);
        issueInvoice.setRequest_path(AllEleInterfaceTypeEnum.OPEN_INVOICE.getRequestPath());
        issueInvoice.setOriginalInvoiceDate(DateUtils.format((Date)invoice.getDate("originalissuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
        DynamicObject issueInvSetting = null;
        if (isInvoice) {
            String buyerProperty;
            DynamicObject agent = invoice.getDynamicObject("operator");
            if (agent != null) {
                issueInvoice.setAgentUser(agent.getString("name"));
                issueInvoice.setAgentCardType(agent.getString("certificatetype"));
                issueInvoice.setAgentCardNo(agent.getString("certificatenumber"));
                issueInvoice.setAgentCountry(agent.getString("county"));
                issueInvoice.setAgentTaxNo(agent.getString("taxno"));
            }
            if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)invoice.get("orgid"));
                baseDataFilter.and("number", "=", (Object)issueInvoice.getRedConfirmBillNo());
                DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "govuuid", "uploaddate"), (QFilter[])baseDataFilter.toArray());
                issueInvoice.setGovRedConfirmBillUuid(redConfirmBill.getString("govuuid"));
                issueInvoice.setRedConfirmEnterDate(DateUtils.format((Date)redConfirmBill.getDate("uploaddate"), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)(buyerProperty = invoice.getString("buyerproperty")))) {
                if ("1".equalsIgnoreCase(buyerProperty)) {
                    issueInvoice.setNaturalPersonFlag("Y");
                } else if ("0".equalsIgnoreCase(buyerProperty) || "2".equalsIgnoreCase(buyerProperty)) {
                    issueInvoice.setNaturalPersonFlag("N");
                }
            }
            AllEleIssueInvoiceImpl.setDedutionList(invoice, issueInvoice);
            AllEleIssueInvoiceImpl.setShowBankInfo(invoice, issueInvoice);
            if (invoice.getInt("issuetype") == 0) {
                issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")));
            }
        }
        if (InvoiceSpecialType.allEleSpecialType(issueInvoice.getBusinessType())) {
            AllEleIssueInvoiceImpl.buildSpecialType(invoice, issueInvoice);
        } else {
            issueInvoice.setBusinessType("");
        }
        AllEleIssueInvoiceImpl.replaceAddrAndBank(issueInvoice);
        String originalInvoiceType = InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoice.getString("originalinvoicetype"));
        if (originalInvoiceType != null) {
            issueInvoice.setOriginalInvoiceType(originalInvoiceType);
        }
        issueInvoice.setInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoice.getString("invoicetype")));
        issueInvoice.setInventoryFlag("0");
        issueInvoice.setPurchaseFlag("0");
        String invoiceType = invoice.getString("invoicetype");
        boolean isElePaper = InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType);
        issueInvoice.setPaperInvoiceType(isElePaper ? 2 : 1);
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        issueInvoice.setInventoryProjectName(((DynamicObject)invoiceItems.get(0)).getString("goodsname"));
        ArrayList<AllEleIssueItemRequestDTO> items2 = new ArrayList<AllEleIssueItemRequestDTO>(invoiceItems.size());
        for (int i = 0; i < invoiceItems.size(); ++i) {
            BigDecimal num;
            DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
            AllEleIssueItemRequestDTO item = (AllEleIssueItemRequestDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueItemRequestDTO.class, (DynamicObject)invoiceItem);
            if (isInvoice && i == 0 && !MathUtils.isNullOrZero(invoice.getBigDecimal("deduction"))) {
                item.setDeduction(issueInvoice.getTotalDeduction());
            }
            if ("0.015".equals(invoiceItem.getString("taxrate"))) {
                item.setTaxRate(new BigDecimal("0.015"));
            }
            if ("2".equals(invoiceItem.getString("rowtype"))) {
                if (i == invoiceItems.size() - 1) {
                    invoiceItem.set("rowtype", (Object)"0");
                } else {
                    BigDecimal discountAmount = ((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount");
                    item.setDiscountAmount(discountAmount.compareTo(BigDecimal.ZERO) < 0 ? discountAmount.negate() : discountAmount);
                }
            }
            if (MathUtils.isNullOrZero(num = invoiceItem.getBigDecimal("num"))) {
                item.setUnitPrice("");
                item.setNum("");
            } else {
                if (isInvoice && invoice.getInt("issuetype") == 0 && invoiceItem.getBigDecimal("unitprice").stripTrailingZeros().toPlainString().length() > 16) {
                    if (null != issueInvSetting && !BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) throw new MsgException(ErrorType.FAIL.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u5355\u4ef7\u957f\u5ea6\u8d85\u9650\u3002\u4f7f\u7528\u7535\u5b50\u7a0e\u5c40\u5f00\u7968\u65f6\uff0c\u5355\u4ef7\u6700\u957f17\u4f4d\uff08\u542b\u5c0f\u6570\u70b9\uff09\uff0c\u6574\u6570\u4f4d\u6700\u591a12\u4f4d\uff0c\u7cbe\u5ea6\u6700\u591a13\u4f4d\u3002\u60a8\u53ef\u4ee5\u5728\u57fa\u7840\u8d44\u6599\u2192\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e\u2192\u5f00\u7968\u5176\u4ed6\u8bbe\u7f6e\u4e2d\u8bbe\u7f6e\u4e3a\u8d85\u957f\u81ea\u52a8\u622a\u53d6\u3002", (String)"AllEleIssueInvoiceImpl_1", (String)"imc-sim-common", (Object[])new Object[0]), i + 1));
                    item.setUnitPrice(PriceHelper.getValue(invoiceItem.getBigDecimal("unitprice"), Boolean.FALSE).stripTrailingZeros().toPlainString());
                    invoiceItem.set("unitprice", (Object)item.getUnitPrice());
                } else {
                    item.setUnitPrice(invoiceItem.getBigDecimal("unitprice").stripTrailingZeros().toPlainString());
                }
                item.setNum(num.stripTrailingZeros().toPlainString());
            }
            AllEleIssueInvoiceImpl.rewriteSpecialItem(invoice, item);
            items2.add(item);
        }
        issueInvoice.setItems(items2);
        return issueInvoice;
    }

    private static void setShowBankInfo(DynamicObject invoice, AllEleIssueRequestDTO issueInvoice) {
        boolean showSalerBank;
        boolean showBuyerBank;
        boolean bl = showBuyerBank = StringUtils.isNotEmpty((CharSequence)invoice.getString("showbuyerbank")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showbuyerbank")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showbuyerbank");
        if (showBuyerBank) {
            invoice.set("showbuyerbank", (Object)"Y");
            issueInvoice.setShowBuyerCard("Y");
        } else {
            invoice.set("showbuyerbank", (Object)"N");
            issueInvoice.setShowBuyerCard("N");
        }
        boolean bl2 = showSalerBank = StringUtils.isNotEmpty((CharSequence)invoice.getString("showsalerbank")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showsalerbank")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showsalerbank");
        if (showSalerBank) {
            invoice.set("showsalerbank", (Object)"Y");
            issueInvoice.setShowSalerCard("Y");
        } else {
            invoice.set("showsalerbank", (Object)"N");
            issueInvoice.setShowSalerCard("N");
        }
    }

    public static boolean checkShowBank(String showBank) {
        return "true".equalsIgnoreCase(showBank) || "Y".equalsIgnoreCase(showBank);
    }

    private static void setDedutionList(DynamicObject invoice, AllEleIssueRequestDTO issueInvoice) {
        if (!MathUtils.isNullOrZero(issueInvoice.getTotalDeduction())) {
            String deductionRemark = String.format("\u6263\u9664\u989d\uff1a%s\u3002", issueInvoice.getTotalDeduction().setScale(2, 4).stripTrailingZeros().toPlainString());
            issueInvoice.setRemark(issueInvoice.getRemark().replaceAll(deductionRemark, "").replaceFirst(System.lineSeparator(), ""));
        }
        if (issueInvoice.getInvoiceAmount().compareTo(BigDecimal.ZERO) < 0) {
            issueInvoice.setDeductionList(null);
            return;
        }
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(issueInvoice.getDifferenceTaxType())) {
            issueInvoice.setDeductionList(null);
            if (!TaxedTypeEnum.all_e_deduction_full.getValue().equals(issueInvoice.getDifferenceTaxType())) {
                issueInvoice.setDifferenceTaxType("");
            }
            issueInvoice.setTotalDeduction(BigDecimal.ZERO);
            return;
        }
        DynamicObjectCollection deductions = invoice.getDynamicObjectCollection("deductions");
        ArrayList<AllEleIssueDeductionRequestDTO> deductionList = new ArrayList<AllEleIssueDeductionRequestDTO>(deductions.size());
        BigDecimal sumDeduction = BigDecimal.ZERO;
        for (DynamicObject deductionItem : deductions) {
            AllEleIssueDeductionRequestDTO deductionRequest = (AllEleIssueDeductionRequestDTO)((Object)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueDeductionRequestDTO.class, (DynamicObject)deductionItem));
            deductionRequest.setInvoiceDate(DateUtils.format((Date)deductionItem.getDate("invoicedate")));
            deductionList.add(deductionRequest);
            sumDeduction = sumDeduction.add(deductionRequest.getDeduction());
        }
        issueInvoice.setDeductionList(deductionList);
        issueInvoice.setTotalDeduction(sumDeduction);
    }

    private static void replaceAddrAndBank(AllEleIssueRequestDTO issueInvoice) {
        if (StringUtils.isBlank((CharSequence)issueInvoice.getSalerPhone())) {
            Pair salerAddressAndTel = AddressSplitHelper.splitAddressAndTel((String)issueInvoice.getSalerAddress());
            issueInvoice.setSalerAddress((String)salerAddressAndTel.getKey());
            issueInvoice.setSalerPhone((String)salerAddressAndTel.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getSalerCardNumber())) {
            Pair salerBankAndName = AddressSplitHelper.splitBankAndName((String)issueInvoice.getSalerCardName());
            issueInvoice.setSalerCardName((String)salerBankAndName.getKey());
            issueInvoice.setSalerCardNumber((String)salerBankAndName.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getBuyerFixedTelephone())) {
            Pair buyerAddressAndTel = AddressSplitHelper.splitAddressAndTel((String)issueInvoice.getBuyerAddress());
            issueInvoice.setBuyerAddress((String)buyerAddressAndTel.getKey());
            issueInvoice.setBuyerFixedTelephone((String)buyerAddressAndTel.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getBuyerCardNumber())) {
            Pair buyerBankAndName = AddressSplitHelper.splitBankAndName((String)issueInvoice.getBuyerCardName());
            issueInvoice.setBuyerCardName((String)buyerBankAndName.getKey());
            issueInvoice.setBuyerCardNumber((String)buyerBankAndName.getValue());
        }
    }

    private static void buildSpecialType(DynamicObject invoice, AllEleIssueRequestDTO issueInvoice) {
        String specialType = invoice.getString("specialtype");
        DynamicObject simpleAddressObj = invoice.getDynamicObject("simpleaddress");
        String simpleAddress = simpleAddressObj == null ? "" : simpleAddressObj.getString("name");
        issueInvoice.setBusinessType(issueInvoice.getBusinessType().substring(1));
        switch (specialType) {
            case "E03": {
                AllEleIssueBuildInfoRequestDTO build = (AllEleIssueBuildInfoRequestDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueBuildInfoRequestDTO.class, (DynamicObject)invoice);
                build.setSimpleAddress(simpleAddress);
                issueInvoice.setBuildInfo(build);
                break;
            }
            case "E05": {
                DynamicObjectCollection estatesales = new DynamicObjectCollection();
                if (invoice.containsProperty("estatesales")) {
                    estatesales = invoice.getDynamicObjectCollection("estatesales");
                }
                String coBuyerFlag = "0";
                if (invoice.containsProperty("cobuyerflag")) {
                    coBuyerFlag = invoice.getString("cobuyerflag");
                }
                DynamicObjectCollection cobuyers = new DynamicObjectCollection();
                if (invoice.containsProperty("cobuyers")) {
                    cobuyers = invoice.getDynamicObjectCollection("cobuyers");
                }
                ArrayList<AllEleEstateSaleInfoReqeustDTO> estateSaleInfoList = new ArrayList<AllEleEstateSaleInfoReqeustDTO>(estatesales.size());
                if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                    DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoice.getString("originalinvoicecode"), (String)invoice.getString("originalinvoiceno")).toArray());
                    if (CollectionUtils.isEmpty((Collection)estatesales)) {
                        estatesales = blueInvoice.getDynamicObjectCollection("estatesales");
                        coBuyerFlag = blueInvoice.getString("cobuyerflag");
                        cobuyers = blueInvoice.getDynamicObjectCollection("cobuyers");
                    }
                    if (CollectionUtils.isEmpty((Collection)estatesales)) {
                        DynamicObject estatesaleDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice").getDynamicObjectCollection("estatesales").addNew();
                        estatesaleDynamicObject.set("saleestatecode", (Object)blueInvoice.getString("estatecode"));
                        estatesaleDynamicObject.set("onlinecontracteno", (Object)"");
                        estatesaleDynamicObject.set("saleestateid", (Object)blueInvoice.getString("estateid"));
                        DynamicObject blueSimpleAddressObj = invoice.getDynamicObject("simpleaddress");
                        String blueSimpleAddress = blueSimpleAddressObj == null ? "" : blueSimpleAddressObj.getString("name");
                        estatesaleDynamicObject.set("saleprincename", (Object)blueSimpleAddress);
                        estatesaleDynamicObject.set("salecityname", (Object)"");
                        estatesaleDynamicObject.set("saledetailaddress", (Object)blueInvoice.getString("detailaddress"));
                        estatesaleDynamicObject.set("salecrosscitysign", (Object)blueInvoice.getString("crosscitysign"));
                        estatesaleDynamicObject.set("saleunit", (Object)blueInvoice.getString("areaunit"));
                        estatesaleDynamicObject.set("salelandtaxno", (Object)blueInvoice.getString("landtaxno"));
                        estatesaleDynamicObject.set("assessmenttaxamount", (Object)blueInvoice.getString("approvedprice"));
                        estatesaleDynamicObject.set("actualtotalamount", (Object)blueInvoice.getString("actualturnover"));
                        estatesales.add((Object)estatesaleDynamicObject);
                    }
                }
                for (int i = 0; i < estatesales.size(); ++i) {
                    AllEleEstateSaleInfoReqeustDTO estateSale = (AllEleEstateSaleInfoReqeustDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleEstateSaleInfoReqeustDTO.class, (DynamicObject)((DynamicObject)estatesales.get(i)));
                    estateSale.setSimpleAddress(((DynamicObject)estatesales.get(i)).getString("saleprincename") + ((DynamicObject)estatesales.get(i)).getString("salecityname"));
                    if (MathUtils.isNullOrZero(estateSale.getActualTurnover())) {
                        estateSale.setActualTurnover(null);
                    }
                    if (MathUtils.isNullOrZero(estateSale.getApprovedPrice())) {
                        estateSale.setApprovedPrice(null);
                    }
                    estateSaleInfoList.add(estateSale);
                }
                issueInvoice.setEstateSaleInfoList(estateSaleInfoList);
                if (StringUtils.isNotEmpty((CharSequence)coBuyerFlag) && "1".equals(coBuyerFlag)) {
                    issueInvoice.setEstateSaleCoFlag("Y");
                    ArrayList<AllEleEstateSaleCoBuyerInfoReqeustDTO> coPurchasers = new ArrayList<AllEleEstateSaleCoBuyerInfoReqeustDTO>(cobuyers.size());
                    for (int i = 0; i < cobuyers.size(); ++i) {
                        AllEleEstateSaleCoBuyerInfoReqeustDTO coPurchaser = (AllEleEstateSaleCoBuyerInfoReqeustDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleEstateSaleCoBuyerInfoReqeustDTO.class, (DynamicObject)((DynamicObject)cobuyers.get(i)));
                        coPurchasers.add(coPurchaser);
                    }
                    issueInvoice.setEstateSaleCoBuyer(coPurchasers);
                    break;
                }
                issueInvoice.setEstateSaleCoFlag("N");
                issueInvoice.setEstateSaleCoBuyer(null);
                break;
            }
            case "E06": {
                AllEleEstateLeaseInfoRequestDTO estateLease = (AllEleEstateLeaseInfoRequestDTO)DynamicObjectUtil.dynamicObject2Bean(AllEleEstateLeaseInfoRequestDTO.class, (DynamicObject)invoice);
                estateLease.setSimpleAddress(simpleAddress);
                estateLease.setStartLeaseDate(DateUtils.format((Date)invoice.getDate("startleasedate"), (String)"yyyyMMdd"));
                estateLease.setEndLeaseDate(DateUtils.format((Date)invoice.getDate("endleasedate"), (String)"yyyyMMdd"));
                issueInvoice.setEstateLeaseInfo(estateLease);
                break;
            }
            case "E04": {
                DynamicObjectCollection freights = invoice.getDynamicObjectCollection("freights");
                ArrayList<AllEleIssueFreightRequestDTO> freightList = new ArrayList<AllEleIssueFreightRequestDTO>();
                for (DynamicObject freight : freights) {
                    freightList.add((AllEleIssueFreightRequestDTO)((Object)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueFreightRequestDTO.class, (DynamicObject)freight)));
                }
                issueInvoice.setFreightList(freightList);
                break;
            }
            case "02": {
                issueInvoice.setBusinessType(InvoiceSpecialType.InvoiceSpecialTypeEnum.PURCHASE.getLqCode());
                break;
            }
            case "E09": {
                DynamicObjectCollection travelers = invoice.getDynamicObjectCollection("travelers");
                ArrayList<AllEleIssueTravelerRequestDTO> travelerList = new ArrayList<AllEleIssueTravelerRequestDTO>();
                for (DynamicObject traveler : travelers) {
                    AllEleIssueTravelerRequestDTO travellerRequestDTO = (AllEleIssueTravelerRequestDTO)((Object)DynamicObjectUtil.dynamicObject2Bean(AllEleIssueTravelerRequestDTO.class, (DynamicObject)traveler));
                    travellerRequestDTO.setTravelDate(DateUtils.format((Date)traveler.getDate("traveldate"), (String)"yyyy-MM-dd"));
                    travelerList.add(travellerRequestDTO);
                }
                issueInvoice.setTravelerList(travelerList);
                break;
            }
            case "E14": {
                issueInvoice.setBusinessType(InvoiceSpecialType.InvoiceSpecialTypeEnum.ALL_ELE_VEHICLE.getLqCode());
                break;
            }
            case "E07": {
                AllEleVehicleVesselTaxRequestDTO vehicleVesselTax = AllEleIssueInvoiceImpl.createVehicleVesselTaxMethod(invoice);
                issueInvoice.setVehicleVesselTax(vehicleVesselTax);
                String remarkContent = AllEleIssueInvoiceImpl.createVehicleVesselRemarkMethod(vehicleVesselTax);
                issueInvoice.setRemark(remarkContent);
            }
        }
    }

    private static String createVehicleVesselRemarkMethod(AllEleVehicleVesselTaxRequestDTO vehicleVesselTax) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u4fdd\u9669\u5355\u53f7:").append(vehicleVesselTax.getInsuranceNo()).append("\n");
        stringBuilder.append("\u8f66\u724c\u53f7/\u8239\u8236\u767b\u8bb0\u53f7:").append(vehicleVesselTax.getRegisterNo()).append("\n");
        stringBuilder.append("\u7a0e\u6b3e\u6240\u5c5e\u671f:").append(vehicleVesselTax.getTaxPeriod()).append("\n");
        stringBuilder.append("\u8f66\u67b6\u53f7:").append(vehicleVesselTax.getIdentifyNo()).append("\n");
        stringBuilder.append("\u4ee3\u6536\u8f66\u8239\u7a0e\u91d1\u989d:").append(vehicleVesselTax.getAmount()).append("\n");
        stringBuilder.append("\u6ede\u7eb3\u91d1\u91d1\u989d:").append(vehicleVesselTax.getLateFeeAmount()).append("\n");
        stringBuilder.append("\u91d1\u989d\u5408\u8ba1:").append(vehicleVesselTax.getTotalAmount()).append("\n");
        return stringBuilder.toString();
    }

    private static AllEleVehicleVesselTaxRequestDTO createVehicleVesselTaxMethod(DynamicObject invoice) {
        DynamicObjectCollection dynamicObjectCollection = invoice.getDynamicObjectCollection("vehichevesselships");
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return new AllEleVehicleVesselTaxRequestDTO();
        }
        AllEleVehicleVesselTaxRequestDTO vehicleVesselTax = new AllEleVehicleVesselTaxRequestDTO();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            vehicleVesselTax.setInsuranceNo(dynamicObject.getString("policyno"));
            vehicleVesselTax.setRegisterNo(dynamicObject.getString("shipsno"));
            vehicleVesselTax.setTaxPeriod(dynamicObject.getString("perioddate"));
            BigDecimal vehiclevesselamount = dynamicObject.getBigDecimal("vehiclevesselamount");
            String amount = vehiclevesselamount == null ? BigDecimal.ZERO.toString() : vehiclevesselamount.toString();
            vehicleVesselTax.setAmount(new BigDecimal(amount).setScale(2, RoundingMode.HALF_UP).toString());
            BigDecimal vehiclelateamount = dynamicObject.getBigDecimal("vehiclelateamount");
            String lateFeeAmount = vehiclelateamount == null ? BigDecimal.ZERO.toString() : vehiclelateamount.toString();
            vehicleVesselTax.setLateFeeAmount(new BigDecimal(lateFeeAmount).setScale(2, RoundingMode.HALF_UP).toString());
            BigDecimal vehicletotalamount = dynamicObject.getBigDecimal("vehicletotalamount");
            String totalAmount = vehicletotalamount == null ? BigDecimal.ZERO.toString() : vehicletotalamount.toString();
            vehicleVesselTax.setTotalAmount(new BigDecimal(totalAmount).setScale(2, RoundingMode.HALF_UP).toString());
            vehicleVesselTax.setIdentifyNo(dynamicObject.getString("vehiclecode"));
        }
        return vehicleVesselTax;
    }

    private static void rewriteSpecialItem(DynamicObject invoice, AllEleIssueItemRequestDTO item) {
        String specialType;
        switch (specialType = invoice.getString("specialtype")) {
            case "E03": {
                item.setNum("");
                item.setUnitPrice("");
                item.setSpecModel("");
                item.setUnit("");
                break;
            }
            case "E05": {
                item.setSpecModel("");
                item.setUnit("");
                break;
            }
            case "E06": {
                item.setSpecModel("");
                item.setUnit("");
            }
        }
    }
}

