/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.actions.SerializationUtils;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HTXXUtil;
import kd.imc.sim.common.service.issueinvoice.impl.AbstractTGIssueInvoiceImpl;
import org.apache.commons.lang.StringUtils;

public class BwServerIssueInvoiceImpl
extends AbstractTGIssueInvoiceImpl {
    @Override
    public boolean support(DynamicObject invoice) {
        return "8".equals(invoice.getString("issuesource"));
    }

    @Override
    public MsgResponse issue(DynamicObject invoice) {
        MsgResponse msgResponse = new MsgResponse();
        return this.createInvoice(invoice, msgResponse);
    }

    private MsgResponse createInvoice(DynamicObject invoice, MsgResponse msgResponse) {
        try {
            String res;
            this.rewriteInvoice(invoice);
            JSONObject invoiceJSON = new JSONObject();
            DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)invoice, (JSONObject)invoiceJSON);
            try {
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u6d41\u6c34\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u767e\u671b\u670d\u52a1\u5668\u8bf7\u6c42\u5f00\u7968\u6570\u636e:%s", invoice.getString("orderno"), invoice.getString("salertaxno"), SerializationUtils.toJsonString((Object)invoiceJSON)));
                }
                res = HTXXUtil.callIsmcInvoice((JSONObject)invoiceJSON, (String)"BwServerOpenInvoice", (String)"openinvoice");
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u6d41\u6c34\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u767e\u671b\u670d\u52a1\u5668\u5f00\u7968\u8fd4\u56de\u6570\u636e:%s", invoice.getString("orderno"), invoice.getString("salertaxno"), res));
                }
            }
            catch (MsgException e) {
                msgResponse.setErrorCode(e.getErrorCode());
                msgResponse.setErrorMsg(e.getErrorMsg());
                return msgResponse;
            }
            this.handleIssueResponse(res, invoice, msgResponse);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"BwServerIssueInvoiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return msgResponse;
    }

    public void handleIssueResponse(String res, DynamicObject invoice, MsgResponse msgResponse) {
        if (StringUtils.isNotBlank((String)res)) {
            String issueType;
            JSONObject resJson = JSONObject.parseObject((String)res);
            String jqbh = resJson.getString("jqbh");
            if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoice.getString("invoicetype")) && StringUtils.isNotBlank((String)jqbh)) {
                invoice.set("jqbh", (Object)jqbh);
            }
            if ("1".equals(issueType = invoice.getString("issuetype"))) {
                invoice.set("remark", (Object)"");
            }
            invoice.set("fileurl", (Object)resJson.getString("fileurl"));
            msgResponse.setRespData(res);
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            msgResponse.setErrorMsg(ErrorType.SUCCESS.getName());
        } else {
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"BwServerIssueInvoiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
    }
}

