/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.imc.bdm.common.component.ComponentResponseHandler;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.helper.issueinvoice.BuildInvoiceHelper;
import kd.imc.sim.common.service.issueinvoice.IIssueInvoice;

public class ComponentIssueInvoiceImpl
implements IIssueInvoice {
    @Override
    public boolean support(DynamicObject invoice) {
        return true;
    }

    @Override
    public MsgResponse issue(DynamicObject invoice) {
        return this.doComponentRequest(invoice, invoice.getString("orderno"));
    }

    private MsgResponse doComponentRequest(DynamicObject invoiceDynamicObject, String orderNo) {
        ComponentIssueInvoiceImpl.dealWith(invoiceDynamicObject);
        String requestData = BuildInvoiceHelper.buildComponentData(invoiceDynamicObject, orderNo);
        JSONObject jsonObject = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)invoiceDynamicObject.getString("jqbh")), (String)requestData);
        return ComponentResponseHandler.handleComponentIssueInvoiceResponse((JSONObject)jsonObject);
    }

    public static void dealWith(DynamicObject invoiceDynamicObject) {
        String jqbh = invoiceDynamicObject.getString("jqbh");
        String taxno = invoiceDynamicObject.getString("salertaxno");
        String terminalNo = invoiceDynamicObject.getString("terminalno");
        if (StringUtils.isEmpty((String)terminalNo) && "8".equals(invoiceDynamicObject.get("issuesource"))) {
            DynamicObject[] equipmentArr = EquipmentUtil.getEquipmentListByDevNo((String)jqbh, (String)taxno);
            if (equipmentArr != null && equipmentArr.length == 1) {
                invoiceDynamicObject.set("terminalno", (Object)equipmentArr[0].getString("terminalno"));
            } else {
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid"));
                if (orgId == 0L) {
                    orgId = RequestContext.get().getOrgId();
                }
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                invoiceDynamicObject.set("jqbh", (Object)saleInfo.getDefaultDev());
                invoiceDynamicObject.set("terminalno", (Object)saleInfo.getDefaultTerminal());
            }
        } else {
            invoiceDynamicObject.set("terminalno", (Object)"");
        }
    }
}

