/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.GBKUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiVerifyUtil {
    public static final int BUYERNAME_LENGTH = 100;
    public static final int BUYERADDRESSANDTEL_LENGTH = 100;
    public static final int ALL_E_BUYER_ADDR_TEL_LENGTH = 120;
    public static final int BUYERBANKANDACCOUNT_LENGTH = 100;
    public static final int ALL_E_BUYER_BANK_ACCOUNT_LENGTH = 150;
    public static final int SELLERNAME_LENGTH = 100;
    public static final int SELLERADDRESSANDTEL_LENGTH = 100;
    public static final int SELLERBANKANDACCOUNT_LENGTH = 100;
    public static final int REMARK_LENGTH = 230;
    public static final int ALL_E_REMARK_LENGTH = 200;
    public static final int GOODSNAME_LENGTH = 92;
    public static final int GOODSNAME_LENGTH_E = 100;
    public static final int ALL_E_BUILDING_LENGTH = 120;
    public static final int SPE_LIMIT = 40;
    public static final int ALL_E_SPE_LIMIT = 40;
    public static final int UNIT_LIMIT = 22;
    public static final int ALL_E_UNIT_LIMIT = 22;
    public static final int NAME_LIMIT = 16;
    public static final int ALL_E_NAME_LIMIT = 16;
    public static final int LINE_REMARK_LIMIT = 100;
    private static final int LIMIT_100 = 100;
    private static String[] percentTaxRate = new String[]{"0%", "1%", "1.5%", "3%", "4%", "5%", "6%", "9%", "10%", "11%", "13%", "16%", "17%"};
    private static String[] intTaxRate = new String[]{"0", "1", "1.5", "3", "4", "5", "6", "9", "10", "11", "13", "16", "17"};
    private static String[] floatTaxRate = new String[]{"0", "0.01", "0.015", "0.03", "0.04", "0.05", "0.06", "0.09", "0.10", "0.11", "0.13", "0.16", "0.17"};

    public static String[] getPercentTaxRate() {
        return percentTaxRate;
    }

    public static String[] getIntTaxRate() {
        return intTaxRate;
    }

    public static String[] getFloatTaxRate() {
        return floatTaxRate;
    }

    public static boolean checkLength100(String name) {
        return GBKUtils.getGBKLength((String)name) > 100;
    }

    public static String getStandardTaxRateOrOriginalValue(String inputTaxaRate) {
        if (!BigDecimalUtil.isNumber((String)inputTaxaRate)) {
            return inputTaxaRate;
        }
        for (String taxRate : floatTaxRate) {
            if (new BigDecimal(taxRate).compareTo(new BigDecimal(inputTaxaRate)) != 0) continue;
            return taxRate;
        }
        return inputTaxaRate;
    }

    public static Map<String, String> checkAndFillOrgCode(String taxNo, String orgCode, String deviceNo) {
        DynamicObjectCollection orgs;
        QFilter filter;
        HashMap<String, String> rMap = new HashMap<String, String>(4);
        DynamicObject taxEquipment = null;
        if (StringUtils.isNotBlank((CharSequence)deviceNo)) {
            filter = new QFilter("equipmentno", "=", (Object)deviceNo);
            filter.and("authstatus", "=", (Object)"1");
            filter.and("epinfo.number", "=", (Object)taxNo);
            taxEquipment = QueryServiceHelper.queryOne((String)"bdm_tax_equipment", (String)"id", (QFilter[])filter.toArray());
        }
        filter = new QFilter("epinfo.number", "=", (Object)taxNo);
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            filter.and("number", "=", (Object)orgCode);
        } else {
            filter.and("enterprisemainorg", "=", (Object)"1");
        }
        if (null != taxEquipment) {
            filter.and("devlist_tag", "like", (Object)("%" + taxEquipment.get("id") + "%"));
        }
        if (null == (orgs = QueryServiceHelper.query((String)"bdm_org", (String)String.join((CharSequence)",", "id", "number"), (QFilter[])filter.toArray())) || orgs.size() == 0) {
            rMap.put("checkMsg", ResManager.loadKDString((String)"\u7a0e\u53f7\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u4fe1\u606f\u6216\u5f53\u524d\u8bbe\u5907\u672a\u7ed1\u5b9a\u7ec4\u7ec7\uff01", (String)"ApiVerifyUtil_0", (String)"imc-sim-common", (Object[])new Object[0]));
            rMap.put("orgCode", orgCode);
            rMap.put("orgId", "");
            return rMap;
        }
        orgCode = ((DynamicObject)orgs.get(0)).getString("number");
        rMap.put("checkMsg", "");
        rMap.put("orgCode", orgCode);
        rMap.put("orgId", ((DynamicObject)orgs.get(0)).getString("id"));
        return rMap;
    }

    public static String getStandardTaxRate(BigDecimal decimalValue) {
        if (null == decimalValue) {
            return null;
        }
        for (String s : floatTaxRate) {
            if (new BigDecimal(s).compareTo(decimalValue) != 0) continue;
            return s;
        }
        return null;
    }
}

