/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;

public class BillOperationLockUtil {
    private static final Log LOGGER = LogFactory.getLog(BillOperationLockUtil.class);
    public static final String SAVE_INVOICE = "SAVE_INVOICE";
    public static final int TIME_OUT = 600;
    private static final int DEFAULT_TRY_LOCK_TIME = 120;

    public static void unOperationLook(String orgId, List<String> billNos) {
        String traceId = RequestContext.get().getTraceId();
        for (String billNo : billNos) {
            String cacheKey = orgId + "!!!" + billNo;
            String cache = CacheHelper.get((String)cacheKey);
            if (!StringUtils.isNotBlank((CharSequence)cache) || !cache.equals(traceId)) continue;
            CacheHelper.remove((String)cacheKey);
        }
    }

    public static boolean getBillsLock(List<String> billNos, boolean isSaved, long org) {
        LOGGER.info("run getBillsLock");
        HashMap<String, Boolean> billLocks = new HashMap<String, Boolean>(billNos.size());
        try (DLock lock = DLock.create((String)(org + SAVE_INVOICE), (String)SAVE_INVOICE);){
            if (!lock.tryLock(120L)) {
                boolean bl = false;
                return bl;
            }
            String traceId = RequestContext.get().getTraceId();
            for (String billNo : billNos) {
                boolean getLock = true;
                String cacheKey = org + "!!!" + billNo;
                if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
                    getLock = false;
                } else {
                    CacheHelper.put((String)cacheKey, (String)traceId, (int)600);
                }
                billLocks.put(billNo, getLock);
            }
            DynamicObjectCollection bills = BillOperationLockUtil.getBillByBillNos(billNos, org);
            Map<String, String> billConfirmStates = bills.stream().collect(Collectors.toMap(k -> k.getString("billno"), v -> v.getString("confirmstate"), (v1, v2) -> v1));
            for (String billNo : billNos) {
                if (((Boolean)billLocks.get(billNo)).booleanValue()) {
                    String confirmState = billConfirmStates.get(billNo);
                    if (StringUtils.isBlank((CharSequence)confirmState)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u4e0d\u5b58\u5728", (String)"BillOperationLockUtil_2", (String)"imc-sim-common", (Object[])new Object[0]), billNo));
                    }
                    if (isSaved || !"2".equals(confirmState)) continue;
                    LOGGER.info(String.format("\u5355\u636e%s\u72b6\u6001\u5df2\u88ab\u786e\u8ba4", billNo));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7533\u8bf7\u72b6\u6001\u4e3a\u5df2\u7533\u8bf7\uff0c\u65e0\u6cd5\u63d0\u4ea4", (String)"BillOperationLockUtil_0", (String)"imc-sim-common", (Object[])new Object[0]), billNo));
                }
                LOGGER.info("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u5355\u636e\u88ab\u5360\u7528");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u88ab\u5360\u7528", (String)"BillOperationLockUtil_1", (String)"imc-sim-common", (Object[])new Object[0]), billNo));
            }
        }
        return true;
    }

    private static DynamicObjectCollection getBillByBillNos(List<String> billNos, long org) {
        QFilter qFilter = new QFilter("billno", "in", billNos);
        qFilter.and("orgid", "=", (Object)org);
        return QueryServiceHelper.query((String)"sim_original_bill", (String)String.join((CharSequence)",", "confirmstate", "billno"), (QFilter[])qFilter.toArray());
    }
}

