/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.math.BigDecimal;

public class MathUtils {
    public static String formatToNumber(BigDecimal obj) {
        if (obj == null) {
            return "0.00";
        }
        return obj.setScale(2, 4).toPlainString();
    }

    public static boolean isNotZero(BigDecimal sourceBigDecimal) {
        return !MathUtils.isZero(sourceBigDecimal);
    }

    public static boolean isZero(BigDecimal sourceBigDecimal) {
        if (sourceBigDecimal == null) {
            return true;
        }
        return sourceBigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isNullOrZero(BigDecimal sourceBigDecimal) {
        return sourceBigDecimal == null || MathUtils.isZero(sourceBigDecimal);
    }

    public static int getNumberOfDecimalPlace(BigDecimal bigDecimal) {
        String s = bigDecimal.toPlainString();
        int index = s.indexOf(46);
        if (index < 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    public static boolean bigDecimalIsIntegerValue(BigDecimal value) {
        return value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public static boolean bigDecimalIsNegativeValue(BigDecimal value) {
        if (MathUtils.isZero(value)) {
            return true;
        }
        return value.signum() == -1;
    }

    public static BigDecimal notIncludeTaxConvertToHs(BigDecimal notIncludeTaxAmount, BigDecimal taxRateBigDecimal) {
        return notIncludeTaxAmount.multiply(BigDecimal.ONE.add(taxRateBigDecimal));
    }
}

