/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.imc.sim.common.utils.DateUtils;
import kd.imc.sim.common.utils.DigestUtils;

public class SignatureUtils {
    public static Map<String, Object> sign(String appKey, String appSecret, Map<String, Object> signData) {
        String uuid = UUID.randomUUID().toString();
        String nonce = uuid.replaceAll("-", "");
        long timestamp = DateUtils.nowInSeconds();
        String sign = SignatureUtils.sign(appKey, appSecret, nonce, timestamp, signData);
        HashMap<String, Object> signInfoMap = new HashMap<String, Object>();
        signInfoMap.put("sign", sign);
        signInfoMap.put("nonce", nonce);
        signInfoMap.put("appKey", appKey);
        signInfoMap.put("timestamp", timestamp);
        return signInfoMap;
    }

    public static String sign(String appKey, String appSecret, String nonce, long timestamp, Map<String, Object> signData) {
        HashMap<String, Object> newSignData = signData != null ? new HashMap<String, Object>(signData) : new HashMap();
        newSignData.put("appKey", appKey);
        newSignData.put("nonce", nonce);
        newSignData.put("timestamp", timestamp);
        String orderData = SignatureUtils.order(newSignData);
        return DigestUtils.md5(orderData + appSecret);
    }

    public static String order(Map<String, Object> data) {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder stringBuilder = new StringBuilder();
        Object[] keyStrs = keyArray;
        int var5 = keyArray.length;
        for (int i = 0; i < var5; ++i) {
            Object k = keyStrs[i];
            if (((String)k).equals("sign") || data.get(k) == null) continue;
            stringBuilder.append((String)k).append("=").append(data.get(k)).append("&");
        }
        String result = stringBuilder.toString();
        return result.substring(0, result.length() - 1);
    }
}

