/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class UpdateGoodsPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(UpdateGoodsPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        LOGGER.info("updateGoodsPlugin201309192101");
        IDataModel model = this.getModel();
        Object goodscode = model.getValue("goodscode");
        if (null == goodscode) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u7968\u9879", (String)"UpdateGoodsPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject goodsInfo = (DynamicObject)goodscode;
        goodsInfo = BusinessDataServiceHelper.loadSingle((Object)goodsInfo.getPkValue(), (String)"bdm_goods_info");
        String spbm = (String)goodsInfo.get("number");
        DynamicObject taxcode = goodsInfo.getDynamicObject("taxcode");
        String taxcodenumber = goodsInfo.getDynamicObject("taxcode").getString("mergecode");
        String privilegeFlag = goodsInfo.getString("privilegeflag");
        String privilegeType = goodsInfo.getString("privilegetype");
        String simplecodename = goodsInfo.getString("taxcode.simplename");
        DynamicObject[] invoices = this.updateWaitInvoices(spbm, taxcodenumber, privilegeFlag, privilegeType, simplecodename);
        DynamicObject[] bills = this.updateBills(spbm, taxcodenumber, privilegeFlag, privilegeType);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u6570\u91cf\uff1a%1$s,\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u4f46\u6570\u91cf\uff1a%2$s", (String)"UpdateGoodsPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoices.length, bills.length));
    }

    private DynamicObject[] updateBills(String spbm, String taxcodenumber, String privilegeFlag, String privilegeType) {
        DynamicObject[] bills;
        Calendar instance = Calendar.getInstance();
        int defaultMonth = -3;
        String month = ImcConfigUtil.getValue((String)"updateGoodsMonth", (String)"updateGoodsMonth");
        if (StringUtils.isNotBlank((CharSequence)month)) {
            defaultMonth = Integer.parseInt(month);
        }
        instance.set(2, defaultMonth);
        Date time = instance.getTime();
        QFilter dateFilter = new QFilter("createdate", ">=", (Object)time);
        QFilter spbmFilter = new QFilter("sim_original_bill_item.spbm", "=", (Object)spbm);
        QFilter allFilter = dateFilter.and(spbmFilter);
        String billFields = "billno,sim_original_bill_item.policycontants,sim_original_bill_item.policylogo,sim_original_bill_item.goodscode,sim_original_bill_item.spbm";
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)billFields, (QFilter[])allFilter.toArray())) {
            DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject billItem : billItems) {
                if (!spbm.equals(billItem.getString("spbm"))) continue;
                LOGGER.info("enterBillItems," + bill.getString("billno"));
                billItem.set("goodscode", (Object)taxcodenumber);
                billItem.set("policylogo", (Object)privilegeFlag);
                billItem.set("policycontants", (Object)privilegeType);
            }
        }
        if (bills.length > 0) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        return bills;
    }

    private DynamicObject[] updateWaitInvoices(String spbm, String taxcodenumber, String privilegeFlag, String privilegeType, String simplecodename) {
        QFilter filter = new QFilter("items.spbm", "=", (Object)spbm);
        QFilter issueStatusFilter = new QFilter("issuestatus", "in", (Object)new String[]{"2", "3"});
        String field = "id,orderno,items.goodsname,items.taxpremark,items.zzstsgl,items.goodscode,items.spbm";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)field, (QFilter[])filter.and(issueStatusFilter).toArray());
        LOGGER.info("invoiceSize" + invoices.length);
        for (DynamicObject invoice : invoices) {
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                if (!spbm.equals(item.getString("spbm"))) continue;
                LOGGER.info("enterInvoiceItems," + invoice.getString("orderno"));
                item.set("goodscode", (Object)taxcodenumber);
                item.set("taxpremark", (Object)privilegeFlag);
                item.set("zzstsgl", (Object)privilegeType);
                String goodsname = item.getString("goodsname");
                String oriGoodsName = this.getOriGoodsName(goodsname);
                String tGoodsName = "*" + simplecodename + "*" + oriGoodsName;
                item.set("goodsname", (Object)tGoodsName);
            }
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
        return invoices;
    }

    private String getOriGoodsName(String goodsname) {
        StringBuilder replaceBuilder = new StringBuilder();
        int starNum = 0;
        if ('*' == goodsname.charAt(0)) {
            for (int i = 0; i < goodsname.length(); ++i) {
                replaceBuilder.append(goodsname.charAt(i));
                if ('*' == goodsname.charAt(i)) {
                    ++starNum;
                }
                if (2 == starNum) break;
            }
        }
        if (replaceBuilder.length() > 2) {
            return goodsname.replace(replaceBuilder.toString(), "");
        }
        return goodsname;
    }
}

