/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.billsplit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.split.SplitRequestDTO;
import kd.imc.bdm.common.dto.split.SplitResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.billsplit.AbstractHSAmountSplitPlugin;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillSplitHelper;

public class AutoAmountSplitDialogPlugin
extends AbstractHSAmountSplitPlugin {
    private static final Log LOG = LogFactory.getLog(AutoAmountSplitDialogPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String args = (String)customParams.get("requestJson");
        LOG.info("\u81ea\u5b9a\u4e49\u91d1\u989d\u62c6\u5206 Auto requestJson" + args);
        this.getPageCache().put("requestJson", args);
        String cacheBillStr = (String)customParams.get("cacheBill");
        LOG.info("\u81ea\u5b9a\u4e49\u91d1\u989d\u62c6\u5206 Auto cacheBill" + cacheBillStr);
        this.getPageCache().put("cacheBill", cacheBillStr);
        try {
            ArrayList<BigDecimal> splitAmountList = new ArrayList<BigDecimal>();
            JSONObject cacheBillJsonObject = JSON.parseObject((String)cacheBillStr);
            BigDecimal originBillTotalAmount = cacheBillJsonObject.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP);
            this.getPageCache().put("originamount", originBillTotalAmount.toString());
            this.getModel().setValue("totaltaxamount", (Object)originBillTotalAmount);
            BigDecimal hsAmountLimit = AutoAmountSplitDialogPlugin.setLimitAmountToView(this, cacheBillStr, this.getEquipmentLimit(cacheBillJsonObject));
            LOG.info("\u81ea\u52a8\u542b\u7a0e\u62c6\u5206\u542b\u7a0e\u9650\u989d " + hsAmountLimit);
            this.buildSplitAmountList(cacheBillStr, originBillTotalAmount, splitAmountList, hsAmountLimit);
            this.getModel().deleteEntryData("entryentity");
            this.executeSplit(splitAmountList);
        }
        catch (MsgException msgException) {
            this.getView().showErrorNotification(msgException.getErrorMsg());
        }
        catch (Exception e) {
            LOG.error("\u6309\u542b\u7a0e\u91d1\u989d\u81ea\u52a8\u62c6\u5206\u5f02\u5e38", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6309\u542b\u7a0e\u91d1\u989d\u81ea\u52a8\u62c6\u5206\u5f02\u5e38", (String)"AutoAmountSplitDialogPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildSplitAmountList(String cacheBill, BigDecimal originBillTotalAmount, List<BigDecimal> splitAmountList, BigDecimal hsAmountLimit) {
        Map billMap = (Map)SerializationUtils.fromJsonString((String)cacheBill, Map.class);
        DynamicObject originBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        DynamicObjectUtil.map2DynamicObject((Map)billMap, (DynamicObject)originBill);
        DynamicObjectCollection billItems = originBill.getDynamicObjectCollection("sim_original_bill_item");
        boolean numIsInteger = true;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        BigDecimal itemTaxUnitPrice = null;
        BigDecimal numCount = BigDecimal.ZERO;
        for (DynamicObject billItem : billItems) {
            if (MathUtils.isZero((BigDecimal)billItem.getBigDecimal("num")) || !MathUtils.bigDecimalIsIntegerValue((BigDecimal)billItem.getBigDecimal("num"))) {
                numIsInteger = false;
            }
            if (MathUtils.isZero((BigDecimal)billItem.getBigDecimal("taxunitprice")) || !MathUtils.bigDecimalIsIntegerValue((BigDecimal)billItem.getBigDecimal("taxunitprice"))) {
                numIsInteger = false;
            }
            hashSet.add(billItem.getBigDecimal("taxamount").intValue());
            numCount = numCount.add(billItem.getBigDecimal("num"));
            itemTaxUnitPrice = billItem.getBigDecimal("taxunitprice");
        }
        String hsAmountSplitRuleType = HSAmountSplitHelper.getHSAmountSplitRuleType((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)originBill.get("orgid")));
        if (numIsInteger && hashSet.size() == 1 && "2".equals(hsAmountSplitRuleType)) {
            this.getTopHSAmountByIntegerNum(splitAmountList, hsAmountLimit, itemTaxUnitPrice, numCount);
        } else {
            this.getHSAmountSplitList(originBillTotalAmount, splitAmountList, hsAmountLimit);
        }
    }

    private void getTopHSAmountByIntegerNum(List<BigDecimal> splitAmountList, BigDecimal hsAmountLimit, BigDecimal itemTaxUnitPrice, BigDecimal numCount) {
        BigDecimal maxNum = hsAmountLimit.divideToIntegralValue(itemTaxUnitPrice);
        BigDecimal splitTopTaxAmount = maxNum.multiply(itemTaxUnitPrice);
        if (MathUtils.isZero((BigDecimal)maxNum)) {
            throw new MsgException(ResManager.loadKDString((String)"\u9876\u989d\u6570\u91cf\u62c6\u5206\uff0c\u542b\u7a0e\u9650\u989d\u5c0f\u4e8e\u542b\u7a0e\u5355\u4ef7\uff0c\u65e0\u6cd5\u62c6\u5206", (String)"AutoAmountSplitDialogPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        BigDecimal maxSplitCount = numCount.divide(maxNum, 2, RoundingMode.HALF_UP);
        if (!MathUtils.bigDecimalIsIntegerValue((BigDecimal)maxSplitCount)) {
            BigDecimal maxTopCount = numCount.divideToIntegralValue(maxNum);
            BigDecimal endNum = numCount.subtract(maxNum.multiply(maxTopCount));
            for (int i = 0; i < maxTopCount.intValue(); ++i) {
                splitAmountList.add(splitTopTaxAmount);
            }
            splitAmountList.add(endNum.multiply(itemTaxUnitPrice));
        } else {
            for (int i = 0; i < maxSplitCount.intValue(); ++i) {
                splitAmountList.add(splitTopTaxAmount);
            }
        }
    }

    private void getHSAmountSplitList(BigDecimal originBillTotalAmount, List<BigDecimal> amounts, BigDecimal hsAmountLimit) {
        BigDecimal surplusAmount = originBillTotalAmount.subtract(hsAmountLimit);
        if (surplusAmount.divide(hsAmountLimit, 2, RoundingMode.HALF_UP).compareTo(new BigDecimal(1000)) > 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u62c6\u5206\u53d1\u7968\u8d85\u8fc71000\u5f20\uff0c\u5efa\u8bae\u8c03\u6574\u542b\u7a0e\u9650\u989d", (String)"AutoAmountSplitDialogPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        amounts.add(hsAmountLimit);
        if (surplusAmount.compareTo(hsAmountLimit) > 0) {
            this.getHSAmountSplitList(surplusAmount, amounts, hsAmountLimit);
        } else {
            amounts.add(surplusAmount);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("confirm".equals(source.getKey())) {
            String cacheBill = this.getPageCache().get("cacheBill");
            String args = this.getPageCache().get("requestJson");
            JSONObject requestJson = JSON.parseObject((String)args);
            DynamicObject originBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
            JSONObject cacheBillJsonObject = JSON.parseObject((String)cacheBill);
            BigDecimal originBillTotalAmount = cacheBillJsonObject.getBigDecimal("totalamount").setScale(2, RoundingMode.HALF_UP);
            BigDecimal hsAmountLimit = AutoAmountSplitDialogPlugin.getHSAmountLimit(cacheBillJsonObject);
            ArrayList<BigDecimal> splitAmountList = new ArrayList<BigDecimal>();
            try {
                this.buildSplitAmountList(cacheBill, originBillTotalAmount, splitAmountList, hsAmountLimit);
                SplitRequestDTO splitRequestDTO = this.buildSplitRequestDTO(cacheBill, requestJson, originBill, splitAmountList);
                SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)splitRequestDTO);
                if (this.checkDevAmountLimit(splitResponseDTO, originBill.getString("invoicetype"))) {
                    this.sendSplitDataToCustomView(requestJson, originBill, splitResponseDTO);
                }
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            catch (Exception e) {
                LOG.info("\u62c6\u5206\u5f02\u5e38");
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private boolean checkDevAmountLimit(SplitResponseDTO splitResponseDTO, String invoiceType) {
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            return true;
        }
        if (splitResponseDTO.getInvoices().size() > 0 && AllEleAuthHelper.isElePaper((Object)((DynamicObject)splitResponseDTO.getInvoices().get(0)).getString("iselepaper"))) {
            return true;
        }
        BigDecimal limitAmount = new BigDecimal(this.getPageCache().get("limitamount"));
        for (int i = 0; i < splitResponseDTO.getInvoices().size(); ++i) {
            if (((DynamicObject)splitResponseDTO.getInvoices().get(i)).getBigDecimal("invoiceamount").compareTo(limitAmount) <= 0) continue;
            String str = this.getModel().getValue("rowname", i) == null ? "" : (String)this.getModel().getValue("rowname", i);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s \u4e0d\u542b\u7a0e\u91d1\u989d\u8d85\u8fc7\u8bbe\u5907\u9650\u989d\uff0c\u8bf7\u524d\u5f80 '\u57fa\u7840\u8d44\u6599-\u7cfb\u7edf\u53c2\u6570\u8bbe\u7f6e-\u57fa\u7840\u4fe1\u606f\u8bbe\u7f6e' \u8c03\u6574\u542b\u7a0e\u62c6\u5206\u9650\u989d", (String)"AutoAmountSplitDialogPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), str));
            return false;
        }
        return true;
    }

    private void executeSplit(List<BigDecimal> amounts) {
        String billStr = this.getPageCache().get("cacheBill");
        String args = this.getPageCache().get("requestJson");
        JSONObject requestJson = JSON.parseObject((String)args);
        DynamicObject originBill = BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill");
        SplitResponseDTO splitResponseDTO = BillSplitHelper.splitBill((SplitRequestDTO)this.buildSplitRequestDTO(billStr, requestJson, originBill, amounts));
        List returnSplitInvoices = splitResponseDTO.getInvoices();
        if (this.checkDevAmountLimit(splitResponseDTO, originBill.getString("invoicetype"))) {
            this.getModel().batchCreateNewEntryRow("entryentity", returnSplitInvoices.size());
            this.getModel().setValue("rowsizetitle", (Object)String.format(ResManager.loadKDString((String)"\u5171\u62c6\u5206\u4e3a%d\u5f20\u53d1\u7968", (String)"AutoAmountSplitDialogPlugin_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), returnSplitInvoices.size()));
            for (int i = 0; i < returnSplitInvoices.size(); ++i) {
                this.getModel().setValue("rowname", (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968%s", (String)"AutoAmountSplitDialogPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1), i);
                this.getModel().setValue("jshj", (Object)((DynamicObject)returnSplitInvoices.get(i)).getBigDecimal("totalamount"), i);
                this.getModel().setValue("bshje", (Object)((DynamicObject)returnSplitInvoices.get(i)).getBigDecimal("invoiceamount"), i);
                this.getModel().setValue("taxamount", (Object)((DynamicObject)returnSplitInvoices.get(i)).getBigDecimal("totaltax"), i);
            }
        }
    }
}

