/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.bill.BillHelper;
import kd.imc.bdm.common.helper.callback.CallBackLogHelper;
import kd.imc.bdm.common.invoicecallback.impl.FiBotpCallBackServiceImpl;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.sim.common.dto.FillInInvoiceDTO;
import kd.imc.sim.common.dto.FillInInvoiceRequestDTO;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.helper.FillInInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;

public class OperationCancelRelateInvoicePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(OperationCancelRelateInvoicePlugin.class);
    private static final String cancelSuccess = "0";

    public void initialize() {
        this.addClickListeners(new String[]{"docancelrelateinvoice"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label label = (Label)this.getControl("ftitle");
        label.setText((String)parameter.getCustomParam("title"));
        Html content = (Html)this.getControl("fcontent");
        content.setConent((String)parameter.getCustomParam("msg"));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "docancelrelateinvoice": {
                JSONArray pksArr = (JSONArray)this.getView().getFormShowParameter().getCustomParam("listdata");
                List pks = JSONArray.parseArray((String)pksArr.toJSONString(), Long.class);
                this.doCancelRelateInvoice(pks);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u56de\u586b\u53d1\u7968\u6210\u529f", (String)"OperationCancelRelateInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.getView().close();
            }
        }
    }

    public void doCancelRelateInvoice(List<Long> pks) {
        QFilter qFilter = new QFilter("id", "in", (Object)pks.toArray()).and(BillHelper.notCancelFilter());
        DynamicObject[] relateInvoice = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false), (QFilter[])qFilter.toArray());
        HashMap<String, ArrayList<DynamicObject>> fillInSerialNoMap = new HashMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject fillInInv : relateInvoice) {
            String serialNo = fillInInv.getString("serialno");
            ArrayList<DynamicObject> relateList = (ArrayList<DynamicObject>)fillInSerialNoMap.get(serialNo);
            if (null == relateList) {
                relateList = new ArrayList<DynamicObject>();
                fillInSerialNoMap.put(serialNo, relateList);
            }
            relateList.add(fillInInv);
        }
        List billPks = Arrays.stream(relateInvoice).map(e -> e.getLong("originalbillid")).collect(Collectors.toList());
        QFilter qFilterBill = new QFilter("id", "in", (Object)billPks.toArray());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true), (QFilter[])qFilterBill.toArray());
        Map<Long, DynamicObject> billPkMap = Arrays.stream(bills).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        Set invoicePkSet = Arrays.stream(relateInvoice).map(o -> o.getLong("invoiceid")).filter(o -> o != 0L).collect(Collectors.toSet());
        HashMap<String, DynamicObject> invoiceMap = new HashMap<String, DynamicObject>(invoicePkSet.size());
        if (invoicePkSet.size() > 0) {
            DynamicObject[] invoiceArray;
            for (DynamicObject invoice : invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])new QFilter("id", "in", invoicePkSet).toArray())) {
                String key = StringUtils.isBlank((CharSequence)invoice.getString("invoicecode")) ? invoice.getString("invoiceno") : invoice.getString("invoicecode") + invoice.getString("invoiceno");
                invoiceMap.put(key, invoice);
            }
        }
        for (Map.Entry<String, List<DynamicObject>> entry : fillInSerialNoMap.entrySet()) {
            this.cancelOneBatchRelateInvoices(entry, billPkMap, invoiceMap);
        }
        this.invokeBillCenter(bills);
    }

    private void invokeBillCenter(DynamicObject[] originalBillArray) {
        if (originalBillArray == null || originalBillArray.length == 0) {
            LOGGER.error("invokeBillCenter, \u53d6\u6d88\u56de\u586b\u65f6\uff0c\u53cd\u5199\u8d26\u5355\u4e2d\u5fc3\u65f6\u5f00\u7968\u7533\u8bf7\u5355\u5217\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
            return;
        }
        for (DynamicObject originalBillObject : originalBillArray) {
            DynamicObject invoiceObject;
            Long originalId = originalBillObject.getLong("id");
            String systemSource = originalBillObject.getString("systemsource");
            String systemCode = originalBillObject.getString("textfield1");
            LOGGER.info("invokeBillCenter, originalId:{}, systemSource:{}, systemCode:{}", new Object[]{originalId, systemSource, systemCode});
            if (!"BILL_CENTER".equals(systemSource) || !StringUtils.isNotBlank((CharSequence)systemCode)) continue;
            String invoiceNo = originalBillObject.getString("invoiceno");
            String invoiceCode = originalBillObject.getString("invoicecode");
            QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
            if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                qFilter = qFilter.and("invoicecode", "=", (Object)invoiceCode);
            }
            if ((invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (QFilter[])qFilter.toArray())) == null) continue;
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callbackByOpType", (Object[])new Object[]{invoiceObject.getPkValue(), originalId, "callbackByCancel"});
            LOGGER.info("invokeBillCenter, invoiceNo:{}, invoiceCode:{}, \u53d6\u6d88\u56de\u586b\u65f6\uff0c\u56de\u5199\u8d26\u5355\u4e2d\u5fc3\u5b8c\u6210!", (Object)invoiceNo, (Object)invoiceCode);
        }
    }

    private void cancelOneBatchRelateInvoices(Map.Entry<String, List<DynamicObject>> entry, Map<Long, DynamicObject> billPkMap, Map<String, DynamicObject> invoiceMap) {
        FillInInvoiceResponseDTO response;
        boolean isInvRelate;
        List<DynamicObject> callbackLogs = null;
        List<DynamicObject> listRelateInv = entry.getValue();
        DynamicObject fillInInv = listRelateInv.get(0);
        List<DynamicObject> billList = this.getBillList(billPkMap, listRelateInv);
        long billDetailPk = fillInInv.getLong("billdetailid");
        boolean bl = isInvRelate = 0L == billDetailPk;
        if (isInvRelate) {
            FillInInvoiceRequestDTO request = new FillInInvoiceRequestDTO();
            ArrayList<FillInInvoiceDTO> invs = this.getFillInInvoiceDTOS(listRelateInv);
            request.setInvs(invs);
            request.setBills(billList);
            response = FillInInvoiceHelper.fillInvoice((FillInInvoiceRequestDTO)request);
        } else {
            HashMap<String, List> relationMap = new HashMap<String, List>();
            response = new FillInInvoiceResponseDTO();
            response.setRelationMap(relationMap);
            for (DynamicObject dynamicObject : listRelateInv) {
                long billPk = dynamicObject.getLong("originalbillid");
                DynamicObject bill = billPkMap.get(billPk);
                ArBillRelationExtensionDTO dto = FillInInvoiceHelper.getArBillRelationExtensionDTO((DynamicObject)dynamicObject, (DynamicObject)bill);
                String key = StringUtils.isBlank((CharSequence)dynamicObject.getString("invoicecode")) ? dynamicObject.getString("invoiceno") : dynamicObject.getString("invoicecode") + dynamicObject.getString("invoiceno");
                List relations = relationMap.computeIfAbsent(key, k -> new ArrayList());
                relations.add(dto);
            }
        }
        String randomStr = RandomString.nextString((int)3, (boolean)true, (boolean)false);
        String fillInBatchNo = "CancelInv" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + randomStr;
        callbackLogs = this.addLogs(billList, fillInBatchNo, response, invoiceMap);
        IssuedInvoiceWriteBackHelper.fillInInvoiceWriteBack2OriginalBill((DynamicObject[])billList.toArray(new DynamicObject[0]), (FillInInvoiceResponseDTO)response, (String)fillInBatchNo, (boolean)true);
        for (DynamicObject relate : listRelateInv) {
            relate.set("iscancel", (Object)BillRelateInvoicesConstant.IsCancelEnum.YES);
        }
        ImcSaveServiceHelper.update(listRelateInv);
        Object var14_15 = null;
        if (!CollectionUtils.isEmpty(callbackLogs)) {
            Map invoiceNoRelationMap = IssuedInvoiceWriteBackHelper.getInvoiceNoRelationMap((DynamicObject[])billList.toArray(new DynamicObject[0]), (FillInInvoiceResponseDTO)response);
            IssuedInvoiceWriteBackHelper.saveRelation((Map)invoiceNoRelationMap, (String)fillInBatchNo, (String)"4");
            DynamicObject[] dynamicObjectArray = (DynamicObject[])ImcSaveServiceHelper.save(callbackLogs);
            FiBotpCallBackServiceImpl callBackService = new FiBotpCallBackServiceImpl();
            ArrayList<DynamicObject> successlogs = new ArrayList<DynamicObject>();
            for (DynamicObject callbackLog : dynamicObjectArray) {
                CallbackLogVo callbackLogVo = (CallbackLogVo)DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, (DynamicObject)callbackLog);
                callbackLogVo.setBusinessType(OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL_FILL_IN.getCode());
                if (callBackService.support(callbackLogVo)) {
                    String invoiceCode = callbackLogVo.getInvoiceCode();
                    String invoiceNo = callbackLogVo.getInvoiceNo();
                    String key = StringUtils.isBlank((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + invoiceNo;
                    DynamicObject invoice = invoiceMap.get(key);
                    CallbackResponseVo vo = callBackService.callBack(callbackLogVo, invoice);
                    if (!cancelSuccess.equals(vo.getCode())) {
                        if (successlogs.size() > 0) {
                            ImcSaveServiceHelper.update(successlogs);
                        }
                        throw new KDBizException(vo.getMessage());
                    }
                    successlogs.add(callbackLog);
                }
                callbackLog.set("callback_status", (Object)cancelSuccess);
                callbackLog.set("callback_content", (Object)RequestContext.get().getTraceId());
            }
            if (successlogs.size() > 0) {
                ImcSaveServiceHelper.update(successlogs);
            }
        }
        IssuedInvoiceWriteBackHelper.cancelFillInInvoice((DynamicObject[])billList.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.update(billList);
    }

    private List<DynamicObject> addLogs(List<DynamicObject> billList, String fillInBatchNo, FillInInvoiceResponseDTO response, Map<String, DynamicObject> invoiceMap) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(billList.size());
        String systemSource = billList.get(0).getString("systemsource");
        if (!BotpHelper.isFromAr((Object)systemSource)) {
            return logs;
        }
        Map relationMap = response.getRelationMap();
        for (Map.Entry entry : relationMap.entrySet()) {
            String key = (String)entry.getKey();
            DynamicObject invoice = invoiceMap.get(key);
            String businessCode = OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL_FILL_IN.getCode();
            if (null == invoice) continue;
            CallBackProcessVo vo = new CallBackProcessVo(invoice, systemSource, businessCode, null);
            vo.setCallbackno(fillInBatchNo);
            DynamicObject callbackLog = CallBackLogHelper.createCallBackObj((CallBackProcessVo)vo, (String)invoice.getString("issuetype"), (boolean)true);
            if (null == callbackLog) continue;
            callbackLog.set("callbacktype", (Object)CallBackLogTypeEnum.fillin.getValue());
            logs.add(callbackLog);
        }
        return logs;
    }

    private List<DynamicObject> getBillList(Map<Long, DynamicObject> billPkMap, List<DynamicObject> listRelateInv) {
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject row : listRelateInv) {
            long billPk = row.getLong("originalbillid");
            DynamicObject bill = billPkMap.get(billPk);
            if (null == bill) continue;
            billMap.put(billPk, bill);
        }
        return new ArrayList<DynamicObject>(billMap.values());
    }

    private ArrayList<FillInInvoiceDTO> getFillInInvoiceDTOS(List<DynamicObject> listRelateInv) {
        ArrayList<FillInInvoiceDTO> invs = new ArrayList<FillInInvoiceDTO>();
        HashSet<String> invoiceNoSet = new HashSet<String>();
        for (DynamicObject row : listRelateInv) {
            FillInInvoiceDTO fillInvDto = FillInInvoiceHelper.getFillInInvoiceDTO((DynamicObject)row);
            if (invoiceNoSet.contains(fillInvDto.getInvoiceNo())) continue;
            invoiceNoSet.add(fillInvDto.getInvoiceNo());
            invs.add(fillInvDto);
        }
        return invs;
    }
}

