/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.schedule.redconfirm.RedConfirmBillDownloadTask;
import org.apache.commons.collections.CollectionUtils;

public class RedConfirmCheckPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
F7SelectedListRemoveListener,
SearchEnterListener {
    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(new String[]{"cancel", "download", "confirm"});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "download": {
                Map params = this.getView().getFormShowParameter().getCustomParams();
                HashMap<String, Long> map = new HashMap<String, Long>(4);
                map.put("org", Long.parseLong(String.valueOf(params.get("org"))));
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d", (String)"RedConfirmCheckPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), map, (String)"sim_red_confirm_bill_down", (String)"sim_red_confirm_bill_down");
                break;
            }
            case "confirm": {
                BillList billlist = (BillList)this.getView().getControl("billlistap");
                ArrayList numbers = Lists.newArrayListWithCapacity((int)0);
                for (ListSelectedRow selectedRow : billlist.getSelectedRows()) {
                    numbers.add(selectedRow.getNumber());
                }
                this.getView().returnDataToParent((Object)numbers);
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        QFilter filter = this.getCommonQFilter();
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refreshData();
    }

    private QFilter getCommonQFilter() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        QFilter occupyFilter = new QFilter("occupystatus", "!=", (Object)"1");
        Object buyerName = params.get("buyername");
        Object buyerTaxNo = params.get("buyertaxno");
        Object salerTaxNo = params.get("salertaxno");
        if (StringUtils.isNotBlank(buyerTaxNo)) {
            occupyFilter.and("buyertaxno", "=", buyerTaxNo);
        } else if (StringUtils.isNotBlank(buyerName)) {
            occupyFilter.and("buyername", "=", buyerName);
        }
        QFilter salerFilter = new QFilter("salertaxno", "=", salerTaxNo);
        QFilter issueFilter = new QFilter("issuestatus", "not in", (Object)new String[]{"0", "1"});
        QFilter statusFilter = new QFilter("confirmstatus", "in", (Object)new String[]{"01", "02", "03", "04"});
        QFilter uploadFilter = new QFilter("uploadstatus", "=", (Object)"1");
        return occupyFilter.and(issueFilter).and(salerFilter).and(statusFilter).and(uploadFilter);
    }

    public void afterBindData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("infocode").toString().matches("^[\\[\\]\\\"]*$")) {
            return;
        }
        Object infoNumbers = params.get("infocode");
        if (StringUtils.isNotBlank(infoNumbers)) {
            JSONArray array = JSONArray.parseArray((String)infoNumbers.toString());
            F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
            ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
            HashSet<String> pkSet = new HashSet<String>();
            for (Object pks : array) {
                String pkStr = pks.toString();
                ValueTextItem item = new ValueTextItem(pkStr, null);
                items.add(item);
                pkSet.add(pkStr);
            }
            selectedList.addItems(items);
            this.getView().updateView("f7selectedlistap");
            BillList billList = (BillList)this.getControl("billlistap");
            DynamicObjectCollection collection = billList.getListModel().getQueryResult().getCollection();
            ArrayList<Integer> selectRowList = new ArrayList<Integer>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject obj = (DynamicObject)collection.get(i);
                if (!pkSet.contains(String.valueOf(obj.getString("number")))) continue;
                selectRowList.add(i);
            }
            if (selectRowList.size() != 0) {
                billList.selectRows(selectRowList.stream().mapToInt(Integer::valueOf).toArray());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        switch (actionId) {
            case "sim_red_confirm_bill_down": {
                AllEleRedConfirmDownLoadRequestDTO request = (AllEleRedConfirmDownLoadRequestDTO)closedCallBackEvent.getReturnData();
                new RedConfirmBillDownloadTask().formDispatchTask(this, request, ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0b\u8f7d", (String)"RedConfirmCheckPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
                break;
            }
            case "dispatchTask": {
                TaskInfo taskInfo;
                Map result = (Map)returnData;
                String taskInfoStr = (String)result.get("taskinfo");
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taskInfoStr) || !(taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)taskInfo.getData())) break;
                Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                Boolean success = (Boolean)data.get("success");
                if (success.booleanValue()) {
                    this.getView().showSuccessNotification((String)data.get("errMsg"), Integer.valueOf(6000));
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showErrorNotification((String)data.get("errMsg"));
            }
        }
    }

    public void search(SearchEnterEvent enterEvent) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(this.getCommonQFilter());
        List searchFields = enterEvent.getSearchFields();
        if (CollectionUtils.isNotEmpty((Collection)searchFields)) {
            for (Map search : searchFields) {
                List fieldNames = (List)search.get("fieldName");
                List values = (List)search.get("value");
                QFilter filter = null;
                for (String fieldName : fieldNames) {
                    for (String value : values) {
                        if (filter == null) {
                            filter = new QFilter(fieldName, "ftlike", (Object)("%" + value + "%"));
                            continue;
                        }
                        filter.or(fieldName, "ftlike", (Object)("%" + value + "%"));
                    }
                }
                filters.add(filter);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setQFilters(filters);
        billList.setFilterParameter(fp);
        billList.refreshData();
    }

    public void listRowClick(ListRowClickEvent evt) {
        F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        ListSelectedRowCollection col = evt.getListSelectedRowCollection();
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>();
        for (ListSelectedRow row : col) {
            ValueTextItem item = new ValueTextItem(String.valueOf(row.getPrimaryKeyValue()), row.getNumber());
            items.add(item);
        }
        selectedList.addItems(items);
        this.getView().updateView("f7selectedlistap");
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        String param = (String)f7SelectedListRemoveEvent.getParam();
        BillList billList = (BillList)this.getControl("billlistap");
        if (StringUtils.isBlank((CharSequence)param)) {
            billList.clearSelection();
            return;
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        selectedRows.removeIf(row -> Objects.equal((Object)row.getPrimaryKeyValue().toString(), (Object)param));
        if (selectedRows.size() == 0) {
            billList.clearSelection();
        } else {
            billList.restoreSelection(selectedRows);
        }
    }
}

