/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.callback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.annotation.CallBackAnnotation;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CallBackEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EasBusinessHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.OriginalBillWithdrawHelper;
import kd.imc.sim.formplugin.bill.originalbill.InvoiceOriginalBillPlugin;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.issuing.invalid.InvalidInvoiceControl;

public class InvoiceOriginalBillCallBack {
    @CallBackAnnotation(value={"btn_bill_withdraw"}, callback=CallBackEnum.CONFIRM)
    public void billWithDrawConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            OriginalBillWithdrawHelper.notice2BusSys((AbstractListPlugin)((AbstractListPlugin)that));
        }
    }

    @CallBackAnnotation(value={"bill_issuepush_check_remark"}, callback=CallBackEnum.CONFIRM)
    public void billIssuePushCheckSpecialCodeRemarkConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
            HashSet typeSet = Sets.newHashSet();
            typeSet.add(that.getPageCache().get("select_bill_issyetype"));
            BillHelper.issuePushBill((AbstractFormPlugin)that, (Object[])rows.getPrimaryKeyValues(), (HashSet)typeSet);
        } else {
            that.getPageCache().remove("select_bill_issyetype");
        }
    }

    @CallBackAnnotation(value={"bill_preview_check_remark"}, callback=CallBackEnum.CONFIRM)
    public void billPreviewCheckSpecialCodeRemarkConfirmCallBack(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            InvoiceOriginalBillPlugin invoiceOriginalBillPlugin = (InvoiceOriginalBillPlugin)that;
            ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            invoiceOriginalBillPlugin.billProcessPreView(bills);
        }
    }

    @CallBackAnnotation(value={"btn_clickopeninvoice"}, callback=CallBackEnum.CLOSED)
    public void issuePushClosedCallBack(AbstractFormPlugin that, ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        OriginalBillPluginIssueControl.issuePush((AbstractFormPlugin)that, (Object[])rows.getPrimaryKeyValues(), (Map)returnData);
    }

    @CallBackAnnotation(value={"sim_ori_preview"}, callback=CallBackEnum.CLOSED)
    public void billProcessPrevies(AbstractFormPlugin that, ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        InvoiceOriginalBillPlugin invoiceOriginalBillPlugin = (InvoiceOriginalBillPlugin)that;
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        returnData.put("step", "preview");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        invoiceOriginalBillPlugin.openWorkBench(that, bills, returnData);
    }

    @CallBackAnnotation(value={"quick_issue"}, callback=CallBackEnum.CLOSED)
    public void quickIssue(AbstractFormPlugin that, ClosedCallBackEvent event) {
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"addrelateinvoice"}, callback=CallBackEnum.CLOSED)
    public void addRelateInvoice(AbstractFormPlugin that, ClosedCallBackEvent event) {
        BillList billList = (BillList)that.getView().getControl("billlistap");
        billList.refresh();
        this.refreshList(that);
        Object returnData = event.getReturnData();
        if ("SUCCESS".equals(returnData)) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u586b\u53d1\u7968\u6210\u529f", (String)"InvoiceOriginalBillCallBack_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    @CallBackAnnotation(value={"sim_original_bill_import"}, callback=CallBackEnum.CLOSED)
    public void importClosedCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        if (event.getReturnData() != null) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff01", (String)"InvoiceOriginalBillCallBack_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"sim_original_invs_preview"}, callback=CallBackEnum.CLOSED)
    public void invoicePreviewCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        if (event.getReturnData() != null) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"InvoiceOriginalBillCallBack_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.refreshList(that);
        }
    }

    @CallBackAnnotation(value={"sim_bill_process", "sim_alle_bill_process"}, callback=CallBackEnum.CLOSED)
    public void billProcessCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        BillList list = (BillList)that.getView().getControl("billlistap");
        BillHelper.clearWorkbench((ListSelectedRowCollection)list.getSelectedRows());
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"sim_split_process"}, callback=CallBackEnum.CLOSED)
    public void billSplitProcessCallback(AbstractFormPlugin that, ClosedCallBackEvent event) {
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"msg_inv_abolish"}, callback=CallBackEnum.CLOSED)
    public void closeCancelInvoice(AbstractFormPlugin that, ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData != null && "msg_inv_abolish".equals(event.getActionId())) {
            InvalidInvoiceControl.handlerInvalidSuccessOrErrorReturn((AbstractFormPlugin)that, (Object)returnData);
        }
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"sim_cancel_relate_invoice_callkey"}, callback=CallBackEnum.CLOSED)
    public void cancelRelateInvoiceCallBack(AbstractFormPlugin that, ClosedCallBackEvent event) {
        this.refreshList(that);
    }

    @CallBackAnnotation(value={"isNotExsit"}, callback=CallBackEnum.CONFIRM)
    public void issusContinue(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            HashSet typeSet = Sets.newHashSet();
            typeSet.add("-1");
            BillHelper.checkIssuePushSpecialCodeRemark((AbstractFormPlugin)that, (DynamicObject[])dynamicObjects, (HashSet)typeSet);
        } else {
            that.getPageCache().remove("select_bill_issyetype");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallBackAnnotation(value={"closeBills"}, callback=CallBackEnum.CONFIRM)
    public void closeBills(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        JSONArray array = new JSONArray();
        for (DynamicObject originalBill : dynamicObjects) {
            array.add((Object)originalBill.getString("billno"));
        }
        try {
            if (event.getResult() == MessageBoxResult.Yes) {
                BotpHelper.closeBills((DynamicObject[])dynamicObjects);
                that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f", (String)"InvoiceOriginalBillCallBack_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.refreshList(that);
            }
        }
        finally {
            for (Object o : array) {
                CacheHelper.remove((String)("closestatus" + o));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallBackAnnotation(value={"closeEASBills"}, callback=CallBackEnum.CONFIRM)
    public void closeEasBills(AbstractFormPlugin that, MessageBoxClosedEvent event) {
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        List<String> billNos = Arrays.stream(bills).map(o -> o.getString("billno")).collect(Collectors.toList());
        try {
            if (event.getResult() != MessageBoxResult.Yes) {
                return;
            }
            String systemSource = bills[0].getString("systemsource");
            DynamicObject accessConfigObj = CallbackHelperUtil.getAccessConfig((String)systemSource);
            if (null == accessConfigObj) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5728[\u53d1\u7968\u4e91]-[\u7cfb\u7edf\u7ba1\u7406]-[\u4e1a\u52a1\u7cfb\u7edf]\u914d\u7f6e\u597d\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]", (String)"InvoiceOriginalBillCallBack_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), systemSource));
            }
            String param = EasBusinessHelper.getEasRequestData((String)JSONObject.toJSONString(billNos), (String)"closeEASBills");
            QFilter systemSourceFilter = new QFilter("business_system_code", "=", (Object)systemSource);
            DynamicObject callBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_callback_config"), (QFilter[])systemSourceFilter.toArray());
            String result = CallbackHelperUtil.postEas((DynamicObject)callBackConfig, (String)param, (String)systemSource);
            if (StringUtils.isEmpty((CharSequence)result)) {
                that.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[eas\u5355\u636e\u5173\u95ed\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a]", (String)"InvoiceOriginalBillCallBack_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (!ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("errCode"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25 %s", (String)"InvoiceOriginalBillCallBack_8", (String)"imc-sim-formplugin", (Object[])new Object[0]), jsonObject.getString("description")));
            }
            EasBusinessHelper.handleEasResponse((JSONObject)jsonObject);
            if (ApiErrCodeEnum.OK.getCode().equals(jsonObject.getString("errorCode"))) {
                Arrays.stream(bills).forEach(o -> o.set("closestatus", (Object)"1"));
                SaveServiceHelper.update((DynamicObject[])bills);
                that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f", (String)"InvoiceOriginalBillCallBack_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.refreshList(that);
                return;
            }
            that.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[eas\u5355\u636e\u5173\u95ed\u5931\u8d25]%s", (String)"InvoiceOriginalBillCallBack_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), jsonObject.getString("message")));
        }
        finally {
            billNos.forEach(o -> CacheHelper.remove((String)("closestatus" + o)));
        }
    }

    @CallBackAnnotation(value={"sim_origin_select"}, callback=CallBackEnum.CLOSED)
    public void selectInvoiceCallBack(AbstractFormPlugin that, ClosedCallBackEvent event) {
        Map param = (Map)event.getReturnData();
        if (Objects.nonNull(param)) {
            ViewUtil.openDialog((AbstractFormPlugin)that, (Map)param, (String)"sim_bill_process_reverse", (String)"sim_bill_process_reverse");
        }
    }

    @CallBackAnnotation(value={"sim_bill_process_reverse"}, callback=CallBackEnum.CLOSED)
    public void reverseWorkbenchClose(AbstractFormPlugin that, ClosedCallBackEvent event) {
        this.refreshList(that);
    }

    private void refreshList(AbstractFormPlugin that) {
        BillList billList = (BillList)that.getView().getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }
}

