/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.op;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.OriginalBillHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceOriginalBillAuditPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_original_bill"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] arr = e.getDataEntities();
        if (arr == null || arr.length == 0) {
            return;
        }
        HashMap billStatusMap = null;
        for (DynamicObject dynamicObject : arr) {
            if (!BotpHelper.isFromAr((Object)dynamicObject.getString("systemsource"))) continue;
            billStatusMap = BotpHelper.checkCloseStatusClosed((DynamicObject[])arr, billStatusMap, (DynamicObject)dynamicObject);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            bill.set("comprehensivestatus", (Object)"01");
        }
        ImcSaveServiceHelper.update((DynamicObject[])bills);
        RequestContext context = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"reverse_bill_change_status", () -> {
            RequestContext.copyAndSet((RequestContext)context);
            InvoiceOriginalBillAuditPlugin.changeTrackDownBillStatus(bills, BillStatusEnum.NO_APPROVAL_REQUIRED);
        });
    }

    public static void changeTrackDownBillStatus(DynamicObject[] bills, BillStatusEnum billStatus) {
        DynamicObject[] invoices;
        ArrayList<Pair> invalidBill = new ArrayList<Pair>(bills.length);
        for (DynamicObject bill : bills) {
            String billSourceType = bill.getString("billsourcetype");
            if (!"C".equals(billSourceType)) continue;
            invalidBill.add(Pair.of((Object)bill.getString("invoicecode"), (Object)bill.getString("invoiceno")));
        }
        if (!CollectionUtils.isEmpty(invalidBill) && (invoices = OriginalBillHelper.queryInvoice(invalidBill)).length != 0) {
            for (DynamicObject invoice : invoices) {
                if (BillStatusEnum.AUDIT_SUCCESS.getCode().equals(invoice.getString("billstatus"))) continue;
                invoice.set("billstatus", (Object)billStatus.getCode());
            }
            ImcSaveServiceHelper.update((DynamicObject[])invoices);
        }
    }
}

