/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.originalbill.workbench;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.PrintInvoiceDTO;
import kd.imc.sim.common.dto.bill.workbench.WorkbenchPrintInvoiceDTO;
import kd.imc.sim.common.dto.bill.workbench.WorkbenchPrintInvoiceGroupDTO;
import kd.imc.sim.common.helper.PaperPrintHelper;
import kd.imc.sim.formplugin.issuing.paperprint.control.PrintInvoiceControl;

public class InvPrintTipPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(InvPrintTipPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap", "printnumflex"});
        WorkbenchPrintInvoiceGroupDTO normalPaper = this.getPrintGroupByInvoiceType(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
        WorkbenchPrintInvoiceGroupDTO specialPaper = this.getPrintGroupByInvoiceType(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
        if (normalPaper == null && specialPaper == null) {
            return;
        }
        if (normalPaper != null && specialPaper != null) {
            this.multiplePrint(normalPaper, specialPaper);
            return;
        }
        if (normalPaper != null && !CollectionUtils.isEmpty((Collection)normalPaper.getList())) {
            this.setInfo(String.format(ResManager.loadKDString((String)"\u5373\u5c06\u6253\u5370\u7eb8\u8d28\u666e\u7968\uff0c\u8bf7\u786e\u8ba4\u6253\u5370\u4e0a\u5f53\u524d\u7684\u53d1\u7968\u53f7\u7801\u4e3a%s\u3002", (String)"InvPrintTipPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getInvoiceNo(normalPaper)), normalPaper, null);
        }
        if (specialPaper != null && !CollectionUtils.isEmpty((Collection)specialPaper.getList())) {
            this.setInfo(String.format(ResManager.loadKDString((String)"\u5373\u5c06\u6253\u5370\u7eb8\u8d28\u4e13\u7968\uff0c\u8bf7\u786e\u8ba4\u6253\u5370\u4e0a\u5f53\u524d\u7684\u53d1\u7968\u53f7\u7801\u4e3a%s\u3002", (String)"InvPrintTipPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]), this.getInvoiceNo(specialPaper)), null, specialPaper);
        }
    }

    public void registerListener(EventObject e) {
        Button btnOk = (Button)this.getView().getControl("btnok");
        Button btncancel = (Button)this.getView().getControl("btncancel");
        btnOk.addClickListener((ClickListener)this);
        btncancel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btncancel".equals(control.getKey())) {
            this.getView().returnDataToParent((Object)"InvPrintTipCancel");
            this.getView().close();
            return;
        }
        if (!"btnok".equals(control.getKey())) {
            return;
        }
        Object mark = this.getModel().getValue("page_use_mark");
        if ("detailList".equals(mark)) {
            JSONArray printGroupJson = (JSONArray)this.getView().getFormShowParameter().getCustomParam("detailInvoiceList");
            if (printGroupJson == null) {
                return;
            }
            int printnum = ((BigDecimal)this.getModel().getValue("printnum")).intValue();
            CacheHelper.put((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()), (String)String.valueOf(printnum), (int)604800);
            List detailInvoiceList = JSONArray.parseArray((String)printGroupJson.toJSONString(), WorkbenchPrintInvoiceDTO.class);
            if (!CollectionUtils.isEmpty((Collection)detailInvoiceList)) {
                String printerName = (String)this.getModel().getValue("printerselect");
                this.syncExecPrint(detailInvoiceList, printerName, "1", printnum);
            }
            return;
        }
        if (StringUtils.isBlank((Object)mark)) {
            String invType = (String)this.getModel().getValue("invoicetyperadio");
            String printerName = (String)this.getModel().getValue("printerselect");
            WorkbenchPrintInvoiceGroupDTO printGroup = this.getPrintGroupByInvoiceType(invType);
            if (null == printGroup || CollectionUtils.isEmpty((Collection)printGroup.getList())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u5f02\u5e38,\u8bf7\u5237\u65b0\u91cd\u8bd5!", (String)"InvPrintTipPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            List printInvoiceList = printGroup.getList();
            if (printInvoiceList.size() == 1) {
                this.syncExecPrint((List)printInvoiceList.get(0), printerName, "0", 1);
            } else if (printInvoiceList.size() > 1) {
                this.syncExecPrint((List)printInvoiceList.get(0), printerName, "0", 1);
                if (!CollectionUtils.isEmpty((Collection)printInvoiceList)) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u672c\u6279\u6b21\u53d1\u7968\u7684\u7968\u53f7\u4e0d\u8fde\u53f7\uff0c\u8bf7\u5173\u6ce8\u6253\u5370\u8fdb\u5ea6\u5e76\u53ca\u65f6\u66f4\u6362\u53d1\u7968\u7eb8\u3002%1$s\u5373\u5c06\u6253\u5370\u7eb8\u8d28\u666e\u7968\uff0c\u8bf7\u786e\u8ba4\u6253\u5370\u4e0a\u7684\u5f53\u524d\u53d1\u7968\u53f7\u7801\u4e3a%2$s\u3002", (String)"InvPrintTipPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), "\n\t", ((WorkbenchPrintInvoiceDTO)((List)printInvoiceList.get(0)).get(0)).getInvoiceNo());
                    this.setContinuePrintingInfo(tipMsg, "0");
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("sim_inv_print_ok_callback".equals(actionId)) {
            this.getView().close();
            return;
        }
        if ("sim_inv_print_progress_callback".equals(actionId)) {
            Map rMap = (Map)closedCallBackEvent.getReturnData();
            if (null == rMap) {
                return;
            }
            boolean printFlag = (Boolean)rMap.get("printFlag");
            String printType = (String)rMap.get("printType");
            String invType = (String)rMap.get("invType");
            if ("0".equals(printType)) {
                this.dealPrintFinish(invType, printFlag);
                return;
            }
            if (printFlag && "1".equals(printType)) {
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_inv_print_ok", (String)"sim_inv_print_ok_callback");
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e05\u5355\u6253\u5370\u5931\u8d25", (String)"InvPrintTipPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void dealPrintFinish(String invType, boolean printFlag) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        WorkbenchPrintInvoiceGroupDTO printGroup = this.getPrintGroupByInvoiceType(invType);
        if (printGroup != null) {
            List list = printGroup.getList();
            if (CollectionUtils.isEmpty((Collection)list) || list.size() == 1) {
                printGroup = null;
            } else {
                list.remove(0);
            }
        }
        map.put(invType, printGroup);
        WorkbenchPrintInvoiceGroupDTO otherPrintGroup = this.getPrintGroupByInvoiceType(invType.equals(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()) ? InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode() : InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
        if (printGroup != null || otherPrintGroup != null) {
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
            return;
        }
        List detailInvoiceList = (List)this.getView().getFormShowParameter().getCustomParam("detailInvoiceList");
        if (CollectionUtils.isEmpty((Collection)detailInvoiceList) && printFlag) {
            ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_inv_print_ok", (String)"sim_inv_print_ok_callback");
            return;
        }
        String tips = ResManager.loadKDString((String)"\u672c\u6279\u6b21\u53d1\u7968\u5305\u542b\u6e05\u5355\uff0c\u662f\u5426\u6253\u5370\u6e05\u5355\uff1f", (String)"InvPrintTipPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("page_use_mark", (Object)"detailList");
        this.getView().setVisible(Boolean.TRUE, new String[]{"printnumflex"});
        String printnum = CacheHelper.get((String)("detail_print_num" + RequestContext.get().getOrgId() + RequestContext.get().getUserId()));
        if (StringUtils.isNotBlank((CharSequence)printnum)) {
            this.getModel().setValue("printnum", (Object)Integer.parseInt(printnum));
        }
        this.setContinuePrintingInfo(tips, "1");
    }

    private void multiplePrint(WorkbenchPrintInvoiceGroupDTO normalPaper, WorkbenchPrintInvoiceGroupDTO specialPaper) {
        String tipMsg = ResManager.loadKDString((String)"\u672c\u6279\u6b21\u5f00\u7968\u5305\u542b\u7eb8\u8d28\u4e13\u7968\u548c\u7eb8\u8d28\u666e\u7968\uff0c\u8bf7\u9009\u62e9\u5148\u6253\u5370\u7684\u53d1\u7968\u7c7b\u578b\uff0c\u5e76\u786e\u8ba4\u6253\u5370\u673a\u4e0a\u7684\u53d1\u7968\u53f7\u7801\u548c\u4e0b\u5217\u53d1\u7968\u53f7\u4e00\u81f4\uff1a", (String)"InvPrintTipPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        this.setInfo(tipMsg, normalPaper, specialPaper);
    }

    private void setInfo(String tipDes, WorkbenchPrintInvoiceGroupDTO normalPaper, WorkbenchPrintInvoiceGroupDTO specialPaper) {
        String specialInvNo;
        this.getModel().setValue("tips_des", (Object)tipDes);
        this.getModel().setValue("invoicetyperadio", (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
        String normalInvNo = this.getInvoiceNo(normalPaper);
        if (StringUtils.isBlank((CharSequence)normalInvNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"normal_invoice_flex"});
            this.getModel().setValue("invoicetyperadio", (Object)InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
        }
        if (StringUtils.isBlank((CharSequence)(specialInvNo = this.getInvoiceNo(specialPaper)))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"special_invoice_flex"});
            this.getModel().setValue("invoicetyperadio", (Object)InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
        }
        ViewUtil.setLabelViewData((IFormView)this.getView(), (String)"normal_inv_no", (String)String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u53f7\u7801:%1$s (\u672c\u6b21\u5171\u6253\u5370\u666e\u7968%2$s\u5f20)", (String)"InvPrintTipPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]), normalInvNo, null != normalPaper ? ((List)normalPaper.getList().get(0)).size() : 0));
        ViewUtil.setLabelViewData((IFormView)this.getView(), (String)"special_inv_no", (String)String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u53f7\u7801:%1$s (\u672c\u6b21\u5171\u6253\u5370\u4e13\u7968%2$s\u5f20)", (String)"InvPrintTipPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]), specialInvNo, null != specialPaper ? ((List)specialPaper.getList().get(0)).size() : 0));
        JSONObject json = this.getPrintMachineFromServer();
        this.setPrintMachine(json, "0");
    }

    private String getInvoiceNo(WorkbenchPrintInvoiceGroupDTO invoiceDTO) {
        if (null == invoiceDTO) {
            return "";
        }
        String firstNo = ((WorkbenchPrintInvoiceDTO)((List)invoiceDTO.getList().get(0)).get(0)).getInvoiceNo();
        return StringUtils.isBlank((CharSequence)firstNo) ? "" : firstNo;
    }

    private void setContinuePrintingInfo(String tips, String printType) {
        this.getModel().setValue("tips_des", (Object)tips);
        JSONObject printMachineJson = this.getPrintMachineFromServer();
        if (null != printMachineJson) {
            this.setPrintMachine(printMachineJson, printType);
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoicetypeflex"});
        }
    }

    private void setPrintMachine(JSONObject json, String printType) {
        JSONObject machineObj = json.getJSONObject("sjd");
        JSONArray otherPrintMachine = machineObj.getJSONArray("printers");
        String cachePrintNameKey = PrintInvoiceControl.getPrinterNameCacheKey((String)("0".equals(printType) ? PrintTypeEnum.INVOICE_PRINT.getType() : PrintTypeEnum.QD_PRINT.getType()), (String)((String)this.getView().getFormShowParameter().getCustomParam("jqbh")));
        String defaultMachine = PrintInvoiceControl.getPrintName((String)machineObj.getString("default_printer"), (String)CacheHelper.get((String)cachePrintNameKey), (JSONArray)otherPrintMachine);
        ArrayList data = Lists.newArrayList();
        if (!otherPrintMachine.isEmpty()) {
            for (Object o : otherPrintMachine) {
                String machineName = JSONObject.parseObject((String)o.toString()).getString("name");
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(machineName));
                item.setValue(machineName);
                item.setImageKey(machineName);
                data.add(item);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("printerselect");
        comboEdit.setComboItems((List)data);
        defaultMachine = StringUtils.isBlank((CharSequence)defaultMachine) ? ((ComboItem)data.get(0)).getValue() : defaultMachine;
        this.getModel().setValue("printerselect", (Object)defaultMachine);
    }

    private JSONObject getPrintMachineFromServer() {
        String cacheStr = this.getPageCache().get(this.getView().getPageId() + "machine");
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            return JSON.parseObject((String)cacheStr);
        }
        String remoteUrl = ComponentServiceHelper.getComponentRequestUrl((String)((String)this.getView().getFormShowParameter().getCustomParam("jqbh")));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5f00\u7968\u5de5\u4f5c\u53f0\u83b7\u53d6\u53d1\u7968\u6253\u5370\u673a\u5217\u8868\u8bf7\u6c42URL\uff1a%s", remoteUrl));
        }
        JSONObject reqData = new JSONObject();
        reqData.put("czlx", (Object)ComponentInterfaceTypeEnum.GETPRINTINFO.getCzlx());
        reqData.put("hxbzdh", (Object)"");
        JSONObject json = ComponentServiceHelper.doPost((String)remoteUrl, (String)reqData.toJSONString());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u83b7\u53d6\u7684\u53d1\u7968\u6253\u5370\u673a\u4fe1\u606f\u662f\uff1a%s", json.toJSONString()));
        }
        String errCode = json.getString("errcode");
        if (ErrorType.SUCCESS.getCode().equals(errCode)) {
            this.getPageCache().put(this.getView().getPageId() + "machine", json.toJSONString());
            return json;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6253\u5370\u673a\u4fe1\u606f\u5f02\u5e38\uff1a%s", (String)"InvPrintTipPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]), json.getString("description")));
    }

    private void syncExecPrint(List<WorkbenchPrintInvoiceDTO> printInvoiceList, String printerName, String printType, int printnum) {
        if (CollectionUtils.isEmpty(printInvoiceList)) {
            return;
        }
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"syncExecPrint", () -> {
            block11: {
                RequestContext.get().setTraceId(traceId);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u5f02\u6b65\u6267\u884c\u53d1\u7968\u6253\u5370");
                }
                try {
                    JSONObject cacheObj = new JSONObject();
                    for (int i = 0; i < printInvoiceList.size(); ++i) {
                        WorkbenchPrintInvoiceDTO workbenchPrintInvoiceDTO = (WorkbenchPrintInvoiceDTO)printInvoiceList.get(i);
                        PrintInvoiceDTO printInvoice = this.convertWorkbench2Print(workbenchPrintInvoiceDTO, printType, printerName);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(String.format("\u8c03\u7528\u53d1\u7968\u6253\u5370\u673a\u8bf7\u6c42\u62a5\u6587\u662f\uff1a%s", JSON.toJSONString((Object)printInvoice)));
                        }
                        CacheHelper.put((String)PrintInvoiceControl.getPrinterNameCacheKey((String)("0".equals(printType) ? PrintTypeEnum.INVOICE_PRINT.getType() : PrintTypeEnum.QD_PRINT.getType()), (String)printInvoice.getJqbh()), (String)printerName, (int)2592000);
                        for (int printIndex = 0; printIndex < printnum; ++printIndex) {
                            ComponentResponse componentResponse = PaperPrintHelper.printInvoice((PrintInvoiceDTO)printInvoice, (String)printInvoice.getJqbh());
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(String.format("\u8c03\u7528\u53d1\u7968\u6253\u5370\u673a\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%s", JSON.toJSONString((Object)componentResponse)));
                            }
                            if (!componentResponse.isSucess()) {
                                if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info(String.format("\u8c03\u7528\u53d1\u7968\u6253\u5370\u53d1\u751f\u5f02\u5e38\uff1a%s", JSON.toJSONString((Object)componentResponse)));
                                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u6253\u5370\u5f02\u5e38", (String)"InvPrintTipPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                                }
                            } else {
                                DynamicObject invObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id".concat(",").concat("printflag"), (QFilter[])new QFilter("id", "=", (Object)workbenchPrintInvoiceDTO.getId()).toArray());
                                if (null != invObj) {
                                    invObj.set("printflag", (Object)"1");
                                    ImcSaveServiceHelper.update((DynamicObject)invObj);
                                }
                            }
                            int currentInv = i + 1;
                            cacheObj.put("totalInv", (Object)printInvoiceList.size());
                            cacheObj.put("currentInv", (Object)currentInv);
                            cacheObj.put("invoiceCode", (Object)printInvoice.getFpdm());
                            cacheObj.put("invoiceNo", (Object)printInvoice.getFphm());
                            CacheHelper.put((String)(this.getView().getPageId() + "_PAGE_CACHE_KEY"), (String)cacheObj.toJSONString(), (int)1800);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) break block11;
                    LOGGER.error(String.format("\u6267\u884c\u53d1\u7968\u5f02\u6b65\u6253\u5370\u5f02\u5e38\uff1a%s", e.getMessage()));
                }
            }
        });
        String mark = (String)this.getModel().getValue("page_use_mark");
        String invType = (String)this.getModel().getValue("invoicetyperadio");
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("printType", printType);
        param.put("invType", "detailList".equals(mark) ? "" : invType);
        ViewUtil.openDialog((AbstractFormPlugin)this, param, (String)"sim_inv_print_progress", (String)"sim_inv_print_progress_callback");
    }

    private PrintInvoiceDTO convertWorkbench2Print(WorkbenchPrintInvoiceDTO workbenchPrintInvoiceDTO, String printType, String printerName) {
        PrintInvoiceDTO printInvoiceDTO = new PrintInvoiceDTO();
        printInvoiceDTO.setFpdm(workbenchPrintInvoiceDTO.getInvoiceCode());
        printInvoiceDTO.setFphm(workbenchPrintInvoiceDTO.getInvoiceNo());
        printInvoiceDTO.setJqbh(workbenchPrintInvoiceDTO.getJqbh());
        printInvoiceDTO.setKpzl(InvoiceType.getTypeCodeHx((String)workbenchPrintInvoiceDTO.getInvoiceType()));
        printInvoiceDTO.setPrint_type(printType);
        printInvoiceDTO.setPrinter_name(printerName);
        printInvoiceDTO.setYlbz("0");
        return printInvoiceDTO;
    }

    private WorkbenchPrintInvoiceGroupDTO getPrintGroupByInvoiceType(String invoiceType) {
        JSONObject printGroupJson = (JSONObject)this.getView().getFormShowParameter().getCustomParam(invoiceType);
        return printGroupJson == null ? null : (WorkbenchPrintInvoiceGroupDTO)JSONObject.parseObject((String)printGroupJson.toJSONString(), WorkbenchPrintInvoiceGroupDTO.class);
    }
}

