/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.bill.relate;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.sim.common.dto.bill.ConfrimBillInvoiceDTO;
import kd.imc.sim.formplugin.bill.helper.OriginalBillRelateInvoicesHelper;

public class OriginalBillRelateInvoicesPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String KEY_ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        JSONArray primaryKeys = (JSONArray)customParams.get("orginalBillPrimaryKey");
        OriginalBillRelateInvoicesHelper.showRelateInvoicesEntry((Object[])primaryKeys.toArray(), (IDataModel)this.getModel());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        IDataModel model = this.getModel();
        Object invoiceCode = model.getValue("invoicecode", rowIndex);
        Object invoiceNo = model.getValue("invoiceno", rowIndex);
        Object sourceid = model.getValue("sourceid", rowIndex);
        Object type = model.getValue("type", rowIndex);
        if (ConfrimBillInvoiceDTO.TYPE_REDINFO.equals(type) && StringUtils.isBlank((Object)invoiceNo)) {
            OriginalBillRelateInvoicesHelper.showRedInfo((Object)sourceid, (AbstractFormPlugin)this);
            return;
        }
        if (ConfrimBillInvoiceDTO.TYPE_REDCONFIRMBILL.equals(type) && StringUtils.isBlank((Object)invoiceNo)) {
            OriginalBillRelateInvoicesHelper.showRedConfirm((Object)sourceid, (AbstractFormPlugin)this);
            return;
        }
        if (StringUtils.isNotBlank((Object)invoiceNo)) {
            OriginalBillRelateInvoicesHelper.invoiceShow((Object)invoiceCode, (Object)invoiceNo, (AbstractFormPlugin)this);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap", "advtoolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("exist".equals(itemKey)) {
            this.getView().close();
        }
    }
}

