/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.decalaration;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.formplugin.bill.delclarationbill.DeclarationFormControl;

public class DeclarationFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"consignorcname", "cnsntradescc", "ownername", "ownerscc", "consigneeename"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        Object org = this.getModel().getValue("org");
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)org);
        switch (key = control.getKey()) {
            case "consignorcname": 
            case "cnsntradescc": 
            case "ownername": 
            case "ownerscc": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getInvTitleFilter((Object)orgId), (String)"bdm_invice_title_strate", (String)key);
                break;
            }
            case "consigneeename": {
                ViewUtil.openListPage((AbstractFormPlugin)this, null, (String)"bdm_enterprise_bas_layout", (String)key, (boolean)true, (boolean)false, null, null, (String)CommonConstant.getBDM_ENTERPRISE_BAS_LAYOUT_DESCRIPTION());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("not_property_change" + this.getView().getPageId()))) {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("items");
        int[] rows = entryGrid.getSelectRows();
        int editIndex = 0;
        if (rows.length > 0) {
            editIndex = rows[0];
        }
        switch (name) {
            case "taxrate": {
                break;
            }
            case "issuerule": {
                DeclarationFormControl.editIssueRule((AbstractFormPlugin)this, (String)name, (Object)newValue, (Object)oldValue);
                break;
            }
            case "issueprice": {
                DeclarationFormControl.editIssuePrice((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue, (int)editIndex);
                break;
            }
            case "issueamount": {
                DeclarationFormControl.editIssueAmount((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue, (int)editIndex);
                break;
            }
            case "otherexchangerate": {
                DeclarationFormControl.editOtherExchangeRate((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                DeclarationFormControl.calculateAllIssueAmount((AbstractFormPlugin)this);
                break;
            }
            case "feeexchangerate": {
                DeclarationFormControl.editFeeExchangeRate((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                DeclarationFormControl.calculateAllIssueAmount((AbstractFormPlugin)this);
                break;
            }
            case "insurexchangerate": {
                DeclarationFormControl.editInsurExchangeRate((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                DeclarationFormControl.calculateAllIssueAmount((AbstractFormPlugin)this);
                break;
            }
            case "dealexchangerate": {
                DeclarationFormControl.editDealExchangeRate((AbstractFormPlugin)this, (String)name, (BigDecimal)((BigDecimal)newValue), (Object)oldValue);
                DeclarationFormControl.calculateAllIssueAmount((AbstractFormPlugin)this);
                break;
            }
            case "insurlocalamount": {
                DeclarationFormControl.editInsurAmount((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                break;
            }
            case "feeamount": {
                DeclarationFormControl.editFeeAmount((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                break;
            }
            case "otherlocalamount": {
                DeclarationFormControl.editOtherAmount((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                break;
            }
            case "issuedolaramount": {
                DeclarationFormControl.editIssueAmountByDollar((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue, (int)editIndex);
                break;
            }
            case "dollarexchangerate": {
                DeclarationFormControl.editDollarExchangeRate((AbstractFormPlugin)this, (Object)oldValue, (Object)newValue);
                break;
            }
            case "transmodename": {
                DeclarationFormControl.calculateAllIssueAmount((AbstractFormPlugin)this);
                break;
            }
            case "insurrate": {
                DeclarationFormControl.editInsurRate((AbstractFormPlugin)this, (BigDecimal)((BigDecimal)newValue), (Object)oldValue);
                this.getView().updateView("insurlocalamount");
                break;
            }
            case "otherrate": {
                DeclarationFormControl.editOtherRate((AbstractFormPlugin)this, (BigDecimal)((BigDecimal)newValue), (Object)oldValue);
                this.getView().updateView("otherlocalamount");
                break;
            }
            case "feerate": {
                DeclarationFormControl.editFeeRate((AbstractFormPlugin)this, (BigDecimal)((BigDecimal)newValue), (Object)oldValue);
                this.getView().updateView("feeamount");
                break;
            }
            case "otherMark": {
                if ("3".equals(newValue)) {
                    BigDecimal rate = (BigDecimal)this.getModel().getValue("otherrate");
                    BigDecimal otherExchangeRate = (BigDecimal)this.getModel().getValue("otherexchangerate");
                    this.getModel().setValue("otherlocalamount", (Object)rate.multiply(otherExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
                }
                this.getView().updateView("otherlocalamount");
                break;
            }
            case "insurMark": {
                if ("3".equals(newValue)) {
                    BigDecimal rate = (BigDecimal)this.getModel().getValue("insurrate");
                    BigDecimal insurExchangeRate = (BigDecimal)this.getModel().getValue("insurexchangerate");
                    this.getModel().setValue("insurlocalamount", (Object)rate.multiply(insurExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
                }
                this.getView().updateView("insurlocalamount");
                break;
            }
            case "feeMark": {
                if ("3".equals(newValue)) {
                    BigDecimal rate = (BigDecimal)this.getModel().getValue("feerate");
                    BigDecimal feeExchangeRate = (BigDecimal)this.getModel().getValue("feeexchangerate");
                    this.getModel().setValue("feeamount", (Object)rate.multiply(feeExchangeRate).setScale(UnitPriceHelper.MONEY_ACCURACY, RoundingMode.HALF_UP));
                }
                this.getView().updateView("feeamount");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityPropertyCollection allProperties = dataEntity.getDataEntityType().getProperties();
        HashSet editAbleFields = new HashSet();
        Collections.addAll(editAbleFields, "issuerule", "dealexchangerate", "feeexchangerate", "insurexchangerate", "feeamount", "insurlocalamount", "issuefromamount", "otherlocalamount", "otherexchangerate", "issueprice", "issueamount", "items", "seq", "issuedolaramount", "issueoriginamount", "dollarexchangerate");
        for (IDataEntityProperty property : allProperties) {
            String name = property.getName();
            Object value = dataEntity.get(name);
            if (!DeclarationFormControl.isFieldNotBlank((Object)value) || editAbleFields.contains(name)) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{name});
        }
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("items");
        for (int i = 0; i < itemList.size(); ++i) {
            DataEntityPropertyCollection itemProperties = ((DynamicObject)itemList.get(0)).getDynamicObjectType().getProperties();
            for (IDataEntityProperty itemProperty : itemProperties) {
                String name = itemProperty.getName();
                Object value = ((DynamicObject)itemList.get(0)).get(name);
                if (!StringUtils.isNotBlank((Object)value) || editAbleFields.contains(name)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{name});
            }
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bd_currency"), (QFilter[])new QFilter("number", "=", (Object)"USD").toArray());
        this.getModel().setValue("dollar", (Object)dynamicObject);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        switch (actionId) {
            case "ownername": 
            case "ownerscc": {
                Long pk = (Long)((ListSelectedRowCollection)returnData).getPrimaryKeyValues()[0];
                DynamicObject buyerTitle = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_invice_title_strate");
                this.getModel().setValue("ownername", (Object)buyerTitle.getString("name"));
                this.getModel().setValue("ownerscc", (Object)buyerTitle.getString("taxno"));
                break;
            }
            case "consignorcname": 
            case "cnsntradescc": {
                Long pk = (Long)((ListSelectedRowCollection)returnData).getPrimaryKeyValues()[0];
                DynamicObject buyerTitle = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_invice_title_strate");
                this.getModel().setValue("consignorcname", (Object)buyerTitle.getString("name"));
                this.getModel().setValue("cnsntradescc", (Object)buyerTitle.getString("taxno"));
                break;
            }
            case "consigneeename": {
                Long pk = (Long)((ListSelectedRowCollection)returnData).getPrimaryKeyValues()[0];
                DynamicObject epInfo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_enterprise_baseinfo");
                this.getModel().setValue("consigneeename", (Object)epInfo.getString("name"));
            }
        }
    }
}

