/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.giftreceipt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.util.MD5;

public class GiftReceiptPrintPlugin
extends AbstractPrintPlugin {
    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        DynamicObject giftReceipt = BusinessDataServiceHelper.loadSingle((Object)dataSource.getPkId(), (String)dataSource.getFormId());
        DynamicObjectCollection items2 = giftReceipt.getDynamicObjectCollection("items");
        List customDataRows = evt.getCustomDataRows();
        DataRowSet dataRowSet = new DataRowSet();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        for (DynamicObject item : items2) {
            totalAmount = totalAmount.add(item.getBigDecimal("taxamount"));
            if (!"1".equals(item.getString("rowtype"))) continue;
            discountAmount = discountAmount.add(item.getBigDecimal("taxamount"));
        }
        dataRowSet.put("totalamount", (Field)new DecimalField(totalAmount));
        dataRowSet.put("discountamount", (Field)new DecimalField(discountAmount));
        dataRowSet.put("qrcode", (Field)new TextField(this.getQrCode(dataSource, totalAmount)));
        customDataRows.add(dataRowSet);
    }

    private String getQrCode(CustomDataSource dataSource, BigDecimal totalAmount) {
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacSciiFromImc");
        request.setMsgType("createWeChatUrl");
        DataRowSet mainDataRow = dataSource.getMainDataRow();
        JSONObject requestJson = new JSONObject();
        String billNo = (String)mainDataRow.getField("billno").getValue();
        String accountId = RequestContext.get().getAccountId();
        requestJson.put("qrKey", (Object)accountId);
        requestJson.put("billNo", (Object)billNo);
        requestJson.put("billSource", (Object)"giftReceipt");
        requestJson.put("md5", (Object)MD5.md5Hex((String)(accountId + billNo)));
        requestJson.put("billTotalAmount", (Object)totalAmount.setScale(2, 4));
        JSONArray array = new JSONArray();
        array.add((Object)requestJson);
        request.setReqData((Object)array);
        MsgResponse send = SendMsg2Imac.send((MsgRequest)request, (String)"/kapi/app/imasm/imacWebService".concat("?access_token="));
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(send.getErrorCode())) {
            JSONObject jsonObject = JSON.parseObject((String)send.getRespData());
            return jsonObject.getString("url_link");
        }
        throw new KDBizException(send.getErrorMsg());
    }
}

