/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.home;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;

public class InvoiceStatsHomePlugin
extends AbstractFormPlugin {
    public static final String BILL_ISSUEDEND = "issue_end";
    public static final String BILL_SUM = "bill_sum";
    public static final String BILL_CONFIRMED = "bill_confirmed";
    public static final String BILL_UNCONFIRMED = "bill_unconfirmed";
    public static final String COLON = "\uff1a";

    public void afterCreateNewData(EventObject e) {
        this.getView().getModel().setValue("time", (Object)new Date());
        this.setFormData(new Date());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("time".equals(e.getProperty().getName())) {
            this.setFormData((Date)e.getChangeSet()[0].getNewValue());
        }
    }

    private void setFormData(Date date) {
        this.setOriginalBillData(date);
    }

    private void setOriginalBillData(Date date) {
        QFilter qFilter = new QFilter("billdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)date));
        qFilter.and("billdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)date));
        qFilter.and("orgid", "=", (Object)RequestContext.get().getOrgId());
        DynamicObjectCollection originalBills = QueryServiceHelper.query((String)"sim_original_bill", (String)String.format("%s,%s,%s", "billno", "confirmstate", "validstate"), (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)originalBills)) {
            this.setViewData(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO);
            return;
        }
        int issuedEndSize = 0;
        int confirmdSize = 0;
        for (DynamicObject originalBill : originalBills) {
            if ("2".equals(originalBill.getString("validstate"))) {
                ++issuedEndSize;
            }
            if (!"2".equals(originalBill.getString("confirmstate"))) continue;
            ++confirmdSize;
        }
        this.setViewData(originalBills.size(), confirmdSize, originalBills.size() - confirmdSize, issuedEndSize);
    }

    private void setViewData(int sum, int confirmed, int unconfirmed, int issueEnd) {
        Label billSum = (Label)this.getControl(BILL_SUM);
        billSum.setText(COLON + sum);
        Label billConfirmed = (Label)this.getControl(BILL_CONFIRMED);
        billConfirmed.setText(COLON + confirmed);
        Label billUnconfirmed = (Label)this.getControl(BILL_UNCONFIRMED);
        billUnconfirmed.setText(COLON + unconfirmed);
        Label issueEndLable = (Label)this.getControl(BILL_ISSUEDEND);
        issueEndLable.setText(COLON + issueEnd);
    }
}

