/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicebatch;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.CheckBillRelateInvoiceVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.constant.RpaErrorType;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RiskControlRecordConstant;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.BillRollbackHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.formplugin.bill.originalbill.control.OriginalBillPluginIssueControl;
import kd.imc.sim.formplugin.invoicebatch.control.WaitInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.BatchInvoiceControl;
import kd.imc.sim.formplugin.issuing.control.CreateInvoiceWaitControl;
import kd.imc.sim.formplugin.issuing.control.InvoiceQueryControl;
import kd.imc.sim.formplugin.risk.control.BillRiskControlService;
import org.apache.commons.lang.StringUtils;

public class InvoiceBatchPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(InvoiceBatchPlugin.class);
    private static final String FILEIMPORT = "lotsizeimport";
    private static final String RED_FILEIMPORT = "red_lotsizeimport";
    private static final String IMPORT_ALL_EINVOICE = "import_all_einvoice";
    private static final String SIM_INV_BATCH_IMPORT = "sim_inv_batch_import";
    private static final String SIM_ISSUE_CONFIG = "sim_issue_config";
    private static final String IMPORT_BILL = "import_bill";
    private static final String SIM_BATCH_LIST_REVIEW = "sim_batch_list";
    private static final String BTN_BAR_REMOVE = "barremove";
    private static final String CLOSE_BACK_SIM_CREATE_INVOICE = "close_back_sim_create_invoice";
    private static final String SIM_ALLE_RELATE = "sim_alle_relate";

    public void setFilter(SetFilterEvent e) {
        List collect;
        boolean isIdFilter;
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        LinkQueryPkIdCollection linkQueryPkIdCollection = formShowParameter.getLinkQueryPkIdCollection();
        if (!CollectionUtils.isEmpty((Collection)linkQueryPkIdCollection) && (isIdFilter = e.getQFilters().stream().anyMatch(o -> o.getProperty().equals("id"))) && !CollectionUtils.isEmpty(collect = e.getQFilters().stream().filter(q -> q.getProperty().equals("issuestatus") && "in".equals(q.getCP().toLowerCase())).collect(Collectors.toList()))) {
            e.getQFilters().removeAll(collect);
        }
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"barworkout"});
        String showErrorMsg = (String)this.getView().getFormShowParameter().getCustomParam("showErrorMsg");
        String showSuccessMsg = (String)this.getView().getFormShowParameter().getCustomParam("showSuccessMsg");
        if (StringUtils.isNotEmpty((String)showErrorMsg)) {
            this.getView().showErrorNotification(showErrorMsg);
        }
        if (StringUtils.isNotEmpty((String)showSuccessMsg)) {
            this.getView().showSuccessNotification(showSuccessMsg, Integer.valueOf(8000));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "lotsizeimport": 
            case "red_lotsizeimport": 
            case "import_all_einvoice": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SIM_BATCH_IMPORT);
                HashMap<String, String> customParams = new HashMap<String, String>(4);
                customParams.put("issuetype", FILEIMPORT.equals(key) ? IssueType.BLUE_INVOICE.getTypeCode() : IssueType.RED_INVOICE.getTypeCode());
                customParams.put("importKey", key);
                ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)SIM_INV_BATCH_IMPORT, (String)IMPORT_BILL);
                break;
            }
            case "barinvoice": {
                this.issueInvoice();
                break;
            }
            case "btn_revoke_ori": {
                this.preRollBack();
                break;
            }
            case "trackup": {
                BillHelper.trackup((AbstractListPlugin)this, (String)"sim_vatinvoice", (Object[])((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues());
                break;
            }
            case "autoconfig": {
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)SIM_ISSUE_CONFIG, (String)SIM_ISSUE_CONFIG);
            }
        }
        if (BTN_BAR_REMOVE.equalsIgnoreCase(key)) {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\uff1f", (String)"InvoiceBatchPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)BTN_BAR_REMOVE);
        }
    }

    private void issueInvoice() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6570\u636e!", (String)"InvoiceBatchPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] waitInvoiceList = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        ArrayList<DynamicObject> needUpdateInvs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> needUpdateRedConfirms = new ArrayList<DynamicObject>();
        for (DynamicObject inv : waitInvoiceList) {
            if (!InvoiceUtils.isRedConfirmInvoice((String)inv.getString("issuetype"), (String)inv.getString("invoicetype")) || !String.valueOf(inv.getString("result")).contains("\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a")) continue;
            this.fillDrawerFromBlueInv(inv, needUpdateRedConfirms);
            needUpdateInvs.add(inv);
        }
        if (needUpdateInvs.size() > 0) {
            ImcSaveServiceHelper.update(needUpdateInvs);
        }
        if (needUpdateRedConfirms.size() > 0) {
            ImcSaveServiceHelper.update(needUpdateRedConfirms);
        }
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_INVOICE, (DynamicObject[])waitInvoiceList);
        ArrayList<DynamicObject> batchSourceInvoiceList = new ArrayList<DynamicObject>(waitInvoiceList.length > 0 ? waitInvoiceList.length : 1);
        ErrorMsgDTO errorMsgDTO = null;
        OriginalBillPluginIssueControl.checkOnlyType((DynamicObject[])waitInvoiceList);
        int alleFailCount = 0;
        String firstJqbh = waitInvoiceList[0].getString("jqbh") == null ? "" : waitInvoiceList[0].getString("jqbh");
        for (DynamicObject waitInvoice : waitInvoiceList) {
            if (!StringUtils.isEmpty((String)waitInvoice.getString("issuebillstatus"))) {
                if (!"D".equals(waitInvoice.getString("issuebillstatus")) && !"C".equals(waitInvoice.getString("issuebillstatus"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s \u9700\u5ba1\u6838\u901a\u8fc7\u624d\u53ef\u5f00\u7968", (String)"InvoiceBatchPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), waitInvoice.getString("billno")));
                    return;
                }
                if (!InvoiceUtils.isAllEInvoice((Object)waitInvoice.getString("invoicetype")) && !firstJqbh.equals(waitInvoice.getString("jqbh"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u8bbe\u5907\u7f16\u53f7\u7684\u5f85\u5f00\u53d1\u7968\u8fdb\u884c\u5f00\u7968", (String)"InvoiceBatchPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ("1".equals(waitInvoice.getString("buyertype"))) {
                batchSourceInvoiceList.add(waitInvoice);
            }
            String result = waitInvoice.getString("result");
            if (!InvoiceUtils.isAllEInvoice((Object)waitInvoice.getString("invoicetype")) || !IssueStatusEnum.failed.getCode().equals(waitInvoice.getString("issuestatus")) || !RpaErrorType.issueFail((String)result)) continue;
            ++alleFailCount;
        }
        if (alleFailCount > 1 || alleFailCount == 1 && waitInvoiceList.length != 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u662f\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u7684\u5f85\u5f00\u8bb0\u5f55\uff0c\u4ec5\u652f\u6301\u52fe\u9009\u5355\u4e2a\u8bf7\u6c42\u5f00\u7968\u3002", (String)"InvoiceBatchPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]), RpaErrorType.RPA_91338_INV_NO_MATCH.getMessage(), RpaErrorType.RPA_91339_INV_SUCCESS_NO_RESULT.getMessage()));
            return;
        }
        EquipmentHelper.checkIssueJQBH((DynamicObject[])waitInvoiceList);
        if (batchSourceInvoiceList.size() > 0) {
            errorMsgDTO = BillHelper.checkInvoiceListSpecialGoodCodeRemark(batchSourceInvoiceList);
        }
        TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)waitInvoiceList[0].get("orgid")));
        String invoiceType = BatchInvoiceControl.checkSelectData((DynamicObject[])waitInvoiceList, (boolean)true);
        if (alleFailCount == 1) {
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("opt", "barinvoice");
            new WaitInvoiceControl().createAllEleRequest(params, waitInvoiceList[0]);
            ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u63d0\u793a", (String)"InvoiceBatchPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), params, (String)SIM_ALLE_RELATE, (String)SIM_ALLE_RELATE);
            return;
        }
        this.getPageCache().put("SPECIAL_GOODSCODE_REMARK_CHECK", invoiceType);
        if (errorMsgDTO != null) {
            String msgKey = "SPECIAL_GOODSCODE_REMARK_CHECK";
            String msg = String.format(ResManager.loadKDString((String)"%s,\u662f\u5426\u8865\u5145?", (String)"InvoiceBatchPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), errorMsgDTO.getFailmsg());
            ViewUtil.openConfirm((String)msgKey, (String)msg, (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8865\u5145", (String)"InvoiceBatchPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0d\u8865\u5145", (String)"InvoiceBatchPlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            this.openBatchDialog(selectedRows, invoiceType);
        }
    }

    private void fillDrawerFromBlueInv(DynamicObject inv, List<DynamicObject> needUpdateRedConfirms) {
        String oriInvoiceNo;
        if (StringUtils.isNotBlank((String)inv.getString("drawer"))) {
            return;
        }
        String oriInvoiceCode = inv.getString("originalinvoicecode");
        QFilter filter = InvoiceUtils.getInvoiceFilter((Object)oriInvoiceCode, (Object)(oriInvoiceNo = inv.getString("originalinvoiceno")));
        DynamicObject[] blueInvs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"drawer", (QFilter[])filter.toArray());
        if (blueInvs.length == 0) {
            return;
        }
        inv.set("drawer", (Object)blueInvs[0].getString("drawer"));
        String number = inv.getString("infocode");
        QFilter redConfirmFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)inv.getDynamicObject("orgid"))).and("number", "=", (Object)number);
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"drawer", (QFilter[])redConfirmFilter.toArray());
        if (redConfirms.length > 0 && StringUtils.isBlank((String)redConfirms[0].getString("drawer"))) {
            redConfirms[0].set("drawer", (Object)blueInvs[0].getString("drawer"));
            needUpdateRedConfirms.add(redConfirms[0]);
        }
    }

    public void openBatchDialog(ListSelectedRowCollection selectedRows, String invoiceType) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("ids", selectedRows.getPrimaryKeyValues());
        customParams.put("invoiceType", invoiceType);
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)SIM_BATCH_LIST_REVIEW, (String)SIM_BATCH_LIST_REVIEW);
    }

    private void showBatchInvoiceView(DynamicObject waitInvoice, Object primaryKey, String fromType) {
        String invoiceState = waitInvoice.getString("issuestatus");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (IssueStatusEnum.ok.getCode().equals(invoiceState) || IssueStatusEnum.underway.getCode().equals(invoiceState)) {
            params.put("hasIssueInvoice", "1");
        }
        if ("bill".equals(fromType)) {
            boolean waitNeedEditAll = CreateInvoiceWaitControl.isWaitNeedEditAll((String)waitInvoice.getString("salertaxno"));
            if (waitNeedEditAll) {
                params.put("waitFromBill", "1");
            } else {
                params.put("waitFromBill", "0");
            }
        }
        params.put("invoiceBatchShowFid", primaryKey);
        params.put("account", StringUtils.trimToEmpty((String)waitInvoice.getString("account")));
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)(this.getView().getPageId() + primaryKey), params, (String)"sim_create_invoice_inh", (String)CLOSE_BACK_SIM_CREATE_INVOICE, (String)ResManager.loadKDString((String)"\u5f85\u5f00\u53d1\u7968\u67e5\u770b", (String)"InvoiceBatchPlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (fieldName.equals("billno")) {
            args.setCancel(true);
            DynamicObject waitInvoice = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"sim_vatinvoice");
            String issueStatus = waitInvoice.getString("issuestatus");
            if (IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                InvoiceQueryControl.showInvoiceView((AbstractFormPlugin)this, (DynamicObject)waitInvoice);
                return;
            }
            if ("4".equals(waitInvoice.getString("buyertype"))) {
                this.showBatchInvoiceView(waitInvoice, currentSelectedRowInfo.getPrimaryKeyValue(), "bill");
            } else {
                this.showBatchInvoiceView(waitInvoice, currentSelectedRowInfo.getPrimaryKeyValue(), "other");
            }
        } else if (fieldName.equals("batchbelong")) {
            args.setCancel(true);
            BillHelper.trackup((AbstractListPlugin)this, (String)"sim_vatinvoice", (Object[])new Object[]{currentSelectedRowInfo.getPrimaryKeyValue()});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        IListView list = (IListView)this.getView();
        if (closedCallBackEvent.getReturnData() != null) {
            switch (actionId) {
                case "import_bill": {
                    if (!closedCallBackEvent.getReturnData().equals("success")) break;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"Excel\u6570\u636e\u5bfc\u5165\u6210\u529f", (String)"InvoiceBatchPlugin_12", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
                    break;
                }
                case "sim_batch_list": {
                    if (!closedCallBackEvent.getReturnData().equals("success") && !closedCallBackEvent.getReturnData().equals(ErrorType.SUBMITED.getName())) break;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5f00\u7968\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u7a0d\u5019\u5237\u65b0\u5217\u8868\u67e5\u770b\u5f00\u7968\u72b6\u6001", (String)"InvoiceBatchPlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "close_back_sim_create_invoice": {
                    this.getView().showSuccessNotification(closedCallBackEvent.getReturnData().toString(), Integer.valueOf(6000));
                    break;
                }
                case "sim_alle_relate": {
                    Map returnData = (Map)closedCallBackEvent.getReturnData();
                    Object callbackId = returnData.get("callbackId");
                    if ("btn_revoke_ori".equals(callbackId)) {
                        new BillRollbackHelper().rollback((AbstractFormPlugin)this, new Object[]{returnData.get("id")}, "sim_vatinvoice");
                        break;
                    }
                    if ("barinvoice".equals(callbackId)) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5f00\u7968\u6210\u529f", (String)"InvoiceBatchPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f", (String)"InvoiceBatchPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
        }
        list.clearSelection();
        list.refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (!e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().remove("SPECIAL_GOODSCODE_REMARK_CHECK");
            this.getPageCache().remove("rollbackUnIssue");
            this.getPageCache().remove("issuedInvoice");
            return;
        }
        String callBackId = StringUtils.defaultString((String)e.getCallBackId());
        if (callBackId.startsWith("risk_control_check_")) {
            String key = callBackId.substring(callBackId.indexOf("risk_control_check_") + "risk_control_check_".length());
            BillRiskControlService.unlockRiskRecord((AbstractFormPlugin)this);
            ItemClickEvent evt = new ItemClickEvent(new Object(), key, key);
            this.itemClick(evt);
            return;
        }
        switch (callBackId) {
            case "rollback": {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "orderno", "issuestatus", "jqbh", "issuesource", "invoicetype", "thirdserialno", "salertaxno", "batchbelong"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray());
                this.checkRollbackInvoice(invoices);
                new BillRollbackHelper().rollback((AbstractFormPlugin)this, rows.getPrimaryKeyValues(), "sim_vatinvoice");
                this.refresh();
                break;
            }
            case "failRollBack": {
                this.failRollBack();
                break;
            }
            case "rollbackUnIssue": {
                this.rollbackUnIssue();
                this.refresh();
                break;
            }
            case "SPECIAL_GOODSCODE_REMARK_CHECK": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                String invoiceType = this.getPageCache().get("SPECIAL_GOODSCODE_REMARK_CHECK");
                this.openBatchDialog(selectedRows, invoiceType);
                this.getPageCache().remove("SPECIAL_GOODSCODE_REMARK_CHECK");
                break;
            }
            case "barremove": {
                new WaitInvoiceControl().deleteWaitInvoice((AbstractListPlugin)this);
                this.refresh();
            }
        }
    }

    private void checkRollbackInvoice(DynamicObject[] invoices) {
        boolean isCheckFail = StringUtils.isNotBlank((String)this.getPageCache().get("checkFail"));
        for (DynamicObject invoice : invoices) {
            String issueStatus = invoice.getString("issuestatus");
            if (IssueStatusEnum.submit.getCode().equals(issueStatus) || IssueStatusEnum.underway.getCode().equals(issueStatus) || IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5f00\u7968\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u5f00\u7968\u6216\u5f00\u7968\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u9000", (String)"InvoiceBatchPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("orderno")));
            }
            if (!isCheckFail || !IssueStatusEnum.failed.getCode().equals(issueStatus)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5f00\u7968\u72b6\u6001\u4e3a\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u56de\u9000", (String)"InvoiceBatchPlugin_17", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("orderno")));
        }
    }

    public void refresh() {
        BillList list = (BillList)this.getControl("billlistap");
        list.clearSelection();
        list.refresh();
    }

    private void preRollBack() {
        ListSelectedRowCollection selectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] invoices = new WaitInvoiceControl().checkOrg((AbstractFormPlugin)this, selectedRowCollection, ImcPermItemEnum.IMC_SIM_ROLLBACK_1);
        if (invoices == null) {
            return;
        }
        boolean isContainFail = false;
        ArrayList<Object> merge2OnePks = new ArrayList<Object>();
        for (DynamicObject invoice : invoices) {
            String issueStatus = invoice.getString("issuestatus");
            if (IssueStatusEnum.submit.getCode().equals(issueStatus) || IssueStatusEnum.underway.getCode().equals(issueStatus) || IssueStatusEnum.ok.getCode().equals(issueStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5f00\u7968\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u5f00\u7968\u6216\u5f00\u7968\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u9000", (String)"InvoiceBatchPlugin_16", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("orderno")));
                return;
            }
            if (!"4".equals(invoice.getString("buyertype")) && !"11".equals(invoice.getString("buyertype"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7(%s)\uff1a\u4ec5\u4ece\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u8fc7\u6765\uff0c\u624d\u5141\u8bb8\u56de\u9000\uff01", (String)"InvoiceBatchPlugin_18", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoice.getString("orderno")));
                return;
            }
            if (ItemMerge2OneHelper.isNeedNumExtraDeal((Object)invoice.getString("mergelable"))) {
                merge2OnePks.add(invoice.getPkValue());
            }
            isContainFail = isContainFail || IssueStatusEnum.failed.getCode().equals(invoice.getString("issuestatus"));
        }
        String message = ResManager.loadKDString((String)"\u5df2\u9009%s\u6761\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u56de\u9000\uff1f", (String)"InvoiceBatchPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        if (merge2OnePks.size() > 0) {
            CheckBillRelateInvoiceVo checkResult = ItemMerge2OneHelper.checkRelateOriginalBillInvoicesIsWait((Object[])merge2OnePks.toArray());
            isContainFail = checkResult.isIssueFailedExist();
            if (checkResult.isContainOtherInvoice()) {
                message = ResManager.loadKDString((String)"\u5df2\u9009%s\u6761\u6570\u636e,\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u8fdb\u884c\u6570\u91cf\u5904\u7406\uff0c\u56de\u9000\u65f6\u9700\u5c06\u5355\u636e\u5173\u8054\u7684\u6240\u6709\u5f85\u5f00\u53d1\u7968\u56de\u9000\uff0c\u662f\u5426\u7ee7\u7eed\u56de\u9000\uff1f", (String)"InvoiceBatchPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
        }
        if (isContainFail) {
            if (EquipmentHelper.isComponentDevice((String)invoices[0].getString("issuesource"))) {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6570\u636e\u672a\u5f00\u7968\uff0c\u9700\u6821\u9a8c\u5f85\u56de\u9000\u6570\u636e\u662f\u5426\u5df2\u5f00\u7968\uff0c\u8bf7\u786e\u8ba4\u7a0e\u76d8\u5728\u7ebf\uff0c\u5e76\u542f\u52a8\u5f00\u7968\u7ec4\u4ef6\u3002", (String)"InvoiceBatchPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"failRollBack");
            } else {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6570\u636e\u672a\u5f00\u7968\uff0c\u9700\u6821\u9a8c\u5f85\u56de\u9000\u6570\u636e\u662f\u5426\u5df2\u5f00\u7968\u3002", (String)"InvoiceBatchPlugin_22", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"failRollBack");
            }
        } else {
            this.getPageCache().put("checkFail", "1");
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(message, selectedRowCollection.size()), (String)"rollback");
        }
    }

    private void failRollBack() {
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "orderno", "issuestatus", "jqbh", "issuesource", "invoicetype", "thirdserialno", "salertaxno", "invoiceno"), (QFilter[])new QFilter("id", "in", (Object)this.getSelectRows((AbstractFormPlugin)this)).toArray());
        this.getPageCache().remove("checkFail");
        this.checkRollbackInvoice(invoices);
        List issuedInvoiceList = new WaitInvoiceControl().getIssuedInvoiceList(invoices);
        if (!CollectionUtils.isEmpty((Collection)issuedInvoiceList)) {
            ArrayList<String> showContent = new ArrayList<String>(issuedInvoiceList.size());
            ArrayList<String> issuedOrderNo = new ArrayList<String>(issuedInvoiceList.size());
            for (JSONObject invoiceJson : issuedInvoiceList) {
                issuedOrderNo.add(invoiceJson.getString("fplsh"));
                if (invoiceJson.containsKey((Object)"fpdm")) {
                    showContent.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7%1$s\u5b58\u5728\u5df2\u5f00\u53d1\u7968\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff0c\u53d1\u7968\u53f7\u7801%3$s\uff1b", (String)"InvoiceBatchPlugin_33", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceJson.getString("fplsh"), invoiceJson.getString("fpdm"), invoiceJson.getString("fphm")));
                    continue;
                }
                showContent.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7%1$s\u5b58\u5728\u5df2\u5f00\u53d1\u7968\uff0c\u53d1\u7968\u53f7\u7801%2$s\uff1b", (String)"InvoiceBatchPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), invoiceJson.getString("fplsh"), invoiceJson.getString("fphm")));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u5f53\u524d\u53d1\u7968\u56de\u9000\u5305\u542b\u5df2\u5f00\u7968\u4f46\u5f85\u5f00\u663e\u793a\u5f00\u7968\u5931\u8d25\u7684\u6570\u636e\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[%s]", Stream.of(invoices).filter(invoice -> issuedOrderNo.contains(invoice.getString("orderno"))).map(invoice -> invoice.getString("orderno")).collect(Collectors.joining(","))));
            }
            this.getPageCache().put("rollbackUnIssue", Stream.of(invoices).filter(invoice -> !issuedOrderNo.contains(invoice.getString("orderno"))).map(invoice -> invoice.getString("orderno")).collect(Collectors.joining(",")));
            this.getPageCache().put("issuedInvoice", String.join((CharSequence)",", issuedOrderNo));
            ViewUtil.openConfirm((String)"rollbackUnIssue", (String)ResManager.loadKDString((String)"\u5f85\u56de\u9000\u6570\u636e\u5728\u7a0e\u63a7\u4e2d\u5b58\u5728\u5df2\u5f00\u53d1\u7968\uff0c\u70b9\u51fb\u786e\u8ba4\u5c06\u5df2\u5f00\u53d1\u7968\u540c\u6b65\u56de\u7cfb\u7edf\u5e76\u56de\u9000\u672a\u5f00\u7968\u6570\u636e\u3002", (String)"InvoiceBatchPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceBatchPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceBatchPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)showContent.stream().collect(Collectors.joining(System.lineSeparator())));
            return;
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5df2\u5f00\u7968\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u56de\u9000\u5168\u90e8\u6570\u636e\u3002", (String)"InvoiceBatchPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"rollback");
    }

    private void rollbackUnIssue() {
        new WaitInvoiceControl().submitIssueMQ((AbstractFormPlugin)this, "issuedInvoice");
        String unIssueOrderNos = this.getPageCache().get("rollbackUnIssue");
        if (StringUtils.isNotBlank((String)unIssueOrderNos)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u5f53\u524d\u56de\u9000\u672a\u5f00\u7968\u6570\u636e\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[%s]", unIssueOrderNos));
            }
            this.getPageCache().remove("rollbackUnIssue");
            QFilter qFilter = new QFilter("orderno", "in", (Object)unIssueOrderNos.split(",")).and("issuestatus", "=", (Object)IssueStatusEnum.none.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
            if (invoices.length != 0) {
                new BillRollbackHelper().rollback((AbstractFormPlugin)this, Stream.of(invoices).map(DataEntityBase::getPkValue).toArray(), "sim_vatinvoice");
            }
        }
    }

    private Object[] getSelectRows(AbstractFormPlugin that) {
        ListSelectedRowCollection selectedRowCollection = ((IListView)that.getView()).getSelectedRows();
        return selectedRowCollection.getPrimaryKeyValues();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("barinvoice".equals(itemKey)) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            Object[] idArr = rows.getPrimaryKeyValues();
            boolean antiReplayControlFlag = BillRiskControlService.riskControl((Object[])idArr, (String)"sim_invoice_wait", (RiskControlRecordConstant.ExecuteActionEnum)RiskControlRecordConstant.ExecuteActionEnum.EXECUTE_ACTION_ISSUE, (AbstractFormPlugin)this, (String)("risk_control_check_" + itemKey));
            evt.setCancel(antiReplayControlFlag);
        }
    }
}

