/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoicecountract;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.FiArFinArBillHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceHelper;
import kd.imc.sim.formplugin.issuing.util.RedInvoiceUtil;
import kd.imc.sim.formplugin.redconfirm.RedConfirmBillListPlugin;

public class RedInvoiceTreeListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(RedInvoiceTreeListPlugin.class);
    private static final String SPECIAL_RED = "SPECIAL_RED";

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode()));
        e.getQFilters().add(new QFilter("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray));
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"btn_close"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("fulldashed".equals(evt.getItemKey())) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (!this.checkCounteract(rows)) {
                return;
            }
            this.checkBillPreviewSpecialCodeRemark(rows, evt.getItemKey());
        }
    }

    private void checkBillPreviewSpecialCodeRemark(ListSelectedRowCollection rows, String itemKey) {
        ErrorMsgDTO errorMsgDTO = BillHelper.checkInvoiceSpecialGoodCodeRemark((ListSelectedRowCollection)rows);
        if (errorMsgDTO != null) {
            ViewUtil.openConfirm((String)"SPECIAL_GOODSCODE_REMARK_CHECK", (String)String.format(ResManager.loadKDString((String)"%s,\u662f\u5426\u8865\u5145?", (String)"RedInvoiceTreeListPlugin_31", (String)"imc-sim-formplugin", (Object[])new Object[0]), errorMsgDTO.getFailmsg()), (AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u8865\u5145", (String)"RedInvoiceTreeListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0d\u8865\u5145", (String)"RedInvoiceTreeListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        } else {
            this.fullCounteract(rows, itemKey);
        }
    }

    private boolean checkCounteract(ListSelectedRowCollection rows) {
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ea2\u51b2\u7684\u53d1\u7968!", (String)"RedInvoiceTreeListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        DynamicObject[] blueInvoiceDOs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicetype", "invoicecode", "invoiceno", "issuetime", "issuetype", "invoicestatus", "invoiceamount", "remainredamount", "totaltax", "canredtaxamount", "buyertype", "orgid", "jqbh", "salertaxno", "iselepaper", "applicant"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray());
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.SIM_RED, (DynamicObject[])blueInvoiceDOs);
        TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoiceDOs[0].get("orgid")));
        if (blueInvoiceDOs.length > 1) {
            EquipmentHelper.checkIssueJQBH((DynamicObject[])blueInvoiceDOs);
        }
        int primaryKeyLength = rows.getPrimaryKeyValues().length;
        String invoiceType = blueInvoiceDOs[0].getString("invoicetype");
        String isElePaper = StringUtils.isBlank((CharSequence)blueInvoiceDOs[0].getString("iselepaper")) ? "0" : blueInvoiceDOs[0].getString("iselepaper");
        for (DynamicObject obj : blueInvoiceDOs) {
            String objIsElePaper;
            if (!IssueType.BLUE_INVOICE.getTypeCode().equals(obj.get("issuetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ea2\u51b2\u6b63\u6570\u53d1\u7968\uff01", (String)"RedInvoiceTreeListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!InvoiceStatus.isNormalInvIncludePartRed((String)obj.getString("invoicestatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ea2\u51b2\u5df2\u5f00\u5177\u7684\u53d1\u7968\uff01", (String)"RedInvoiceTreeListPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!obj.getString("invoicetype").equals(invoiceType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u79cd\u53d1\u7968\u79cd\u7c7b\u8fdb\u884c\u7ea2\u51b2\uff01", (String)"RedInvoiceTreeListPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (blueInvoiceDOs.length > 1) {
                String buyerType = obj.getString("buyertype");
                if ("9".equals(buyerType) || "10".equals(buyerType)) continue;
                if (obj.getBigDecimal("invoiceamount").compareTo(obj.getBigDecimal("remainredamount")) != 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u5df2\u7ecf\u90e8\u5206\u7ea2\u51b2\u8fc7\uff0c\u4e0d\u80fd\u6279\u91cf\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.get("invoicecode"), obj.get("invoiceno")));
                    return false;
                }
                if (obj.getBigDecimal("totaltax").compareTo(obj.getBigDecimal("canredtaxamount")) != 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53f7\u7801%2$s\u5df2\u7ecf\u90e8\u5206\u7ea2\u51b2\u8fc7\uff0c\u4e0d\u80fd\u6279\u91cf\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_32", (String)"imc-sim-formplugin", (Object[])new Object[0]), obj.get("invoicecode"), obj.get("invoiceno")));
                    return false;
                }
            }
            String string = objIsElePaper = StringUtils.isBlank((CharSequence)obj.getString("iselepaper")) ? "0" : obj.getString("iselepaper");
            if (isElePaper.equals(objIsElePaper)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u7ea2\u51b2\u6570\u7535\u7eb8\u7968\u6216\u8005\u975e\u6570\u7535\u7eb8\u7968\uff01", (String)"RedInvoiceTreeListPlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && primaryKeyLength != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u8fdb\u884c\u5f55\u5165\u7ea2\u5b57\u786e\u8ba4\u5355\uff01", (String)"RedInvoiceTreeListPlugin_35", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (AllEleAuthHelper.isElePaper((Object)isElePaper) && primaryKeyLength != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e3a\u6570\u7535\u7eb8\u7968\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u8fdb\u884c\u5f55\u5165\u7ea2\u5b57\u786e\u8ba4\u5355\uff01", (String)"RedInvoiceTreeListPlugin_36", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void fullCounteract(ListSelectedRowCollection rows, String itemKey) {
        JSONObject param;
        DynamicObject[] invoices;
        for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicetype", "invoicecode", "invoiceno", "issuetime", "issuetype", "invoicestatus", "invoiceamount", "remainredamount", "totaltax", "canredtaxamount", "buyertype", "systemsource", "orgid", "canredtaxamount", "cancelredlable", "iselepaper"), (QFilter[])new QFilter("id", "in", (Object)rows.getPrimaryKeyValues()).toArray())) {
            String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew((DynamicObject)invoice, (String)"");
            if (!StringUtils.isNotBlank((CharSequence)errmsg)) continue;
            this.getView().showTipNotification(errmsg);
            return;
        }
        String invoiceType = invoices[0].getString("invoicetype");
        String isElePaper = invoices[0].getString("iselepaper");
        if (invoices.length == 1) {
            DynamicObject dynamicObject = invoices[0];
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
            map.put("data", dynamicObject);
            if (InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)isElePaper)) {
                ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"sim_red_info_dialog", (String)"sim_red_info_dialog");
            } else if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)isElePaper)) {
                ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"sim_red_confirm_bill_add", (String)"sim_red_confirm_bill_add");
            } else {
                BotpHelper.cancelOrRedArInvoice((DynamicObject[])invoices, (CancelRedEum)CancelRedEum.ISSUE_RED_NORMAL);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_red_reason", (String)"sim_red_reason");
            }
            return;
        }
        RedInvoiceTreeListPlugin.checkSelectOrg(invoices);
        String callBackId = itemKey;
        String confirmMsg = ResManager.loadKDString((String)"\u662f\u5426\u7ea2\u51b2\u9009\u4e2d\u7684\u53d1\u7968\u6570\u636e\uff1f", (String)"RedInvoiceTreeListPlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
            callBackId = SPECIAL_RED;
            confirmMsg = ResManager.loadKDString((String)"\u662f\u5426\u63d0\u4ea4\u9009\u4e2d\u7684\u53d1\u7968\u6570\u636e\u5230\u7ea2\u5b57\u4fe1\u606f\u8868\uff1f", (String)"RedInvoiceTreeListPlugin_15", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        }
        if ((param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])invoices, (CancelRedEum)CancelRedEum.ISSUE_RED_NORMAL)).getInteger("billPksSize") > 0) {
            this.getPageCache().put("cancelOrRedArInvoiceBillPks", param.toJSONString());
        }
        ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)confirmMsg, (String)callBackId);
    }

    public static void checkSelectOrg(DynamicObject[] objs) {
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)objs.length);
        for (DynamicObject obj : objs) {
            orgSet.add(obj.getDynamicObject("orgid").getString("id"));
        }
        if (orgSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6570\u636e\u64cd\u4f5c", (String)"RedInvoiceTreeListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        switch (e.getCallBackId()) {
            case "sim_red_info_edit": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("org", this.getPageCache().get("org"));
                ViewUtil.openListPageByMainPage((AbstractFormPlugin)this, null, map, (String)"sim_red_info", null, null);
                break;
            }
            case "fulldashed": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"sim_red_reason", (String)"sim_red_reason");
                break;
            }
            case "SPECIAL_RED": {
                this.redinfoSpecialInvoices(e);
                break;
            }
            case "SPECIAL_GOODSCODE_REMARK_CHECK": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                this.fullCounteract(rows, "fulldashed");
                break;
            }
            case "cancelOrRedArInvoice": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String paramStr = this.getPageCache().get("cancelOrRedArInvoiceBillPks");
                if (StringUtils.isNotBlank((CharSequence)paramStr)) {
                    BotpHelper.writeOffArBillAndAddMark((String)paramStr, (String)"sim_vatinvoice");
                }
                String redReason = this.getPageCache().get("cancelOrRedArInvoiceredReason");
                this.getPageCache().remove("cancelOrRedArInvoiceredReason");
                this.batchRed(redReason);
            }
        }
    }

    private void batchRed(String redReason) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] blueInvoiceList = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        LOGGER.info(String.format("\u6279\u91cf\u7ea2\u51b2\u51b2\u7ea2\u539f\u56e0\uff1a%s", redReason));
        ArrayList<Object> redInvoiceList = new ArrayList<Object>();
        ArrayList<DynamicObject> newRedInvoiceList = new ArrayList<DynamicObject>();
        for (DynamicObject blueDynamicObject : blueInvoiceList) {
            DynamicObject[] redInvoiceListByBlueDO = this.getRedInvoiceListByBlueDO(blueDynamicObject);
            if (redInvoiceListByBlueDO.length == 0) {
                newRedInvoiceList.add(this.saveWaitRed(redReason, blueDynamicObject));
                continue;
            }
            redInvoiceList.addAll(Arrays.asList(redInvoiceListByBlueDO));
        }
        if (!newRedInvoiceList.isEmpty()) {
            Object[] save = ImcSaveServiceHelper.save(newRedInvoiceList);
            LOGGER.info(String.format("\u6279\u91cf\u7ea2\u51b2\u4fdd\u5b58\u7ea2\u7968\u6210\u529f\uff1a%s", save.length));
            redInvoiceList.addAll(newRedInvoiceList);
        }
        IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])redInvoiceList.toArray(new DynamicObject[0]));
        this.getView().close();
        String fiInvoiceTip = "";
        HashSet billPks = new HashSet();
        for (DynamicObject dynamicObject : blueInvoiceList) {
            if (!BotpHelper.isFromAr((Object)dynamicObject.getString("systemsource"))) continue;
            billPks.addAll(Arrays.stream(RelationHelper.getOriBillByInvoice((DynamicObject)dynamicObject)).map(o -> o.getLong("id")).collect(Collectors.toSet()));
        }
        if (billPks.size() > 0 && BotpHelper.isArNeedShowTip(billPks)) {
            fiInvoiceTip = BotpHelper.getArFiTip();
        }
        String tip = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u7ea2\u51b2\u63d0\u4ea4\u5230\u5f85\u5f00\u6210\u529f\uff0c\u8bf7\u5230\u53d1\u7968\u67e5\u8be2\u67e5\u770b\u7ea2\u51b2\u6210\u529f\u7684\u53d1\u7968\u3002%s", (String)"RedInvoiceTreeListPlugin_34", (String)"imc-sim-formplugin", (Object[])new Object[0]), fiInvoiceTip);
        IssueInvoiceHelper.jumpWaitInvoiceListPage((AbstractFormPlugin)this, null, tip);
    }

    private DynamicObject saveWaitRed(String redReason, DynamicObject blueDynamicObject) {
        DynamicObject redDynamicObject = RedInvoiceUtil.blueInvoiceConvertToRed((DynamicObject)blueDynamicObject, (boolean)true);
        redDynamicObject.set("redreason", (Object)redReason);
        redDynamicObject.set("buyertype", (Object)"0");
        return redDynamicObject;
    }

    private void redinfoSpecialInvoices(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes) {
            try {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)objs[0].get("orgid"));
                this.getPageCache().put("org", String.valueOf(orgId));
                SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgId);
                DynamicObject[] redInfoArray = new DynamicObject[objs.length];
                int index = 0;
                for (DynamicObject invoice : objs) {
                    DynamicObject redInfo;
                    redInfoArray[index] = redInfo = RedInfoHelper.convertInvoice2RedInfo((DynamicObject)invoice, (SaleInfo)saleInfo);
                    ++index;
                }
                SaveServiceHelper.save((DynamicObject[])redInfoArray);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"RedInvoiceTreeListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u524d\u5f80", (String)"RedInvoiceTreeListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f,\u8bf7\u524d\u5f80\u7ea2\u5b57\u4fe1\u606f\u8868\u9875\u9762\u8fdb\u884c\u7ea2\u51b2\u64cd\u4f5c\uff01", (String)"RedInvoiceTreeListPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("sim_red_info_edit"), btnNameMaps);
            }
            catch (KDBizException e1) {
                LOGGER.error("\u4e13\u7968\u7ea2\u51b2:" + e1.getMessage(), (Throwable)e1);
                throw e1;
            }
            catch (Exception e1) {
                LOGGER.error("\u4e13\u7968\u7ea2\u51b2:" + e1.getMessage(), (Throwable)e1);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e13\u7968\u7ea2\u51b2\u5931\u8d25", (String)"RedInvoiceTreeListPlugin_23", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        switch (actionId = event.getActionId()) {
            case "sim_red_info_dialog": {
                if (null == event.getReturnData()) break;
                Map map = (Map)event.getReturnData();
                ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)String.valueOf(map.get("id")), (Map)map, (String)"sim_red_info_edit", (String)"sim_red_info_edit");
                break;
            }
            case "sim_red_confirm_bill_add": {
                if (null == event.getReturnData()) break;
                Map map = (Map)event.getReturnData();
                RedConfirmBillListPlugin.openRedConfirmAddPage((AbstractFormPlugin)this, map);
                break;
            }
            case "sim_red_info_edit": {
                if (event.getReturnData() == null) break;
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"RedInvoiceTreeListPlugin_19", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u524d\u5f80", (String)"RedInvoiceTreeListPlugin_20", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f,\u8bf7\u524d\u5f80\u7ea2\u5b57\u4fe1\u606f\u8868\u9875\u9762\u8fdb\u884c\u7ea2\u51b2\u64cd\u4f5c\uff01", (String)"RedInvoiceTreeListPlugin_21", (String)"imc-sim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("sim_red_info_edit"), btnNameMaps);
                break;
            }
            case "sim_red_reason": {
                ListSelectedRowCollection rows = this.getSelectedRows();
                if (event.getReturnData() == null) break;
                Object[] primaryKeyValues = rows.getPrimaryKeyValues();
                if (primaryKeyValues.length == 1) {
                    this.redOneNormalInvoice(event, rows);
                    break;
                }
                String paramStr = this.getPageCache().get("cancelOrRedArInvoiceBillPks");
                this.getPageCache().remove("cancelOrRedArInvoiceBillPks");
                if (StringUtils.isNotBlank((CharSequence)paramStr)) {
                    this.getPageCache().put("cancelOrRedArInvoiceredReason", String.valueOf(event.getReturnData()));
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u7ea2\u51b2\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RedInvoiceTreeListPlugin_37", (String)"imc-sim-formplugin", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
                    return;
                }
                this.batchRed(String.valueOf(event.getReturnData()));
                break;
            }
            case "waitRed": {
                if (event.getReturnData() == null || !event.getReturnData().toString().contains("\u6210\u529f")) break;
                this.getView().showSuccessNotification(event.getReturnData().toString(), Integer.valueOf(5000));
            }
        }
        if ("needApproval".equals(event.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u5f00\u7968\u5ba1\u6838\uff0c\u8bf7\u8fdb\u5165\u5f85\u5f00\u53d1\u7968\u5217\u8868\u63d0\u4ea4\u5ba1\u6838\u540e\uff0c\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_25", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
        } else if ("redHasWait".equals(event.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u84dd\u7968\u7ea2\u51b2\u5df2\u63d0\u4ea4\u5f00\u7968\u5ba1\u6838\uff0c\u8bf7\u8fdb\u5165\u5f85\u5f00\u53d1\u7968\u5217\u8868\u63d0\u4ea4\u5ba1\u6838\u540e\uff0c\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_26", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
        }
        this.getView().invokeOperation("refresh");
    }

    private void redOneNormalInvoice(ClosedCallBackEvent event, ListSelectedRowCollection rows) {
        Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
        DynamicObject blueInvoiceDO = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
        DynamicObject[] redInvoiceDOS = this.getRedInvoiceListByBlueDO(blueInvoiceDO);
        if (redInvoiceDOS.length > 0) {
            this.existRedInvoice(redInvoiceDOS);
        } else {
            this.jumNewSingleRedInvoicePage((String)event.getReturnData(), blueInvoiceDO);
        }
    }

    private DynamicObject[] getRedInvoiceListByBlueDO(DynamicObject blueInvoiceDO) {
        QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)blueInvoiceDO.get("orgid"))).and("originalinvoicecode", "=", (Object)blueInvoiceDO.getString("invoicecode")).and("originalinvoiceno", "=", (Object)blueInvoiceDO.getString("invoiceno")).and("invoicestatus", "not in", (Object)new String[]{"0", "6"});
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "issuesource", "issuestatus", "result", "id", "invoiceamount", "salertaxno", "jqbh", "orderno"), (QFilter[])qFilter.toArray());
    }

    private void existRedInvoice(DynamicObject[] redInvoiceDOS) {
        if (redInvoiceDOS.length > 1) {
            IssueInvoiceHelper.jumpWaitInvoiceListPage((AbstractFormPlugin)this, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u5f20\u84dd\u7968\u7ea2\u51b2\u751f\u6210\u7684\u7ea2\u7968\uff0c\u8bf7\u5230\u5f85\u5f00\u53d1\u7968\u8fdb\u884c\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_27", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        } else {
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("invoiceBatchShowFid", redInvoiceDOS[0].getPkValue());
            ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, (String)(this.getView().getPageId() + redInvoiceDOS[0].getPkValue()), customParams, (String)"sim_create_invoice_inh", (String)"waitRed", (String)ResManager.loadKDString((String)"\u5f85\u5f00\u7ea2\u7968\u67e5\u770b", (String)"RedInvoiceTreeListPlugin_28", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private void jumNewSingleRedInvoicePage(String redInvoiceReason, DynamicObject blueInvoiceDO) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("data", blueInvoiceDO);
        map.put("redInvoiceFid", blueInvoiceDO.getPkValue());
        if (StringUtils.isBlank((CharSequence)redInvoiceReason)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7ea2\u51b2\u539f\u56e0", (String)"RedInvoiceTreeListPlugin_29", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String invoiceCode = blueInvoiceDO.getString("invoicecode");
        String invoiceNo = blueInvoiceDO.getString("invoiceno");
        CacheHelper.put((String)(invoiceCode + invoiceNo + "redreason"), (String)redInvoiceReason, (int)60);
        LOGGER.info(String.format("redInvoiceReason\uff1a%s", redInvoiceReason));
        map.put("redreason", redInvoiceReason);
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, (Map)map, (String)"sim_create_invoice_red", (String)"red_invoice", (String)ResManager.loadKDString((String)"\u53d1\u7968\u7ea2\u51b2", (String)"RedInvoiceTreeListPlugin_30", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }
}

