/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;

public class AutoIssueConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(AutoIssueConfigPlugin.class);

    public void afterCreateNewData(EventObject e) {
        QFilter filter = this.getFilter();
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_auto_issue_config", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_auto_issue_config", (boolean)true), (QFilter[])filter.toArray());
        if (array.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (DynamicObject config : array) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("useorg", (Object)config.getDynamicObject("useorg"), index);
                long pk = config.getDynamicObject("useorg").getLong("id");
                builder.append(pk).append(',');
                String reason = config.getString("reason");
                this.getModel().setValue("reason", (Object)reason, index);
            }
            this.getModel().setValue("orgpks", (Object)builder.toString());
        }
    }

    private QFilter getFilter() {
        QFilter filter;
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (userHasPermOrgs.hasAllOrgPerm()) {
            filter = new QFilter("1", "=", (Object)1);
        } else {
            List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            filter = new QFilter("useorg", "in", (Object)hasPermOrgs.toArray());
        }
        return filter;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
    }

    /*
     * Unable to fully structure code
     */
    public void itemClick(ItemClickEvent evt) {
        var3_3 = itemKey = evt.getItemKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 3522941: {
                if (!var3_3.equals("save")) break;
                var4_4 = 0;
            }
        }
        switch (var4_4) {
            case 0: {
                lockKey = "autoIssueConfigKey";
                try {
                    lock = DLock.create((String)lockKey);
                    var7_8 = null;
                    if (lock.tryLock(10L)) {
                        this.saveConfig();
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AutoIssueConfigPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    }
                    if (lock == null) break;
                    if (var7_8 == null) ** GOTO lbl26
                    try {
                        lock.close();
                    }
                    catch (Throwable var8_9) {
                        var7_8.addSuppressed(var8_9);
                    }
                    break;
lbl26:
                    // 1 sources

                    lock.close();
                    ** break;
                    catch (Throwable var8_10) {
                        try {
                            var7_8 = var8_10;
                            throw var8_10;
                        }
                        catch (Throwable var9_11) {
                            if (lock != null) {
                                if (var7_8 != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable var10_12) {
                                        var7_8.addSuppressed(var10_12);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            throw var9_11;
lbl43:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    AutoIssueConfigPlugin.LOGGER.error("autoIssueConfigKey" + e.getMessage(), (Throwable)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"AutoIssueConfigPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), new Object[]{e.getMessage()}));
                }
            }
        }
        super.itemClick(evt);
    }

    private void saveConfig() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        String orgStr = (String)this.getModel().getValue("orgpks");
        String[] oriOrgPks = null;
        if (entry.size() == 0) {
            if (StringUtils.isNotBlank((CharSequence)orgStr)) {
                oriOrgPks = orgStr.split(",");
                this.deleteOrgData(oriOrgPks, new ArrayList<Object>());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AutoIssueConfigPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultMap = this.checkEntry(entry);
        if (StringUtils.isNotBlank((CharSequence)orgStr)) {
            oriOrgPks = orgStr.split(",");
        }
        List orgPks = (List)resultMap.get("orgPks");
        this.deleteOrgData(oriOrgPks, orgPks);
        QFilter deleteFilter = new QFilter("useorg", "in", (Object)orgPks.toArray());
        DeleteServiceHelper.delete((String)"sim_auto_issue_config", (QFilter[])deleteFilter.toArray());
        List newList = (List)resultMap.get("newList");
        if (newList.size() > 0) {
            ArrayList<DynamicObject> dbNewConfigs = new ArrayList<DynamicObject>();
            for (Object o : newList) {
                DynamicObject row = (DynamicObject)o;
                DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"sim_auto_issue_config");
                String reason = row.getString("reason");
                config.set("reason", (Object)reason);
                config.set("useorg", (Object)row.getDynamicObject("useorg"));
                config.set("createtime", (Object)new Date());
                config.set("modifytime", (Object)new Date());
                config.set("createrfield", (Object)Long.parseLong(RequestContext.get().getUserId()));
                config.set("modifierfield", (Object)Long.parseLong(RequestContext.get().getUserId()));
                dbNewConfigs.add(config);
            }
            SaveServiceHelper.save((DynamicObject[])dbNewConfigs.toArray(new DynamicObject[0]));
            StringBuilder builder = new StringBuilder();
            for (DynamicObject config : dbNewConfigs) {
                long pk = config.getDynamicObject("useorg").getLong("id");
                builder.append(pk).append(',');
            }
            this.getModel().setValue("orgpks", (Object)builder.toString());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AutoIssueConfigPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
    }

    private void deleteOrgData(String[] oriOrgPks, List<Object> orgPks) {
        if (oriOrgPks == null) {
            return;
        }
        ArrayList<Long> oriPks = new ArrayList<Long>();
        for (String string : oriOrgPks) {
            oriPks.add(Long.parseLong(string));
        }
        HashSet orgSet = new HashSet();
        Collections.addAll(orgSet, orgPks);
        ArrayList deleteOrgs = new ArrayList();
        for (Object e : oriPks) {
            if (orgSet.contains(oriOrgPks)) continue;
            deleteOrgs.add(e);
        }
        if (deleteOrgs.size() > 0) {
            QFilter deleteFilter = new QFilter("useorg", "in", (Object)deleteOrgs.toArray());
            DeleteServiceHelper.delete((String)"sim_auto_issue_config", (QFilter[])deleteFilter.toArray());
        }
    }

    private Map<String, Object> checkEntry(DynamicObjectCollection entry) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(8);
        ArrayList<Long> orgPks = new ArrayList<Long>(8);
        resultMap.put("newList", newList);
        resultMap.put("orgPks", orgPks);
        HashMap<Long, Integer> orgRowIndexMap = new HashMap<Long, Integer>();
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject item = (DynamicObject)entry.get(i);
            DynamicObject org = item.getDynamicObject("useorg");
            if (null == org) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ec4\u7ec7\u5fc5\u586b", (String)"AutoIssueConfigPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            }
            String reason = item.getString("reason");
            if (StringUtils.isBlank((CharSequence)reason)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53ef\u91cd\u5f00\u539f\u56e0\u5fc5\u586b", (String)"AutoIssueConfigPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), i + 1));
            }
            long orgId = org.getLong("id");
            orgPks.add(orgId);
            newList.add(item);
            if (orgRowIndexMap.containsKey(orgId)) {
                Integer rowSeq = (Integer)orgRowIndexMap.get(orgId);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u7ec4\u7ec7\u91cd\u590d", (String)"AutoIssueConfigPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]), rowSeq, i + 1));
            }
            orgRowIndexMap.put(org.getLong("id"), i + 1);
        }
        return resultMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("useorg".equalsIgnoreCase(name)) {
            QFilter filter = this.getFilter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(filter);
            beforeF7SelectEvent.setCustomQFilters(filters);
        }
    }
}

