/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;

public class InvoiceFileTipPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(InvoiceFileTipPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"cancel", "downloadandpush", "continuepush", "toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        switch (itemKey) {
            case "downloadandpush": {
                JSONArray allInvoice = (JSONArray)params.get("allInvoice");
                String fields = String.join((CharSequence)",", "salertaxno");
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])new QFilter("id", "in", (Object)allInvoice.toArray(new Object[0])).toArray());
                if (invoices.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f", (String)"InvoiceFileTipPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                String sellerTaxNo = invoices[0].getString("salertaxno");
                HashMap param = Maps.newHashMap();
                param.put("salertaxno", sellerTaxNo);
                boolean isNeedlogin = AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)this, (Map)param);
                LOGGER.info("\u662f\u5426\u8fdb\u884c\u4e86\u767b\u5f55" + isNeedlogin);
                if (isNeedlogin) {
                    return;
                }
                params.put("way", "downloadandpush");
                this.getView().returnDataToParent((Object)params);
                this.getView().close();
                break;
            }
            case "continuepush": {
                JSONArray canSendInvoice = (JSONArray)params.get("canSendInvoice");
                if (canSendInvoice.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u7535\u53d1\u7968\u7684ofd\u683c\u5f0f\u7684\u7248\u5f0f\u6587\u4ef6\u90fd\u7f3a\u5931\uff0c\u8bf7\u4e0b\u8f7d\u540e\u63a8\u9001", (String)"InvoiceFileTipPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                params.put("way", "continuepush");
                this.getView().returnDataToParent((Object)params);
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String tip = ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u7f3a\u5931\u4e00\u90e8\u5206\u6587\u4ef6\uff0c\u9700\u8981\u5148\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\uff0c\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\uff0c\u5982\u4e0d\u767b\u5f55\uff0c\u4ec5\u652f\u6301\u63a8\u9001\u5df2\u6709\u7684\u53d1\u7968\u6587\u4ef6", (String)"InvoiceFileTipPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String noFile = (String)params.get("noFile");
        String noPdf = (String)params.get("noPdf");
        String noXml = (String)params.get("noXml");
        this.getModel().setValue("tip", (Object)tip);
        StringBuilder tipBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)noFile)) {
            tipBuilder.append(ResManager.loadKDString((String)"\u7f3a\u5931OFD\u6587\u4ef6\u53d1\u7968\u53f7\u7801\uff1a", (String)"InvoiceFileTipPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(noFile).append(System.lineSeparator());
        }
        if (StringUtils.isNotEmpty((CharSequence)noPdf)) {
            tipBuilder.append(ResManager.loadKDString((String)"\u7f3a\u5931PDF\u6587\u4ef6\u53d1\u7968\u53f7\u7801\uff1a", (String)"InvoiceFileTipPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(noPdf).append(System.lineSeparator());
        }
        if (StringUtils.isNotEmpty((CharSequence)noXml)) {
            tipBuilder.append(ResManager.loadKDString((String)"\u7f3a\u5931XML\u6587\u4ef6\u53d1\u7968\u53f7\u7801\uff1a", (String)"InvoiceFileTipPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0])).append(noXml).append(System.lineSeparator());
        }
        if (tipBuilder.length() > 0) {
            this.getModel().setValue("checkmessage", (Object)tipBuilder.toString());
        }
    }
}

