/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcLicenseServiceHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;

public class InvoiceMessageResendPlugin
extends AbstractFormPlugin {
    private static final String BUTRESEND = "butresend";
    private static final String BUTCLOSE = "butclose";
    private static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final Log LOGGER = LogFactory.getLog(InvoiceMessageResendPlugin.class);

    public void registerListener(EventObject e) {
        Button butresend = (Button)this.getView().getControl(BUTRESEND);
        butresend.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"emaillabelsuccess"});
        view.setVisible(Boolean.FALSE, new String[]{"phonelabelsuccess"});
        view.setVisible(Boolean.FALSE, new String[]{"emaillabelfailure"});
        view.setVisible(Boolean.FALSE, new String[]{"phonelabelfailure"});
        if (customParams.size() > 0) {
            DynamicObject dObject;
            String pk = customParams.get("pks").toString();
            try {
                dObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)SIM_VATINVOICE);
            }
            catch (Exception e1) {
                LOGGER.error("\u6ca1\u6709\u67e5\u8be2\u5230\u4e3b\u952e\u4e3a\uff1a" + pk + "\u7684\u53d1\u7968" + e1.getMessage(), (Throwable)e1);
                return;
            }
            model.setValue("invoiceno", dObject.get("invoiceno"));
            model.setValue("buyername", dObject.get("buyername"));
            model.setValue("buyeremail", dObject.get("buyeremail"));
            model.setValue("buyerphone", dObject.get("buyerphone"));
            model.setValue("primarykey", (Object)pk);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BUTCLOSE)) {
            this.getView().close();
            return;
        }
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BUTRESEND)) {
            String rephone = this.getModel().getValue("buyerphone").toString();
            String email = this.getModel().getValue("buyeremail").toString();
            int invoiceMsgAuth = ImcLicenseServiceHelper.getInvoiceMsgAuth();
            if (invoiceMsgAuth == 0 && StringUtils.isNotBlank((CharSequence)rephone)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u77ed\u4fe1\u4f59\u91cf\u4e3a0\uff0c\u65e0\u6cd5\u63a8\u9001\u77ed\u4fe1\uff0c\u8bf7\u8d2d\u4e70\u77ed\u4fe1\u8bb8\u53ef\u670d\u52a1\u540e\u518d\u8fdb\u884c\u77ed\u4fe1\u63a8\u9001", (String)"InvoiceMessageResendPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rephone.equals("") && email.equals("")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7\u548c\u90ae\u7bb1\u53f7\u81f3\u5c11\u4e00\u9879", (String)"InvoiceMessageResendPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)email)) {
                String[] mails = email.split(";");
                if (mails.length > 3) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u586b\u51653\u4e2a\u90ae\u7bb1", (String)"InvoiceMessageResendPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                for (String m : mails) {
                    if (RegexUtil.isEmail((String)m)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceMessageResendPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
            try {
                InvoiceValidHelper.checkMultiMobile((String)rephone);
            }
            catch (MsgException e) {
                this.getView().showTipNotification(e.getErrorMsg(), Integer.valueOf(3000));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams.size() > 0) {
                String pk = customParams.get("pks").toString();
                DynamicObject dObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)SIM_VATINVOICE);
                PermissionHelper.checkPermission((String)"sim", (String)SIM_VATINVOICE, (long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dObject.get("orgid")), (ImcPermItemEnum)ImcPermItemEnum.BTN_RE_SEND);
                if (StringUtils.isNotBlank((CharSequence)rephone) && dObject.getInt("msgresendnum") > 4) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\u77ed\u4fe1\u91cd\u53d1\u6b21\u6570\u8d85\u8fc7\u9650\u5236", (String)"InvoiceMessageResendPlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]), dObject.getString("invoiceno")), Integer.valueOf(3000));
                    return;
                }
                boolean msgSendFlag = MsgSendAuthHelper.authEpInfoByTaxNo((String)dObject.getString("salertaxno"));
                if (!msgSendFlag && StringUtils.isNotBlank((CharSequence)rephone)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fd8\u672a\u5f00\u901a\u53d1\u7968\u4e91\u77ed\u4fe1\u670d\u52a1\uff0c\u65e0\u6cd5\u63a8\u9001\u53d1\u7968\u77ed\u4fe1\u3002\u8bf7\u5148\u5728\u5f00\u7968\u53c2\u6570\u8bbe\u7f6e/\u5f00\u7968\u5176\u4ed6\u4fe1\u606f\u8bbe\u7f6e/\u77ed\u4fe1\u63a8\u9001\u6743\u9650\u63a7\u5236\u4e2d\u5f00\u542f\u77ed\u4fe1\u670d\u52a1\u53c2\u6570", (String)"InvoiceMessageResendPlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                JSONObject pushJson = SendMsgEmailService.sendMultiMsgJson((DynamicObject)dObject, (String)rephone, (String)email);
                String pushStatus = pushJson.getString("pushStatus");
                String emailErrorMsg = pushJson.getString("emailErrorMsg");
                if (StringUtils.isNotBlank((CharSequence)emailErrorMsg)) {
                    throw new KDBizException(emailErrorMsg);
                }
                String phoneErrorMsg = pushJson.getString("phoneErrorMsg");
                if (StringUtils.isNotBlank((CharSequence)phoneErrorMsg)) {
                    throw new KDBizException(phoneErrorMsg);
                }
                this.getView().returnDataToParent((Object)pushStatus);
                this.getView().close();
            }
        }
    }
}

