/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.PrintInvoiceDTO;
import kd.imc.sim.common.dto.PrinterInfoDTO;
import kd.imc.sim.formplugin.issuing.paperprint.control.PrintInvoiceControl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoicePrinterConfirmDialogPlugin
extends AbstractFormPlugin {
    private static final String PAGE_KEY_PRINTERSELECT = "printerselect";
    private static final String PAGE_KEY_INVOICETYPENAME = "invoicetypename";
    private static final String PAGE_KEY_CHECKPRINTREVIEW = "checkprintreview";
    private static final Log LOG = LogFactory.getLog(InvoicePrinterConfirmDialogPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null) {
            PrinterInfoDTO printerInfoDTO;
            ComponentResponse componentResponse;
            String url;
            String equipmentNo = ObjectUtils.defaultIfNull(customParams.get("jqbh"), (Object)"").toString();
            String terminalNo = ObjectUtils.defaultIfNull(customParams.get("terminalno"), (Object)"").toString();
            this.getPageCache().put("jqbh", equipmentNo);
            ImmutableList.of((Object)"invoicecode", (Object)"invoiceno", (Object)"invoicetype").asList().forEach(item -> this.getModel().setValue(item, customParams.get(item)));
            this.getModel().setValue(PAGE_KEY_INVOICETYPENAME, (Object)InvoiceType.getInvoiceDescription((String)(this.getModel().getValue("invoicetype") == null ? "" : this.getModel().getValue("invoicetype").toString())));
            try {
                url = ComponentServiceHelper.getComponentRequestUrl((String)equipmentNo);
            }
            catch (KDBizException e1) {
                this.getView().showTipNotification(e1.getMessage(), Integer.valueOf(3000));
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)url) && (componentResponse = ComponentServiceHelper.doPost((String)url, (String)JSON.toJSONString((Object)new ComponentRequest(ComponentInterfaceTypeEnum.GETPRINTINFO.getCzlx(), null, null, terminalNo)), PrinterInfoDTO.class)).isSucess() && componentResponse.getResponse() != null && (printerInfoDTO = (PrinterInfoDTO)componentResponse.getResponse()) != null && printerInfoDTO.getPrinters() != null && printerInfoDTO.getDefault_printer() != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("print_size: " + printerInfoDTO.getPrinters().size());
                    LOG.info("print_default: " + printerInfoDTO.getDefault_printer());
                }
                this.bindPrinterSelect(printerInfoDTO);
            }
        }
    }

    private void bindPrinterSelect(PrinterInfoDTO printerInfoDTO) {
        HashMap map = new HashMap();
        printerInfoDTO.getPrinters().forEach(element -> {
            String cfr_ignored_0 = (String)map.put(element.get("name"), element.get("name"));
        });
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)PAGE_KEY_PRINTERSELECT, map);
        String jqbh = (String)ObjectUtils.defaultIfNull((Object)this.getView().getFormShowParameter().getCustomParam("jqbh"), (Object)"");
        String defaultPrinterName = StringUtils.defaultString((String)CacheHelper.get((String)PrintInvoiceControl.getPrinterNameCacheKey((String)PrintTypeEnum.INVOICE_PRINT.getType(), (String)jqbh)), (String)printerInfoDTO.getDefault_printer());
        if (StringUtils.isNotEmpty((CharSequence)defaultPrinterName) && map.containsKey(defaultPrinterName)) {
            this.getView().getModel().setValue(PAGE_KEY_PRINTERSELECT, (Object)defaultPrinterName);
        }
    }

    public void click(EventObject evt) {
        Object printMachine = this.getModel().getValue(PAGE_KEY_PRINTERSELECT);
        if (printMachine == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u673a\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoicePrinterConfirmDialogPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return;
        }
        CacheHelper.put((String)PrintInvoiceControl.getPrinterNameCacheKey((String)PrintTypeEnum.INVOICE_PRINT.getType(), (String)this.getPageCache().get("jqbh")), (String)printMachine.toString(), (int)2592000);
        PrintInvoiceDTO printInvoiceDTO = new PrintInvoiceDTO();
        printInvoiceDTO.setFpdm(this.getModel().getValue("invoicecode").toString());
        printInvoiceDTO.setFphm(this.getModel().getValue("invoiceno").toString());
        printInvoiceDTO.setKpzl(InvoiceType.getTypeCodeHx((String)this.getModel().getValue("invoicetype").toString()));
        printInvoiceDTO.setPrint_type("0");
        Boolean previewFlag = Boolean.valueOf(String.valueOf(this.getModel().getValue(PAGE_KEY_CHECKPRINTREVIEW)));
        printInvoiceDTO.setYlbz(previewFlag != false ? "1" : "0");
        printInvoiceDTO.setPrinter_name(ObjectUtils.defaultIfNull((Object)this.getModel().getValue(PAGE_KEY_PRINTERSELECT), (Object)"").toString());
        printInvoiceDTO.setJqbh(this.getPageCache().get("jqbh"));
        this.getView().returnDataToParent((Object)printInvoiceDTO);
        this.getView().close();
    }
}

