/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import com.google.common.collect.ImmutableSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ReducedHelper;
import kd.imc.bdm.common.util.ComboEditUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.ModelUtil;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import org.apache.commons.lang3.StringUtils;

public class IssueInvoicePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Label invoiceTitleLabel;
        String specialType;
        DynamicObject invoice;
        String invoiceCode = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam("invoiceCode")).orElse("");
        String invoiceNo = Optional.ofNullable((String)this.getView().getFormShowParameter().getCustomParam("invoiceNo")).orElse("");
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if ((StringUtils.isNotBlank((CharSequence)invoiceCode) || StringUtils.isNotBlank((CharSequence)invoiceNo)) && (invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray())) != null) {
            pkId = (Long)invoice.getPkValue();
        }
        if (pkId == null) {
            return;
        }
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_vatinvoice");
        this.dealInvoice(invoiceDynamicObject);
        this.getView().setStatus(OperationStatus.VIEW);
        ModelUtil.setModelAndEntryValueFromDynamicObject((DynamicObject)invoiceDynamicObject, (AbstractFormPlugin)this);
        if (!this.getView().getFormShowParameter().getFormId().equals("sim_vatinvoice_show_roll") && !this.getView().getFormShowParameter().getFormId().equals("sim_vatinvoice_show_all")) {
            if (!"6".equals(invoiceDynamicObject.getString("invoicestatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"cancelflex"});
            } else if (invoiceDynamicObject.get("invaliddate") != null) {
                this.getView().getModel().setValue("invaliddate", invoiceDynamicObject.get("invaliddate"));
            }
        }
        Label invoiceTypeTitleLabel = (Label)this.getView().getControl("invoicetitle");
        invoiceTypeTitleLabel.setText(InvoiceType.getInvoiceDescription((String)invoiceDynamicObject.getString("invoicetype")));
        ImmutableSet buyerTypeSet = ImmutableSet.of((Object)"2", (Object)"8", (Object)"9");
        if (!StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("buyertype")) && !buyerTypeSet.contains((Object)invoiceDynamicObject.getString("buyertype")) && InvoiceUtils.getEtcInvoiceType().contains(invoiceDynamicObject.getString("invoicetype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u7248\u5f0f\u6587\u4ef6\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"IssueInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        }
        if ("06".equals(specialType = invoiceDynamicObject.getString("specialtype"))) {
            invoiceTitleLabel = (Label)this.getView().getControl("txf");
            invoiceTitleLabel.setText(ResManager.loadKDString((String)"\u901a\u884c\u8d39", (String)"IssueInvoicePlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        if ("07".equals(specialType)) {
            invoiceTitleLabel = (Label)this.getView().getControl("txf");
            invoiceTitleLabel.setText("");
        }
    }

    private void dealInvoice(DynamicObject invoiceDynamicObject) {
        DynamicObjectCollection items2 = invoiceDynamicObject.getDynamicObjectCollection("items");
        ComboEdit comboEdit = (ComboEdit)this.getControl("taxrate");
        HashMap<String, String> addNew = new HashMap<String, String>();
        String taxedType = invoiceDynamicObject.getString("taxedtype");
        boolean isReduced = TaxedTypeEnum.subtract.getValue().equals(taxedType);
        if (AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper")) && StringUtils.isNotBlank((CharSequence)invoiceDynamicObject.getString("alletaxinvoiceno"))) {
            String allEInvoiceNo = invoiceDynamicObject.getString("alletaxinvoiceno");
            String description = String.format(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801\uff1a%1$s%2$s\u5168\u56fd\u589e\u503c\u7a0e\u53d1\u7968\u67e5\u9a8c\u5e73\u53f0\uff1a%3$s%4$s", (String)"IssueInvoicePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]), allEInvoiceNo, "\n", "\n", "https://inv-veri.chinatax.gov.cn/");
            invoiceDynamicObject.set("skm", (Object)description);
        }
        for (DynamicObject item : items2) {
            String zeroMark = item.getString("zerotaxmark");
            String taxMark = item.getString("taxpremark");
            if (("1".equals(zeroMark) || "2".equals(zeroMark)) && "1".equals(taxMark)) {
                item.set("taxrate", item.get("zzstsgl"));
                addNew.put(item.getString("zzstsgl"), item.getString("zzstsgl"));
            }
            if (!isReduced || !ReducedHelper.isSpecialCalc((Object)item.get("zzstsgl"))) continue;
            item.set("taxrate", (Object)"***");
        }
        ComboEditUtil.fillComboEdit((ComboEdit)comboEdit, addNew, (boolean)true);
    }
}

