/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.ViewUtil;

public class ScanInvoiceListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"btn_exit"});
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (evt.getItemKey()) {
            case "btn_delete": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_DELETE);
                if (rows.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ScanInvoiceListPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delete", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ScanInvoiceListPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ScanInvoiceListPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u626b\u7801\u5f00\u7968\u62ac\u5934\u4fe1\u606f\uff1f", (String)"ScanInvoiceListPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                break;
            }
            case "btn_openinvoice": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_SIM_INVOICE);
                if (rows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5f00\u7968\u3002", (String)"ScanInvoiceListPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openInvoice(rows.get(0).getPrimaryKeyValue());
                break;
            }
        }
    }

    private void openInvoice(Object pk) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("scan_pk", pk);
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, map, (String)"sim_create_invoice", (String)"sim_create_invoice");
    }

    public void closedCallBack(ClosedCallBackEvent evn) {
        String key = evn.getActionId();
        if ("sim_create_invoice".equals(key)) {
            this.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evn) {
        String callBackId = evn.getCallBackId();
        if ("btn_delete".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evn.getResult())) {
            this.delete();
        }
    }

    private void delete() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Object[] ids = rows.getPrimaryKeyValues();
        DeleteServiceHelper.delete((String)"sim_scan_invoice", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"ScanInvoiceListPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        this.refresh();
    }

    private void refresh() {
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }
}

