/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.dataimport;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import org.apache.commons.lang3.StringUtils;

public class HistoryInvoiceDataImportPopPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(HistoryInvoiceDataImportPopPlugin.class);
    private static final String FLEX_ACCOUNT = "flexaccount";

    public void afterCreateNewData(EventObject e) {
        this.setInvoiceDate();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_ACCOUNT});
    }

    public void registerListener(EventObject e) {
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("epinfo");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            String importMethod = (String)this.getModel().getValue("importmethod");
            HashMap returnMap = new HashMap(2);
            if ("2".equals(importMethod)) {
                AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanel");
                List attachmentData = panel.getAttachmentData();
                returnMap.put("attachmentpanel", attachmentData);
            }
            returnMap.put("paramData", this.getModel().getDataEntity());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private List<String> getLastYearList(int yearsAgo) {
        DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
        LocalDate currentDate = LocalDate.now();
        LocalDate fiveYearsAgo = currentDate.minusYears(yearsAgo);
        return IntStream.rangeClosed(fiveYearsAgo.getYear(), currentDate.getYear()).mapToObj(year -> yearFormatter.format(LocalDate.of(year, 1, 1))).collect(Collectors.toList());
    }

    private void setInvoiceDate() {
        List<String> lastYearList = this.getLastYearList(4);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(lastYearList.size());
        for (String yearStr : lastYearList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(yearStr));
            comboItem.setValue(yearStr);
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("invoicedate");
        comboEdit.setComboItems(comboItems);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("epinfo".equals(name)) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            Set permEpSet = OrgHelper.getUserHasPermEpPk();
            list.add(new QFilter("id", "in", (Object)permEpSet.toArray(new Object[0])));
            beforeF7SelectEvent.setCustomQFilters(list);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("epinfo".equals(name)) {
            String importMethod = (String)this.getModel().getValue("importmethod");
            boolean showAccount = false;
            DynamicObjectCollection newValueCollection = (DynamicObjectCollection)changeSet[0].getNewValue();
            if (newValueCollection != null) {
                DynamicObject dynamicObject;
                int size = newValueCollection.size();
                boolean isFile = "2".equals(importMethod);
                String downloadChannel = (String)this.getModel().getValue("downloadchannel");
                boolean isRpa = "2".equals(downloadChannel);
                if (size == 1 && !isFile && isRpa && (dynamicObject = ((DynamicObject)newValueCollection.get(0)).getDynamicObject("fbasedataId")) != null) {
                    String taxNo = dynamicObject.getString("number");
                    showAccount = this.setAccount(taxNo);
                }
                if (size > 1 && isFile) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u5f0f\u4e3a\u5bfc\u5165\u7535\u5b50\u7a0e\u5c40\u6587\u4ef6\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u9500\u65b9", (String)"HistoryInvoiceDataImportPopPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            }
            if (!showAccount) {
                this.getModel().setValue("issueaccount", null);
                ComboEdit comboEdit = (ComboEdit)this.getControl("issueaccount");
                comboEdit.setComboItems(null);
            }
            this.getView().setVisible(Boolean.valueOf(showAccount), new String[]{FLEX_ACCOUNT});
        } else if ("importmethod".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            MulComboEdit invoiceDateEdit = (MulComboEdit)this.getControl("invoicedate");
            MulComboEdit invoiceTypeEdit = (MulComboEdit)this.getControl("invoicetype");
            if ("2".equals(newValue)) {
                DynamicObjectCollection epInfos = (DynamicObjectCollection)this.getModel().getValue("epinfo");
                if (epInfos != null && epInfos.size() > 1) {
                    this.getModel().setValue("epinfo", null);
                }
                invoiceDateEdit.setMustInput(Boolean.FALSE.booleanValue());
                invoiceTypeEdit.setMustInput(Boolean.FALSE.booleanValue());
            } else {
                invoiceDateEdit.setMustInput(Boolean.TRUE.booleanValue());
                invoiceTypeEdit.setMustInput(Boolean.TRUE.booleanValue());
            }
        } else if ("downloadchannel".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            if ("1".equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ACCOUNT});
            } else {
                DynamicObject epInfo;
                String taxNo;
                DynamicObjectCollection epInfos = (DynamicObjectCollection)this.getModel().getValue("epinfo");
                if (epInfos != null && epInfos.size() == 1 && this.setAccount(taxNo = (epInfo = ((DynamicObject)epInfos.get(0)).getDynamicObject("fbasedataId")).getString("number"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ACCOUNT});
                }
            }
        } else if ("datatype".equals(name)) {
            MulComboEdit invoiceDateEdit = (MulComboEdit)this.getControl("invoicedate");
            MulComboEdit invoiceTypeEdit = (MulComboEdit)this.getControl("invoicetype");
            String importMethod = (String)this.getModel().getValue("importmethod");
            boolean isFile = "2".equals(importMethod);
            Object newValue = changeSet[0].getNewValue();
            if (isFile && "1".equals(newValue)) {
                invoiceDateEdit.setMustInput(Boolean.FALSE.booleanValue());
                invoiceTypeEdit.setMustInput(Boolean.FALSE.booleanValue());
            } else {
                invoiceDateEdit.setMustInput(Boolean.TRUE.booleanValue());
                invoiceTypeEdit.setMustInput(Boolean.TRUE.booleanValue());
            }
        }
    }

    private boolean setAccount(String taxNo) {
        boolean accountIsNotEmpty = false;
        DynamicObject accountDO = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
        if (accountDO != null) {
            DynamicObjectCollection items2;
            String defaultAccount = AllEleAuthHelper.getEpDefaultAccount((DynamicObject)accountDO, (boolean)true, (boolean)false);
            if (StringUtils.isNotEmpty((CharSequence)defaultAccount)) {
                this.getModel().setValue("issueaccount", (Object)defaultAccount);
            }
            if ((items2 = accountDO.getDynamicObjectCollection("entryentity")) != null && !items2.isEmpty()) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
                for (DynamicObject item : items2) {
                    String accountStr = item.getString("account");
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(accountStr));
                    comboItem.setValue(accountStr);
                    comboItems.add(comboItem);
                }
                ComboEdit comboEdit = (ComboEdit)this.getControl("issueaccount");
                comboEdit.setComboItems(comboItems);
                accountIsNotEmpty = true;
            }
        }
        return accountIsNotEmpty;
    }
}

