/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invalid;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.PaperInvoiceRollInfoDTO;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.helper.BwServerInvoiceHelper;
import kd.imc.sim.common.helper.HostModeInvoiceHelper;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlankInvalidInvoicePlugin
extends AbstractFormPlugin {
    private static final String PAGE_KEY_BTNOK = "btnok";
    private static final String KEY_INVOICE_COUNT = "invoicecount";
    private static final String KEY_INVOICE_TYPE = "invoicetype";
    private static final String KEY_INVOICE_CODE = "fpdm";
    private static final String KEY_START_NO = "startno";
    private static final String KEY_INVALID_START_NO = "invalidstartno";
    private static final String KEY_INVALID_END_NO = "invalidendno";
    private static final String KEY_JQBH = "jqbh";
    private static final String KEY_TERMINALNO = "terminalno";
    private static final String KEY_INVALID_COUNT = "invalidcount";
    private static final String KEY_SELLER_TAX_NO = "salertaxno";
    private static final String ABOLISH_SELF = "abolishself";
    private static final String KEY_CUSTOM_CONTROL = "customcontrolap";
    private static final Log logger = LogFactory.getLog(BlankInvalidInvoicePlugin.class);
    private static final String IMC_SIM_INVALID_CACHE = "imc_invalid_cache";
    private static final String IMC_SIM_INVALID_DEV_CACHE = "imc_invalid_dev_cache";
    private static final String BLANK_INVALID_STATUS_SUCCESS = "success";
    private static final String PAGE_CACHE_INVALID_COUNT = "page_cache_invalid_count";
    private static final String PAGE_CACHE_RETRY_START_INDEX = "retryStartIndex";
    private static final String PAGE_CACHE_INVOICE_TYPE = "page_cache_invoice_type";
    private static final String PAGE_CACHE_TAX_NO = "page_cache_tax_no";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.initView();
    }

    private void initDialogData() {
        SaleInfo saleInfo;
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CUSTOM_CONTROL});
        Long orgID = this.getOrgID(this.getModel());
        if (null == orgID) {
            return;
        }
        try {
            saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgID);
        }
        catch (Exception e) {
            this.getView().showMessage(e.getMessage());
            return;
        }
        this.getPageCache().put(PAGE_CACHE_TAX_NO, saleInfo.getSaleTaxNo());
        EquipmentUtil.initEquipmentAndTerminal((AbstractFormPlugin)this, (long)orgID, (String)saleInfo.getSaleTaxNo(), (String)KEY_JQBH, (String)KEY_TERMINALNO, (boolean)true);
        if (!StringUtils.isEmpty((CharSequence)saleInfo.getDefaultDev())) {
            this.setPaperInvoiceRoll(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), saleInfo.getDefaultDev(), saleInfo.getSaleTaxNo(), 1, saleInfo.getDefaultTerminal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPaperInvoiceRoll(String invoiceType, String devNo, String taxNo, int invalidCount, String terminalNo) {
        logger.error((Object)("\u7a7a\u767d\u4f5c\u5e9f_setPaperInvoiceRoll_" + invoiceType + "_devNo_" + devNo));
        this.getPageCache().put(KEY_JQBH, devNo);
        this.getPageCache().put(PAGE_CACHE_INVOICE_TYPE, invoiceType);
        this.getPageCache().put(KEY_SELLER_TAX_NO, taxNo);
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u4e2d,\u8bf7\u7a0d\u5019", (String)"BlankInvalidInvoicePlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0])));
        try {
            String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)devNo);
            if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType)) {
                MsgResponse msgResponse = HostModeInvoiceHelper.getInvoiceStock((String)taxNo, (String)invoiceType, (String)devNo);
                if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    this.success(invalidCount, msgResponse);
                }
            } else if ("8".equals(equipmentType)) {
                MsgResponse msgResponse = BwServerInvoiceHelper.getInvoiceStock((String)devNo, (String)terminalNo, (String)invoiceType, (String)devNo, (String)taxNo);
                if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    this.success(invalidCount, msgResponse);
                }
            } else if (EquipmentType.isLyServer((String)equipmentType)) {
                MsgResponse msgResponse = LyServerInvoiceHelper.getInvoiceStock((String)devNo, (String)terminalNo, (String)invoiceType, (String)devNo, (String)taxNo);
                if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
                    this.success(invalidCount, msgResponse);
                }
            } else if ("3".equals(equipmentType)) {
                MsgResponse msgResponse = new MsgResponse();
                String invoiceCode = RandomString.nextString((int)12, (boolean)true, (boolean)false);
                msgResponse.setRespData("{\"remainder\":\"500\", \"invoice_code\":" + invoiceCode + ", \"invoice_num\":\"00000001\"}");
                this.success(invalidCount, msgResponse);
            } else {
                PaperInvoiceRollInfoDTO paperInvoiceRollInfoDTO = EquipmentHelper.queryComponentEquipmentInfo((String)invoiceType, (String)devNo, (int)0);
                if (paperInvoiceRollInfoDTO != null) {
                    this.showData(paperInvoiceRollInfoDTO.getInfo().getRemainder(), paperInvoiceRollInfoDTO.getInfo().getInvoice_code(), paperInvoiceRollInfoDTO.getInfo().getInvoice_num(), invalidCount);
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25 %s", (String)"BlankInvalidInvoicePlugin_13", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void success(int invalidCount, MsgResponse msgResponse) {
        String res = msgResponse.getRespData();
        JSONObject retJson = JSONObject.parseObject((String)res);
        this.showData(retJson.getString("remainder"), retJson.getString("invoice_code"), retJson.getString("invoice_num"), invalidCount);
    }

    private void showData(String stockNum, String invoiceCode, String invoiceNum, int invalidCount) {
        this.getView().getModel().setValue(KEY_INVOICE_COUNT, (Object)stockNum);
        this.getView().getModel().setValue(KEY_INVOICE_CODE, (Object)invoiceCode);
        this.getView().getModel().setValue(KEY_START_NO, (Object)invoiceNum);
        this.getView().getModel().setValue(KEY_INVALID_START_NO, (Object)invoiceNum);
        this.getView().getModel().setValue(KEY_INVALID_END_NO, (Object)invoiceNum);
        this.getView().getModel().setValue(KEY_INVALID_COUNT, (Object)invalidCount);
        int endNo = Integer.parseInt("1" + invoiceNum) + invalidCount - 1;
        String endNoStr = String.valueOf(endNo);
        this.getView().getModel().setValue(KEY_INVALID_END_NO, (Object)endNoStr.substring(1));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PAGE_KEY_BTNOK});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (PAGE_KEY_BTNOK.equals(source.getKey())) {
            Long orgID = this.getOrgID(this.getModel());
            if (null == orgID) {
                return;
            }
            PermissionHelper.checkPermission((String)"sim", (String)"sim_invoice_valid_list", (long)orgID, (ImcPermItemEnum)ImcPermItemEnum.IMC_EMPTY_INVALID);
            String invoiceCode = (String)this.getView().getModel().getValue(KEY_INVOICE_CODE);
            String invoiceNo = (String)this.getView().getModel().getValue(KEY_START_NO);
            Object invoiceCount = this.getView().getModel().getValue(KEY_INVOICE_COUNT);
            Object invalidCount = this.getView().getModel().getValue(KEY_INVALID_COUNT);
            if (StringUtils.isEmpty((CharSequence)invoiceCode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a7a\u767d\u4f5c\u5e9f\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"BlankInvalidInvoicePlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a7a\u767d\u4f5c\u5e9f\u53d1\u7968\u8d77\u59cb\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"BlankInvalidInvoicePlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            String jqbh = this.getPageCache().get(KEY_JQBH);
            String terminalNo = (String)this.getModel().getValue(KEY_TERMINALNO);
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrg((Long)orgID);
            EquipmentHelper.checkTerminalNo((String)jqbh, (String)saleInfo.getSaleTaxNo(), (String)terminalNo);
            int invoiceCountInteger = Integer.parseInt(invoiceCount.toString());
            int invalidCountInteger = Integer.parseInt(invalidCount.toString());
            if (invalidCountInteger > invoiceCountInteger) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u4efd\u6570\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u5269\u4f59\u4efd\u6570", (String)"BlankInvalidInvoicePlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(PAGE_CACHE_INVALID_COUNT, Integer.toString(invalidCountInteger));
            String lockKey = IssueInvoiceMqHelper.getIssueInvoiceLockKey((String)saleInfo.getSaleTaxNo(), (String)this.getPageCache().get(KEY_JQBH));
            try (DLock lock = DLock.create((String)lockKey);){
                if (!lock.tryLock(1000L)) {
                    logger.error((Object)"\u7a7a\u767d\u4f5c\u5e9f\u65f6\u6b63\u5728\u5f00\u7968");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u5907\u6b63\u5728\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u7a0d\u5019", (String)"BlankInvalidInvoicePlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.setPaperInvoiceRoll(this.getPageCache().get(PAGE_CACHE_INVOICE_TYPE), this.getView().getModel().getValue(KEY_JQBH).toString(), this.getPageCache().get(KEY_SELLER_TAX_NO), invalidCountInteger, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CUSTOM_CONTROL});
            this.bindCustomViewValue(1, 1, invoiceCode, invoiceNo, "", "");
            ThreadPools.executeOnce((String)"for:BlankInvalidInvoiceSuccessPlugin", () -> this.foreachInvalidRequest(1));
        }
    }

    private Long getOrgID(IDataModel model) {
        Object value = model.getValue("org");
        if (null == value) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"BlankInvalidInvoicePlugin_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            return null;
        }
        Long orgId = value instanceof DynamicObject ? Long.valueOf(((DynamicObject)value).getLong("id")) : (Long)value;
        return orgId;
    }

    private void bindCustomViewValue(int index, int timeFlag, String invoiceCode, String invoiceNo, String status, String description) {
        logger.error((Object)("\u7a7a\u767d\u4f5c\u5e9f" + index));
        HashMap<String, Object> showMap = new HashMap<String, Object>(8);
        showMap.put("eventKey", "updatePrint");
        showMap.put("invoicecode", invoiceCode);
        showMap.put("invoiceno", invoiceNo);
        showMap.put("timeflag", timeFlag);
        showMap.put("printtype", ResManager.loadKDString((String)"\u7a7a\u767d\u4f5c\u5e9f", (String)"BlankInvalidInvoicePlugin_7", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        showMap.put("time", System.currentTimeMillis());
        if ("failed".equals(status)) {
            String invalidCount = this.getPageCache().get(PAGE_CACHE_INVALID_COUNT);
            int successCount = index - 1;
            int blankCount = Integer.parseInt(invalidCount) - successCount;
            this.getPageCache().put(PAGE_CACHE_RETRY_START_INDEX, String.valueOf(index));
            showMap.put("printseq", String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5f20\u7a7a\u767d\u4f5c\u5e9f\u5931\u8d25\uff0c\u4f5c\u5e9f\u6210\u529f%2$s\u5f20\uff0c\u5269\u4f59%3$s\u5f20\u672a\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u8bd5\u6216\u9000\u51fa...", (String)"BlankInvalidInvoicePlugin_14", (String)"imc-sim-formplugin", (Object[])new Object[0]), index, successCount, blankCount));
            showMap.put("printreason", description);
            showMap.put("status", "failed");
            CacheHelper.remove((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE));
        } else {
            showMap.put("printseq", index == 0 ? ResManager.loadKDString((String)"\u5f00\u59cb\u51c6\u5907\u7a7a\u767d\u4f5c\u5e9f", (String)"BlankInvalidInvoicePlugin_9", (String)"imc-sim-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6b63\u5728\u7a7a\u767d\u4f5c\u5e9f\u7b2c%s\u5f20\u53d1\u7968...", (String)"BlankInvalidInvoicePlugin_10", (String)"imc-sim-formplugin", (Object[])new Object[0]), index));
            showMap.put("status", "ok");
        }
        CustomControl printControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
        printControl.setData(showMap);
    }

    public void foreachInvalidRequest(int startIndex) {
        String invoiceType = this.getPageCache().get(PAGE_CACHE_INVOICE_TYPE);
        String devNo = this.getPageCache().get(KEY_JQBH);
        String taxNo = this.getPageCache().get(KEY_SELLER_TAX_NO);
        Integer invalidCount = (Integer)this.getView().getModel().getValue(KEY_INVALID_COUNT);
        Object invoiceNo = this.getView().getModel().getValue(KEY_START_NO);
        Object terminalNo = this.getView().getModel().getValue(KEY_TERMINALNO);
        logger.error((Object)String.format("\u7a7a\u767d\u4f5c\u5e9f_invoiceType_%s_devNo_%s_startIndex_%d", invoiceType, devNo, startIndex));
        logger.error((Object)String.format("\u7a7a\u767d\u4f5c\u5e9f_invalidCount_%d", invalidCount));
        CacheHelper.put((String)(IMC_SIM_INVALID_DEV_CACHE + devNo), (String)devNo);
        Object invoiceCode = this.getView().getModel().getValue(KEY_INVOICE_CODE);
        this.doBlank(startIndex, invoiceType, devNo, taxNo, invalidCount, invoiceNo, terminalNo, invoiceCode);
    }

    public void doBlank(int startIndex, String invoiceType, String devNo, String taxNo, Integer invalidCount, Object invoiceNo, Object terminalNo, Object invoiceCode) {
        boolean isFailed = false;
        JSONObject json = new JSONObject();
        ArrayList<String> invoiceNoList = new ArrayList<String>();
        String equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)devNo);
        for (int i = startIndex; i <= invalidCount; ++i) {
            json.put("index", (Object)i);
            json.put("invoicecode", invoiceCode);
            String invoiceNoStr = "1" + invoiceNo;
            int no = Integer.parseInt(invoiceNoStr) + (i - 1);
            String substring = String.valueOf(no).substring(1);
            json.put("invoiceno", (Object)substring);
            invoiceNoList.add(substring);
            try {
                MsgResponse msgResponse;
                String dqInvoiceCode;
                CacheHelper.put((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE), (String)json.toJSONString());
                if (EquipmentHelper.isBlockChainOrHostModeDevice((String)equipmentType)) {
                    MsgResponse msgResponse2 = HostModeInvoiceHelper.blankInvoiceAbolish((String)taxNo, (String)invoiceType, (String)devNo);
                    logger.info((Object)("\u7a7a\u767d\u4f5c\u5e9f\u7ed3\u679c:" + msgResponse2.getRespData()));
                    if (ErrorType.SUCCESS.getCode().equals(msgResponse2.getErrorCode())) continue;
                    throw new MsgException(msgResponse2.getErrorCode(), ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25", (String)"BlankInvalidInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if ("8".equals(equipmentType)) {
                    dqInvoiceCode = this.getView().getModel().getValue(KEY_INVOICE_CODE) == null ? "" : this.getView().getModel().getValue(KEY_INVOICE_CODE).toString();
                    msgResponse = BwServerInvoiceHelper.blankInvoiceAbolish((String)taxNo, (String)dqInvoiceCode, (String)invoiceType, (String)substring, (String)devNo, (String)(terminalNo == null ? "" : terminalNo.toString()));
                    logger.info((Object)("\u7a7a\u767d\u4f5c\u5e9f\u7ed3\u679c:" + msgResponse.getRespData()));
                    if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) continue;
                    throw new MsgException(msgResponse.getErrorCode(), ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25", (String)"BlankInvalidInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if (EquipmentType.isLyServer((String)equipmentType)) {
                    dqInvoiceCode = this.getView().getModel().getValue(KEY_INVOICE_CODE) == null ? "" : this.getView().getModel().getValue(KEY_INVOICE_CODE).toString();
                    msgResponse = LyServerInvoiceHelper.blankInvoiceAbolish((String)taxNo, (String)dqInvoiceCode, (String)invoiceType, (String)substring, (String)devNo);
                    logger.info((Object)("\u7a7a\u767d\u4f5c\u5e9f\u7ed3\u679c:" + msgResponse.getRespData()));
                    if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) continue;
                    throw new MsgException(msgResponse.getErrorCode(), ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25", (String)"BlankInvalidInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
                if ("3".equals(equipmentType)) {
                    try {
                        Thread.sleep(3000L);
                        logger.info((Object)"\u865a\u62dfukey\u76f4\u63a5\u6210\u529f");
                    }
                    catch (Exception dqInvoiceCode2) {}
                    continue;
                }
                JSONObject result = JSONObject.parseObject((String)"{}");
                JSONObject param = JSONObject.parseObject((String)"{}");
                result.put("czlx", (Object)"6");
                result.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)((String)terminalNo)) ? "" : (String)terminalNo));
                param.put("kpzl", (Object)InvoiceType.getTypeCodeHx((String)invoiceType));
                param.put("zfr", (Object)RequestContext.get().getUserName());
                result.put("sjd", (Object)param);
                String url = ComponentServiceHelper.getComponentRequestUrl((String)devNo);
                logger.info((Object)("\u7a7a\u767d\u4f5c\u5e9f\u8bf7\u6c42\u62a5\u6587:" + result.toJSONString()));
                String data = HttpClientUtils.postjson((String)url, null, (String)result.toJSONString(), (int)10000, (int)15000);
                JSONObject jsonObject = JSONObject.parseObject((String)data);
                logger.info((Object)("\u7a7a\u767d\u4f5c\u5e9f\u7ed3\u679c:" + jsonObject.toJSONString()));
                if ("6011".equals(jsonObject.getString("errcode"))) continue;
                throw new MsgException(jsonObject.getString("errcode"), ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25", (String)"BlankInvalidInvoicePlugin_11", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Object)"\u7a7a\u767d\u4f5c\u5e9f\u5931\u8d25", (Throwable)e);
                json.put("status", (Object)"failed");
                isFailed = true;
                CacheHelper.put((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE), (String)json.toJSONString());
                break;
            }
        }
        if (!isFailed) {
            String abolishself;
            JSONObject object = new JSONObject();
            object.put("num", (Object)invalidCount);
            object.put("invoicecode", this.getView().getModel().getValue(KEY_INVOICE_CODE));
            object.put("invoiceno", this.getView().getModel().getValue(KEY_INVALID_START_NO));
            object.put(KEY_INVOICE_TYPE, (Object)invoiceType);
            object.put("devno", (Object)devNo);
            object.put("invoiceendno", this.getView().getModel().getValue(KEY_INVALID_END_NO));
            object.put("status", (Object)BLANK_INVALID_STATUS_SUCCESS);
            object.put("invoiceNolist", invoiceNoList);
            Object abolisReason = this.getModel().getValue("abolishreason");
            if ("\u5176\u4ed6".equals(abolisReason) && StringUtils.isNotBlank((CharSequence)(abolishself = this.getModel().getValue(ABOLISH_SELF).toString()))) {
                abolisReason = abolishself;
            }
            object.put("abolisReason", abolisReason);
            CacheHelper.put((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE), (String)object.toJSONString());
        }
        CacheHelper.remove((String)(IMC_SIM_INVALID_DEV_CACHE + devNo));
    }

    public void customEvent(CustomEventArgs e) {
        String eventName;
        switch (eventName = e.getEventName()) {
            case "foreachData": {
                String data = CacheHelper.get((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE));
                logger.error((Object)("\u7a7a\u767d\u4f5c\u5e9f_foreachData_" + data));
                if (!StringUtils.isNotBlank((CharSequence)data)) break;
                JSONObject dObject = JSONObject.parseObject((String)data);
                String status = dObject.getString("status");
                if (BLANK_INVALID_STATUS_SUCCESS.equals(status)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CUSTOM_CONTROL});
                    HashMap customParams = new HashMap(dObject);
                    ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"sim_blank_invalid_success", (String)"sim_blank_invalid_success");
                    CacheHelper.remove((String)(RequestContext.get().getUserName() + IMC_SIM_INVALID_CACHE));
                    this.blankInvoiceInsert(dObject);
                    break;
                }
                this.bindCustomViewValue(dObject.getInteger("index"), 1, dObject.getString("invoicecode"), dObject.getString("invoiceno"), dObject.getString("status"), dObject.getString("description"));
                break;
            }
            case "closePrint": 
            case "exit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CUSTOM_CONTROL});
                this.setPaperInvoiceRoll(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), this.getView().getModel().getValue(KEY_JQBH).toString(), this.getPageCache().get(KEY_SELLER_TAX_NO), 1, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
                break;
            }
            case "retry": {
                ThreadPools.executeOnce((String)"for:BlankInvalidInvoiceSuccessRetry", () -> this.foreachInvalidRequest(Integer.parseInt(this.getPageCache().get(PAGE_CACHE_RETRY_START_INDEX))));
            }
        }
    }

    public void blankInvoiceInsert(JSONObject json) {
        String invoiceNolist = json.getString("invoiceNolist");
        String invoicecode = json.getString("invoicecode");
        String invoicetype = json.getString(KEY_INVOICE_TYPE);
        String devno = json.getString("devno");
        String termianlNo = json.getString(KEY_TERMINALNO);
        String abolisReason = json.getString("abolisReason");
        Long orgID = this.getOrgID(this.getModel());
        if (null == orgID) {
            return;
        }
        this.saveBlankInvoice(invoiceNolist, invoicecode, invoicetype, devno, termianlNo, abolisReason, orgID);
    }

    public void saveBlankInvoice(String invoiceNolist, String invoicecode, String invoicetype, String devno, String termianlNo, String abolisReason, Long orgID) {
        SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrg((Long)orgID);
        JSONArray invArr = JSONArray.parseArray((String)invoiceNolist);
        ArrayList<DynamicObject> dList = new ArrayList<DynamicObject>(invArr.size());
        for (Object invoiceNo : invArr) {
            DynamicObject vatInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            vatInvoice.set("invoicecode", (Object)invoicecode);
            vatInvoice.set("invoiceno", invoiceNo);
            vatInvoice.set(KEY_INVOICE_TYPE, (Object)invoicetype);
            vatInvoice.set(KEY_JQBH, (Object)devno);
            vatInvoice.set(KEY_TERMINALNO, (Object)termianlNo);
            vatInvoice.set("issuetype", (Object)"0");
            vatInvoice.set("buyertype", (Object)"6");
            vatInvoice.set("invoicestatus", (Object)"6");
            vatInvoice.set("drawer", (Object)RequestContext.get().getUserName());
            vatInvoice.set("createtime", (Object)new Date());
            vatInvoice.set("issuetime", (Object)new Date());
            vatInvoice.set("abolishtype", (Object)"1");
            vatInvoice.set("abolishreason", (Object)abolisReason);
            vatInvoice.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            vatInvoice.set("salername", (Object)saleInfoByOrg.getSaleName());
            vatInvoice.set(KEY_SELLER_TAX_NO, (Object)saleInfoByOrg.getSaleTaxNo());
            vatInvoice.set("orgid", (Object)orgID);
            dList.add(vatInvoice);
        }
        SaveServiceHelper.save((DynamicObject[])dList.toArray(new DynamicObject[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name = e.getProperty().getName()) {
            case "jqbh": {
                this.jqbhChange(newValue);
                break;
            }
            case "terminalno": {
                this.terminalnoChange(newValue);
                break;
            }
            case "invoicetype": {
                this.invoiceTypeChange(newValue);
                break;
            }
            case "invalidcount": {
                this.invalidCountChange(newValue);
                break;
            }
            case "abolishreason": {
                this.abolishReasonChange(this.getView());
                break;
            }
            case "org": {
                this.initView();
            }
        }
    }

    private void initView() {
        this.initDialogData();
        this.getModel().setValue("abolishreason", (Object)"");
        this.getModel().setValue(ABOLISH_SELF, (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{ABOLISH_SELF});
        HashMap<String, String> titleMap = new HashMap<String, String>(4);
        titleMap.put("eventkey", "loadData");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, titleMap, (String)KEY_CUSTOM_CONTROL);
    }

    private void abolishReasonChange(IFormView view) {
        String abolisReason = view.getModel().getValue("abolishreason").toString();
        if ("\u5176\u4ed6".equals(abolisReason)) {
            view.setVisible(Boolean.TRUE, new String[]{ABOLISH_SELF});
        } else {
            view.getModel().setValue(ABOLISH_SELF, (Object)"");
            view.setVisible(Boolean.FALSE, new String[]{ABOLISH_SELF});
        }
    }

    private void invalidCountChange(Object newValue) {
        if (null == newValue) {
            return;
        }
        Integer invalidCount = (Integer)newValue;
        Object startNo = this.getView().getModel().getValue(KEY_START_NO);
        int endNo = Integer.parseInt("1" + startNo) + invalidCount - 1;
        String endNoStr = String.valueOf(endNo);
        this.getView().getModel().setValue(KEY_INVALID_END_NO, (Object)endNoStr.substring(1));
    }

    private void invoiceTypeChange(Object newValue) {
        this.clearDropView();
        if ("0".equals(newValue)) {
            this.getPageCache().put(KEY_INVOICE_TYPE, InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode());
            this.setPaperInvoiceRoll(InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), this.getPageCache().get(KEY_JQBH), this.getPageCache().get(KEY_SELLER_TAX_NO), 1, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
        } else if ("1".equals(newValue)) {
            this.getPageCache().put(KEY_INVOICE_TYPE, InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode());
            this.setPaperInvoiceRoll(InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), this.getPageCache().get(KEY_JQBH), this.getPageCache().get(KEY_SELLER_TAX_NO), 1, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
        }
    }

    private void terminalnoChange(Object newValue) {
        String equipmentType;
        String terminalno = String.valueOf(newValue);
        String invoiceType = this.getPageCache().get(PAGE_CACHE_INVOICE_TYPE);
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            invoiceType = InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
        }
        if ("8".equals(equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)((String)this.getModel().getValue(KEY_JQBH)))) && !StringUtils.isEmpty((CharSequence)terminalno)) {
            this.setPaperInvoiceRoll(invoiceType, (String)this.getModel().getValue(KEY_JQBH), this.getPageCache().get(KEY_SELLER_TAX_NO), 1, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
        }
    }

    private void jqbhChange(Object newValue) {
        String equipmentType;
        String jqbh = (String)newValue;
        this.getPageCache().put(KEY_JQBH, jqbh);
        if (StringUtils.isEmpty((CharSequence)jqbh)) {
            this.clearDropView();
            return;
        }
        EquipmentUtil.showTerminalNo((AbstractFormPlugin)this, (String)jqbh, (String)this.getPageCache().get(PAGE_CACHE_TAX_NO), (String)KEY_TERMINALNO, (boolean)false);
        String invoiceType = this.getPageCache().get(PAGE_CACHE_INVOICE_TYPE);
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            invoiceType = InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode();
        }
        if (!"8".equals(equipmentType = EquipmentHelper.getEquipmentTypeByNo((String)jqbh))) {
            this.setPaperInvoiceRoll(invoiceType, newValue.toString(), this.getPageCache().get(KEY_SELLER_TAX_NO), 1, this.getView().getModel().getValue(KEY_TERMINALNO) == null ? "" : this.getView().getModel().getValue(KEY_TERMINALNO).toString());
        }
    }

    private void clearDropView() {
        this.getView().getModel().setValue(KEY_INVOICE_COUNT, null);
        this.getView().getModel().setValue(KEY_INVOICE_CODE, null);
        this.getView().getModel().setValue(KEY_START_NO, null);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        this.getView().close();
    }
}

