/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import org.apache.commons.collections.CollectionUtils;

public class SimBillCenterCallBackTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SimBillCenterCallBackTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramsMap) throws KDException {
        logger.info("SimBillCenterCallBackTask\uff0c\u56de\u8c03\u901a\u77e5\u4efb\u52a1\u7684\u529f\u80fd\uff01");
        try (DLock lock = DLock.create((String)SimBillCenterCallBackTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                logger.error("SimBillCenterCallBackTask-\u5f53\u524d\u5b9a\u65f6\u4efb\u52a1\u7684\u7ebf\u7a0b\u672a\u83b7\u53d6\u5230\u76f8\u5173\u7684\u9501\u673a\u5236\uff01");
                return;
            }
            logger.info("SimBillCenterCallBackTask, paramsMap:{}", paramsMap);
            String systemCode = (String)paramsMap.get("systemCode");
            String billNo = (String)paramsMap.get("billNo");
            String callbackNum = (String)paramsMap.get("callBackNum");
            logger.info("SimBillCenterCallBackTask, systemCode:{}, billNo:{}, callbackNum:{}", new Object[]{systemCode, billNo, callbackNum});
            this.dealNoticeCallBackStatusMethod(systemCode, billNo);
            this.dealNoticeSendWarnEmailMethod(systemCode, billNo, callbackNum);
        }
    }

    private void dealNoticeSendWarnEmailMethod(String systemCode, String billNo, String callbackNum) {
        int callback_num = 3;
        if (StringUtils.isNotBlank((CharSequence)callbackNum)) {
            callback_num = Integer.parseInt(callbackNum);
        }
        QFilter qFilter = new QFilter("callback_num", ">=", (Object)callback_num).and("callback_status", "=", (Object)"2");
        if (StringUtils.isNotEmpty((CharSequence)systemCode)) {
            qFilter = qFilter.and("system_code", "=", (Object)systemCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            qFilter = qFilter.and("billno", "=", (Object)billNo);
        }
        Date startDate = DateUtils.getDayStart((Date)new Date());
        Date endDate = DateUtils.getDayEnd((Date)new Date());
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        DynamicObjectCollection dynamicObjectCollection = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod(qFilter = qFilter.and("modifytime", ">=", (Object)startDate).and("modifytime", "<", (Object)endDate));
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            logger.info("dealNoticeSendWarnEmailMethod, dynamicObjectCollection\u5927\u5c0f:{}", (Object)dynamicObjectCollection.size());
            String receiveEmail = ImcConfigUtil.getValue((String)CacheKeyEnum.EMPLOYEE_WARN_EMAIL.getConfigType(), (String)CacheKeyEnum.EMPLOYEE_WARN_EMAIL.getConfigKey());
            String emailTitle = "\u672a\u67e5\u8be2\u5230";
            String emailContent = this.buildEmailHtmlTempMethod(dynamicObjectCollection, receiveEmail);
            SendMsgEmailService sendMsgEmailService = new SendMsgEmailService();
            DynamicObject emailObject = this.getEmailTemplateObjectMethod();
            if (emailObject == null) {
                logger.error("dealNoticeSendWarnEmailMethod, \u672a\u5339\u914d\u5230\u6307\u5b9a\u90ae\u4ef6\u6a21\u677f\u89c4\u5219\uff01");
                return;
            }
            SendMsgEmailService.sendEmailBySelf((String)emailContent, (String)receiveEmail, (DynamicObject)emailObject, (String)emailTitle);
        }
    }

    private String buildEmailHtmlTempMethod(DynamicObjectCollection dynamicObjectCollection, String receiveEmail) {
        StringBuilder stringBuilder = new StringBuilder();
        String tips1 = ResManager.loadKDString((String)"\u9884\u8b66\u901a\u77e5\u90ae\u4ef6", (String)"SimBillCenterCallBack_01", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String headerHtml = "<html lang=\"en\"><head>\n<meta charset=\"gbk\" />\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n<title>\n" + tips1 + "</title>\n<style type=\"text/css\">\nbody {\nwidth: 100%;\nbackground: #f8f8f8;\npadding: 0;\nmargin: 0;\n}\np {\nmargin: 0;\npadding: 0;\n}\n.container {\nwidth: 90%;\nmin-width: 1200px;\nmargin: 0 auto;\nbackground: #fff;\n}\n.header {\nheight: 50px;\nbackground: #5582f3;\nfont-size: 20px;\nfont-weight: 600;\ncolor: #fff;\ndisplay: flex;\nalign-items: center;\njustify-content: center;\n}\n.content {\nwidth: 75%;\nmargin: 0 auto;\n}\n.nav {\nfont-size: 16px;\nfont-weight: 600;\ncolor: #212121;\nmargin-top: 40px;\nmargin-bottom: 12px;\n}\n.tips {\nfont-size: 14px;\nfont-weight: 400;\ncolor: #212121;\nmargin-bottom: 4px;\nmargin-left:30px;\n}\n.title {\nfont-size: 18px;\nfont-weight: 600;\ncolor: #212121;\n}\n.table {\nwidth: 100%;\nfont-size: 14px;\nline-height: 1.5;\nborder-top: 1px solid #d9d9d9;\nborder-left: 1px solid #d9d9d9;\nborder-right: 1px solid #d9d9d9;\nmargin-top: 8px;\nmargin-bottom:5px;\n}\n.table th {\nheight: 38px;\ntext-align: left;\npadding-left: 12px;\nfont-size: 12px;\ncolor: #212121;\nfont-weight: 400;\nborder-bottom: 1px solid #d9d9d9;\n}\n.table-title {\nbackground: #f2f2f2;\nborder-right: 1px solid #d9d9d9;\n}\n.table-title:last-child {\nborder-right: none;\n}\n.bottom{\nheight: 50px;\nbackground: #5582f3;\nfont-size: 20px;\nfont-weight: 600;\ncolor: #fff;\ndisplay: flex;\nalign-items: center;\njustify-content: center;\n}\n</style>\n</head>";
        String tips2 = ResManager.loadKDString((String)"\u5c0a\u656c\u7684", (String)"SimBillCenterCallBack_02", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String tips3 = ResManager.loadKDString((String)"\u60a8\u597d\uff01\u672c\u6b21\u7edf\u8ba1\u56de\u8c03\u5931\u8d25\u7684\u7ed3\u679c\u5982\u4e0b:", (String)"SimBillCenterCallBack_03", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String tips4 = ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801", (String)"SimBillCenterCallBack_04", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String tips5 = ResManager.loadKDString((String)"\u7cfb\u7edf\u540d\u79f0", (String)"SimBillCenterCallBack_05", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String tips6 = ResManager.loadKDString((String)"\u8d26\u5355\u4e2d\u5fc3\u7f16\u53f7", (String)"SimBillCenterCallBack_06", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String tips7 = ResManager.loadKDString((String)"\u5931\u8d25\u6b21\u6570", (String)"SimBillCenterCallBack_07", (String)"imc-sim-formplugin", (Object[])new Object[0]);
        String bodyStartHtml = "<body>\n<div class='container'>\n<div class='header'>" + tips1 + "</div>\n<div class='content'>\n<p class='nav'>" + tips2 + receiveEmail + ":</p>\n<p class='tips'>" + tips3 + "</p>\n<table class='table' border=\"1\" cellspacing='0'>\n<tr>\n<th class='table-title'>" + tips4 + "</th>\n<th class='table-title'>" + tips5 + "</th>\n<th class='table-title'>" + tips6 + "</th>\n<th class='table-title'>" + tips7 + "</th>\n</tr>";
        StringBuilder contentHtmlBuilder = new StringBuilder();
        for (DynamicObject billCenterObject : dynamicObjectCollection) {
            String systemCode = billCenterObject.getString("system_code");
            String systemName = billCenterObject.getString("system_name");
            String billNo = billCenterObject.getString("billno");
            int callBackNum = billCenterObject.getInt("callback_num");
            contentHtmlBuilder.append("<tr><td class=\"col35\">").append(systemCode).append("</td>");
            contentHtmlBuilder.append("<td class=\"col35\">").append(systemName).append("</td>");
            contentHtmlBuilder.append("<td class=\"col35\">").append(billNo).append("</td>");
            contentHtmlBuilder.append("<td class=\"col35\">").append(callBackNum).append("</td></tr>");
        }
        String contentHtml = contentHtmlBuilder.toString();
        String bodyEndHtml = "</table>\n</div>\n<div class='bottom'></div>\n</div>\n</body>\n</html>";
        stringBuilder.append(headerHtml).append(bodyStartHtml).append(contentHtml).append(bodyEndHtml);
        return stringBuilder.toString();
    }

    private void dealNoticeCallBackStatusMethod(String systemCode, String billNo) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService;
        DynamicObjectCollection dynamicObjectCollection;
        QFilter qFilter = new QFilter("callback_status", "=", (Object)"2");
        if (StringUtils.isNotEmpty((CharSequence)systemCode)) {
            qFilter = qFilter.and("system_code", "=", (Object)systemCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            qFilter = qFilter.and("billno", "=", (Object)billNo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjectCollection = (billCenterInvoiceCommonService = new BillCenterInvoiceCommonService()).dealCheckBillCenterDataMethod(qFilter)))) {
            logger.info("dealNoticeCallBackStatusMethod, dynamicObjectCollection\u5927\u5c0f:{}", (Object)dynamicObjectCollection.size());
            BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
            for (DynamicObject billCenterObject : dynamicObjectCollection) {
                systemCode = billCenterObject.getString("system_code");
                DynamicObject billLogObject = billCenterInvoiceLogService.dealLoadInvoiceLogMethod(systemCode, billNo = billCenterObject.getString("billno"));
                if (billLogObject == null) continue;
                systemCode = billLogObject.getString("system_code");
                String innerParam = billLogObject.getString("inner_param_tag");
                billNo = billLogObject.getString("billno");
                String operateType = billLogObject.getString("operate_type");
                if ("1".equals(operateType) || StringUtils.isEmpty((CharSequence)systemCode) || StringUtils.isEmpty((CharSequence)innerParam) || StringUtils.isEmpty((CharSequence)billNo)) continue;
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("systemCode", (Object)systemCode);
                    jsonObject.put("innerParam", (Object)innerParam);
                    jsonObject.put("billNo", (Object)billNo);
                    jsonObject.put("opType", (Object)operateType);
                    logger.info("dealNoticeCallBackStatusMethod, \u624b\u5de5\u63a8\u9001\u56de\u8c03\u901a\u77e5\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString((Object)jsonObject));
                    ExternalSystemDataHandler.dealPushCallBackStatusToFrontSystem((JSONObject)jsonObject);
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u56de\u8c03\u7684\u7ed3\u679c\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)e.getMessage());
                }
            }
        }
    }

    private DynamicObject getEmailTemplateObjectMethod() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("YXSZ000002");
        list.add("CHIMELONG");
        QFilter emailFilter = new QFilter("number", "in", list);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_mail", (boolean)true);
        DynamicObject emailObject = BusinessDataServiceHelper.loadSingle((String)"bdm_mail", (String)selectProperties, (QFilter[])emailFilter.toArray());
        return emailObject;
    }
}

