/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.task;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.lqpt.model.request.collect.InvoiceStatusQueryRequest;
import kd.imc.bdm.lqpt.service.collect.InvoiceCollectionService;
import kd.imc.sim.common.dto.syncinvoice.SyncQueryInvoiceDTO;
import kd.imc.sim.common.utils.CollectionsUtils;
import kd.imc.sim.common.utils.DateUtils;
import kd.imc.sim.formplugin.invoicebatch.TaxInvoiceImportUtil;
import kd.imc.sim.formplugin.issuing.control.InvoiceSyncControl;
import kd.imc.sim.schedule.syncinvoice.SyncDevInvoiceTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class SimHisInvDataImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SimHisInvDataImportTask.class);
    private static final String TASK_NAME_PRE = "SimHisInvDataImportTask_";
    private static final String TASK_NAME_FILE = "SimHisInvDataImportTask_FILE";
    private static final String INVOICE_FIELDS = "invoicecode,invoiceno,invoicetype,salertaxno,buyertaxno,specialtype,issuetime";
    private static final int PAGE_SIZE = 200;
    private static final String QUERY_STATUS_SUCCESS_SQL = "select count(1) as count from t_sim_his_inv_data_imp_st where fexecutionstatus = '%s' and fimportentryid = %s";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)"SimHisInvDataImportTask_lock");){
            if (lock.tryLock(1000L)) {
                DynamicObject[] dataArr;
                long currentId = 0L;
                while ((dataArr = this.getData(currentId)) != null && dataArr.length != 0) {
                    logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u68c0\u6d4b\u5230\u5b58\u5728,\u5f00\u59cb\u5904\u7406\u3002");
                    for (DynamicObject data : dataArr) {
                        long id = data.getLong("id");
                        if (id > currentId) {
                            currentId = id;
                        }
                        this.execData(data);
                    }
                }
                logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165\uff0c\u5904\u7406\u7ed3\u675f\u3002");
            } else {
                logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165\uff0c\u5904\u7406\u7ed3\u675f\u3002\u672a\u83b7\u53d6\u5230\u9501");
            }
        }
    }

    private void execData(DynamicObject data) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)"sim_his_inv_data_import");
        String billNo = dynamicObject.getString("billno");
        try (DLock lock = DLock.create((String)(TASK_NAME_PRE + billNo));){
            if (!lock.tryLock(600000L)) {
                return;
            }
            dynamicObject.set("executionstatus", (Object)"2");
            ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5f00\u59cb\u4efb\u52a1:{}", (Object)billNo);
            String importMethod = dynamicObject.getString("importmethod");
            if ("2".equals(importMethod)) {
                this.execInvoiceFileData(dynamicObject);
            } else {
                this.saveInvoiceInterFaceData(dynamicObject);
            }
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u7ed3\u675f\u4efb\u52a1:{}", (Object)billNo);
        }
    }

    private void saveInvoiceInterFaceData(DynamicObject dynamicObject) {
        String issueAccount = dynamicObject.getString("issueaccount");
        DynamicObject epInfo = dynamicObject.getDynamicObject("epinfo");
        long orgId = epInfo.getLong("org.id");
        String taxNo = epInfo.getString("number");
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject item = (DynamicObject)entryEntity.get(i);
                String executionStatus = item.getString("detailexecutionstatus");
                String dataType = dynamicObject.getString("datatype");
                boolean isInvoiceData = "1".equals(dataType);
                if ("0".equals(executionStatus)) {
                    String status = isInvoiceData ? "2" : "1";
                    item.set("detailexecutionstatus", (Object)status);
                    entryEntity.set(i, (Object)item);
                    dynamicObject.set("entryentity", (Object)entryEntity);
                    ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
                } else if ("4".equals(executionStatus) || "5".equals(executionStatus)) continue;
                boolean syncSuccess = isInvoiceData ? this.syncInvoiceData(dynamicObject, entryEntity, taxNo, orgId, issueAccount, i) : this.syncInvoiceStatus(dynamicObject, entryEntity, taxNo, orgId, issueAccount, i);
                if (!syncSuccess) break;
            }
        }
    }

    private boolean syncInvoiceStatus(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, String taxNo, long orgId, String account, int index) {
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        String invoiceDateMonth = item.getString("detailinvoicedate");
        String invoiceTypeStr = item.getString("detailinvoicetype");
        List invoiceTypeList = CollectionsUtils.getListFromStr((String)invoiceTypeStr);
        YearMonth yearMonth = YearMonth.parse(invoiceDateMonth);
        LocalDateTime startDateTime = yearMonth.atDay(1).atStartOfDay();
        LocalDateTime endDateTime = yearMonth.atEndOfMonth().atTime(23, 59, 59);
        int totalNum = 0;
        while (!startDateTime.isAfter(endDateTime)) {
            QFilter qFilter = this.getInvoiceDataQFilter(invoiceTypeList, taxNo, startDateTime);
            totalNum = this.syncInvoiceDataToSt(dynamicObject, item, index, qFilter, totalNum, orgId, account);
            startDateTime = startDateTime.plusDays(1L);
        }
        boolean updateFlag = this.updateEntry(dynamicObject, index, "detailexecutionstatus", "2");
        if (!updateFlag) {
            return false;
        }
        int successNum = this.syncInvoiceDataFromSt(dynamicObject, item, index);
        String execStatus = "3";
        if (totalNum != 0 && successNum == 0) {
            execStatus = "5";
        } else if (totalNum == successNum) {
            execStatus = "4";
        }
        return this.updateEntry(dynamicObject, index, "detailexecutionstatus", execStatus);
    }

    private int syncInvoiceDataFromSt(DynamicObject importData, DynamicObject item, int index) {
        int totalSuccessNum;
        DynamicObject[] dataArr;
        String batchNo = importData.getString("billno");
        Object entryKey = item.getPkValue();
        QFilter qFilter = this.getInvoiceStQFilter(batchNo, entryKey);
        int successNum = 0;
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])qFilter.toArray(), (String)"id", (int)200)) != null && dataArr.length != 0) {
            for (DynamicObject dataPri : dataArr) {
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)dataPri.getPkValue(), (String)"sim_his_inv_data_imp_st");
                String downloadChannel = data.getString("downloadchannel");
                if ("2".equals(downloadChannel)) {
                    successNum += this.queryRedInfoPreRpa(data);
                    continue;
                }
                successNum += this.queryRedInfoPreLeqi(data);
            }
            boolean updateFlag = this.updateEntry(importData, index, "detailsuccessnum", successNum);
            if (updateFlag) continue;
            break;
        }
        if ((totalSuccessNum = this.getSyncInvoiceStSuccessNum(entryKey)) != successNum) {
            this.updateEntry(importData, index, "detailsuccessnum", totalSuccessNum);
        }
        return totalSuccessNum;
    }

    private int getSyncInvoiceStSuccessNum(Object entryKey) {
        String executionStatus = "4";
        String sql = String.format(QUERY_STATUS_SUCCESS_SQL, executionStatus, entryKey);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"getSyncInvoiceStSuccessNum", (DBRoute)new DBRoute("taxc"), (String)sql);){
            if (ds != null) {
                count = ds.next().getLong("count").intValue();
            }
        }
        return count;
    }

    private int queryRedInfoPreRpa(DynamicObject data) {
        int success = 0;
        String failMsg = null;
        try {
            String applicant = data.getString("keylabel");
            String sellerTaxNo = data.getString("salertaxno");
            String buyerTaxNo = data.getString("buyertaxno");
            String taxNo = "1".equalsIgnoreCase(applicant) ? sellerTaxNo : buyerTaxNo;
            AllEleRedApplyQueryRequestDTO dto = new AllEleRedApplyQueryRequestDTO();
            dto.setRequest_path(AllEleInterfaceTypeEnum.QUERY_INVOICE_RED_PRE.getRequestPath());
            dto.setAccount(data.getString("issueaccount"));
            dto.setSalerTaxNo(sellerTaxNo);
            dto.setBuyerTaxNo(buyerTaxNo);
            dto.setKeyLabel(applicant);
            dto.setOriginalInvoiceCode(data.getString("invoicecode"));
            dto.setOriginalInvoiceNo(data.getString("invoiceno"));
            String invoiceType = data.getString("invoicetype");
            dto.setOriginalInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType));
            dto.setOriginalInvoiceDate(data.getString("invoicedate"));
            dto.setHistorySync(true);
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)dto, AllEleRedApplyQueryResponseDTO.class);
            if (response.getSuccess().booleanValue()) {
                Object invoiceId;
                DynamicObject invoiceData;
                AllEleRedApplyQueryResponseDTO responseData = (AllEleRedApplyQueryResponseDTO)response.getData();
                if (responseData != null && (invoiceData = BusinessDataServiceHelper.loadSingle((Object)(invoiceId = data.get("invoiceid")), (String)"sim_vatinvoice")) != null) {
                    invoiceData.set("valueaddedtaxuses", (Object)responseData.getValueAddedTaxUses());
                    invoiceData.set("creditingstatus", (Object)responseData.getCreditingStatus());
                    invoiceData.set("excisetaxpurposes", (Object)responseData.getExciseTaxPurposes());
                    ImcSaveServiceHelper.update((DynamicObject)invoiceData);
                    success = 1;
                    failMsg = response.getDescription();
                }
                if (success == 0) {
                    failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), ErrorType.USER_ERROR_A0160.getDescription());
                }
            } else {
                failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription());
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        String executionStatus = success == 1 ? "4" : "5";
        data.set("executionstatus", (Object)executionStatus);
        data.set("failreason", (Object)failMsg);
        ImcSaveServiceHelper.update((DynamicObject)data);
        return success;
    }

    private int queryRedInfoPreLeqi(DynamicObject data) {
        int success = 0;
        String failMsg = null;
        try {
            String taxNo;
            String applicant = data.getString("keylabel");
            String sellerTaxNo = data.getString("salertaxno");
            String buyerTaxNo = data.getString("buyertaxno");
            String string = taxNo = "1".equalsIgnoreCase(applicant) ? sellerTaxNo : buyerTaxNo;
            if (!EnterpriseHelper.isLqptChannel((String)taxNo)) {
                failMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u53f7\u6682\u4e0d\u652f\u6301\u4e50\u4f01\u901a\u9053\u67e5\u8be2\u5165\u8d26\u72b6\u6001\u3002", (String)"SimHisInvDataImportTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            String invoiceType = data.getString("invoicetype");
            String invoiceDate = data.getString("invoicedate");
            if (invoiceDate != null && invoiceDate.length() > 8) {
                invoiceDate = invoiceDate.replace("-", "");
                invoiceDate = invoiceDate.substring(0, 8);
            }
            InvoiceStatusQueryRequest request = new InvoiceStatusQueryRequest();
            request.setNsrsbh(taxNo);
            request.setFpdm(data.getString("invoicecode"));
            request.setFphm(data.getString("invoiceno"));
            request.setFplx(InvoiceType.getRimLqptCodeByTypeCode((String)invoiceType));
            request.setKprq(invoiceDate);
            JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            json.put("api_type", (Object)"FPZTXXCX");
            JSONObject responseJson = new InvoiceCollectionService().send(json);
            String description = responseJson.getString("description");
            if (kd.imc.sim.common.constant.ErrorType.SUCCESS.getErrcode().equals(responseJson.getString("errcode"))) {
                Object invoiceId;
                DynamicObject invoiceData;
                JSONObject resultData = responseJson.getJSONObject("data");
                if (resultData != null && (invoiceData = BusinessDataServiceHelper.loadSingle((Object)(invoiceId = data.get("invoiceid")), (String)"sim_vatinvoice")) != null) {
                    String accountingStatus;
                    String vatStatus = resultData.getString("fpyt");
                    if ("0".equals(vatStatus)) {
                        vatStatus = "03";
                    }
                    if ("01".equals(accountingStatus = resultData.getString("rzzt"))) {
                        accountingStatus = "00";
                    } else if ("02".equals(accountingStatus)) {
                        accountingStatus = "01";
                    }
                    String ctStatus = resultData.getString("xfsyt");
                    if (StringUtils.isEmpty((CharSequence)ctStatus)) {
                        ctStatus = "00";
                    }
                    invoiceData.set("valueaddedtaxuses", (Object)vatStatus);
                    invoiceData.set("creditingstatus", (Object)accountingStatus);
                    invoiceData.set("excisetaxpurposes", (Object)ctStatus);
                    ImcSaveServiceHelper.update((DynamicObject)invoiceData);
                    success = 1;
                    failMsg = description;
                }
                if (success == 0) {
                    failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), ErrorType.USER_ERROR_A0160.getDescription());
                }
            } else {
                failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SimHisInvDataImportTask_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        String executionStatus = success == 1 ? "4" : "5";
        data.set("executionstatus", (Object)executionStatus);
        data.set("failreason", (Object)failMsg);
        ImcSaveServiceHelper.update((DynamicObject)data);
        return success;
    }

    private QFilter getInvoiceStQFilter(String batchNo, Object entryKey) {
        QFilter qFilter = new QFilter("billno", "=", (Object)batchNo);
        qFilter.and("importentryid", "=", entryKey);
        qFilter.and("executionstatus", "=", (Object)"0");
        return qFilter;
    }

    private int syncInvoiceDataToSt(DynamicObject importData, DynamicObject item, int entryIndex, QFilter qFilter, int totalNum, long orgId, String account) {
        DynamicObject[] dataArr;
        String batchNo = importData.getString("billno");
        String downloadChannel = importData.getString("downloadchannel");
        Object entryKey = item.getPkValue();
        int pageIndex = 0;
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)INVOICE_FIELDS, (QFilter[])qFilter.toArray(), (String)"issuetime", (int)pageIndex, (int)200)) != null && dataArr.length != 0) {
            totalNum += dataArr.length;
            ArrayList<DynamicObject> invoiceStatusDataList = new ArrayList<DynamicObject>(dataArr.length);
            for (DynamicObject invoiceData : dataArr) {
                String currentExecutionStatus;
                Object invoiceId = invoiceData.getPkValue();
                DynamicObject dynamicObject = this.queryInvoiceSdByInvoiceId(invoiceId, entryKey);
                if (dynamicObject == null && ("0".equals(currentExecutionStatus = (dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_his_inv_data_imp_st")).getString("executionstatus")) || "4".equals(currentExecutionStatus))) continue;
                dynamicObject.set("billno", (Object)batchNo);
                dynamicObject.set("org", (Object)orgId);
                dynamicObject.set("downloadchannel", (Object)downloadChannel);
                dynamicObject.set("invoicecode", (Object)invoiceData.getString("invoicecode"));
                dynamicObject.set("invoiceno", (Object)invoiceData.getString("invoiceno"));
                String invoiceType = invoiceData.getString("invoicetype");
                dynamicObject.set("invoicetype", (Object)invoiceType);
                Date issueTime = invoiceData.getDate("issuetime");
                if (issueTime != null) {
                    String issueTimeStr = DateUtils.formatDate((Date)issueTime, (DateTimeFormatter)DateUtils.FORMATTER_TIME);
                    dynamicObject.set("invoicedate", (Object)issueTimeStr);
                }
                String specialTypeStr = invoiceData.getString("specialtype");
                SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue((String)specialTypeStr);
                String keyLabel = "1";
                String buyerTaxNo = null;
                String sellerTaxNo = invoiceData.getString("salertaxno");
                if (SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS == specialType || SpecialTypeEnum.PURCHASE_OF_AGRICULTURAL_PRODUCTS_02 == specialType) {
                    keyLabel = "2";
                    buyerTaxNo = invoiceData.getString("salertaxno");
                    sellerTaxNo = invoiceData.getString("buyertaxno");
                }
                if (this.specialInvoiceType(invoiceType)) {
                    buyerTaxNo = invoiceData.getString("buyertaxno");
                }
                dynamicObject.set("issueaccount", (Object)account);
                dynamicObject.set("salertaxno", (Object)sellerTaxNo);
                dynamicObject.set("buyertaxno", (Object)buyerTaxNo);
                dynamicObject.set("keylabel", (Object)keyLabel);
                dynamicObject.set("importentryid", entryKey);
                dynamicObject.set("invoiceid", invoiceId);
                dynamicObject.set("executionstatus", (Object)"0");
                invoiceStatusDataList.add(dynamicObject);
            }
            boolean updateFlag = this.updateEntry(importData, entryIndex, "detailtotalnum", totalNum);
            if (!updateFlag) break;
            ImcSaveServiceHelper.save(invoiceStatusDataList);
            ++pageIndex;
        }
        return totalNum;
    }

    private DynamicObject queryInvoiceSdByInvoiceId(Object invoiceId, Object entryKey) {
        QFilter qFilterC = new QFilter("importentryid", "=", entryKey);
        qFilterC.and(new QFilter("invoiceid", "=", invoiceId));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])qFilterC.toArray());
        if (dynamicObject != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)"sim_his_inv_data_imp_st");
        }
        return dynamicObject;
    }

    private boolean updateEntry(DynamicObject dynamicObject, int index, String key, Object value) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        item.set(key, value);
        entryEntity.set(index, (Object)item);
        dynamicObject.set("entryentity", (Object)entryEntity);
        return this.updateData(dynamicObject);
    }

    private boolean specialInvoiceType(String invoiceType) {
        return InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType);
    }

    private QFilter getInvoiceDataQFilter(List<String> invoiceTypeList, String taxNo, LocalDateTime start) {
        QFilter qFilter = new QFilter("invoicetype", "in", invoiceTypeList);
        qFilter.and("salertaxno", "=", (Object)taxNo);
        qFilter.and("issuetype", "=", (Object)"0");
        qFilter.and("invoicestatus", "=", (Object)"0");
        LocalDateTime end = start.withHour(23).withMinute(59).withSecond(59);
        qFilter.and("issuetime", ">=", (Object)start);
        qFilter.and("issuetime", "<=", (Object)end);
        return qFilter;
    }

    private boolean syncInvoiceData(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, String taxNo, long orgId, String account, int index) {
        DynamicObject item = (DynamicObject)entryEntity.get(index);
        String invoiceDate = item.getString("detailinvoicedate");
        YearMonth yearMonth = YearMonth.parse(invoiceDate);
        String startDate = yearMonth.atDay(1).format(DateUtils.FORMATTER_DATE);
        String endDate = yearMonth.atEndOfMonth().format(DateUtils.FORMATTER_DATE);
        String invoiceType = item.getString("detailinvoicetype");
        SyncQueryInvoiceDTO dto = new SyncQueryInvoiceDTO();
        dto.setStartDate(startDate);
        dto.setEndDate(endDate);
        dto.setTaxNo(taxNo);
        dto.setOrgId(Long.valueOf(orgId));
        dto.setAccount(account);
        boolean successFlag = Boolean.FALSE;
        try {
            Map<String, Integer> resultMap;
            String downloadChannel = dynamicObject.getString("downloadchannel");
            if ("2".equals(downloadChannel)) {
                dto.setInvoiceType(InvoiceSyncControl.transAllEleTypeFromTypeCode((String)invoiceType));
                resultMap = SyncDevInvoiceTask.rpaBatchCodeSync(dto, taxNo, true);
            } else {
                boolean updateFlag;
                dto.setInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType));
                String detailTaskNo = item.getString("detailtaskno");
                if (StringUtils.isEmpty((CharSequence)detailTaskNo) && StringUtils.isNotEmpty((CharSequence)(detailTaskNo = this.syncInvoiceDataFromLeqiApply(dto))) && !(updateFlag = this.updateEntry(dynamicObject, index, "detailtaskno", detailTaskNo))) {
                    return Boolean.FALSE;
                }
                resultMap = this.syncInvoiceDataFromLeqiQuery(detailTaskNo);
                if (resultMap == null) {
                    return Boolean.TRUE;
                }
            }
            Integer totalNum = resultMap.get("TOTAL_NUM");
            Integer successNum = resultMap.get("SUCCESS_NUM");
            item.set("detailtotalnum", (Object)totalNum);
            item.set("detailsuccessnum", (Object)successNum);
            item.set("detailexecutionstatus", (Object)"4");
            item.set("detailfailreason", (Object)kd.imc.sim.common.constant.ErrorType.SUCCESS.getDescription());
            successFlag = Boolean.TRUE;
        }
        catch (MsgException msgException) {
            logger.error("SimHisInvDataImportTask msgException", (Throwable)msgException);
            if (ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u540c\u6b65\u7684\u53d1\u7968\u6570\u636e", (String)"SimHisInvDataImportTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(msgException.getErrorMsg())) {
                item.set("detailtotalnum", (Object)0);
                item.set("detailsuccessnum", (Object)0);
                item.set("detailexecutionstatus", (Object)"4");
                successFlag = Boolean.TRUE;
            }
            item.set("detailfailreason", (Object)msgException.getErrorMsg());
        }
        catch (Exception e) {
            logger.error("SimHisInvDataImportTask exception", (Throwable)e);
            item.set("detailfailreason", (Object)String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"SimHisInvDataImportTask_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        if (!successFlag) {
            item.set("detailexecutionstatus", (Object)"5");
        }
        entryEntity.set(index, (Object)item);
        dynamicObject.set("entryentity", (Object)entryEntity);
        return this.updateData(dynamicObject);
    }

    private String syncInvoiceDataFromLeqiApply(SyncQueryInvoiceDTO body) {
        if (!EnterpriseHelper.isInputLqptChannel((String)body.getTaxNo())) {
            throw new MsgException(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u53f7\u6682\u4e0d\u652f\u6301\u4e50\u4f01\u901a\u9053\u67e5\u8be2\u53d1\u7968\u72b6\u6001\u3002", (String)"SimHisInvDataImportTask_4", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("invoiceType", body.getInvoiceType());
        param.put("taxNo", body.getTaxNo());
        param.put("orgId", body.getOrgId());
        param.put("dataType", 2);
        param.put("firstDate", body.getStartDate());
        param.put("endDate", body.getEndDate());
        Map applyResponse = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"outInvoiceApply", (Object[])new Object[]{param});
        logger.info("\u7533\u8bf7\u4e50\u4f01\u53d1\u7968\u6570\u636e\u540c\u6b65\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u8fd4\u56de\u53c2\u6570\uff1a{}", param, (Object)applyResponse);
        if (applyResponse == null || applyResponse.get("data") == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u7533\u8bf7\u540c\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SimHisInvDataImportTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String errCode = (String)applyResponse.get("errcode");
        if (!kd.imc.sim.common.constant.ErrorType.SUCCESS.getErrcode().equals(errCode)) {
            throw new MsgException((String)applyResponse.get("description"));
        }
        Map data = (Map)applyResponse.get("data");
        return (String)data.get("batchNo");
    }

    private Map<String, Integer> syncInvoiceDataFromLeqiQuery(String taskNo) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("batchNo", taskNo);
        Map queryResponse = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"outInvoiceDownloadResult", (Object[])new Object[]{param});
        logger.info("\u83b7\u53d6\u4e50\u4f01\u53d1\u7968\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u679c\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u8fd4\u56de\u53c2\u6570\uff1a{}", param, (Object)queryResponse);
        if (queryResponse == null || queryResponse.get("data") == null) {
            throw new MsgException(ResManager.loadKDString((String)"\u7533\u8bf7\u540c\u6b65\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"SimHisInvDataImportTask_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
        String errCode = (String)queryResponse.get("errcode");
        if (!kd.imc.sim.common.constant.ErrorType.SUCCESS.getErrcode().equals(errCode)) {
            throw new MsgException((String)queryResponse.get("description"));
        }
        Map data = (Map)queryResponse.get("data");
        String status = String.valueOf(data.get("status"));
        if ("success".equals(status)) {
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>(2);
            resultMap.put("TOTAL_NUM", Integer.parseInt((String)data.get("totalNum")));
            resultMap.put("SUCCESS_NUM", Integer.parseInt((String)data.get("successNum")));
            return resultMap;
        }
        if ("fail".equals(status)) {
            throw new MsgException((String)data.get("description"));
        }
        return null;
    }

    private boolean updateData(DynamicObject dynamicObject) {
        DynamicObject dynamicObjectDB = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        String exectionStatus = dynamicObjectDB.getString("executionstatus");
        if ("5".equals(exectionStatus)) {
            return false;
        }
        int totalNum = 0;
        int successNum = 0;
        boolean allSuccess = Boolean.TRUE;
        boolean allFinish = Boolean.TRUE;
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : entryEntity) {
            String executionStatus = item.getString("detailexecutionstatus");
            if ("0".equals(executionStatus) || "2".equals(executionStatus) || "1".equals(executionStatus)) {
                allFinish = Boolean.FALSE;
            }
            if (!allSuccess || !"4".equals(executionStatus)) {
                allSuccess = Boolean.FALSE;
            }
            totalNum += item.getInt("detailtotalnum");
            successNum += item.getInt("detailsuccessnum");
        }
        dynamicObject.set("totalnum", (Object)totalNum);
        dynamicObject.set("successnum", (Object)successNum);
        if (allSuccess) {
            dynamicObject.set("executionstatus", (Object)"4");
        } else if (allFinish) {
            if (successNum == 0) {
                dynamicObject.set("executionstatus", (Object)"5");
            } else {
                dynamicObject.set("executionstatus", (Object)"3");
            }
        } else {
            dynamicObject.set("executionstatus", (Object)"2");
        }
        ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
        return true;
    }

    private void execInvoiceFileData(DynamicObject dynamicObject) {
        try (DLock lock = DLock.create((String)TASK_NAME_FILE);){
            if (!lock.tryLock(600000L)) {
                return;
            }
            List attachments = AttachmentServiceHelper.getAttachments((String)"sim_his_inv_data_import", (Object)dynamicObject.getPkValue(), (String)"attachmentpanel");
            int status = 1;
            long start = System.currentTimeMillis();
            if (attachments != null && !attachments.isEmpty()) {
                try {
                    String url = (String)((Map)attachments.get(0)).get("relativeUrl");
                    String name = (String)((Map)attachments.get(0)).get("name");
                    logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5904\u7406\u6587\u4ef6\u4efb\u52a1\uff0cURL:{}", (Object)url);
                    TaxInvoiceImportUtil invoiceImportUtil = new TaxInvoiceImportUtil();
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    try (InputStream inputStream = service.getInputStream(url);
                         Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
                        long readEnd = System.currentTimeMillis();
                        logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u8bfb\u53d6\u6587\u4ef6\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)(readEnd - start));
                        int successNum = invoiceImportUtil.parseTaxFile(null, workbook, name);
                        logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u89e3\u6790\u6587\u4ef6\u7ed3\u675f\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - readEnd));
                        int totalNum = invoiceImportUtil.getTotal();
                        Set invoiceTypeSet = invoiceImportUtil.getInvoiceTypeSet();
                        dynamicObject.set("successnum", (Object)successNum);
                        dynamicObject.set("totalnum", (Object)totalNum);
                        if (invoiceTypeSet != null && !invoiceTypeSet.isEmpty()) {
                            String invoiceTypeStr = StringUtils.join((Iterable)invoiceTypeSet, (String)",");
                            dynamicObject.set("invoicetype", (Object)invoiceTypeStr);
                        }
                        if (totalNum != 0 && successNum == totalNum) {
                            status = 3;
                        } else if (totalNum > successNum) {
                            status = 2;
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
                }
            }
            logger.info("\u5b9a\u65f6\u4efb\u52a1->\u5386\u53f2\u53d1\u7968\u6570\u636e\u5bfc\u5165,\u5904\u7406\u6587\u4ef6\u4efb\u52a1\uff0c\u5904\u7406\u7ed3\u679c:{}\uff0c\u603b\u8017\u65f6:{}", (Object)status, (Object)(System.currentTimeMillis() - start));
            this.execResult(dynamicObject, status);
        }
    }

    private void execResult(DynamicObject dynamicObject, int status) {
        String execStatus = "4";
        if (status == 1) {
            execStatus = "5";
        } else if (status == 2) {
            execStatus = "3";
        }
        dynamicObject.set("executionstatus", (Object)execStatus);
        ImcSaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private DynamicObject[] getData(long pkValue) {
        QFilter filter = new QFilter("executionstatus", "=", (Object)"0").or(new QFilter("executionstatus", "=", (Object)"2"));
        QFilter qFilter = new QFilter("id", ">", (Object)pkValue);
        qFilter.and(filter);
        return BusinessDataServiceHelper.load((String)"sim_his_inv_data_import", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime", (int)10);
    }
}

